-- ----------------------------------------
-- RRZCMS MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.7.26
-- Database       : rrzcms
-- 
-- Part : #1
-- Version : #v1.3.4
-- Date : 2021-12-13 16:36:23
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- Table structure for `rrz_admin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin`;
CREATE TABLE `rrz_admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(50) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(50) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) unsigned DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) unsigned DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) unsigned DEFAULT '0' COMMENT '同步注册到会员表',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员表';

-- -----------------------------
-- Records of `rrz_admin`
-- -----------------------------
INSERT INTO `rrz_admin` VALUES ('1', 'admin', '', 'admin', '', '', '21232f297a57a5a743894a0e4a801fc3', '/static/images/dfboy.png', '1639373765', '127.0.0.1', '65', '', '0', '1', 'cn', '1', '1', '1586479354', '1588751715');

-- ----------------------------
-- Table structure for `rrz_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_log`;
CREATE TABLE `rrz_admin_log` (
  `id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员日志表';


-- ----------------------------
-- Table structure for `rrz_admin_role`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_role`;
CREATE TABLE `rrz_admin_role` (
  `role_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='用户角色表';

-- -----------------------------
-- Records of `rrz_admin_role`
-- -----------------------------
INSERT INTO `rrz_admin_role` VALUES ('1', '超级管理员', 'all', '管理全站');

-- ----------------------------
-- Table structure for `rrz_article_nodes`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_article_nodes`;
CREATE TABLE `rrz_article_nodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '栏目图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '栏目深度',
  `sort` smallint(6) unsigned DEFAULT '50' COMMENT '排序',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章类目';

-- -----------------------------
-- Records of `rrz_article_nodes`
-- -----------------------------
INSERT INTO `rrz_article_nodes` VALUES ('1', '0', '关于我们', 'ABOUT US', 'guanyuwomen/about', '0', '', '1', '1', '1', '1001', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '关于我们', '人人站CMS是全新内核且开源免费的PHP企业网站开发建设管理系统，是一套高效、简洁、 强悍的PHP CMS源码，能够满足各类企业网站开发建设的需要。系统采用简单的模板标签，只要懂HTML就可快速开发企业网站。官方提供了大量网站模板免费下载和使用，将致', '', '<p>人人站CMS是全新内核且开源免费的PHP企业网站开发建设管理系统，是一套高效、简洁、 强悍的PHP CMS源码，能够满足各类企业网站开发建设的需要。系统采用简单的模板标签，只要懂HTML就可快速开发企业网站。官方提供了大量网站模板免费下载和使用，将致力于为广大站长和企业提供简单易用的网站开发建设解决方案。1、系统采用高效、简洁、强悍的模板标签，只要懂HTML就可快速开发企业网站；2、系统采用PHP语言开发，基于TP6.0框架为核心进行开发；3、系统采用MySql数据库进行数据存储；4、系统支持后台在线升级，满足系统及时升级更新的需要；5、系统支持内容模型、多语言、自定义表单、筛选、多条件搜索等功能；6、系统支持多种URL模式及模型、栏目、内容自定义地址名称，满足各类网站推广优化的需要。</p>', '', 'true', '1639379432');
INSERT INTO `rrz_article_nodes` VALUES ('2', '0', '公司简介', '', 'guanyuwomen/gongsijianjie', '1', '', '1,2', '2', '1', '10011001', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '公司简介', '', '', '《人人站CMS》诞生于2014年6月（www.rrzcms.com），以提供分享精品人人站源码及人人站建站过程常遇到的问题解决方案汇总为主要宗旨。<br />\r\n《人人站CMS》内容涉及: 企业类人人站源码，门户类人人站源码，及工作室或博客类等基于人人站系统仿制等风格。<br />\r\n《人人站CMS》将向着共享化、全面化、专业化、深度化、免费化的多元方向发展，打造实用快捷的建站体验，为会员及用户提供高质量的服务。<br />\r\n《人人站CMS》感谢无数关注、支持我们的会员及各位访客们，感谢您们的信任。年轻的《人人站CMS》愿与同样充满活力的您，彼此相伴，共同成长！<br />\r\n《人人站CMS》只专心做一件事，便是做好的完整的人人站源码！<br />\r\n<br />\r\n人人站CMS开站以来，尽管没有积累太多用户口碑和市场份额，但我们一直努力，每天保持更新各行各业好源码，让找人人站源码去rrzcms已经成为很多人人站爱好者的习惯。<br />\r\n相信通过我们的努力,rrzcms会越来越好！', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('3', '0', '发展历程', '', 'guanyuwomen/fazhanlicheng', '1', '', '1,3', '2', '2', '10011002', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '发展历程', '', '', '<div style=\"text-align: center;\">\r\n	&nbsp;<img alt=\"\" src=\"/storage/images/20211213/1-160G3162225629.jpg\" style=\"width: 700px; height: 482px;\" /></div>\r\n', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('4', '0', '资质荣誉', '', 'guanyuwomen/zizhirongyu', '1', '', '1,4', '2', '3', '10011003', 'zizhirongyu', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '资质荣誉', '', '', '&nbsp;', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('5', '0', '企业文化', '', 'guanyuwomen/qiyewenhua', '1', '', '1,5', '2', '4', '10011004', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '企业文化', '', '', '&nbsp;\r\n<h4>\r\n	愿景</h4>\r\n<p>\r\n	社会价值——成为一家不断提升人类居住美好感受的设计企业<br />\r\n	行业价值——成为一个聚集众多空间艺术设计精英自由发挥的平台<br />\r\n	人文价值——成为一个跨时代、有主张、有号召力的设计符号</p>\r\n<h4>\r\n	经营理念&nbsp;</h4>\r\n<p>\r\n	布施&nbsp;&nbsp;&nbsp;&nbsp;普济众生 &nbsp;<br />\r\n	持戒&nbsp;&nbsp;&nbsp;&nbsp;纪律严明 &nbsp;<br />\r\n	忍辱&nbsp;&nbsp;&nbsp;&nbsp;坚韧不拔 &nbsp;<br />\r\n	精进&nbsp;&nbsp;&nbsp;&nbsp;艺精于勤 &nbsp;<br />\r\n	禅定&nbsp;&nbsp;&nbsp;&nbsp;一日三省 &nbsp;<br />\r\n	智慧&nbsp;&nbsp;&nbsp;&nbsp;通达大道&nbsp;</p>\r\n<h4>\r\n	人才理念</h4>\r\n<p>\r\n	不拘一格&nbsp;&nbsp;&nbsp;&nbsp;人尽其才<br />\r\n	优秀的人才是全方位的素质提升<br />\r\n	优秀的人才是博海生存发展的源动力</p>\r\n<h4>\r\n	工作理念</h4>\r\n<p>\r\n	以内涵孕育艺术<br />\r\n	以效率带动发展</p>\r\n<h4>\r\n	设计理念</h4>\r\n<p>\r\n	不一味迎合市场，创造来源于客户与设计师的良性互动</p>\r\n<div>\r\n	&nbsp;</div>\r\n', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('6', '0', '组织机构', '', 'guanyuwomen/zuzhijigou', '1', '', '1,6', '2', '5', '10011005', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '组织机构', '', '', '<div style=\"text-align: center;\">\r\n	&nbsp;<img alt=\"\" src=\"/storage/images/20211213/1-160G3163FG43.jpg\" style=\"width: 650px; height: 858px;\" /></div>\r\n', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('8', '0', '产品中心', '', 'chanpinzhongxin/gongyelingyu', '0', '', '8', '1', '2', '1002', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '产品中心', '', '', '', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('9', '0', '工业领域', '', 'chanpinzhongxin/gongyelingyu', '8', '', '8,9', '2', '1', '10021001', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '工业领域', '', '', '&nbsp;', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('10', '0', '食品领域', '', 'chanpinzhongxin/shipinlingyu', '8', '', '8,10', '2', '2', '10021002', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '食品领域', '', '', '', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('11', '0', '农业领域', '', 'chanpinzhongxin/nongyelingyu', '8', '', '8,11', '2', '3', '10021003', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '农业领域', '', '', '', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('12', '0', '其他领域', '', 'chanpinzhongxin/qitalingyu', '8', '', '8,12', '2', '4', '10021004', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '其他领域', '', '', '', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('17', '0', '新闻中心', '', 'xinwenzhongxin/gongsixinwen', '0', '', '17', '1', '3', '1003', 'news', 'news', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '新闻中心', '', '', '&nbsp;', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('18', '0', '公司新闻', '', 'xinwenzhongxin/gongsixinwen', '17', '', '17,18', '2', '1', '10031001', 'news', 'news', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '公司新闻', '', '', '', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('19', '0', '行业新闻', '', 'xinwenzhongxin/xingyexinwen', '17', '', '17,19', '2', '2', '10031002', 'news', 'news', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '行业新闻', '', '', '', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('21', '0', '人才招聘', '', 'jiaruwomen/rencailinian', '0', '', '21', '1', '4', '1004', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '加入我们', '', '', '', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('22', '0', '人才理念', '', 'jiaruwomen/rencailinian', '21', '', '21,22', '2', '1', '10041001', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '人才理念', '', '', '&nbsp;人力资源是企业发展的第一资源。公司牢固树立“以人为本、德才兼备”的人才理念，致力于实现企业全面发展与员工价值实现的高度统一。\r\n<p>\r\n	通过建立完善的人力资源管理体系，建立健全人才评价发现、选拔任用、绩效考核等激励约束机制，努力创建“舞台感召人、事业成就人、机制激励人、报酬鼓舞人、情感关爱人”的良好氛围，为公司总体发展战略目标的顺利实现提供了坚强的人才保证和广泛的智力支持。</p>\r\n<p>\r\n	用人方针---德才兼备、五湖四海、老中青结合。</p>\r\n<p>\r\n	用人理念---讲文凭更讲水平、讲职称更讲称职、讲阅历更讲能力、讲资历更讲贡献。</p>\r\n<p>\r\n	选拔原则---公平竞争 优胜劣汰、人员能进能出、职位能升能降、收入能高能低</p>\r\n', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('23', '0', '人才政策', '', 'jiaruwomen/rencaizhengce', '21', '', '21,23', '2', '2', '10041002', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '人才政策', '', '', '&nbsp;\r\n<h3>\r\n	一、发展通道</h3>\r\n<p>\r\n	公司建立了管理、技术、技能三大职业发展通道，其中技术通道设工程、财务、经济、营销四大系列。员工多重职业发展通道的建立，为公司专业技术人员、管理人 员和技术工人的成长建立了一个新的通道，通过设立不同的岗位晋升序列，为各类人才特别是新进优秀人才搭建起施展才能的广阔舞台。</p>\r\n<p>\r\n	在人才使用上，公司特别注重从招聘大学生中启用优秀人才或有为之才，通过层层推荐考核、内部公开招考和社会公开招聘等措施让优秀员工脱颖而出，显现出了中基层管理人员和技术人员的无限生机。</p>\r\n<h6>\r\n	管理通道</h6>\r\n<p>\r\n	基层管理人员—中层管理助理—中层管理副职—中层管理正职—总经理助理及以上（公司高管）</p>\r\n<h6>\r\n	技术通道</h6>\r\n<p>\r\n	助理经济师—经济师—副主任经济师—主任经济师—副总经济师—总经济师<br />\r\n	助理会计师—会计师—副主任会计师—主任会计师—副总会计师—总会计师<br />\r\n	助理工程师—工程师—副主任工程师—主任工程师—副总工程师—总工程师<br />\r\n	业务主管—业务经理助理—业务副经理—业务经理—高级业务经理</p>\r\n<h6>\r\n	技能通道</h6>\r\n<p>\r\n	高级工—技师—高级技师—首席技师</p>\r\n<h3>\r\n	二、员工培训</h3>\r\n<p>\r\n	公司基于长期和短期发展战略，不断建立和完善人力资源管理政策，推动人才培养、选拔使用、绩效考核等工作机制不断创新，将培训作为创建学习型组织的有效手段，采取“请进来”和“送出去”的方式，实施全员培训。</p>\r\n<p>\r\n	邀请专家学者对公司高层进行战略、运营、管理等方面的培训；组织对中层管理干部进行管理理念、管理方法、有效沟通等方面的培训，提高中层管理干部综合素质；采用校企联合等方式培养研发人才，通过外出观摩学习、内部培训等方式培养销售人才，鼓励员工通过学习不断进步；坚持对新员工进行入职培训，对冬修冬试、季节性停产员工进行轮训，有效促进员工成长成才。</p>\r\n<p>\r\n	通过建立基层定期锻炼、差异化轮岗、专业课题攻关、领导定点联系、师徒结对帮扶、员工技能比武等人才培养制度，有效发挥员工专长，提高员工技能，让员工获得更好的职业发展。</p>\r\n<p>\r\n	选派优秀员工前往国内外知名企业进行学习考察，开阔员工视野。</p>\r\n<p>\r\n	建立有效的沟通机制、培训体系、职业生涯规划、工会组织等，来解决员工潜在压力以及在员工能力和配置需求上的潜在变化。</p>\r\n<p>\r\n	严格奖惩兑现，坚持把绩效考核结果与工资奖金、评先表模、岗位转换、学习培训等紧密挂钩，及时进行奖惩兑现。</p>\r\n<h3>\r\n	三、员工福利</h3>\r\n<p>\r\n	公司始终把职工待遇的改善和企业经营业绩的提升摆在同等重要位置，坚持以人为本，在保障企业健康发展的同时，稳步提高员工工资待遇。</p>\r\n<p>\r\n	在员工福利上，对管理、技术人员实行年薪制，对技能员工按国家规定指导线持续提高工资水平，对行业领军人才实行协议工资。</p>\r\n<p>\r\n	发放职称津贴、交通补助、工作餐补贴、卫生津贴、外派人员补助、中夜班津贴、井下作业津贴、降温费等津贴、补助。</p>\r\n<p>\r\n	出台员工素质提升奖励政策，鼓励员工立足岗位自学成才。</p>\r\n<p>\r\n	严格按照国家有关规定为员工及时足额缴纳“五险一金”， 面向一定范围内的员工提供股权奖励、企业年金、补充医疗保险、大病救助、劳动保护、子女上学资助、困难员工帮扶和独生子女优惠等福利保障。</p>\r\n', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('24', '0', '人才招聘', '', 'jiaruwomen/rencaizhaopin', '21', '', '21,24', '2', '3', '10041003', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '人才招聘', '', '', '&nbsp;\r\n<h5>\r\n	新媒体运营主管</h5>\r\n<p>\r\n	岗位职责：</p>\r\n<ol>\r\n	<li>\r\n		公司微博、微信相关原创（伪原创）内容撰写与发布,、维护、管理、互动及新闻监控，提高影响力和关注度；</li>\r\n	<li>\r\n		微博、微信的发展、定位建议（包括第三方平台等内容的搭建建议）；</li>\r\n	<li>\r\n		策划并执行微博、微信推广活动，通过有效运营手段提升粉丝活跃度；跟踪微博、微信推广效果，分析数据并反馈；</li>\r\n</ol>\r\n<p>\r\n	岗位要求：</p>\r\n<ol>\r\n	<li>\r\n		具备较强的分析，判断和概括能力，有极佳文字功底及策划能力，善于捕捉当前热点，有优秀的专题策划能力及组织经验；</li>\r\n	<li>\r\n		对同类产品内容的运营点及传播性有敏感的触觉，一定的理解，对微信和微博有一定的营销战略思想，对微信和微博有自己独到的见解；</li>\r\n	<li>\r\n		注重细节，执行力极强，能承受巨大的工作压力，有超强的自我驱动能力，具有良好的沟通能力，有团队管理经验者优先；</li>\r\n	<li>\r\n		有丰富的自定义互动游戏策划经验，并且熟悉与程序开发团队的对接流程。</li>\r\n</ol>\r\n<p>\r\n	&nbsp;</p>\r\n<h5>\r\n	策划文案</h5>\r\n<p>\r\n	岗位职责：</p>\r\n<ol>\r\n	<li>\r\n		组织参与重要项目的创意构思、文案及客户提案, 给予前期提案、创意说明及后期结案报告等服务；</li>\r\n	<li>\r\n		执行并监督所负责项目的创意构思和文案；</li>\r\n	<li>\r\n		稿件思路清晰，能够独立完成稿件写作思路规划；</li>\r\n	<li>\r\n		协助项目经理进行创意提案，保证工作的顺利推进；</li>\r\n	<li>\r\n		能独立撰写各类稿件（新闻稿、综述稿、评论稿、专访稿等）、策划方案、报告等</li>\r\n</ol>\r\n<p>\r\n	岗位要求：</p>\r\n<ol>\r\n	<li>\r\n		新闻学、传播学、中文、经济管理类相关专业，大学专科以上学历；</li>\r\n	<li>\r\n		熟悉广告传媒行业，三年以上活动策划及文案工作经验；</li>\r\n	<li>\r\n		能够准确捕捉亮点，具备恰如其分的文字表现能力；</li>\r\n	<li>\r\n		熟悉专业创意方法，思维敏捷，洞察力强，文字功底扎实，语言表达能力强；</li>\r\n	<li>\r\n		能独立完成项目、广告等推广文案的撰写</li>\r\n</ol>\r\n<p>\r\n	&nbsp;</p>\r\n<h5>\r\n	品牌策划</h5>\r\n<p>\r\n	岗位职责：</p>\r\n<ol>\r\n	<li>\r\n		组织参与重要项目的创意构思、文案及客户提案, 给予前期提案、创意说明及后期结案报告等服务；</li>\r\n	<li>\r\n		执行并监督所负责项目的创意构思和文案；</li>\r\n	<li>\r\n		稿件思路清晰，能够独立完成稿件写作思路规划；</li>\r\n	<li>\r\n		协助项目经理进行创意提案，保证工作的顺利推进；</li>\r\n	<li>\r\n		能独立撰写各类稿件（新闻稿、综述稿、评论稿、专访稿等）、策划方案、报告等</li>\r\n</ol>\r\n<p>\r\n	岗位要求:</p>\r\n<ol>\r\n	<li>\r\n		广告学、新闻学、经济管理类相关专业，大学专科以上学历；</li>\r\n	<li>\r\n		熟悉广告传媒行业，三年以上品牌策划及文案工作经验；</li>\r\n	<li>\r\n		能够准确捕捉亮点，具备恰如其分的文字表现能力；</li>\r\n	<li>\r\n		熟悉专业创意方法，思维敏捷，洞察力强，文字功底扎实，语言表达能力强；</li>\r\n	<li>\r\n		能独立完成项目、广告等推广文案的撰写。</li>\r\n</ol>\r\n', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('13', '0', '客户见证', '', 'shehuizeren/huanjingbaohu', '0', '', '13', '1', '5', '1005', 'news', 'news', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '社会责任', '', '', '&nbsp;', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('27', '0', '销售网络', '', 'xiaoshouwangluo', '0', '', '27', '1', '6', '1006', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '<div style=\"text-align: center;\">\r\n	&nbsp;<img alt=\"\" src=\"/storage/images/20211213/1-160G9161350Y8.jpg\" style=\"width: 700px; height: 554px;\" /></div>\r\n', '', 'true', '1639365427');
INSERT INTO `rrz_article_nodes` VALUES ('25', '0', '联系我们', '', 'lianxiwomen', '0', '', '25', '1', '7', '1007', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '联系我们', '电话：+86-9999-66666传真：+86-8888-55555网址：邮箱：admin@rrzcms.com地址：天朝天堂路99号', '', '<div style=\"text-align: center;\">\r\n	电话：+86-9999-66666</div><div style=\"text-align: center;\">\r\n	传真：+86-8888-55555</div><div style=\"text-align: center;\">\r\n	网址：</div><div style=\"text-align: center;\">\r\n	邮箱：admin@rrzcms.com</div><div style=\"text-align: center;\">\r\n	地址：天朝天堂路99号<br/>\r\n	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img alt=\"\" src=\"/storage/images/20211213/1-160G9155R4353.png\" style=\"width: 1085px; height: 379px;\"/></div>', '', 'true', '1639380565');
INSERT INTO `rrz_article_nodes` VALUES ('26', '0', '首页幻灯', '', 'shouyehuandeng', '0', '', '26', '1', '8', '1008', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '首页幻灯', '', '', '&nbsp;', '', 'false', '1639365427');

-- ----------------------------
-- Table structure for `rrz_articles`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_articles`;
CREATE TABLE `rrz_articles` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `node_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章标题',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '文章配图',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `uptime` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  `pubtime` int(10) unsigned DEFAULT '0' COMMENT '文章发布时间',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '发布',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '文章创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `source` varchar(100) NOT NULL DEFAULT '' COMMENT '来源',
  `source_url` varchar(255) NOT NULL DEFAULT '' COMMENT '来源URL',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_node_id` (`node_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章';

-- -----------------------------
-- Records of `rrz_articles`
-- -----------------------------
INSERT INTO `rrz_articles` VALUES ('1', '4', '荣誉资质1', '', '/storage/images/20211213/1-160G31634120-L.jpg', '', '', '', 'admin', '', '1468398856', '1468398856', 'true', '', '', '荣誉,资质,荣誉,资质,', '60', '1468398832', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('2', '4', '荣誉资质2', '', '/storage/images/20211213/1-160G31634250-L.jpg', '', '', '', 'admin', '', '1468398871', '1468398871', 'true', '', '', '荣誉,资质,荣誉,资质,', '116', '1468398859', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('3', '4', '荣誉资质3', '', '/storage/images/20211213/1-160G31634400-L.jpg', '', '', '', 'admin', '', '1468398887', '1468398887', 'true', '', '', '荣誉,资质,荣誉,资质,', '125', '1468398874', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('4', '4', '荣誉资质4', '', '/storage/images/20211213/1-160G31635060-L.jpg', '', '', '', 'admin', '', '1468398912', '1468398912', 'true', '', '', '荣誉,资质,荣誉,资质,', '106', '1468398901', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('5', '4', '荣誉资质5', '', '/storage/images/20211213/1-160G31635190-L.jpg', '', '', '', 'admin', '', '1468398926', '1468398926', 'true', '', '', '荣誉,资质,荣誉,资质,', '115', '1468398915', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('6', '9', '黄磷', '', '/storage/images/20211213/1AH03153-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"黄磷\" src=\"/storage/images/20211213/1AH03153-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		黄磷</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468400240', '1468400240', 'true', '', '黄磷 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存', '黄磷,黄磷,化学式,分子量,123.90,执行,标准,', '92', '1468400171', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('7', '9', '甲缩醛', '', '/storage/images/20211213/1AJ2BL-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"甲缩醛\" src=\"/storage/images/20211213/1AJ2BL-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		甲缩醛</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468400262', '1468400262', 'true', '', '甲缩醛 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应', '甲缩,醛,甲缩,醛,化学式,分子量,123.90,执行,', '120', '1468400253', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('8', '9', '黄磷', '', '/storage/images/20211213/1AH03153-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"黄磷\" src=\"/storage/images/20211213/1AH03153-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		黄磷</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468400240', '1468400240', 'true', '', '黄磷 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存', '黄磷,黄磷,化学式,分子量,123.90,执行,标准,', '92', '1468400171', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('9', '9', '甲缩醛', '', '/storage/images/20211213/1AJ2BL-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"甲缩醛\" src=\"/storage/images/20211213/1AJ2BL-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		甲缩醛</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468400262', '1468400262', 'true', '', '甲缩醛 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应', '甲缩,醛,甲缩,醛,化学式,分子量,123.90,执行,', '120', '1468400253', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('10', '9', '黄磷', '', '/storage/images/20211213/1AH03153-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"黄磷\" src=\"/storage/images/20211213/1AH03153-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		黄磷</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468400240', '1468400240', 'true', '', '黄磷 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存', '黄磷,黄磷,化学式,分子量,123.90,执行,标准,', '92', '1468400171', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('11', '9', '甲缩醛', '', '/storage/images/20211213/1AJ2BL-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"甲缩醛\" src=\"/storage/images/20211213/1AJ2BL-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		甲缩醛</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468400262', '1468400262', 'true', '', '甲缩醛 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应', '甲缩,醛,甲缩,醛,化学式,分子量,123.90,执行,', '120', '1468400253', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('12', '9', '黄磷', '', '/storage/images/20211213/1AH03153-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"黄磷\" src=\"/storage/images/20211213/1AH03153-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		黄磷</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468400240', '1468400240', 'true', '', '黄磷 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存', '黄磷,黄磷,化学式,分子量,123.90,执行,标准,', '92', '1468400171', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('13', '9', '甲缩醛', '', '/storage/images/20211213/1AJ2BL-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"甲缩醛\" src=\"/storage/images/20211213/1AJ2BL-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		甲缩醛</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468400262', '1468400262', 'true', '', '甲缩醛 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应', '甲缩,醛,甲缩,醛,化学式,分子量,123.90,执行,', '120', '1468400253', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('14', '9', '黄磷', '', '/storage/images/20211213/1AH03153-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"黄磷\" src=\"/storage/images/20211213/1AH03153-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		黄磷</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468400240', '1468400240', 'true', '', '黄磷 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存', '黄磷,黄磷,化学式,分子量,123.90,执行,标准,', '92', '1468400171', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('15', '9', '甲缩醛', '', '/storage/images/20211213/1AJ2BL-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"甲缩醛\" src=\"/storage/images/20211213/1AJ2BL-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		甲缩醛</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468400262', '1468400262', 'true', '', '甲缩醛 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应', '甲缩,醛,甲缩,醛,化学式,分子量,123.90,执行,', '120', '1468400253', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('16', '10', '磷酸氢钙', '', '/storage/images/20211213/1G92J912-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"磷酸氢钙\" src=\"/storage/images/20211213/1G92J912-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		磷酸氢钙</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468401567', '1468401567', 'true', '', '磷酸氢钙 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时', '磷酸,氢钙,磷酸,氢钙,化学式,分子量,123.90,', '188', '1468401555', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('17', '10', '焦磷酸钾', '', '/storage/images/20211213/1G94B940-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"焦磷酸钾\" src=\"/storage/images/20211213/1G94B940-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		焦磷酸钾</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468401586', '1468401586', 'true', '', '焦磷酸钾 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时', '焦,磷酸,钾,焦,磷酸,钾,化学式,分子量,123.90,', '67', '1468401576', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('18', '10', '磷酸氢二钾', '', '/storage/images/20211213/1H0051314-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"磷酸氢二钾\" src=\"/storage/images/20211213/1H0051314-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		磷酸氢二钾</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468401605', '1468401605', 'true', '', '磷酸氢二钾 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运', '磷酸,氢,二钾,磷酸,氢,二钾,化学式,分子量,', '79', '1468401593', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('19', '10', '氢氧化钠', '', '/storage/images/20211213/1H0231925-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"氢氧化钠\" src=\"/storage/images/20211213/1H0231925-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		氢氧化钠</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468401623', '1468401623', 'true', '', '氢氧化钠 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时', '氢氧化钠,氢氧化钠,化学式,分子量,123.90,执行,', '130', '1468401613', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('20', '11', '甘氨酸', '', '/storage/images/20211213/1H0493531-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"甘氨酸\" src=\"/storage/images/20211213/1H0493531-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		甘氨酸</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468401649', '1468401649', 'true', '', '甘氨酸 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应', '甘,氨酸,甘,氨酸,化学式,分子量,123.90,执行,', '125', '1468401639', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('21', '12', '磷铁', '', '/storage/images/20211213/1H13312N-0-lp.jpg', '', '<div>\r\n	<p style=\"text-align: center;\">\r\n		<img alt=\"磷铁\" src=\"/storage/images/20211213/1H13312N-0.jpg\" /></p>\r\n</div>\r\n<div>\r\n	<h1 style=\"text-align: center;\">\r\n		磷铁</h1>\r\n</div>\r\n<div>\r\n	<div>\r\n		<p style=\"text-align: center;\">\r\n			化学式：P4</p>\r\n		<p style=\"text-align: center;\">\r\n			分子量：123.90</p>\r\n		<p style=\"text-align: center;\">\r\n			执行标准：GB 7816-1998</p>\r\n		<p style=\"text-align: center;\">\r\n			性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存放于水中。有剧毒，其蒸气在空气中最大允许浓度为0.00003mg/l。</p>\r\n		<p style=\"text-align: center;\">\r\n			用途：主要用于生产赤磷、磷酸、各种卤化磷、硫化磷、磷酸盐、磷酸酯以及有机磷农药。</p>\r\n		<p style=\"text-align: center;\">\r\n			包装贮存：200L铁桶包装。应贮存于阴凉、通风良好的专用库房内，远离火源。应与氧化剂、酸类、卤素等化学品分开存放。</p>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1468401693', '1468401693', 'true', '', '磷铁 化学式：P4 分子量：123.90 执行标准：GB 7816-1998 性状：又称白磷。黄白色蜡状，具有光泽的固体，难溶于水，易溶于二硫化碳及磷的卤化物中。在空气中35℃即可自燃。贮运时应存', '磷铁,磷铁,化学式,分子量,123.90,执行,标准,', '98', '1468401685', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('22', '18', '做你自己，不要刻意去取悦别人', '', '/storage/images/20211213/1IH3K55-0-lp.jpg', '', '<p>\r\n	<img alt=\"做你自己，不要刻意去取悦别人\" src=\"/storage/images/20211213/1IH3K55-0.jpg\" title=\"做你自己，不要刻意去取悦别人\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如果我们把自己的心的主权全部交给了别人，别人就不会珍惜，并且随时有可能摧毁它。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我相信，每个人都痛恨过自己，时常有那么一瞬间，自己做出来的事情，说出来的话，连自己都不敢相信。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	你是否也曾经有意无意地用“讨好的语言”来讨人喜欢过？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	迎合别人的感觉，真不好！</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	其实，很多人都会犯这样的错，这是人之常情。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	有很多女人，包括我自己，怕被人不喜欢、怕惹人闲话、怕别人看不起自己，于是会不惜一切地迎合别人，讨人喜欢，连自己的防线都可以不顾。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一味希望得到别人喜欢、追求肯定的人，会觉得筑一道守得住的自我围墙不是一件容易的事。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我有一个朋友，在外企公司工作了两年，眼看着周围的同事都高升了，自己却毫无动静，就找到一家培训公司要求学习管理技巧。培训师听了她的讲述后，首先安排了一堂别开生面的课：让自己成为一个果敢的女人！</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	培训师告诉她：她目前非常有必要先在自己的心中建筑一道墙，这道墙是一条防线，在这道墙之内，她是安全的，她可以不必看别人的脸色，也不必战战兢兢、害怕得罪人。当然，这道墙还有抵挡闲言碎语的作用。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	上完这堂课，她开始明白：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	受欢迎是件好事，但不必要时时处处受欢迎。人人喜欢、人人爱，是谁都不可能做到的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	很快，这个女孩子的“那道墙”，就让她的状况发生了改变，当她第一次向冒犯自己的同事表示强硬态度的时候，弄得对方愕然不知所措。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从此，她在职场备受礼遇。她只管做好自己的事，不再为人际关系发愁。也因注意力集中，能力出众，迅速升职。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这就是，“一堵墙造就好邻居。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	想通过一味掏心，讨好别人来获得别人同样的回报是很难的。所以我们有必要捍卫自己内心的空间，拿捏“硬”与“软”的尺度。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如果我们把自己的心的主权全权交给了别人，别人就不会珍惜，并且随时有可能摧毁它。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	所以，请不要太介意别人对自己的好恶。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	夸也好，贬也好，无所谓，看开些。请记住以下三点原则：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	1、你有说“不”的权利。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2、你有表达意见的权利。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	3、你有保持沉默的权利。这是我们每一个人必修的课题。从现在开始，我们都要开始好好修炼自己。</p>\r\n<p>\r\n	&nbsp;</p>\r\n', '', 'admin', '', '1468402643', '1468402643', 'true', '', '如果我们把自己的心的主权全部交给了别人，别人就不会珍惜，并且随时有可能摧毁它。 我相信，每个人都痛恨过自己，时常有那么一瞬间，自己做出来的事情，说出来的话，连自己都', '做,你自己,不要,刻意,去,取悦,别人,如果,我们,', '120', '1468402606', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('23', '18', '藏，是懂得最深的慈悲', '', '/storage/images/20211213/1IJ4N29-0-lp.jpg', '', '<p>\r\n	<img alt=\"藏，是懂得最深的慈悲\" src=\"/storage/images/20211213/1IJ4N29-0.jpg\" title=\"藏，是懂得最深的慈悲\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	裁一帛光阴，写一阕旧词，字里行间，蕴着清风明月的境，含了幽篁篱菊的情，读在眼眸里，便是一段故事，读在往事中，便是一曲心音，读在岁月里，便是一林静好。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	红尘漫漫，吹不尽的忧伤最易迷眼，翻不尽的章节最易断肠，天高云淡，极目远眺，谁人相忆在江楼。是谁，独自守着窗儿，蘸了盈袖的暗香，研了梧桐黄昏细雨，落下瘦比黄花的文字，欲说还休？是谁，秋风悲画扇，以三更的落梅横笛，在断肠声里忆念平生？是谁，因了懂得，披了一袭的慈悲，因了安好，从尘埃里开了一朵花，又从这一朵花里开了一生的寂寞？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	远去了，那些藤蔓一样生长的忧伤，那些近乎心碎的眺望。但光阴，悄然地留下那一尊尊诗的背影，在每一行黯然神伤的诗句后，浇开了一路芬芳，筑就了一堤风景。风景是光阴精心酿制的一壶酒，需要在一个恰当的时候恰当的地方打开，才会醇香满怀。是的，对于四季递嬗的节奏，一个人，常常习惯了那一季里开场的欣喜，花开春暖，踏雪寻梅，习惯了那一场渐入佳境的悠扬与繁盛，月色荷塘，晚照枫林，而最不可忽略的往往是那令人沉醉的一朵寂静，一片留白，甚至只是一个休止符的默然憩息，一曲轻音乐的余音袅袅，因为它们不只是在吸引，更是在撩拨，撩拨那溪水般潺潺的心动，撩拨那藏在岁月深处的一幅幅生动。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	无言，总在故事里沉淀，回味却在沉淀中升华。品人生的一帧画，画里蕴藏着太多的悲喜笔墨，氤氲着太多的苦乐色调。不见底色，也无需结局，那一程一程生活的山水，已沧桑了故事的所有过往，也洗淡了日子的平平仄仄，绘成为心野上的一抹平静，一片清幽。忧愁终会融化，在恬淡的思绪里流成清清溪水，坎坷也终会定格，在回忆的远方描摹成一线水岸。面对人生的多姿多彩，寻寻觅觅，结果浓缩在一个淡字之中，打开心扉，发现，许多的过往，只是流光的呢喃，怎样的选择，本身就是一道无解，怎样的答案，本身就是一抹纯粹，弱水三千，只取一瓢，大千世界，惟简为上。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不经意间，光阴里藏着的那股暖，如一缕熏风，拂过闲坐的罅隙，落入了怀想的庭院。多少往事走成了背影，多少背影又镌刻成了怀念，点点滴滴，让文字有了温度，让记忆有了诗意。童年的嬉戏远去了，那翻过的一页，似乎还能倒背如流；故乡的炊烟远去了，那隔岸的风景，依稀可在乡音里重现。一些故事已经支离破碎，很多细节却浣洗得干净、素朴，暖着寸寸光阴，暖着栉风沐雨过的友情爱情亲情。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	久远的遐想，行着行着，就回到自己的内心。独坐是一种形式，寂寥是一条蹊径，通往了南山的柴篱野菊，也通往了东山的明月清风。这时，一个人的时光，流淌在字里行间，澄澈见底，心思也是透明的，薄得像月光。这是一个寂静的天地，没有喧嚣，没有熙攘，夏来，可相看两不厌，冬来，可独钓寒江雪，枕着几行诗句，默言自照，尘风不扰。这时，可以在藏着的故事里翻阅那些曾经的悸动，检索那些曾经的现已长满藤蔓的心思，可以在暗夜的一角为自己开一扇明媚的小窗，让久远记忆中的月光曲吹拂进来，而自己，瞬时成为了自我的鉴赏者，消弭去无端的迷失，皈依了内心的菩提，无需一盏茶，半卷书，便已闲适自来，惬意自曳。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	时光知味，山水知心，每一寸光阴都度着人生的苦辣酸甜，每一帧山水都含着灵犀的浓淡色彩，而山水中的一草一木，一云一溪，吐纳着素朴的生命气息，观照着内心的闲逸平和。看山是山，看水是水，多少烟霭笼过，多少清溪流过，多少寂静的声音聆听过，这才有原本的山，原本的水，在一粒心的四域，回响起悠远的云水禅音。一片石，嶙峋也罢，乖巧也罢，山，总在它的心里；一苔藓，深绿也罢，浅灰也罢，石，总在它的心里。一物一人，无论大小，无论深浅，相依便是谐和，入心便是平和，这山、石、苔藓，就有了层叠的风景，就有了懂得的慈悲。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一眸可以览尽远近，一心可以悟得动静。茂林修竹，流觞曲水，人生的愉悦，常常在无尽的慨叹中错失。面对沟壑，一转身，来路上却是开满芳华，人生的风景总青睐于每个人的来路，藏匿于时空的一隅，随遇而显，随缘而开。纵使凭着一叶苦舟，也可行到水穷处，在坐看云起时，心的宁静就是云卷云舒，自得其乐；纵使隔着重重羁旅，也可江花与芳草，莫染我情田，心的闲适就是江花自开，芳草自茂。众声喧哗，终会隐没于高山流水，一场喧嚣，远不及懂得的山高水长，藏，把自己的心野，无垠地延展，也把自己的情思，无声地浓缩。所以，一帧“悲欣交集”里，那慈悲的感喟，把人生的际遇叹尽，一行“风雪夜归人”中，那温暖的皈依，把现实的艰辛咏完，直抵灵魂深处的春暖花开。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	流年的书页里，很多故事已经泛黄，但落字的墨香越显醇厚。闲暇时，常常品味马远的《寒江独钓图》 ，山之角，水之涯，只取半边，山水全在心中，空疏溢于画外，喜欢赏鉴云林的《疏林茅舍》，寒林荒原，一片萧瑟，略了山光水色，略了熙来攘往，只剩得，一重逸气藏于胸中。人生一树花开，那一番生机，不在于繁密，而在于取舍，该收则收，该藏则藏，如此，种一垄懂得，拥半亩明媚，持一心慈悲。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	藏，是一种懂得，是懂得里一潭最深的慈悲。你不来，我还在，藏是一株守望，只在心中描着业已淡去的诺言；时不来，景还在，藏是一份释怀，是跋涉在苦痛的对岸留下的一道永恒微笑；念不来，心还在，藏是一溪宁静，浴了岁月的烟火，袭了流年的清欢，让自己清晰地聆听内心至纯的梵音。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如若 ，一幕风景如约而来，如若，一场告别不期而至，那就以慈悲的名义，在懂得的心巷中珍藏，而巷外，看小桥，流水，人家，清淡依然，宁静如常。</p>\r\n', '', 'admin', '', '1468402664', '1468402664', 'true', '', '裁一帛光阴，写一阕旧词，字里行间，蕴着清风明月的境，含了幽篁篱菊的情，读在眼眸里，便是一段故事，读在往事中，便是一曲心音，读在岁月里，便是一林静好。 红尘漫漫，吹不', '藏,是,懂得,最,深的,慈悲,裁,一帛,光阴,写,', '150', '1468402651', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('24', '18', '做你自己，不要刻意去取悦别人', '', '/storage/images/20211213/1IH3K55-0-lp.jpg', '', '<p>\r\n	<img alt=\"做你自己，不要刻意去取悦别人\" src=\"/storage/images/20211213/1IH3K55-0.jpg\" title=\"做你自己，不要刻意去取悦别人\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如果我们把自己的心的主权全部交给了别人，别人就不会珍惜，并且随时有可能摧毁它。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我相信，每个人都痛恨过自己，时常有那么一瞬间，自己做出来的事情，说出来的话，连自己都不敢相信。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	你是否也曾经有意无意地用“讨好的语言”来讨人喜欢过？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	迎合别人的感觉，真不好！</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	其实，很多人都会犯这样的错，这是人之常情。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	有很多女人，包括我自己，怕被人不喜欢、怕惹人闲话、怕别人看不起自己，于是会不惜一切地迎合别人，讨人喜欢，连自己的防线都可以不顾。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一味希望得到别人喜欢、追求肯定的人，会觉得筑一道守得住的自我围墙不是一件容易的事。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我有一个朋友，在外企公司工作了两年，眼看着周围的同事都高升了，自己却毫无动静，就找到一家培训公司要求学习管理技巧。培训师听了她的讲述后，首先安排了一堂别开生面的课：让自己成为一个果敢的女人！</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	培训师告诉她：她目前非常有必要先在自己的心中建筑一道墙，这道墙是一条防线，在这道墙之内，她是安全的，她可以不必看别人的脸色，也不必战战兢兢、害怕得罪人。当然，这道墙还有抵挡闲言碎语的作用。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	上完这堂课，她开始明白：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	受欢迎是件好事，但不必要时时处处受欢迎。人人喜欢、人人爱，是谁都不可能做到的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	很快，这个女孩子的“那道墙”，就让她的状况发生了改变，当她第一次向冒犯自己的同事表示强硬态度的时候，弄得对方愕然不知所措。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从此，她在职场备受礼遇。她只管做好自己的事，不再为人际关系发愁。也因注意力集中，能力出众，迅速升职。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这就是，“一堵墙造就好邻居。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	想通过一味掏心，讨好别人来获得别人同样的回报是很难的。所以我们有必要捍卫自己内心的空间，拿捏“硬”与“软”的尺度。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如果我们把自己的心的主权全权交给了别人，别人就不会珍惜，并且随时有可能摧毁它。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	所以，请不要太介意别人对自己的好恶。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	夸也好，贬也好，无所谓，看开些。请记住以下三点原则：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	1、你有说“不”的权利。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2、你有表达意见的权利。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	3、你有保持沉默的权利。这是我们每一个人必修的课题。从现在开始，我们都要开始好好修炼自己。</p>\r\n<p>\r\n	&nbsp;</p>\r\n', '', 'admin', '', '1468402643', '1468402643', 'true', '', '如果我们把自己的心的主权全部交给了别人，别人就不会珍惜，并且随时有可能摧毁它。 我相信，每个人都痛恨过自己，时常有那么一瞬间，自己做出来的事情，说出来的话，连自己都', '做,你自己,不要,刻意,去,取悦,别人,如果,我们,', '120', '1468402606', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('25', '18', '藏，是懂得最深的慈悲', '', '/storage/images/20211213/1IJ4N29-0-lp.jpg', '', '<p>\r\n	<img alt=\"藏，是懂得最深的慈悲\" src=\"/storage/images/20211213/1IJ4N29-0.jpg\" title=\"藏，是懂得最深的慈悲\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	裁一帛光阴，写一阕旧词，字里行间，蕴着清风明月的境，含了幽篁篱菊的情，读在眼眸里，便是一段故事，读在往事中，便是一曲心音，读在岁月里，便是一林静好。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	红尘漫漫，吹不尽的忧伤最易迷眼，翻不尽的章节最易断肠，天高云淡，极目远眺，谁人相忆在江楼。是谁，独自守着窗儿，蘸了盈袖的暗香，研了梧桐黄昏细雨，落下瘦比黄花的文字，欲说还休？是谁，秋风悲画扇，以三更的落梅横笛，在断肠声里忆念平生？是谁，因了懂得，披了一袭的慈悲，因了安好，从尘埃里开了一朵花，又从这一朵花里开了一生的寂寞？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	远去了，那些藤蔓一样生长的忧伤，那些近乎心碎的眺望。但光阴，悄然地留下那一尊尊诗的背影，在每一行黯然神伤的诗句后，浇开了一路芬芳，筑就了一堤风景。风景是光阴精心酿制的一壶酒，需要在一个恰当的时候恰当的地方打开，才会醇香满怀。是的，对于四季递嬗的节奏，一个人，常常习惯了那一季里开场的欣喜，花开春暖，踏雪寻梅，习惯了那一场渐入佳境的悠扬与繁盛，月色荷塘，晚照枫林，而最不可忽略的往往是那令人沉醉的一朵寂静，一片留白，甚至只是一个休止符的默然憩息，一曲轻音乐的余音袅袅，因为它们不只是在吸引，更是在撩拨，撩拨那溪水般潺潺的心动，撩拨那藏在岁月深处的一幅幅生动。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	无言，总在故事里沉淀，回味却在沉淀中升华。品人生的一帧画，画里蕴藏着太多的悲喜笔墨，氤氲着太多的苦乐色调。不见底色，也无需结局，那一程一程生活的山水，已沧桑了故事的所有过往，也洗淡了日子的平平仄仄，绘成为心野上的一抹平静，一片清幽。忧愁终会融化，在恬淡的思绪里流成清清溪水，坎坷也终会定格，在回忆的远方描摹成一线水岸。面对人生的多姿多彩，寻寻觅觅，结果浓缩在一个淡字之中，打开心扉，发现，许多的过往，只是流光的呢喃，怎样的选择，本身就是一道无解，怎样的答案，本身就是一抹纯粹，弱水三千，只取一瓢，大千世界，惟简为上。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不经意间，光阴里藏着的那股暖，如一缕熏风，拂过闲坐的罅隙，落入了怀想的庭院。多少往事走成了背影，多少背影又镌刻成了怀念，点点滴滴，让文字有了温度，让记忆有了诗意。童年的嬉戏远去了，那翻过的一页，似乎还能倒背如流；故乡的炊烟远去了，那隔岸的风景，依稀可在乡音里重现。一些故事已经支离破碎，很多细节却浣洗得干净、素朴，暖着寸寸光阴，暖着栉风沐雨过的友情爱情亲情。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	久远的遐想，行着行着，就回到自己的内心。独坐是一种形式，寂寥是一条蹊径，通往了南山的柴篱野菊，也通往了东山的明月清风。这时，一个人的时光，流淌在字里行间，澄澈见底，心思也是透明的，薄得像月光。这是一个寂静的天地，没有喧嚣，没有熙攘，夏来，可相看两不厌，冬来，可独钓寒江雪，枕着几行诗句，默言自照，尘风不扰。这时，可以在藏着的故事里翻阅那些曾经的悸动，检索那些曾经的现已长满藤蔓的心思，可以在暗夜的一角为自己开一扇明媚的小窗，让久远记忆中的月光曲吹拂进来，而自己，瞬时成为了自我的鉴赏者，消弭去无端的迷失，皈依了内心的菩提，无需一盏茶，半卷书，便已闲适自来，惬意自曳。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	时光知味，山水知心，每一寸光阴都度着人生的苦辣酸甜，每一帧山水都含着灵犀的浓淡色彩，而山水中的一草一木，一云一溪，吐纳着素朴的生命气息，观照着内心的闲逸平和。看山是山，看水是水，多少烟霭笼过，多少清溪流过，多少寂静的声音聆听过，这才有原本的山，原本的水，在一粒心的四域，回响起悠远的云水禅音。一片石，嶙峋也罢，乖巧也罢，山，总在它的心里；一苔藓，深绿也罢，浅灰也罢，石，总在它的心里。一物一人，无论大小，无论深浅，相依便是谐和，入心便是平和，这山、石、苔藓，就有了层叠的风景，就有了懂得的慈悲。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一眸可以览尽远近，一心可以悟得动静。茂林修竹，流觞曲水，人生的愉悦，常常在无尽的慨叹中错失。面对沟壑，一转身，来路上却是开满芳华，人生的风景总青睐于每个人的来路，藏匿于时空的一隅，随遇而显，随缘而开。纵使凭着一叶苦舟，也可行到水穷处，在坐看云起时，心的宁静就是云卷云舒，自得其乐；纵使隔着重重羁旅，也可江花与芳草，莫染我情田，心的闲适就是江花自开，芳草自茂。众声喧哗，终会隐没于高山流水，一场喧嚣，远不及懂得的山高水长，藏，把自己的心野，无垠地延展，也把自己的情思，无声地浓缩。所以，一帧“悲欣交集”里，那慈悲的感喟，把人生的际遇叹尽，一行“风雪夜归人”中，那温暖的皈依，把现实的艰辛咏完，直抵灵魂深处的春暖花开。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	流年的书页里，很多故事已经泛黄，但落字的墨香越显醇厚。闲暇时，常常品味马远的《寒江独钓图》 ，山之角，水之涯，只取半边，山水全在心中，空疏溢于画外，喜欢赏鉴云林的《疏林茅舍》，寒林荒原，一片萧瑟，略了山光水色，略了熙来攘往，只剩得，一重逸气藏于胸中。人生一树花开，那一番生机，不在于繁密，而在于取舍，该收则收，该藏则藏，如此，种一垄懂得，拥半亩明媚，持一心慈悲。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	藏，是一种懂得，是懂得里一潭最深的慈悲。你不来，我还在，藏是一株守望，只在心中描着业已淡去的诺言；时不来，景还在，藏是一份释怀，是跋涉在苦痛的对岸留下的一道永恒微笑；念不来，心还在，藏是一溪宁静，浴了岁月的烟火，袭了流年的清欢，让自己清晰地聆听内心至纯的梵音。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如若 ，一幕风景如约而来，如若，一场告别不期而至，那就以慈悲的名义，在懂得的心巷中珍藏，而巷外，看小桥，流水，人家，清淡依然，宁静如常。</p>\r\n', '', 'admin', '', '1468402664', '1468402664', 'true', '', '裁一帛光阴，写一阕旧词，字里行间，蕴着清风明月的境，含了幽篁篱菊的情，读在眼眸里，便是一段故事，读在往事中，便是一曲心音，读在岁月里，便是一林静好。 红尘漫漫，吹不', '藏,是,懂得,最,深的,慈悲,裁,一帛,光阴,写,', '150', '1468402651', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('26', '18', '做你自己，不要刻意去取悦别人', '', '/storage/images/20211213/1IH3K55-0-lp.jpg', '', '<p>\r\n	<img alt=\"做你自己，不要刻意去取悦别人\" src=\"/storage/images/20211213/1IH3K55-0.jpg\" title=\"做你自己，不要刻意去取悦别人\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如果我们把自己的心的主权全部交给了别人，别人就不会珍惜，并且随时有可能摧毁它。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我相信，每个人都痛恨过自己，时常有那么一瞬间，自己做出来的事情，说出来的话，连自己都不敢相信。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	你是否也曾经有意无意地用“讨好的语言”来讨人喜欢过？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	迎合别人的感觉，真不好！</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	其实，很多人都会犯这样的错，这是人之常情。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	有很多女人，包括我自己，怕被人不喜欢、怕惹人闲话、怕别人看不起自己，于是会不惜一切地迎合别人，讨人喜欢，连自己的防线都可以不顾。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一味希望得到别人喜欢、追求肯定的人，会觉得筑一道守得住的自我围墙不是一件容易的事。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我有一个朋友，在外企公司工作了两年，眼看着周围的同事都高升了，自己却毫无动静，就找到一家培训公司要求学习管理技巧。培训师听了她的讲述后，首先安排了一堂别开生面的课：让自己成为一个果敢的女人！</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	培训师告诉她：她目前非常有必要先在自己的心中建筑一道墙，这道墙是一条防线，在这道墙之内，她是安全的，她可以不必看别人的脸色，也不必战战兢兢、害怕得罪人。当然，这道墙还有抵挡闲言碎语的作用。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	上完这堂课，她开始明白：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	受欢迎是件好事，但不必要时时处处受欢迎。人人喜欢、人人爱，是谁都不可能做到的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	很快，这个女孩子的“那道墙”，就让她的状况发生了改变，当她第一次向冒犯自己的同事表示强硬态度的时候，弄得对方愕然不知所措。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从此，她在职场备受礼遇。她只管做好自己的事，不再为人际关系发愁。也因注意力集中，能力出众，迅速升职。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这就是，“一堵墙造就好邻居。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	想通过一味掏心，讨好别人来获得别人同样的回报是很难的。所以我们有必要捍卫自己内心的空间，拿捏“硬”与“软”的尺度。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如果我们把自己的心的主权全权交给了别人，别人就不会珍惜，并且随时有可能摧毁它。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	所以，请不要太介意别人对自己的好恶。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	夸也好，贬也好，无所谓，看开些。请记住以下三点原则：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	1、你有说“不”的权利。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2、你有表达意见的权利。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	3、你有保持沉默的权利。这是我们每一个人必修的课题。从现在开始，我们都要开始好好修炼自己。</p>\r\n<p>\r\n	&nbsp;</p>\r\n', '', 'admin', '', '1468402643', '1468402643', 'true', '', '如果我们把自己的心的主权全部交给了别人，别人就不会珍惜，并且随时有可能摧毁它。 我相信，每个人都痛恨过自己，时常有那么一瞬间，自己做出来的事情，说出来的话，连自己都', '做,你自己,不要,刻意,去,取悦,别人,如果,我们,', '120', '1468402606', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('27', '18', '藏，是懂得最深的慈悲', '', '/storage/images/20211213/1IJ4N29-0-lp.jpg', '', '<p>\r\n	<img alt=\"藏，是懂得最深的慈悲\" src=\"/storage/images/20211213/1IJ4N29-0.jpg\" title=\"藏，是懂得最深的慈悲\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	裁一帛光阴，写一阕旧词，字里行间，蕴着清风明月的境，含了幽篁篱菊的情，读在眼眸里，便是一段故事，读在往事中，便是一曲心音，读在岁月里，便是一林静好。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	红尘漫漫，吹不尽的忧伤最易迷眼，翻不尽的章节最易断肠，天高云淡，极目远眺，谁人相忆在江楼。是谁，独自守着窗儿，蘸了盈袖的暗香，研了梧桐黄昏细雨，落下瘦比黄花的文字，欲说还休？是谁，秋风悲画扇，以三更的落梅横笛，在断肠声里忆念平生？是谁，因了懂得，披了一袭的慈悲，因了安好，从尘埃里开了一朵花，又从这一朵花里开了一生的寂寞？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	远去了，那些藤蔓一样生长的忧伤，那些近乎心碎的眺望。但光阴，悄然地留下那一尊尊诗的背影，在每一行黯然神伤的诗句后，浇开了一路芬芳，筑就了一堤风景。风景是光阴精心酿制的一壶酒，需要在一个恰当的时候恰当的地方打开，才会醇香满怀。是的，对于四季递嬗的节奏，一个人，常常习惯了那一季里开场的欣喜，花开春暖，踏雪寻梅，习惯了那一场渐入佳境的悠扬与繁盛，月色荷塘，晚照枫林，而最不可忽略的往往是那令人沉醉的一朵寂静，一片留白，甚至只是一个休止符的默然憩息，一曲轻音乐的余音袅袅，因为它们不只是在吸引，更是在撩拨，撩拨那溪水般潺潺的心动，撩拨那藏在岁月深处的一幅幅生动。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	无言，总在故事里沉淀，回味却在沉淀中升华。品人生的一帧画，画里蕴藏着太多的悲喜笔墨，氤氲着太多的苦乐色调。不见底色，也无需结局，那一程一程生活的山水，已沧桑了故事的所有过往，也洗淡了日子的平平仄仄，绘成为心野上的一抹平静，一片清幽。忧愁终会融化，在恬淡的思绪里流成清清溪水，坎坷也终会定格，在回忆的远方描摹成一线水岸。面对人生的多姿多彩，寻寻觅觅，结果浓缩在一个淡字之中，打开心扉，发现，许多的过往，只是流光的呢喃，怎样的选择，本身就是一道无解，怎样的答案，本身就是一抹纯粹，弱水三千，只取一瓢，大千世界，惟简为上。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不经意间，光阴里藏着的那股暖，如一缕熏风，拂过闲坐的罅隙，落入了怀想的庭院。多少往事走成了背影，多少背影又镌刻成了怀念，点点滴滴，让文字有了温度，让记忆有了诗意。童年的嬉戏远去了，那翻过的一页，似乎还能倒背如流；故乡的炊烟远去了，那隔岸的风景，依稀可在乡音里重现。一些故事已经支离破碎，很多细节却浣洗得干净、素朴，暖着寸寸光阴，暖着栉风沐雨过的友情爱情亲情。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	久远的遐想，行着行着，就回到自己的内心。独坐是一种形式，寂寥是一条蹊径，通往了南山的柴篱野菊，也通往了东山的明月清风。这时，一个人的时光，流淌在字里行间，澄澈见底，心思也是透明的，薄得像月光。这是一个寂静的天地，没有喧嚣，没有熙攘，夏来，可相看两不厌，冬来，可独钓寒江雪，枕着几行诗句，默言自照，尘风不扰。这时，可以在藏着的故事里翻阅那些曾经的悸动，检索那些曾经的现已长满藤蔓的心思，可以在暗夜的一角为自己开一扇明媚的小窗，让久远记忆中的月光曲吹拂进来，而自己，瞬时成为了自我的鉴赏者，消弭去无端的迷失，皈依了内心的菩提，无需一盏茶，半卷书，便已闲适自来，惬意自曳。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	时光知味，山水知心，每一寸光阴都度着人生的苦辣酸甜，每一帧山水都含着灵犀的浓淡色彩，而山水中的一草一木，一云一溪，吐纳着素朴的生命气息，观照着内心的闲逸平和。看山是山，看水是水，多少烟霭笼过，多少清溪流过，多少寂静的声音聆听过，这才有原本的山，原本的水，在一粒心的四域，回响起悠远的云水禅音。一片石，嶙峋也罢，乖巧也罢，山，总在它的心里；一苔藓，深绿也罢，浅灰也罢，石，总在它的心里。一物一人，无论大小，无论深浅，相依便是谐和，入心便是平和，这山、石、苔藓，就有了层叠的风景，就有了懂得的慈悲。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一眸可以览尽远近，一心可以悟得动静。茂林修竹，流觞曲水，人生的愉悦，常常在无尽的慨叹中错失。面对沟壑，一转身，来路上却是开满芳华，人生的风景总青睐于每个人的来路，藏匿于时空的一隅，随遇而显，随缘而开。纵使凭着一叶苦舟，也可行到水穷处，在坐看云起时，心的宁静就是云卷云舒，自得其乐；纵使隔着重重羁旅，也可江花与芳草，莫染我情田，心的闲适就是江花自开，芳草自茂。众声喧哗，终会隐没于高山流水，一场喧嚣，远不及懂得的山高水长，藏，把自己的心野，无垠地延展，也把自己的情思，无声地浓缩。所以，一帧“悲欣交集”里，那慈悲的感喟，把人生的际遇叹尽，一行“风雪夜归人”中，那温暖的皈依，把现实的艰辛咏完，直抵灵魂深处的春暖花开。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	流年的书页里，很多故事已经泛黄，但落字的墨香越显醇厚。闲暇时，常常品味马远的《寒江独钓图》 ，山之角，水之涯，只取半边，山水全在心中，空疏溢于画外，喜欢赏鉴云林的《疏林茅舍》，寒林荒原，一片萧瑟，略了山光水色，略了熙来攘往，只剩得，一重逸气藏于胸中。人生一树花开，那一番生机，不在于繁密，而在于取舍，该收则收，该藏则藏，如此，种一垄懂得，拥半亩明媚，持一心慈悲。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	藏，是一种懂得，是懂得里一潭最深的慈悲。你不来，我还在，藏是一株守望，只在心中描着业已淡去的诺言；时不来，景还在，藏是一份释怀，是跋涉在苦痛的对岸留下的一道永恒微笑；念不来，心还在，藏是一溪宁静，浴了岁月的烟火，袭了流年的清欢，让自己清晰地聆听内心至纯的梵音。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如若 ，一幕风景如约而来，如若，一场告别不期而至，那就以慈悲的名义，在懂得的心巷中珍藏，而巷外，看小桥，流水，人家，清淡依然，宁静如常。</p>\r\n', '', 'admin', '', '1468402664', '1468402664', 'true', '', '裁一帛光阴，写一阕旧词，字里行间，蕴着清风明月的境，含了幽篁篱菊的情，读在眼眸里，便是一段故事，读在往事中，便是一曲心音，读在岁月里，便是一林静好。 红尘漫漫，吹不', '藏,是,懂得,最,深的,慈悲,裁,一帛,光阴,写,', '150', '1468402651', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('28', '18', '做你自己，不要刻意去取悦别人', '', '/storage/images/20211213/1IH3K55-0-lp.jpg', '', '<p>\r\n	<img alt=\"做你自己，不要刻意去取悦别人\" src=\"/storage/images/20211213/1IH3K55-0.jpg\" title=\"做你自己，不要刻意去取悦别人\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如果我们把自己的心的主权全部交给了别人，别人就不会珍惜，并且随时有可能摧毁它。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我相信，每个人都痛恨过自己，时常有那么一瞬间，自己做出来的事情，说出来的话，连自己都不敢相信。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	你是否也曾经有意无意地用“讨好的语言”来讨人喜欢过？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	迎合别人的感觉，真不好！</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	其实，很多人都会犯这样的错，这是人之常情。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	有很多女人，包括我自己，怕被人不喜欢、怕惹人闲话、怕别人看不起自己，于是会不惜一切地迎合别人，讨人喜欢，连自己的防线都可以不顾。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一味希望得到别人喜欢、追求肯定的人，会觉得筑一道守得住的自我围墙不是一件容易的事。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我有一个朋友，在外企公司工作了两年，眼看着周围的同事都高升了，自己却毫无动静，就找到一家培训公司要求学习管理技巧。培训师听了她的讲述后，首先安排了一堂别开生面的课：让自己成为一个果敢的女人！</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	培训师告诉她：她目前非常有必要先在自己的心中建筑一道墙，这道墙是一条防线，在这道墙之内，她是安全的，她可以不必看别人的脸色，也不必战战兢兢、害怕得罪人。当然，这道墙还有抵挡闲言碎语的作用。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	上完这堂课，她开始明白：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	受欢迎是件好事，但不必要时时处处受欢迎。人人喜欢、人人爱，是谁都不可能做到的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	很快，这个女孩子的“那道墙”，就让她的状况发生了改变，当她第一次向冒犯自己的同事表示强硬态度的时候，弄得对方愕然不知所措。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从此，她在职场备受礼遇。她只管做好自己的事，不再为人际关系发愁。也因注意力集中，能力出众，迅速升职。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这就是，“一堵墙造就好邻居。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	想通过一味掏心，讨好别人来获得别人同样的回报是很难的。所以我们有必要捍卫自己内心的空间，拿捏“硬”与“软”的尺度。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如果我们把自己的心的主权全权交给了别人，别人就不会珍惜，并且随时有可能摧毁它。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	所以，请不要太介意别人对自己的好恶。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	夸也好，贬也好，无所谓，看开些。请记住以下三点原则：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	1、你有说“不”的权利。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2、你有表达意见的权利。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	3、你有保持沉默的权利。这是我们每一个人必修的课题。从现在开始，我们都要开始好好修炼自己。</p>\r\n<p>\r\n	&nbsp;</p>\r\n', '', 'admin', '', '1468402643', '1468402643', 'true', '', '如果我们把自己的心的主权全部交给了别人，别人就不会珍惜，并且随时有可能摧毁它。 我相信，每个人都痛恨过自己，时常有那么一瞬间，自己做出来的事情，说出来的话，连自己都', '做,你自己,不要,刻意,去,取悦,别人,如果,我们,', '120', '1468402606', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('29', '18', '藏，是懂得最深的慈悲', '', '/storage/images/20211213/1IJ4N29-0-lp.jpg', '', '<p>\r\n	<img alt=\"藏，是懂得最深的慈悲\" src=\"/storage/images/20211213/1IJ4N29-0.jpg\" title=\"藏，是懂得最深的慈悲\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	裁一帛光阴，写一阕旧词，字里行间，蕴着清风明月的境，含了幽篁篱菊的情，读在眼眸里，便是一段故事，读在往事中，便是一曲心音，读在岁月里，便是一林静好。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	红尘漫漫，吹不尽的忧伤最易迷眼，翻不尽的章节最易断肠，天高云淡，极目远眺，谁人相忆在江楼。是谁，独自守着窗儿，蘸了盈袖的暗香，研了梧桐黄昏细雨，落下瘦比黄花的文字，欲说还休？是谁，秋风悲画扇，以三更的落梅横笛，在断肠声里忆念平生？是谁，因了懂得，披了一袭的慈悲，因了安好，从尘埃里开了一朵花，又从这一朵花里开了一生的寂寞？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	远去了，那些藤蔓一样生长的忧伤，那些近乎心碎的眺望。但光阴，悄然地留下那一尊尊诗的背影，在每一行黯然神伤的诗句后，浇开了一路芬芳，筑就了一堤风景。风景是光阴精心酿制的一壶酒，需要在一个恰当的时候恰当的地方打开，才会醇香满怀。是的，对于四季递嬗的节奏，一个人，常常习惯了那一季里开场的欣喜，花开春暖，踏雪寻梅，习惯了那一场渐入佳境的悠扬与繁盛，月色荷塘，晚照枫林，而最不可忽略的往往是那令人沉醉的一朵寂静，一片留白，甚至只是一个休止符的默然憩息，一曲轻音乐的余音袅袅，因为它们不只是在吸引，更是在撩拨，撩拨那溪水般潺潺的心动，撩拨那藏在岁月深处的一幅幅生动。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	无言，总在故事里沉淀，回味却在沉淀中升华。品人生的一帧画，画里蕴藏着太多的悲喜笔墨，氤氲着太多的苦乐色调。不见底色，也无需结局，那一程一程生活的山水，已沧桑了故事的所有过往，也洗淡了日子的平平仄仄，绘成为心野上的一抹平静，一片清幽。忧愁终会融化，在恬淡的思绪里流成清清溪水，坎坷也终会定格，在回忆的远方描摹成一线水岸。面对人生的多姿多彩，寻寻觅觅，结果浓缩在一个淡字之中，打开心扉，发现，许多的过往，只是流光的呢喃，怎样的选择，本身就是一道无解，怎样的答案，本身就是一抹纯粹，弱水三千，只取一瓢，大千世界，惟简为上。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不经意间，光阴里藏着的那股暖，如一缕熏风，拂过闲坐的罅隙，落入了怀想的庭院。多少往事走成了背影，多少背影又镌刻成了怀念，点点滴滴，让文字有了温度，让记忆有了诗意。童年的嬉戏远去了，那翻过的一页，似乎还能倒背如流；故乡的炊烟远去了，那隔岸的风景，依稀可在乡音里重现。一些故事已经支离破碎，很多细节却浣洗得干净、素朴，暖着寸寸光阴，暖着栉风沐雨过的友情爱情亲情。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	久远的遐想，行着行着，就回到自己的内心。独坐是一种形式，寂寥是一条蹊径，通往了南山的柴篱野菊，也通往了东山的明月清风。这时，一个人的时光，流淌在字里行间，澄澈见底，心思也是透明的，薄得像月光。这是一个寂静的天地，没有喧嚣，没有熙攘，夏来，可相看两不厌，冬来，可独钓寒江雪，枕着几行诗句，默言自照，尘风不扰。这时，可以在藏着的故事里翻阅那些曾经的悸动，检索那些曾经的现已长满藤蔓的心思，可以在暗夜的一角为自己开一扇明媚的小窗，让久远记忆中的月光曲吹拂进来，而自己，瞬时成为了自我的鉴赏者，消弭去无端的迷失，皈依了内心的菩提，无需一盏茶，半卷书，便已闲适自来，惬意自曳。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	时光知味，山水知心，每一寸光阴都度着人生的苦辣酸甜，每一帧山水都含着灵犀的浓淡色彩，而山水中的一草一木，一云一溪，吐纳着素朴的生命气息，观照着内心的闲逸平和。看山是山，看水是水，多少烟霭笼过，多少清溪流过，多少寂静的声音聆听过，这才有原本的山，原本的水，在一粒心的四域，回响起悠远的云水禅音。一片石，嶙峋也罢，乖巧也罢，山，总在它的心里；一苔藓，深绿也罢，浅灰也罢，石，总在它的心里。一物一人，无论大小，无论深浅，相依便是谐和，入心便是平和，这山、石、苔藓，就有了层叠的风景，就有了懂得的慈悲。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一眸可以览尽远近，一心可以悟得动静。茂林修竹，流觞曲水，人生的愉悦，常常在无尽的慨叹中错失。面对沟壑，一转身，来路上却是开满芳华，人生的风景总青睐于每个人的来路，藏匿于时空的一隅，随遇而显，随缘而开。纵使凭着一叶苦舟，也可行到水穷处，在坐看云起时，心的宁静就是云卷云舒，自得其乐；纵使隔着重重羁旅，也可江花与芳草，莫染我情田，心的闲适就是江花自开，芳草自茂。众声喧哗，终会隐没于高山流水，一场喧嚣，远不及懂得的山高水长，藏，把自己的心野，无垠地延展，也把自己的情思，无声地浓缩。所以，一帧“悲欣交集”里，那慈悲的感喟，把人生的际遇叹尽，一行“风雪夜归人”中，那温暖的皈依，把现实的艰辛咏完，直抵灵魂深处的春暖花开。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	流年的书页里，很多故事已经泛黄，但落字的墨香越显醇厚。闲暇时，常常品味马远的《寒江独钓图》 ，山之角，水之涯，只取半边，山水全在心中，空疏溢于画外，喜欢赏鉴云林的《疏林茅舍》，寒林荒原，一片萧瑟，略了山光水色，略了熙来攘往，只剩得，一重逸气藏于胸中。人生一树花开，那一番生机，不在于繁密，而在于取舍，该收则收，该藏则藏，如此，种一垄懂得，拥半亩明媚，持一心慈悲。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	藏，是一种懂得，是懂得里一潭最深的慈悲。你不来，我还在，藏是一株守望，只在心中描着业已淡去的诺言；时不来，景还在，藏是一份释怀，是跋涉在苦痛的对岸留下的一道永恒微笑；念不来，心还在，藏是一溪宁静，浴了岁月的烟火，袭了流年的清欢，让自己清晰地聆听内心至纯的梵音。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如若 ，一幕风景如约而来，如若，一场告别不期而至，那就以慈悲的名义，在懂得的心巷中珍藏，而巷外，看小桥，流水，人家，清淡依然，宁静如常。</p>\r\n', '', 'admin', '', '1468402664', '1468402664', 'true', '', '裁一帛光阴，写一阕旧词，字里行间，蕴着清风明月的境，含了幽篁篱菊的情，读在眼眸里，便是一段故事，读在往事中，便是一曲心音，读在岁月里，便是一林静好。 红尘漫漫，吹不', '藏,是,懂得,最,深的,慈悲,裁,一帛,光阴,写,', '150', '1468402651', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('30', '18', '做你自己，不要刻意去取悦别人', '', '/storage/images/20211213/1IH3K55-0-lp.jpg', '', '<p>\r\n	<img alt=\"做你自己，不要刻意去取悦别人\" src=\"/storage/images/20211213/1IH3K55-0.jpg\" title=\"做你自己，不要刻意去取悦别人\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如果我们把自己的心的主权全部交给了别人，别人就不会珍惜，并且随时有可能摧毁它。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我相信，每个人都痛恨过自己，时常有那么一瞬间，自己做出来的事情，说出来的话，连自己都不敢相信。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	你是否也曾经有意无意地用“讨好的语言”来讨人喜欢过？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	迎合别人的感觉，真不好！</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	其实，很多人都会犯这样的错，这是人之常情。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	有很多女人，包括我自己，怕被人不喜欢、怕惹人闲话、怕别人看不起自己，于是会不惜一切地迎合别人，讨人喜欢，连自己的防线都可以不顾。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一味希望得到别人喜欢、追求肯定的人，会觉得筑一道守得住的自我围墙不是一件容易的事。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我有一个朋友，在外企公司工作了两年，眼看着周围的同事都高升了，自己却毫无动静，就找到一家培训公司要求学习管理技巧。培训师听了她的讲述后，首先安排了一堂别开生面的课：让自己成为一个果敢的女人！</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	培训师告诉她：她目前非常有必要先在自己的心中建筑一道墙，这道墙是一条防线，在这道墙之内，她是安全的，她可以不必看别人的脸色，也不必战战兢兢、害怕得罪人。当然，这道墙还有抵挡闲言碎语的作用。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	上完这堂课，她开始明白：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	受欢迎是件好事，但不必要时时处处受欢迎。人人喜欢、人人爱，是谁都不可能做到的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	很快，这个女孩子的“那道墙”，就让她的状况发生了改变，当她第一次向冒犯自己的同事表示强硬态度的时候，弄得对方愕然不知所措。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从此，她在职场备受礼遇。她只管做好自己的事，不再为人际关系发愁。也因注意力集中，能力出众，迅速升职。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这就是，“一堵墙造就好邻居。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	想通过一味掏心，讨好别人来获得别人同样的回报是很难的。所以我们有必要捍卫自己内心的空间，拿捏“硬”与“软”的尺度。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如果我们把自己的心的主权全权交给了别人，别人就不会珍惜，并且随时有可能摧毁它。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	所以，请不要太介意别人对自己的好恶。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	夸也好，贬也好，无所谓，看开些。请记住以下三点原则：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	1、你有说“不”的权利。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2、你有表达意见的权利。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	3、你有保持沉默的权利。这是我们每一个人必修的课题。从现在开始，我们都要开始好好修炼自己。</p>\r\n<p>\r\n	&nbsp;</p>\r\n', '', 'admin', '', '1468402643', '1468402643', 'true', '', '如果我们把自己的心的主权全部交给了别人，别人就不会珍惜，并且随时有可能摧毁它。 我相信，每个人都痛恨过自己，时常有那么一瞬间，自己做出来的事情，说出来的话，连自己都', '做,你自己,不要,刻意,去,取悦,别人,如果,我们,', '120', '1468402606', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('31', '18', '藏，是懂得最深的慈悲', '', '/storage/images/20211213/1IJ4N29-0-lp.jpg', '', '<p>\r\n	<img alt=\"藏，是懂得最深的慈悲\" src=\"/storage/images/20211213/1IJ4N29-0.jpg\" title=\"藏，是懂得最深的慈悲\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	裁一帛光阴，写一阕旧词，字里行间，蕴着清风明月的境，含了幽篁篱菊的情，读在眼眸里，便是一段故事，读在往事中，便是一曲心音，读在岁月里，便是一林静好。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	红尘漫漫，吹不尽的忧伤最易迷眼，翻不尽的章节最易断肠，天高云淡，极目远眺，谁人相忆在江楼。是谁，独自守着窗儿，蘸了盈袖的暗香，研了梧桐黄昏细雨，落下瘦比黄花的文字，欲说还休？是谁，秋风悲画扇，以三更的落梅横笛，在断肠声里忆念平生？是谁，因了懂得，披了一袭的慈悲，因了安好，从尘埃里开了一朵花，又从这一朵花里开了一生的寂寞？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	远去了，那些藤蔓一样生长的忧伤，那些近乎心碎的眺望。但光阴，悄然地留下那一尊尊诗的背影，在每一行黯然神伤的诗句后，浇开了一路芬芳，筑就了一堤风景。风景是光阴精心酿制的一壶酒，需要在一个恰当的时候恰当的地方打开，才会醇香满怀。是的，对于四季递嬗的节奏，一个人，常常习惯了那一季里开场的欣喜，花开春暖，踏雪寻梅，习惯了那一场渐入佳境的悠扬与繁盛，月色荷塘，晚照枫林，而最不可忽略的往往是那令人沉醉的一朵寂静，一片留白，甚至只是一个休止符的默然憩息，一曲轻音乐的余音袅袅，因为它们不只是在吸引，更是在撩拨，撩拨那溪水般潺潺的心动，撩拨那藏在岁月深处的一幅幅生动。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	无言，总在故事里沉淀，回味却在沉淀中升华。品人生的一帧画，画里蕴藏着太多的悲喜笔墨，氤氲着太多的苦乐色调。不见底色，也无需结局，那一程一程生活的山水，已沧桑了故事的所有过往，也洗淡了日子的平平仄仄，绘成为心野上的一抹平静，一片清幽。忧愁终会融化，在恬淡的思绪里流成清清溪水，坎坷也终会定格，在回忆的远方描摹成一线水岸。面对人生的多姿多彩，寻寻觅觅，结果浓缩在一个淡字之中，打开心扉，发现，许多的过往，只是流光的呢喃，怎样的选择，本身就是一道无解，怎样的答案，本身就是一抹纯粹，弱水三千，只取一瓢，大千世界，惟简为上。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不经意间，光阴里藏着的那股暖，如一缕熏风，拂过闲坐的罅隙，落入了怀想的庭院。多少往事走成了背影，多少背影又镌刻成了怀念，点点滴滴，让文字有了温度，让记忆有了诗意。童年的嬉戏远去了，那翻过的一页，似乎还能倒背如流；故乡的炊烟远去了，那隔岸的风景，依稀可在乡音里重现。一些故事已经支离破碎，很多细节却浣洗得干净、素朴，暖着寸寸光阴，暖着栉风沐雨过的友情爱情亲情。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	久远的遐想，行着行着，就回到自己的内心。独坐是一种形式，寂寥是一条蹊径，通往了南山的柴篱野菊，也通往了东山的明月清风。这时，一个人的时光，流淌在字里行间，澄澈见底，心思也是透明的，薄得像月光。这是一个寂静的天地，没有喧嚣，没有熙攘，夏来，可相看两不厌，冬来，可独钓寒江雪，枕着几行诗句，默言自照，尘风不扰。这时，可以在藏着的故事里翻阅那些曾经的悸动，检索那些曾经的现已长满藤蔓的心思，可以在暗夜的一角为自己开一扇明媚的小窗，让久远记忆中的月光曲吹拂进来，而自己，瞬时成为了自我的鉴赏者，消弭去无端的迷失，皈依了内心的菩提，无需一盏茶，半卷书，便已闲适自来，惬意自曳。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	时光知味，山水知心，每一寸光阴都度着人生的苦辣酸甜，每一帧山水都含着灵犀的浓淡色彩，而山水中的一草一木，一云一溪，吐纳着素朴的生命气息，观照着内心的闲逸平和。看山是山，看水是水，多少烟霭笼过，多少清溪流过，多少寂静的声音聆听过，这才有原本的山，原本的水，在一粒心的四域，回响起悠远的云水禅音。一片石，嶙峋也罢，乖巧也罢，山，总在它的心里；一苔藓，深绿也罢，浅灰也罢，石，总在它的心里。一物一人，无论大小，无论深浅，相依便是谐和，入心便是平和，这山、石、苔藓，就有了层叠的风景，就有了懂得的慈悲。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一眸可以览尽远近，一心可以悟得动静。茂林修竹，流觞曲水，人生的愉悦，常常在无尽的慨叹中错失。面对沟壑，一转身，来路上却是开满芳华，人生的风景总青睐于每个人的来路，藏匿于时空的一隅，随遇而显，随缘而开。纵使凭着一叶苦舟，也可行到水穷处，在坐看云起时，心的宁静就是云卷云舒，自得其乐；纵使隔着重重羁旅，也可江花与芳草，莫染我情田，心的闲适就是江花自开，芳草自茂。众声喧哗，终会隐没于高山流水，一场喧嚣，远不及懂得的山高水长，藏，把自己的心野，无垠地延展，也把自己的情思，无声地浓缩。所以，一帧“悲欣交集”里，那慈悲的感喟，把人生的际遇叹尽，一行“风雪夜归人”中，那温暖的皈依，把现实的艰辛咏完，直抵灵魂深处的春暖花开。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	流年的书页里，很多故事已经泛黄，但落字的墨香越显醇厚。闲暇时，常常品味马远的《寒江独钓图》 ，山之角，水之涯，只取半边，山水全在心中，空疏溢于画外，喜欢赏鉴云林的《疏林茅舍》，寒林荒原，一片萧瑟，略了山光水色，略了熙来攘往，只剩得，一重逸气藏于胸中。人生一树花开，那一番生机，不在于繁密，而在于取舍，该收则收，该藏则藏，如此，种一垄懂得，拥半亩明媚，持一心慈悲。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	藏，是一种懂得，是懂得里一潭最深的慈悲。你不来，我还在，藏是一株守望，只在心中描着业已淡去的诺言；时不来，景还在，藏是一份释怀，是跋涉在苦痛的对岸留下的一道永恒微笑；念不来，心还在，藏是一溪宁静，浴了岁月的烟火，袭了流年的清欢，让自己清晰地聆听内心至纯的梵音。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如若 ，一幕风景如约而来，如若，一场告别不期而至，那就以慈悲的名义，在懂得的心巷中珍藏，而巷外，看小桥，流水，人家，清淡依然，宁静如常。</p>\r\n', '', 'admin', '', '1468402664', '1468402664', 'true', '', '裁一帛光阴，写一阕旧词，字里行间，蕴着清风明月的境，含了幽篁篱菊的情，读在眼眸里，便是一段故事，读在往事中，便是一曲心音，读在岁月里，便是一林静好。 红尘漫漫，吹不', '藏,是,懂得,最,深的,慈悲,裁,一帛,光阴,写,', '150', '1468402651', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('32', '19', '2015年上半年热点生意趋势扫描', '', '/storage/images/20211213/1J0163K8-0-lp.jpg', '', '<p style=\"text-align: center;\">\r\n	<img alt=\"2015年上半年热点生意趋势扫描\" src=\"/storage/images/20211213/1J0163K8-0.jpg\" title=\"2015年上半年热点生意趋势扫描\" /></p>\r\n<p style=\"text-align: center;\">\r\n	&nbsp;</p>\r\n<p style=\"text-align: center;\">\r\n	“私人定制”风吹向传统工艺品</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	曾经在服装、旅游等领域劲吹的“私人定制”之风，如今也吹向了传统工艺品领域。一批以“艺术品私人定制”为服务内容的机构出现在广州等地，范围涉及书画、陶瓷、雕塑、家具等。除瓷器外，剪纸、中国结等老工艺也乘着“私人定制”这股风潮渐趋红火。在一家名为“甲天下剪纸”的网店，店家既可以批量剪出十二生肖、仕女图、熊猫等著名的“中国符号”，还可以按照顾客要求，专门定制蒙娜丽莎、卡通人物等各种富有创意的图案。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	成人兴趣班迎来春天</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	茶道、陶艺、烘焙、芭蕾和音乐，甚至如何做一杯完美的虹吸咖啡，都是现代人不满足单调生活衍生出的兴趣，有了兴趣便生出了市场。在欧美大城市习以为常的兴趣班，很长一段时间并不被中国人所接受。当时人们几乎忙得停不下来，更无暇顾及所谓的兴趣，甚至没有太多意愿。“百年油画”艺术沙龙的创始人弓继鑫没有任何艺术背景。百年油画选择了更聪明的做法，它每周在4个地方开课，只有一个是自有场地，其他则和咖啡馆、中高档西式餐厅合作，使用对方的闲置场地。学生上课在地点上有了更多选择，也能够让百年油画迅速扩大规模。从去年5月第一期至今，每逢周六上课的绘画沙龙吸引了近2000个学生。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	炒菜也流行用“大数据”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	和人们生活紧密相关的餐饮业，可算是商业史上最古老的行业之一。在过去漫长的时间里，它固守一套手工业时代的操作模式：手记点单，开火炒菜，只需门店、厨师和服务员到位，便能即刻开门揽客。然而，当中餐厅发展到一定规模后，管理者意识到了一些问题。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	所以现在业内流行用大数据开店，从采购先看走势图、酒店要什么菜农户就种什么菜、到开店依靠数据模板……目前凡是采用大数据开店的餐饮企业成活几率超过80%，远远高于采用传统办法的餐饮企业。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	拼大巴成为新商机</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在拼车市场的“贴身肉搏”战中，爱拼车就在上周第一个倒下了，留下业界一句意味深长的“格局已定”。在滴滴快的、Uber等大腕的搅动下，留给创业公司的生存空间到底还有多少？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	有家叫接我拼车的创业型公司决定放弃小车型的拼车业务，半年前转投拼大巴业务。在接我副总裁崔睿看来，大巴是相对标准的产品，定时定点出发，线路匹配较容易些，而且尚没有企业对这一垂直市场进行深入挖掘，是出行领域的新机会。结果短短一周就增加1000多个用户。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	家电业兴起“微店”热</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	今年以来，家电业兴起“微店”热潮。不只海尔，苏宁、国美、美的在今年年初就宣布将发动员工，开设微店，抢占移动电商先机。一位苏宁内部人士表示，苏宁的微店数量已达十多万个，全部由员工开设，微店内有苏宁易购的所有实体商品，产品、价格、服务都一模一样，所谓“千军万马做电商”。做得好的，一个月有20万-30万元的销售额，很多都是基于自身的社交圈子进行个性化、精准化的商品推荐。不同商品、品类的“分成”不同，都是员工正式工资外的额外收入。“这样大家才有积极性，对苏宁易购移动端的流量、销量拉动都很明显。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	微商“异军突起”或将催生新一轮培训风潮</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	据统计显示，自2011年发布至今，微信平台已发展了800多万公众账号，并以每天1.5万的规模增长，与此同时，微信活跃用户的规模也已达到4.5亿。面对这块大蛋糕，不少个人开始利用自己碎片化的时间寻求商机，甚至不少传统电商也在悄然转向微商市场。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	尤其在“韩束微商”风暴中心的义乌，走上微商创业之路的年轻人越来越多。义乌大大义乌小胡子微商创始人杨景中也曾是去年韩束微赛的团队培训讲师之一，他认为，“专业微商培训机构的导师或多或少是有实操经验的，如果自己本身就对微商团队中的细节不了解，那么这个课程显然是不合格的。”这将会催生新一轮的培训热潮。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	“密室逃脱”生意流行走向户外</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	仅仅两年时间，曾经火爆的密室逃脱的好光景就开始衰败，2013年和2014年的日进斗金早已不复存在，行业嬗变中，产品应该怎样创新？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	北京的密室逃脱公司“奥秘城市”将整个北京当做谜面，基于这座熟悉的城市实景和地理位置，策划了大型全城寻宝活动，吸引挑战赛的玩家们到不同的活动站点解谜，寻宝。玩法非常简单：玩家下载奥秘城市APP或者使用奥秘城市手机版，在APP中查找离自己最近的线索点/藏宝点；选择感兴趣的任务点开始游戏；根据地点描述和任务描述，完成任务点的任务；最后分享寻找的过程、晒出自己的宝藏。作为内测版有超过10000位玩家参与了这个游戏。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	现在将生意引流到户外已经成为了该生意创新解脱困境的最佳方式。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	餐饮后市场有百亿美金市场等着去啃</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	对于餐饮这一庞大的产业来说，除了前端那个可以看到的消费与服务外，餐饮营收最重要的环节来自于后端的采购节流。供应链产业其实是很传统的，一直都存在，而供应链管理并非简单的采购。拿百胜餐饮来说，在国内就有400多家供应商，由439人组成的专业团队来管理。而这样下来就需要投入巨额的成本，对于大型餐饮企业来说还能够接受，也是必须去这样做的，而对于那些中小餐馆来说，他们也需要采购，也需要有供应链，可他们却下不了这么大的成本。所以掘金餐饮后市场是一个不错的机会，预估国内相关市场的空间超过百亿美金。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	红木行情稳中有升</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	“2015年有可能是香花梨年了。”曾老板经营木材生意10多年，对木材市场的“风水轮流转”已经习以为常。日前发布的全国红木制品市场景气指数显示全国红木市场稳中有升，与此同时，不少中国木材商斥资投资缅甸花梨，导致其出货量大增。不过，行家提醒收藏者，缅甸花梨只是消费型木材，不是收藏型木材，要认真了解不同“花梨”的区别，不要误用藏品价买了消费品。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	可以抗衡电商的服装买手店</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	买手店的经营模式从上世纪90年代由香港的连卡佛带入内地，消费习惯的日益成熟促使近几年中小规模的买手店不断涌现。店主们看好买手店的未来。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	有过一定服装品牌运营经验的姚勤对自己的买手店信心满满。曾任国内某著名男装公司大区经理的他，早些年已经意识到单品牌渠道模式发展的日趋困难。在他看来，整个消费形式已经发生变化。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2012年8月开始筹备，今年2月14日两家名为h+的买手店同时在杭州开业。据他介绍，买手店主要是做女性微百货(服装、配饰、家居、女性教育等)，重视产品的性价比，消费人群定位在20-35岁的女性，服装品类占整个产品的35%左右。2015年预计开店20家左右，主要集中在江浙沪一带。姚勤的雄心壮志是未来5年，做到100亿元的零售额。</p>\r\n', '', 'admin', '', '1468402816', '1468402816', 'true', '', '私人定制风吹向传统工艺品 曾经在服装、旅游等领域劲吹的私人定制之风，如今也吹向了传统工艺品领域。一批以艺术品私人定制为服务内容的机构出现在广州等地，范围涉及书画、陶', '2015年,上半年,热点,生意,趋势,扫描,私人,定制,', '76', '1468402794', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('33', '19', '刘旷：国内图片电商正在崛起，全景微图或成突', '', '/storage/images/20211213/1J0423162-0-lp.jpg', '', '<p>\r\n	纵观目前整个中国的电商市场，基本上已经被天猫、京东两大电商体系所霸占。不过在垂直细分领域也正在涌现一些不错的电商平台，诸如时尚类商品的唯品会，化妆品的聚美优品，汽车电商的汽车之家、易车网，房产电商的搜房网、房多多……而今天，图片电商也正在成为一个新兴的电商领域。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p style=\"text-align: center;\">\r\n	<img alt=\"刘旷：国内图片电商正在崛起，全景微图或成突破口\" src=\"/storage/images/20211213/1J0423162-0.jpg\" title=\"刘旷：国内图片电商正在崛起，全景微图或成突破口\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	也许有很多人多少会感到有些不解，打开搜索引擎或者到图片网站直接一搜不就会出来一大堆图片吗？为何还要花钱买图片？但是事实上整个图片电商行业正在释放巨大的生机。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	1、对于很多企业来说，为了展现更好的企业形象或者达到更好的宣传效果，他们在独特创意的图片上有着越来越强烈的需求。但是这些创意图片从哪里来？如果自己公司单独成立一个庞大的设计、摄影团队，这显然对于大多数的公司来说并不现实。一方面需要巨大的成本投入，另一方面即便是成立了团队，也是术业有专攻，某些很多专业化领域的图片还是需要寻求外部市场的帮助。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2、对于个人来说，需求多种多样，有的个人喜欢收藏一些优美的摄影作品；有的个人为了自己的设计效果，也需要大量的设计素材，而这些素材却并不是自己擅长的。但是这些优秀的摄影作品和设计素材上哪里去找？到图片搜索或者图片兴趣社交平台中是很难找到这种专业的素材或者作品，那么图片电商对于个人而言也就具备了市场价值。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	3、从整个行业的发展来看，过去很多人可能经常会把自己设计的一些不错的图片素材以及拍摄的一些优秀作品上传到各大网站，免费分享给广大用户。但是随着优秀高质量图片的需求越来越多、价值越发凸显时，他们会发现图片其实能给自己带来丰厚的收入，这个时候他们对于自己的作品就会越发珍惜、越发重视，所以免费的优秀高质量图片将会越来越稀少，最终促成整个行业向电商方向发展。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	于是，近年来国内的图片电商交易平台开始纷纷崛起，有很多平台运营得还算不错。至于图片电商交易的模式，刘旷个人将其分为以下三种不同的模式，并分别选取了他们的代表平台进行分析。那么，哪一种模式才会是未来图片电商的大趋势所在呢？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一、以微图网为代表的标准化图片电商</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	过去，很多人想要找个好的Logo或者海报之类，往往都会找一家线下的设计公司帮忙设计，走线下定制化路线。于是很多人都在脑海中形成了一个固有的印象：由于每个企业或者个人对于图片的需求都个性化、且大小尺寸等都不一样，图片很难实现标准化交易。不过全景微图电商却让我们改变了过去这一传统的看法。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从微图网自身的角度来看，通过借助全景视觉公司二十余年的打造与积累，目前全景平台已经拥有了5000万张专业高清、高质量且有版权的图片，拥有国内最大的的正版图片库。同时，微图网整合了全球500家图片机构100000名专业摄影师。这些资源的积累，为微图电商平台的搭建打下了坚实的基础。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从用户的角度来看，微图网的这种模式有几大好处。一个是明确了版权问题，在保证图片数量的基础之上，用户可以选择合适的图片尺寸来购买，其使用不受用途、时间以及区域的限制；另一个微图网的这种方式避免了第三方的介入，在线交易的价格信息透明，避免了信息不对称等问题产生的利益损失；第三个好处则是方便、快捷，让用户直接购买，自由选择也无需等待过长的时间。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从摄影师的角度来看，微图网提供一个可以让摄影师的作品得到商业价值展现的机会，这无形之中会得到广大摄影师的大力支持，这也就是为何会有如此众多的图片机构以及专业摄影师会选择微图网。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从微图网的战略布局来看，这种模式有利于平台做大做强。但任何事情都是利弊相生的，微图网同时也会面临一定的挑战。尤其是可能面临同质化竞争激烈，大多数的摄影师们都会在多个图库平台上传内容，通过图片的多次售卖与图库网站销售分成来获得更多的利润，这无形之中就会导致各个平台之间的同质化竞争将会相当激烈，平台难以树立其差异化的竞争优势。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	二、以猪八戒为代表的威客交易平台</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	对于威客平台，相信很多人也都不陌生了，其实就是一个服务类的淘宝平台。在所有的威客平台当中，以猪八戒发展最为迅猛，当然图片交易只占据了猪八戒平台交易中的一部分。其实除了猪八戒，也有一些专门从事图片交易的威客平台，通过需求者发布任务，供应方来做任务，最后双方达成交易的这么一种方式。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不过刘旷认为以猪八戒为代表的威客平台对于一些对于图片需求不是很大，也不是非常频繁的用户来说，不失为一种不错的选择。但是对于那些经常有着大量图片需求的企业和用户来说，威客平台存在一定的不足。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	首先，需求方每想要一个图片素材就需要发布一个任务，然后等待设计师和摄影师的应答之后，再经过双方的多次沟通与协调才有可能达成一笔交易。这样对于有着大量图片需求的用户来说，着实有些时间浪费。如果作品不满意的话，那还需要供应方从新提供，颇费周折。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	其次，对于供应方来说，这种方式实际上也存在一定的不公平。需求方每发布一个任务，都需要很多的供应方来提供自己的方案或样图之类，然后参与竞标。本来一张图片就没有多少利润可言，但是供应方却需要为此付出相当高的代价和耐心。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	三、以淘宝为代表的综合类电商平台</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	提到淘宝，可以说它是一个大杂烩，丝毫不为过。今天的淘宝早就已经不再只满足于与实物商品有关的交易，它正在把自己的电商范围渗透到服务类电商的每一个角落，在淘宝同时也涌现出了大批的图片处理、制作、拍摄商家。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但淘宝模式也有其弊端。这第一个弊端就是整体服务水平参差不齐，整个淘宝上充斥着各式各样的图片服务商，消费者根本无从下手，不知道哪家的图片质量好，服务水平高。既然消费者愿意花钱购买图片，而不是去网上免费下载，那一定是对图片设计等各方面都有着相当高的要求，这一点上恐怕淘宝上大多数的商家都难以保证。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第二个弊端，流量入口大是好事，但是对于大多数没有花钱在淘宝打广告的商家而言，其淘宝店是很难被人发现和找到的。流量入口虽大，均摊到每一个商家上就不多了，同时淘宝内部的竞争激烈，大多数的商家在淘宝开了店最终很可能只会成为一个摆设。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	中美图片电商的三大差距</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从以上三类不同的图片电商模式，我们可以看出，国内的图片电商市场正在悄然崛起。但是纵观整个全球的图片电商市场，我们会发现，中国的电子商务整体规模实际上已经超越美国，但是国内图片电商距离美国仍然有较大的差距。在美国，与微图网类似的图片电商模式平台gettyimages、shutterstock等已经成为了全球化的大公司，那么国内的图片电商与美国的图片电商差距到底在哪里？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	1、版权意识不够强</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	国人对于文字、图片、音像等作品的版权意识远远不及美国，所有很多人的图片作品被盗用了也不会有过多的法律意识要去维护自己的版权。当然，随着国内从事文字、图片、视频等内容创作的群体越来越多，他们的版权意识也会逐步加强，这对于整个国内图片电商的长远发展是非常有利的，同时也说明了国内图片电商的增长空间巨大。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2、模仿风气较浓</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在中国市场，似乎任何领域都免不了会存在大量的仿造品，与版权保护意识不够紧紧相关的则是国内模仿、复制风气较浓，很多优秀的摄影、设计类图片作品被人模仿之后，以非常低的价格售卖给其他用户，导致了原创作品的损失。从目前来看，这个模仿的风气还真是没有特别好的办法去杜绝，图片电商交易平台的图片要达成交易，就必须要把图片展示出来，这也就很难避免不会遭到模仿。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	3、用户图片付费意识有待提升</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这第三个差距则是国人的图片付费意识，在很多国人看来，他们已经习惯了从网上去下载各种免费的图片，如果想让这部分建立起付费的意识，这需要一个漫长的过程。这就好比过去我们在视频网站看视频，大家都已经习惯了免费上网看视频，如今各大视频网站针对很多最新的电影都会采取收费的方式，而这个方式要想被大家普遍接受，也是需要时间去积累培养的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	总体看来，国内的图片电商相较于美国的图片电商确实还需要在版权意识、付费意识等方面加强，但这同时也说明了国内的图片电商市场空间巨大。对于图片电商平台而言，刘旷认为以全景微图为代表的标准化的图片电商平台将会具有更大的发展空间，而个性化设计的电商平台也会存在一定的小众市场。</p>\r\n', '', 'admin', '', '1468402842', '1468402842', 'true', '', '纵观目前整个中国的电商市场，基本上已经被天猫、京东两大电商体系所霸占。不过在垂直细分领域也正在涌现一些不错的电商平台，诸如时尚类商品的唯品会，化妆品的聚美优品，汽', '刘旷,国内,图片,电商,正在,崛起,全景,微图,或,', '62', '1468402825', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('34', '19', '生鲜电商O2O：给菜品买保险，员工吃胖算工伤', '', '/storage/images/20211213/1J40W495-0-lp.jpg', '', '<p>\r\n	导读 : 与青年菜君、爱餐桌等直接自己卖菜不同，味库是一个半成品净菜平台，整合的是两类B端。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<img alt=\"生鲜电商O2O：给菜品买保险，员工吃胖算工伤\" src=\"/storage/images/20211213/1J40W495-0.jpg\" title=\"生鲜电商O2O：给菜品买保险，员工吃胖算工伤\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	“北京有10万用户买过我们的菜，日订单峰值3000单，平均稳定在1000单左右，客单价接近50元。”这是半成品生鲜电商平台味库交出的数据。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	与青年菜君、爱餐桌等直接自己卖菜不同，味库是一个半成品净菜平台，整合的是两类B端，一是净菜厨坊、福成五丰之类的中央厨房；二是俏江南、九头鹰之类的餐厅厨房，后者范围局限在餐馆周围两三公里之内。因为只提供半成品净菜，他们的做法相当于将超市和菜市场买菜环节砍掉。据其联合创始人透露，味库的菜品价格相当于超市售价的6到7折。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	给菜品买保险</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	“生鲜电商所会碰到的问题我们都会碰到，生鲜电商碰不到的半成品电商也会碰到。”味库联合创始人海若感叹，半成品生鲜电商很苦很累，里面涉及大量问题，譬如严格的时效限制。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	味库在做净菜半成品电商方面有三个特点：一是品控上，联合中国人寿推出买菜险，所有生鲜半成品净菜商家入驻味库APP平台，均须投保食品安全责任险。用户在味库APP上买菜有明确的在线交易记录，一旦发生问题可实现快速查询和追溯。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	二是冷链物流配送，这是做生鲜物流电商普遍的难点和痛点。目前给味库平台做冷链物流配送配送的公司，包括万家康、黑狗、万家康、路达达四家公司合作。餐厅厨房覆盖周围两至三公里，中央厨房通过冷练车配送，只是需要提前一天预定。而配送的费用统一为5元。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	作为高成本的冷链物流，以味库目前5元的配送费完全不够覆盖成本，味库联合创始人海若坦言，现在还处于贴钱运营状态。不过，她并没有自建物流的打算，当然也没有自建物流体系的能力，“目前只做两个事情：供应链和市场推广。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	三是菜品的来源，全部来自两个方面：餐厅和中央厨房，尤其以中央厨房为主，平台上目前已经接入了20多个中央厨房，100多个餐厅厨房。味库等于把之前中央厨房规模化的生产，变成多元化的需求，小批量生产。而让中央厨房做出这种改变的是，能够让他们直接对接消费者，供应商可以通过后台看到用户的反馈和评论。这种互动改变了供应商闷头生产，不关注用户体验的状态。餐厅厨房方面，“饭点”的时候忙死、“非饭点”的时候闲死，但是人力成本和房租成本?一直没法根据高峰期和低谷期流量来增减。利用“非饭点”的空余时间作为代加工点，提供半成品净菜也能够增加收入。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	为了保证供应商的菜品质量，味库已经开始在搭建自己的Cooking studio（美食录制棚），买食材亲自烹制，检验菜品品质，更为重要的是拍摄美食和录制视频之用。目前味库页面的介绍都是纯文字的步骤介绍，味库打算把做法全部录制成几十秒的短视频，供用户参考。“之前做的事情是让用户买到菜，现在的事情是让用户更好的把菜做出来。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	先扫描食材再检索菜谱</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	味库的创始人兼CEO顾东君曾在九阳集团担任发言人，这一次出来创业很大一部分原因是受到了做家电时的启发。早再2011年牵头做了一款与味库类似的产品，根据各家家电厨具情况选择合适菜谱。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	味库并非是一款纯菜谱类应用，相比于单纯做一个连接中央厨房和消费者，味库延伸出了菜谱搜索功能，一方面搜索菜品名称找到需要购买的食材；另一方面，能够根据厨房已有食材和厨具提供菜谱。举例而言，扫描厨具的二维码，选择厨房已有的菜品，系统可以自动生成上百种菜谱，每种下面都有烹饪步骤，打破了菜谱类应用的单向度呈现搜索结果的局面，让用户可以充分利用现有食材和厨电，实现美食的烹饪。这种工具属性和导购逻辑为平台带来大量流量，这也是味库与其他平台做法的差异化之处。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	关于未来如何盈利的问题，海若透露，包括电商和广告盈利，不过当下还处于贴钱运营状态，“我现在不是要把用户量做起来，而是把交易量做起来，说不定未来还会出现第三种，第四种模式呢，who knows？”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不过相比于盈利模式上的含混，味库有一点很清晰一致：员工吃胖了算工伤。因为每天需要买各种食材回来烹饪，试验，录制视频。录制完之后的菜都由内部员工消化，而有时一天录制的烹饪视频高达上百道菜。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	生鲜电商依然困难重重</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	今日资本徐新曾在网易科技峰会上表示，电商还有最后一个堡垒就是生鲜，你拿下了生鲜就能拿下天下，互联网这么风水水起，占整个社会零售销售总额只有10%，那90%你还没捞着呢，那90%就是生鲜。而地方政府也开始在积极推进净菜工程，北京市的净菜产业平台更是被纳入“十三五”规划，获得了大量政策上的倾斜。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不过同样不容忽视的是，当下用户习惯在超市和菜市场买菜，或是买菜的群体并非8090后，而是父母一辈，市场真正成熟可能还需要等待。海若也反复强调，当下的问题是要提高用户的长期的使用习惯，“如果用户一个月买一次基本上就活不下去了。”因为昂贵的物流成本决定了量少难以长久运营。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	另外，中央厨房和餐厅厨房尽管能通过平台卖菜，增加销量，及时获得市场反馈，但毕竟量不大，这对平台的依赖程度或许也是一个考验。</p>\r\n', '', 'admin', '', '1468403048', '1468403048', 'true', '', '导读 : 与青年菜君、爱餐桌等直接自己卖菜不同，味库是一个半成品净菜平台，整合的是两类B端。 北京有10万用户买过我们的菜，日订单峰值3000单，平均稳定在1000单左右，客单价接近', '生鲜,电商,O2O,给,菜品,买,保险,员工,吃胖,算,', '85', '1468403023', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('35', '19', '市集和电商并行，鹦鹉螺市集搭建手工艺者的孵', '', '/storage/images/20211213/1J42QV1-0-lp.jpg', '', '<p>\r\n	如果非要给鹦鹉螺贴一个标签，那这个标签一定是完美。这种诞生于5亿年前的海洋生物，螺壳以黄金分割比例环绕，将自然的鬼斧神工体现的淋漓尽致。而借此名字起意的鹦鹉螺市集想挖掘的，似乎也是每一件手工艺品天然的魅力，结合线下市集和线上电商，给手工艺人一个平台。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	“我们的核心是手工艺人的孵化，”联合创始人王赫如是说。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<img alt=\"市集和电商并行，鹦鹉螺市集搭建手工艺者的孵化圈\" src=\"/storage/images/20211213/1J42QV1-0.jpg\" title=\"市集和电商并行，鹦鹉螺市集搭建手工艺者的孵化圈\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	鹦鹉螺市集从2013年1月开始筹划，到8月正式起步，两年多的时间里，和3000多名手工艺人完成了合作。最开始的市集和电商模式也完成了2C端用户的积累，在江浙沪地区，甚至港澳地区小有名气。猎云也在3月份进行了报道。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而当资源逐渐积累，保持平台最健康的方式似乎还在于商家的管理。用王赫的话说：“这是一个相辅相成的过程。”具体到做法，鹦鹉螺选择自建商务部进行商家挑选。对手工的包容度很大，从手工、独立设计，甚至烘焙都不排斥。挑选的标准就是人，对艺术的爱好，作品的风格，鹦鹉螺建立了自己的算法体系。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	“3000多家能服务过来么？”笔者问。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	王赫一笑：“我们会给商家按需分类。创意、材料、商业推广是一个品牌的三要素，而创意是他们的根本。在这个基础上，每个手工艺人的区别只在于是没有材料渠道还是商业渠道。相互之间的资源互补是我们在做的事情。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	为了给手工艺人提供更好的机会，除了跟地产商合作进行收取门票的市集活动，鹦鹉螺也在跟各大商超洽谈尝试长时间的开放式市集，进行用户的相互引流。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	线下体验店也有可能是鹦鹉螺尝试的方向。“当然店里不会只有商品的销售，我们可能在店里选择开放一部分场地给商家，现场的教学、讲解都有可能。”王赫说。“因为一些用户对制作很感兴趣，我们也会开发教学的套餐包，将非标准化商品的制作简单化，降低用户的入门成本。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而鹦鹉螺的App会在线下充当社区的功能。除了可以查到每次市集的时间表、摊位、表演形式。社区里会鼓励大家分享使用甚至制作工艺品的心得，从而增加用户的活跃度。如果用王赫的话说，就是买东西有几个爽点：一买，二用，第三去晒。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	至于纯手工品不是标品，难以量产，但喜欢的人又很多的问题。鹦鹉螺明年会添加个人店铺，商品不一定有现货，但可以使用预定功能，从下单，到心仪的物件一步步成型，用户买到的不仅是功能，更是故事。而CEO张磊给鹦鹉螺一锤定音：“我们解决的就是消费升级过程中用户对个性化商品的认知成本过高，以及供应端的产能、渠道与销售能力不足的两大问题。”</p>\r\n', '', 'admin', '', '1468403068', '1468403068', 'true', '', '如果非要给鹦鹉螺贴一个标签，那这个标签一定是完美。这种诞生于5亿年前的海洋生物，螺壳以黄金分割比例环绕，将自然的鬼斧神工体现的淋漓尽致。而借此名字起意的鹦鹉螺市集想', '市集,和,电商,并行,鹦鹉,螺,搭建,手工艺,者,', '63', '1468403056', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('36', '13', '创业，一个从家狗变成狼的过程', '', '/storage/images/20211213/1545091V4-0-lp.jpg', '', '<p>\r\n	创业是把一条家狗变成一只狼的过程。你一旦习惯狼的生活以后，要想回到家犬的状态这是几乎不可能的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<img alt=\"创业，一个从家狗变成狼的过程\" src=\"/storage/images/20211213/1545091V4-0.jpg\" title=\"创业，一个从家狗变成狼的过程\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	创业必须付出行动，光靠看书不会起到太大作用。在创业这条路上实践比理论要更加重要，当然有理论指导更好。</p>\r\n<p>\r\n	创业就像游泳，你得让自己跳下水里，有一点要注意，不会游泳就跳到深不见底的大海，如果没人救你铁定被淹死。你可以从能踩到底的游泳池开始，慢慢学会游泳，再到小河，池塘，紧接着到长江中间，再到大海。创业也是这样循序渐进的过程，当然如果有像我这样的（投资）人帮你，你可以大胆一点。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<section>\r\n	<section data-id=\"38806\">\r\n		<section>\r\n			<section data-bcless=\"darken\">\r\n				<p>\r\n					创业有两个要素</p>\r\n			</section>\r\n		</section>\r\n	</section>\r\n</section>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第一必须从对自己安全的地方开始。</p>\r\n<p>\r\n	创业不是上来就铺开做大的事情，而是从小事做起把它做成大事；但如果你创业起点不一样，那可以大胆一点，拿出你的商业计划，商业模型，告诉我们（投资人）说你能成为游泳健将，说服我们了，我们就可以给你安排游泳池，甚至是大海，对你进行保护，最后来游，这就是我们投资人的角色。我们把自己当教练看，但首先你要跳到水里游泳，这是第一个要素。</p>\r\n<p>\r\n	第二件事情我自己一直认为创业一旦开始，是很难有回头路的。</p>\r\n<p>\r\n	这个道理非常简单，我觉得创业是把一条家狗变成一只狼的过程，从小到大在学校学习，你一直处于安全范围之内，而创业像把你从游泳池扔到大海，如果你在大海游习惯了，你一定不会再选择游泳池，就像你现在让我再次选择，我仍会选择辞职创业一样。因为我从北大辞职创业以后，才发现校园外面是一个更大的海，是可以为更大的梦想而奋斗的世界。马云做阿里巴巴是他做的第五个公司，前面四家没有做成功，他回去当老师了？没有，他已经做野了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<section label=\"Copyright ? 2015 Yead All Rights Reserved.\">\r\n	<section>\r\n		<section>\r\n			你一旦习惯狼的生活以后，要想回到家犬的状态这是几乎不可能的，而且我也鼓励这种状态，因为人的生命就是一种扩张，人的生命就是一种兴奋，人的生命就是一种在未知道路上的探索，遭遇一个个人生中的意外之喜，这种意外之喜伴随着很多艰难困苦等等。</section>\r\n	</section>\r\n</section>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	按照美国心理学最终结论，如果一个人在奋进的道路上遇到艰难困苦绝望等等事情，能够培养出自己坚毅能力，当养成这种心智之后，一旦你下海以后，狂野之后你这个心智是不得不养成的。我总结人生几个挫折，给我带来的都是好处，我高考前两年失败大专没考上，所以你可以发现有的时候相反的东西是另外一个你的生存道路新的展现。</p>\r\n<p>\r\n	大家都看过《中国合伙人》，里面黄晓明扮演的陈冬青签证再次失败后高喊“美国人民需要我”，实际上当时我喊的是“我需要美国”，当时觉得很悲惨。但是我现在想，如果当初去了美国，现在我最多是个大学教授，甚至连终身教授都算不上，后来天无绝人之路我创办新东方，到现在还比较成功。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<section>\r\n	<section data-id=\"38806\">\r\n		<section>\r\n			<section data-bcless=\"darken\">\r\n				<p>\r\n					这么多年的生活磨练，我养成了一个心智模式</p>\r\n			</section>\r\n		</section>\r\n	</section>\r\n</section>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我认定任何一个生命中的伤痛都是打造完美的人的前提条件，如果你这么想了，你遇到很多事情就会能够抓住任何机会往前探索。</p>\r\n<p>\r\n	如果你创业失败了就像马云那样想，当时马云把所有朋友再次请到杭州告诉所有人，我们做的这家公司叫阿里巴巴，我们一定能够把它做到世界上最大的公司。他自身显露出来的自信，让“十八罗汉”尽管未必完全相信，也把钱拿了出来。</p>\r\n<p>\r\n	所以坚决的相信自己能够做成事情是非常重要的，有这样不回头的勇气，面临失败之后反而觉得这是老天在锻炼你的能耐，我觉得创业（成功）这件事情就离不远，至于创业多大多小无所谓，重要的是你在人生道路上几十年，由于你自己的热情，对自己一生有了比你原地不动更好的，甚至给世界留下痕迹的交代这才是重要的，由于时间关系就讲这么多。</p>\r\n', '', 'admin', '', '1468914309', '1468914309', 'true', '', '创业是把一条家狗变成一只狼的过程。你一旦习惯狼的生活以后，要想回到家犬的状态这是几乎不可能的。 创业必须付出行动，光靠看书不会起到太大作用。在创业这条路上实践比理论', '创业,一个,从,家狗,变成,狼,的,过程,创业,', '79', '1468914265', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('37', '26', '幻灯1', '', '/storage/images/20211213/1-160G9143109445.jpg', '', '', '', 'admin', '', '1468397973', '1468397973', 'true', '', '', '幻灯,幻灯,', '140', '1468910609', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('38', '26', '幻灯2', '', '/storage/images/20211213/1-160G9142R9B7.jpg', '', '', '', 'admin', '', '1468397986', '1468397986', 'true', '', '', '幻灯,幻灯,', '66', '1468909655', '0', '0', '0', '100', '未知', '');

-- ----------------------------
-- Table structure for `rrz_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channelfield`;
CREATE TABLE `rrz_channelfield` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `channel_type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` longtext COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `ifrequire` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否必填',
  `sort` int(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='自定义字段表';


-- ----------------------------
-- Table structure for `rrz_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channeltype`;
CREATE TABLE `rrz_channeltype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章（产品）类型';


-- ----------------------------
-- Table structure for `rrz_config`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_config`;
CREATE TABLE `rrz_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置内容',
  `type` varchar(64) DEFAULT '' COMMENT '类型',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0：否，1：是）',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE,
  KEY `idx_type` (`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统配置表';

-- -----------------------------
-- Records of `rrz_config`
-- -----------------------------
INSERT INTO `rrz_config` VALUES ('1', 'status', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('2', 'name', '某某网络科技有限公司', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('3', 'logo', '/storage/images/20211213/504af09628b39dd171eeaa5d5cd5c97a.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('4', 'wap_logo', '/storage/images/20211213/504af09628b39dd171eeaa5d5cd5c97a.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('5', 'favicon', '/storage/images/20200509/9e9ffe4e859c185d063363237637f296.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('6', 'copyright', 'Copyright © 2012-2018 某某公司 版权所有', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('7', 'recordnum', '琼ICP备xxxxxxxx号', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('8', 'title', '工业化工类企业展示人人站模板（响应式）', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('9', 'keywords', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('10', 'description', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('11', 'is_authorization', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('12', 'authortoken_code', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('13', 'popup_upgrade', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('14', 'wap_domain', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('15', 'is_https', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('16', 'logo', '/static/images/logo.png', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('17', 'sqldatapath', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('18', 'expiretime', '3600', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('19', 'name', '广州某某公司', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('20', 'telephone', '400-123-4567', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('21', 'fax', '020-99999999', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('22', 'qq', '88888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('23', 'email', 'admin@youweb.com', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('24', 'addr', '广东省广州市天河区88号', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('25', 'coord', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('26', 'thirdcode_pc', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('27', 'thirdcode_wap', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('28', 'inlet', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('29', 'auto', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('30', 'filter_isurl', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('31', 'type', 'xml', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('32', 'index_changefreq', 'always', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('33', 'list_changefreq', 'hourly', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('34', 'view_changefreq', 'daily', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('35', 'index_priority', '1.0', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('36', 'list_priority', '0.8', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('37', 'view_priority', '0.5', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('38', 'articles_num', '100', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('39', 'zzbaidutoken', '', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('40', 'app_map', 'admin', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('41', 'status', '1', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('42', 'replace', '国家级|国际级|世界级|宇宙级|千万级|百万级|星级|甲级|超甲级|完美|唯一|一流|精确|顶级|顶尖|尖端|最|国际级产品|填补国内空白|带头|首个|首次|首发|首款|首家|首选|品牌|正品|金牌|名牌|优秀|顶级|独家|唯独|独有|独创|独据|开发者|缔造者|创始|发明者|领先|领头|领导|领跑|领袖|领先|引领|创领|领航|权威|先进|耀领|缔造者|极品|极佳|顶级|尖端|顶尖|终极|绝佳|绝对|绝版|终极|极致|极具|王牌|冠军|第一|极致|永久|王牌|掌门人|领袖|独一无二|绝无仅有|前无古人|史无前例|万能|绝对|绝顶|大牌|精确|超赚|巨星|至尊|巅峰|之王|巨星|王者|冠军|资深|至尊|著名|奢侈|百分之百|国家级产品|国家免检|国家领导人|填补国内空白|史无前例|前无古人|永久|永远|万能|祖传|特效|无敌|纯天然|超赚|国际品质|专家推荐|超强|全面|全网|全球|随时结束|仅此一次|空前绝后|随时涨价|马上降价|最后一波|包治百病|药到病除|特供|专供|专家推荐|热销|畅销|全效|标杆|精确|优秀|仅此|遥遥|高档|真皮|超赚|精准|指定|精品|特供|专供|军方|军事|国旗|国徽|党旗|驰名|秒杀|一步到位|', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('43', 'connector_title', '_', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('44', 'list_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('45', 'view_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('46', 'mobile', '138-0000-0000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('47', 'wx', 'WX8888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('48', 'qrcode', '/storage/images/20211213/ef783a52407c5e48ad4c6b1127a8706d.png', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('49', 'nav_hide_suffix', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('50', 'url_level_dir', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('51', 'app_debug', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('52', 'hide_plugin', '0', 'admin', '', 'cn', '0');

-- ----------------------------
-- Table structure for `rrz_form_data`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_form_data`;
CREATE TABLE `rrz_form_data` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `form_id` int(10) unsigned DEFAULT '0' COMMENT '表单ID',
  `form_name` varchar(255) DEFAULT '' COMMENT '表单名称',
  `content` longtext COMMENT '提交内容',
  `ip` varchar(255) DEFAULT '' COMMENT '提交人IP',
  `add_time` int(10) unsigned DEFAULT NULL COMMENT '提交时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_forms`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_forms`;
CREATE TABLE `rrz_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `config` longtext COMMENT '表单配置',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '创建时间',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '删除(0=否，1=是)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_is_del` (`is_del`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_goods`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods`;
CREATE TABLE `rrz_goods` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '产品名称',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `brief` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '商品简介',
  `cat_id` mediumint(8) unsigned DEFAULT NULL COMMENT '产品分类id',
  `brand_id` int(10) unsigned DEFAULT '0' COMMENT '产品品牌id',
  `def_img` varchar(500) DEFAULT '' COMMENT '产品默认图片路径',
  `imgs` longtext COMMENT '产品图片集合',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `del_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品划线价格',
  `store` int(8) unsigned DEFAULT '0' COMMENT '产品库存',
  `is_presell` enum('true','false') DEFAULT 'false' COMMENT '是否预售（是否定金付款）',
  `presell_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '预售价格（定金）',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '产品规格',
  `content` longtext COMMENT '产品详情',
  `wap_content` longtext COMMENT '手机端详情',
  `sales` int(11) unsigned DEFAULT '0' COMMENT '产品销量',
  `addtime` int(11) unsigned DEFAULT '0' COMMENT '创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_news` tinyint(1) unsigned DEFAULT '0' COMMENT '新品（0=否，1=是）',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '上架',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cat_id` (`cat_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_is_news` (`is_news`) USING BTREE,
  KEY `idx_brand_id` (`brand_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品管理';


-- ----------------------------
-- Table structure for `rrz_goods_attr`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attr`;
CREATE TABLE `rrz_goods_attr` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品属性id自增',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `attr_value` text COMMENT '属性值',
  `attr_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `goods_id` (`goods_id`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性关联表';


-- ----------------------------
-- Table structure for `rrz_goods_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attribute`;
CREATE TABLE `rrz_goods_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '类型（0 单行文本框 1下拉式列表 2多行文本框）',
  `values` text COMMENT '属性值集合',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性';


-- ----------------------------
-- Table structure for `rrz_goods_brand`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_brand`;
CREATE TABLE `rrz_goods_brand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '品牌表',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌logo',
  `desc` text COMMENT '备注介绍',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌地址',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品品牌';


-- ----------------------------
-- Table structure for `rrz_goods_cat`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_cat`;
CREATE TABLE `rrz_goods_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) DEFAULT '' COMMENT '分类名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '分类英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '分类图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '节点深度',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类排序',
  `path` varchar(255) DEFAULT '' COMMENT '节点路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `attrs` longtext COMMENT '参数列表',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品分类';


-- ----------------------------
-- Table structure for `rrz_goods_skus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_skus`;
CREATE TABLE `rrz_goods_skus` (
  `sku_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品规格id',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '规格明细',
  PRIMARY KEY (`sku_id`) USING BTREE,
  KEY `idx_goods_id` (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品规格详情';


-- ----------------------------
-- Table structure for `rrz_goods_spec_values`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_spec_values`;
CREATE TABLE `rrz_goods_spec_values` (
  `spec_value_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规格值ID',
  `spec_id` bigint(15) unsigned NOT NULL DEFAULT '0' COMMENT '规格ID',
  `spec_value` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值',
  PRIMARY KEY (`spec_value_id`) USING BTREE,
  KEY `idx_spec_id` (`spec_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格值';


-- ----------------------------
-- Table structure for `rrz_goods_specification`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_specification`;
CREATE TABLE `rrz_goods_specification` (
  `spec_id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `spec_name` varchar(50) DEFAULT NULL COMMENT '规格名',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序顺序',
  PRIMARY KEY (`spec_id`) USING BTREE,
  KEY `idx_sort` (`sort`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格表';


-- ----------------------------
-- Table structure for `rrz_plugin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_plugin`;
CREATE TABLE `rrz_plugin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL DEFAULT '' COMMENT '编码',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `desc` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `version` varchar(20) NOT NULL DEFAULT '' COMMENT '版本号',
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '作者',
  `isadmin` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否存在后台（0否1是）',
  `ishome` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否存在前台（0否1是）',
  `isload` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动加载（0手动加载、1自动加载）',
  `loadtemp` text COMMENT '自动加载在指定模板，空白默认全部',
  `config` text COMMENT '额外参数',
  `data` text COMMENT '配置存储数据，简单插件可以不创建表',
  `saflag` varchar(500) DEFAULT NULL COMMENT '标示内容',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0未安装、1启用、2禁用）',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='插件表';


-- ----------------------------
-- Table structure for `rrz_search_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_search_keywords`;
CREATE TABLE `rrz_search_keywords` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `keywords` text COMMENT '关键词',
  `type` varchar(50) DEFAULT 'article' COMMENT '搜索类型',
  `ip` varchar(100) DEFAULT NULL COMMENT '搜索客户端的ip地址',
  `hot` int(10) unsigned DEFAULT '0' COMMENT '关键词搜索量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '搜索时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_hot` (`hot`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_site_links`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_links`;
CREATE TABLE `rrz_site_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `url` varchar(255) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) unsigned DEFAULT '0' COMMENT '是否新窗口打开',
  `email` varchar(50) DEFAULT '',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='友情链接表';

-- -----------------------------
-- Records of `rrz_site_links`
-- -----------------------------
INSERT INTO `rrz_site_links` VALUES ('1', '企业建站系统', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481203', '1627543172');
INSERT INTO `rrz_site_links` VALUES ('2', '淘进微信', 'http://taobao.kbstore.cn/', 'http://taobao.kbstore.cn/Public/images/logo-1.png', '100', '1', '', '', '1', 'cn', '1590481246', '1627543144');
INSERT INTO `rrz_site_links` VALUES ('3', '人人站CMS', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481266', '1627543178');
INSERT INTO `rrz_site_links` VALUES ('4', '抖进微信', 'http://dou.kbstore.cn/', 'http://dou.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244482', '1627543197');

-- ----------------------------
-- Table structure for `rrz_site_menus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_menus`;
CREATE TABLE `rrz_site_menus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `en_title` varchar(100) NOT NULL DEFAULT '' COMMENT '英文标题',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级菜单',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '菜单深度',
  `url` varchar(200) DEFAULT '' COMMENT '自定义链接',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '上下级路径',
  `target_blank` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '是否新开窗口',
  `config` longtext COMMENT '配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='导航菜单表';

-- -----------------------------
-- Records of `rrz_site_menus`
-- -----------------------------
INSERT INTO `rrz_site_menus` VALUES ('1', '首页', 'Home', 'index', '0', '1', '1', '/', '1', '1001', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('2', '关于我们', '', 'guanyuwomen/gongsijianjie', '0', '2', '1', '/node/1.html', '2', '1002', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('3', '产品中心', '', 'chanpinzhongxin/gongyelingyu', '0', '3', '1', '/node/8.html', '3', '1003', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('4', '新闻中心', '', 'xinwenzhongxin/gongsixinwen', '0', '4', '1', '/node/17.html', '4', '1004', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('5', '人才招聘', '', 'jiaruwomen/rencailinian', '0', '5', '1', '/node/21.html', '5', '1005', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('6', '客户见证', '', 'shehuizeren/huanjingbaohu', '0', '6', '1', '/node/13.html', '6', '1006', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('7', '销售网络', '', 'xiaoshouwangluo', '0', '7', '1', '/node/27.html', '7', '1007', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('8', '联系我们', '', 'lianxiwomen', '0', '8', '1', '/node/25.html', '8', '1008', 'false', '');
