/**
 * This code was generated by v0 by Vercel Labs.
 * @see https://v0.dev/t/Jd3OFwX
 */
import useCurrentTab from 'hooks/useCurrentTab'
import {Separator} from '@/components/ui/separator'
import {Avatar, AvatarFallback, AvatarImage} from '@/components/ui/avatar'
import useTabPagenoteState from '../../hooks/useTabPagenoteState'
import Achieve from './Achieve'
import {openUrlInGroup} from "../../utils/url";

export function Bookmark() {
  const {tab} = useCurrentTab()
  const [content] = useTabPagenoteState()

  return (
    <div className="w-full p-4 bg-card rounded flex flex-col gap-2">
      <div className={'flex justify-start items-start gap-2.5'}>
        <Avatar className={'rounded'}>
          <AvatarImage
            src={tab?.favIconUrl || 'https://pagenote.cn/favicon.ico'}
            alt={tab?.title}
          />
          <AvatarFallback>{tab?.title}</AvatarFallback>
        </Avatar>

        <div className=" relative">
          <div className=" text-sm font-medium font-['Inter'] overflow-hidden overflow-ellipsis line-clamp-1">
            <a target={'_blank'} onClick={()=>{openUrlInGroup(content?.pageUrl || content?.pageKey || tab?.url || '')}} className={''}>{tab?.title || '--'}</a>
          </div>
          <div className="mt-1 text-muted-foreground text-xs font-normal overflow-hidden overflow-ellipsis line-clamp-2">
            {content?.description || ''}
          </div>
        </div>
      </div>
      <Separator className={'my-1'} />
      <Achieve />
    </div>
  )

}
