Contributing to Our Project

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

-     Reporting a bug
-     Discussing the current state of the code
-     Submitting a fix
-     Proposing new features
-     Becoming a maintainer

We Develop with Github

We use github to host code, to track issues and feature requests, as well as accept pull requests.

Pull requests are the best way to propose changes to the codebase (we use Github Flow). We actively welcome your pull requests:

-     Fork the repo and create your branch from master.
-     If you've added code that should be tested, add tests.
-     If you've changed APIs, update the documentation.
-     Ensure the test suite passes.
-     Make sure your code lints.
-     Issue that pull request!

Any contributions you make will be under the MIT Software License

In short, when you submit code changes, your submissions are understood to be under the same MIT License that covers the project. Feel free to contact the maintainers if that's a concern.
Report bugs using Github's issues

We use GitHub issues to track public bugs. Report a bug by opening a new issue; it's that easy!
Write bug reports with detail, background, and sample code

Great Bug Reports tend to have:

-     A quick summary and/or background
-     Steps to reproduce
-         Be specific!
-         Give sample code if you can. My stackoverflow question includes sample code that anyone with a base R setup can run to reproduce what I was seeing
-     What you expected would happen
-     What actually happens
-     Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

People love thorough bug reports. I'm not even kidding.

## Examples of low quality contributions

-     Pull requests that are automated e.g. scripted opening pull requests to remove whitespace / fix typos / optimize images.
-     Pull requests that are disruptive e.g. taking someone else's branch/commits and making a pull request.
-     Pull requests that are regarded by a project maintainer as a hindrance vs. helping.
-     Something that's clearly an attempt to simply +1 your pull request count for October.
-     Last but not least, one pull request to fix a typo is fine, but 5 pull requests to remove a stray whitespace is not. 
