# Contribution Guidelines

Thankyou for showing interest in Devectus!
This file contains information on Contribution Guidelines for code and documentation. These guidelines will likely change over time, so please always check these guidelines before submitting pull requests.

## To Begin
- Please check the Desired Features and Future Features area of the README.md or in the Planned Features area.
- If you have an idea for a feature in this project, please submit a feature request in Issues discussing the intent of your feature idea so that it can be discussed accordingly. Please try to form features based on our Goals area so that we don't waste any time on unaligned features.

>[!IMPORTANT]
>A Discord Server will be created for discussion of this project if this repo catches any attention for contribution.

### Contribution Checklist
Please ensure you have followed these steps before interacting with this project -
- Have read through Planned Features (Desired Features and Future Features).
- Have read through Issues and Pull requests.
- Have created a new Issue for a new feature idea before working on that feature.
- Have read through code guidelines and/or documentation guidelines.
- Ready to work on Devetus!

### Prerequisites -

Please ensure your NodeJS Version is v20.15.1 or later

### Installation -
Follow the guidelines at [GitHub Docs](https://docs.github.com/en/get-started/exploring-projects-on-github/contributing-to-a-project)

Install packages -
```
npm install
```
Start the Application -
```
npm start
```


## Code Guidelines

### Style

- Please ensure code is clear, concise and organised.
- Code comments should be used to help describe sections of code for others to pick up where you left off.
- Do not use any online connecting code such as API's, keep it local.
- Try to adhere to accessibility standards in UX/UI (WCAG).
- 
- More TBD

## Documentation Guidelines

- Use "snake_case" for file and folder names.
- Provide alt text for all embedded media.
- If you believe you can improve the documentation structure in the repo, please let us know.
- 
- More TBD


