class TestPOSTagger:

    def test_data_maker(self:"TestPOSTagger", pos_tagger):
        actual = pos_tagger.data_maker([["دلم", "اینجا", "مانده‌است", "."]])
        expected = [[{"word": "دلم", "is_first": True, "is_last": False, "prefix-1": "د", "prefix-2": "دل", "prefix-3": "دلم", "suffix-1": "م", "suffix-2": "لم", "suffix-3": "دلم", "prev_word": "", "two_prev_word": "", "next_word": "اینجا", "two_next_word": "مانده\u200cاست", "is_numeric": False, "prev_is_numeric": "", "next_is_numeric": False, "is_punc": False, "prev_is_punc": "", "next_is_punc": False}, {"word": "اینجا", "is_first": False, "is_last": False, "prefix-1": "ا", "prefix-2": "ای", "prefix-3": "این", "suffix-1": "ا", "suffix-2": "جا", "suffix-3": "نجا", "prev_word": "دلم", "two_prev_word": ".", "next_word": "مانده\u200cاست", "two_next_word": ".", "is_numeric": False, "prev_is_numeric": False, "next_is_numeric": False, "is_punc": False, "prev_is_punc": False, "next_is_punc": False}, {"word": "مانده\u200cاست", "is_first": False, "is_last": False, "prefix-1": "م", "prefix-2": "ما", "prefix-3": "مان", "suffix-1": "ت", "suffix-2": "ست", "suffix-3": "است", "prev_word": "اینجا", "two_prev_word": "دلم", "next_word": ".", "two_next_word": "", "is_numeric": False, "prev_is_numeric": False, "next_is_numeric": False, "is_punc": False, "prev_is_punc": False, "next_is_punc": True}, {"word": ".", "is_first": False, "is_last": True, "prefix-1": ".", "prefix-2": ".", "prefix-3": ".", "suffix-1": ".", "suffix-2": ".", "suffix-3": ".", "prev_word": "مانده\u200cاست", "two_prev_word": "اینجا", "next_word": "", "two_next_word": "", "is_numeric": False, "prev_is_numeric": False, "next_is_numeric": "", "is_punc": True, "prev_is_punc": False, "next_is_punc": ""}]]
        assert actual == expected

    def test_data_maker_universal(self:"TestPOSTagger", universal_pos_tagger):
        actual = universal_pos_tagger.tag(["من", "به", "مدرسه", "ایران", "رفته_بودم", "."])
        expected = [("من", "PRON"), ("به", "ADP"), ("مدرسه", "NOUN"), ("ایران", "NOUN"), ("رفته_بودم", "VERB"), (".", "PUNCT")]
        assert actual == expected

    def test_tag_sents(self:"TestPOSTagger", pos_tagger):
        actual = pos_tagger.tag_sents([["من", "به", "مدرسه", "ایران", "رفته_بودم", "."]])
        expected = [[("من", "PRON"), ("به", "ADP"), ("مدرسه", "NOUN,EZ"), ("ایران", "NOUN"), ("رفته_بودم", "VERB"), (".", "PUNCT")]]
        assert actual == expected

    def test_tag_sents_universal(self:"TestPOSTagger", universal_pos_tagger):
        actual = universal_pos_tagger.tag_sents([["من", "به", "مدرسه", "ایران", "رفته_بودم", "."]])
        expected = [[("من", "PRON"), ("به", "ADP"), ("مدرسه", "NOUN"), ("ایران", "NOUN"), ("رفته_بودم", "VERB"), (".", "PUNCT")]]
        assert actual == expected
