## 项目简介

这是一个模仿小米商城实现主要功能点的电商项目。

前端包含了 11 个页面：首页、登录、注册、全部商品、商品详情页、关于我们、我的收藏、购物车、订单结算页面、我的订单以及错误处理页面。

实现了商品的展示、商品分类查询、关键字搜索商品、商品详细信息展示、登录、注册、用户购物车、订单结算、用户订单、用户收藏列表以及错误处理功能。

后端根据前端需要的数据分模块设计了相应的接口、控制层、数据持久层。

## 技术栈

-   **前端：**`Vue`+`Vue-router`+`Vuex`+`Element-ui`+`Axios`

-   **后端：**`Node.js`、`Koa框架`

-   **数据库：**`Mysql`、`redis`

**后端项目传送地址：[xiaomi-server](https://github.com/root-lucas/xiaomi-server)**

> 后端项目运行请 **参照说明配置** 确保已开启本地数据库`mysql、redis`服务及相应端口端口

## 功能模块

-   [x] 登录
-   [x] 注册
-   [x] 首页
-   [x] 全部商品
-   [x] 商品详情页
-   [x] 我的购物车
-   [x] 订单结算
-   [x] 我的收藏
-   [x] 我的订单

## 运行项目

```
1. Clone project

git clone https://github.com/root-lucas/vue-xiaomi

2. Project setup

cd vue-store
npm install

3. Compiles and hot-reloads for development

npm run serve

4. Compiles and minifies for production

npm run build
```

> 如果觉得这个项目还不错，您可以点右上角 `Star`支持一下， 谢谢！ ^\_^

## 项目页面截图

**首页**

![](https://raw.githubusercontent.com/root-lucas/vue-xiaomi/master/public/screenshots/home.png)

**全部商品**

![](https://raw.githubusercontent.com/root-lucas/vue-xiaomi/master/public/screenshots/goods.png)

**购物车**

![](https://raw.githubusercontent.com/root-lucas/vue-xiaomi/master/public/screenshots/shoppingCart.png)

**我的收藏**

![](https://raw.githubusercontent.com/root-lucas/vue-xiaomi/master/public/screenshots/collect.png)

**我的订单**

![](https://raw.githubusercontent.com/root-lucas/vue-xiaomi/master/public/screenshots/order.png)

**登录**

![](https://raw.githubusercontent.com/root-lucas/vue-xiaomi/master/public/screenshots/login.png)

**注册**

![](https://raw.githubusercontent.com/root-lucas/vue-xiaomi/master/public/screenshots/register.png)
