package grpc

import (
	"context"

	ldaperror "github.com/romnn/ldap-manager/pkg/err"
	pb "github.com/romnn/ldap-manager/pkg/grpc/gen"
	log "github.com/sirupsen/logrus"

	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

// RemoveGroupMember removes a member of a group
func (s *LDAPManagerService) RemoveGroupMember(ctx context.Context, req *pb.GroupMember) (*pb.Empty, error) {
	claims, err := s.Authenticate(ctx)
	if err != nil {
		return nil, err
	}
	if !claims.IsAdmin && claims.Username != req.GetUsername() {
		return nil, status.Error(codes.PermissionDenied, "requires admin privileges")
	}
	allowDeleteDefaultGroups := claims.IsAdmin
	if err := s.manager.RemoveGroupMember(req, allowDeleteDefaultGroups); err != nil {
		log.Error(err)
		if appErr, ok := err.(ldaperror.ApplicationError); ok {
			return nil, appErr.StatusError()
		}
		return nil, status.Error(codes.Internal, "error deleting group member")
	}
	return &pb.Empty{}, nil
}
