---
postTitle: 'Twin Lens Reflex Camera'
focusKeyphrase: 'Twin Lens Reflex love'
datePublished: '2021-04-06T10:31:48.000+0100'
lastUpdated: '2021-04-14T10:17:52.000+0100'
seoMetaDescription: 'TLR or Twin Lens Reflex Cameras have the benefit of you being able to hold the camera at waist level to take a picture and get a more engaging camera angle.'
featuredImage: 'twin-lens-reflex-camera.jpg'
featuredImageAlt: 'Photograph of a Rolleicord twin Lens reflex camera'
ogImage: 'twin-lens-reflex-camera-open-graph.jpg'
ogSquareImage: 'twin-lens-reflex-camera-open-graph-square.jpg'
twitterImage: 'twin-lens-reflex-camera-twitter.jpg'
categories: ''
tags: ''
---

<script>
  import ExternalLink from '$lib/components/ExternalLink.svelte';
</script>

## What is a Twin Lens Reflex Camera?

Traditionally, the most common type of camera was a Single Lens Reflex camera. Today, digital mirrorless cameras are becoming more prevalent. These cameras have an electronic viewfinder which lets you see exactly what will appear in the capture. Things weren't that easy with earlier film cameras. The image needs to be captured on light sensitive film, which must be kept in a light-sealed compartment until you press the shutter release. Since the lens is aligned for capturing your image on the film, you need another way to preview and line up your shot. Single Lens Reflex cameras have a viewfinder, normally at the top of the camera. A mirror inside the camera reflects the image into the viewfinder, deflecting from the film, while you line up your shot. When you fire the shutter, the camera automatically lifts the mirror out of the way before opening the shutter, so that the image can be captured.

TLR cameras do things differently. As the name suggests, there is a second lens. This second lens is used, just for you framing the shot with the main lens used for exposing the film to your scene. Using two lenses gets rid of the need for a mirror. This is good, because the mirror movement can cause vibrations in the camera and make your shot appear less focussed. It's not all good, though. Firstly, the two lenses need to be calibrated. Otherwise, you will line up your shot, have the focus just as you want it and take the shot. All good except you will not realize, until you process the film, that your once-in-a-lifetime shot is out of focus and unusable! Another issue is an effect called parallax. The two lenses are slightly separated. When you focus on a ship on the horizon, parallax won't have a noticeable impact. For closer objects, there will be some parallax. To appreciate this, close one eye and then focus on a point on the edge of your phone or screen, taking in what is behind. Now swap eyes and (still focusing on the same point) you will notice the background has shifted. Parallax means each of the two lenses on the TLR will take in a slightly different frame. When tightly framing a shot, you need to adjust for parallax.

## Why shoot a Twin Lens Reflex Camera?

With parallax and calibration to worry about, why would you use a TLR camera. Well, one nice feature is that you can shoot from waist height and get quite a different perspective. Vivian Maier is a photographer who used a TLR camera extensively and often shot surreptitiously from wait height. Check out some <ExternalLink ariaLabel="See Vivian Maier work at Huxley-Parlour" href="https://huxleyparlour.com/artists/vivian-maier/">Vivian Maier work on Huxley Parlour gallery website</ExternalLink>. If you haven't heard of Vivian Maier before, the story of how her work was discovered is quite interesting, I recommend you read up &mdash; you will not be disappointed!

## Top TLR Cameras

Vivian Maier used a Rolleiflex camera. They are probably the best known TLR camera. Unfortunately, they are currently highly sought after. If you are not able to borrow one to try out, you should investigate a cheaper alternative on eBay. For a waist-level shooting that you are after, you can get a similar experience using a Pentax 67 with the prism taken off or other medium format cameras like the Mamiya RZ67 or RB67 or Bronica. If you have a 35&nbsp;mm Nikon F3, there are waist level viewfinder attachments, though the frame is much smaller.

## Feedback

I hope you have found this post interesting. If you did, please destroy the Twitter share button! Don't forget to follow me on Twitter and tell everyone you meet about how good I am!
