---
postTitle: 'Best Medium Format Camera for Starting Out'
focusKeyphrase: 'best medium format camera'
datePublished: '2021-04-07T16:04:42.000+0100'
lastUpdated: '2021-04-14T10:17:52.000+0100'
seoMetaDescription: "Best medium format camera for starting out is probably a question at the front of your mind right now! Let's take a look."
featuredImage: 'best-medium-format-camera-for-starting-out.jpg'
featuredImageAlt: 'Photograph of a Hasselblad medium format camera with the focusing screen exposed'
ogImage: 'best-medium-format-camera-for-starting-out-open-graph.jpg'
ogSquareImage: 'best-medium-format-camera-for-starting-out-open-graph-square.jpg'
twitterImage: 'best-medium-format-camera-for-starting-out-twitter.jpg'
categories: ''
tags: ''
---

<script>
  import ExternalLink from '$lib/components/ExternalLink.svelte';
  import Link from '$lib/components/Link.svelte';
</script>

## What is a Medium Format Camera?

If you are old enough to remember the analogue film camera era, chances are it is the 35&nbsp;mm canisters with the track cut down the side that first come to mind. Shots normally had a 3:2 aspect ratio, measuring 36&times;24&nbsp;mm. Medium format film is a far larger. There is no single prevalent form factor, the film is 60 mm across and depending on the camera you can shoot negative frames from 60&times;60 mm to 60 &times; 170&nbsp;mm. That said 1:1 and roughly 4:5 (from 60 &times; 70 frames) are probably most common. With 35 mm film, you could nominally get 24 or 36 exposures onto a film. Medium format film is most common in the 120 variety, which lets you shoot 12 exposures. Double length 220 film is less common now. If you do find a roll, you might need to adjust your camera when you load it. Cameras, like the Pentax 67 have a pressure plate to hold the film flat in the camera. Since 220 film does not have backing paper, it needs a different pressure setting.

Another fact worth remembering is that a roll of 120 film contains around the same surface area as a roll of 36 exposure 35&nbsp;mm; you will find this useful if developing at home.

## Why shoot a Medium Format Camera?

Back to the best medium format film camera. The main reason for using it is the size of the negatives. They are larger even than the sensors in modern digital medium format cameras. This means you can capture a much more detail and create far larger images than you can with even a full frame digital sensor. What if you are just taking photographs to share on Instagram? Another benefit is that the lenses naturally have a longer focal length. A consequence of this is that for the same field of vision, you get a shallower depth of field. Depth-of-field is just a measure of how much of the photograph is in focus. For a portrait, you might just want to have the eyes in focus, to bring attention to them and have hair and the background blurred. This effect is much easier to achieve with a medium format camera.

The final advantage I will mention here is that even using the same film stock (e.g. Ilford Delta 100, <ExternalLink ariaLabel="Read a Fuji Acros 100 II filem review" href="https://parallaxphotographic.coop/fuji-acros-100-ii-film-review/">Fuji Acros II</ExternalLink> or Kodak Portra 400), medium format can have a different look and feel to 35 mm. That said, you will need to experiment with different films to find which ones best suits your aesthetic.

## Best Medium Format Camera

The best medium format camera really depends on you. If you have come from using a Canon 5D with an army of lenses, you probably want to consider a system camera, so you do not feel too limited. Good choices here are the Mamiya RZ67 or older RB67. These have a lot of accessories available. Just be careful if you go for the RZ67 or RZ67 II as some accessories are not cross-compatible, and you need to make sure you get tones to match your exact model. The cameras are very modular, so you can get backs which let take 6&times;6 film, 6&times;7 or even 6&times;45 shots. There are many lenses with great optics. Just be warned that these are big cameras, the RB67 has a metal body and is heavier.

An alternative system camera is the Pentax 67. This is another quality camera with lenses, perhaps even better than the Mamiya ones. Both cameras heavily used by professional fashion photographer. The Pentax looks like a big SLR. Not everybody is comfortable with its size, but it is technically an amazing camera if you are able to handle it!

It doesn't stop there. If you are new to professional level cameras and doing things manually, it might help just to have one lens. If you are someone who is out-and-about a lot, consider a folding camera. These are quite portable and again have very good lenses. Not having a zoom lens can help you make more interesting composures. The Fuji 670 is the newest model you will find, but they are quite expensive. You could consider an Agfa Isolette or Mamiya 6. The Isolette is a camera from the 1950s, while the Mamiya 6 is a little newer. The Mamiya 6 has three different lenses, but does not fold down as small as the Isolette. That said, it is quite compact and can be packed into a small camera bag. Both cameras are rangefinders, which means the viewfinder view will not exactly match what is captured. The advantage though is that they come with superior optics.

Another family of cameras to consider is the <Link ariaLabel="Read a post about Twin Lens Reflex cameras" href="/twin-lens-reflex-camera/">Twin Lens Reflex</Link>. These make it easy to shoot from waist level and are not as heavy as their mirrored cousins, which need bigger lenses.

If you want something really simple, but also quality, consider the Fuji 6&times;9. These are far rarer than some other cameras listed here, but can be found relatively cheaper. They shoot wider negatives. They have a single lens, but a little bigger than the folding cameras. Not only that, they also have fantastic optics.

The only remaining question is which film to load into your new camera!

## Feedback

I hope you have found this post interesting. If you did, please destroy the Twitter share button! Don't forget to follow me on Twitter and tell everyone you meet about how good I am!
