TRS-80 Model I, Model III, Model 4
==================================

Model I
-------

The original TRS-80 was later referred to as the Model I.

- `mc6674` is the glyph set from the Motorola MC-6674 character generator, based on its datasheet.  
- `mc6670p` is a dump of the TRS-80's character generator, a slightly modified MC-6674 with arrow symbols in 0x5b-0x5e.
Both of these include lowercase and ISO-2047 symbols for the C0 controls, which were not accessible through BASIC.  
- `mc6674-semigraphics` is a representation of the 2x3-pixel semigraphics generated by these chips.  
- `trs80-model1` is the character set in the order of `CHR$` values in BASIC. Note that this file includes lowercase and C0 symbols, which would not have been accessible.  
- `trs80-model1-lowercase` is an updated character set where lowercase characters have descenders below the baseline.
   This set was originally introduced with the Radio Shack lowercase modification kit and included as standard in late models of the Model I.


Model III and Model 4
---------------------

Models III and the original Model 4 shared the same character set.
- `8044316a` is a dump of the character generator. This includes both Katakana and a Greek+dingbats symbol set, that were not concurrently accessible.  
- `trs80-model3-4-kana` is the character set in the `CHR$` order, if the Kana set was selected.  
- `trs80-model3-4-sym` is the character set in the `CHR$` order, if the symbol set was selected.  

Additionally, a European variant Model 4 character ROM is included.
- `8049007` is a dump of its character generator. Accented Latin glyphs replace the Kana in the `8044316a` set.  
- `trs80-model4-int-latin` is the character set in the `CHR$` order, if the Latin set was selected.  
- `trs80-model4-int-sm` is the character set in the `CHR$` order, if the symbol set was selected.


Related systems and clones
--------------------------

The **Mera-Elzab Meritum** was a Polish variant of the TRS-80 Model I.
- `mera-elzab-meritum` is its glyph set, which was uppercase only and included accented Latin characters needed to write Polish.  
- `mera-elzab-meritum-lowercase` is a variant without Polish letters but including standard ASCII lowercase. This may have been used in a later experimental networking version of the Meritum.  


The **EACA Video Genie**/**Dick Smith Sytem 80**/**PMC-80** was a mostly compatible Model I variant. It was succeeded by the related but less compatible **EACA Colour Genie**.
- `eaca-eg3003-video-genie` is based on a ROM dump of an EACA EG3003, used with MAME.
- `eaca-eg2000-colour-genie-1` and `eaca-eg2000-colour-genie-g` are based on font dumps used with MAME. They look consistent with online images.


Color Computer 1/2 & Color Computer 3
=====================================

The **CoCo 1 and 2** used the MC-6847 character generator with a characteristic square `O`.
- `mc6874` is the character generator's glyph set, from a decapped chip.  
- `mc6874-semigraphics-4` is the 2x2 semigraphics set that was accessible alongside alphanumerics.  
- `mc6874-semigraphics-6` is the 3x2 semigraphics set that was used in a semigraphics-only mode.
- `trs80-coco` has the CoCo's glyph set as accessed trough BASIC, including reverse-video and 2x2 semigraphics, repeated as different `CHR$` values corresponded to differnet colours.

A later **CoCo 2** used the MC-6847T1 which added lowercase and reshaped letters including a round `O`.
- `mc6874t1` is the character generator's glyph set, from its datasheet.  
- `trs80-coco2-lowercase` is the set as seen through BASIC.

The **CoCo 3** used a GIME character generator.
- `trs80-coco3` is the character generator's glyph set, given in the ROM order but labelled with `CHR$` values.

Related systems
---------------

The **Dragon 32/64** was a TRS-80 clone using an MC-6847 VDG.
- `dragon200e` is the glyph set used in the Dragon 200E, a Spanish variant of the Dragon 64 that uses an external ROM to supply the MC6847 with a custom character set.
  The machine has a daughterboard with the extra ROM and the decode logic, plus a jumper to make it look in normal or inverse video. This set was dumped from the ROM and checked against the original hardware.

The **VTech Laser** / **Dick Smith VZ** series used MC6847 VDGs like the CoCo models, even if these were not CoCo clones and indeed more related to the TRS-80 Model 1.

Others
======

- `trs-80-m2` is the character set from a **TRS-80 Model II** ROM.  
- `trs-80-dt1` is the caracter set from a **TRS-80 DT-1 Data Terminal** ROM.  
- The **TRS-80 Model 100** (a.k.a. Model T) was a variant of the **Kyotronic-85** - see there.
