<?php

namespace Rizwan3D\ValidationMyPhp;

use Rizwan3D\ValidationMyPhp\Rules\Required;

class Validation
{
    public static $DB_HOST;
    public static $DB_NAME;
    public static $DB_USER;
    public static $DB_PASSWORD = '';

    /**
     * Validate.
     *
     * @param array $data
     * @param array $fields
     * @param array $messages
     *
     * @return array
     */
    public function validate(array $data, array $fields, array $messages = []): array
    {
        $errors = [];

        foreach ($fields as $field => $option) {
            $rules = $this->separator($option, '|');

            if (!in_array('required', $rules)) {
                if (!(new Required())->check($data, $field)) {
                    continue;
                }
            }

            foreach ($rules as $rule) {
                // get rule name params
                $params = [];
                // if the rule has parameters e.g., min: 1
                if (strpos($rule, ':')) {
                    [$rule_name, $param_str] = $this->separator($rule, ':');
                    $params = $this->separator($param_str, ',');
                } else {
                    $rule_name = trim($rule);
                }

                $fn = '\\Rizwan3D\\ValidationMyPhp\\Rules\\'.ucfirst($rule_name);

                if (class_exists($fn, true)) {
                    $rule = new $fn();
                    $pass = $rule->check($data, $field, ...$params);
                    if (!$pass) {
                        $msg = $rule->message;
                        if (isset($messages[$field])) {
                            $msg = $messages[$field][$rule_name] ?? $rule->message;
                        } else {
                            $msg = $messages[$field] ?? $rule->message;
                        }

                        // get the error message for a specific field and rule if exists
                        // otherwise get the error message from the $validation_errors
                        $errors[$field][] = sprintf(
                            $msg,
                            $field,
                            ...$params
                        );
                    }
                }
            }
        }

        return $errors;
    }

    // Split the array by a separator, trim each element
    // and return the array
    private function separator($str, $separator)
    {
        return array_map('trim', explode($separator, $str));
    }
}
