# Scala CheatSheet

A "Cheat-Sheet" for Scala. Under development. Click on watch to keep you informed of updates. Designed for people who are already familiar with the Scala programming language, for small reminders.

I am not a Scala professional, so please report my errors in the issues, in order to have better quality content. To read, consider each section as a separate cheat sheet, not the whole project as a cheat sheet. Thank you and have fun!

## Getting Started

You can read the Cheat-Sheet by accessing this link : https://riiswa.github.io/Scala-CheatSheet/

## Table of contents

<div class="toc"><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Scala-Cheat-Sheet" data-toc-modified-id="Scala-Cheat-Sheet-1">Scala Cheat Sheet</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Scala-essentials" data-toc-modified-id="Scala-essentials-1.1">Scala essentials</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Display-and-Strings" data-toc-modified-id="Display-and-Strings-1.1.1">Display and Strings</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Blocks-and-expressions" data-toc-modified-id="Blocks-and-expressions-1.1.1.1">Blocks and expressions</a></span></li></ul></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Method-definitions" data-toc-modified-id="Method-definitions-1.1.2">Method definitions</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Conditional" data-toc-modified-id="Conditional-1.1.3">Conditional</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Pattern-matching" data-toc-modified-id="Pattern-matching-1.1.4">Pattern matching</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Exceptions" data-toc-modified-id="Exceptions-1.1.5">Exceptions</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Parametric-type" data-toc-modified-id="Parametric-type-1.1.6">Parametric type</a></span></li></ul></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Object-oriented-programming" data-toc-modified-id="Object-oriented-programming-1.2">Object oriented programming</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#General-hierarchy-of-classes-/-traits-/-objects" data-toc-modified-id="General-hierarchy-of-classes-/-traits-/-objects-1.2.1">General hierarchy of classes / traits / objects</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#object" data-toc-modified-id="object-1.2.2">object</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#class" data-toc-modified-id="class-1.2.3">class</a></span></li></ul></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Arrays" data-toc-modified-id="Arrays-1.3">Arrays</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Declaration-of-array" data-toc-modified-id="Declaration-of-array-1.3.1">Declaration of array</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Access-to-the-elements" data-toc-modified-id="Access-to-the-elements-1.3.2">Access to the elements</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Iteration-on-the-elements-of-an-array" data-toc-modified-id="Iteration-on-the-elements-of-an-array-1.3.3">Iteration on the elements of an array</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Creating-an-array-by-transformation" data-toc-modified-id="Creating-an-array-by-transformation-1.3.4">Creating an array by transformation</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#for/yield" data-toc-modified-id="for/yield-1.3.4.1">for/yield</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#filter" data-toc-modified-id="filter-1.3.4.2">filter</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#map" data-toc-modified-id="map-1.3.4.3">map</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#sortWith" data-toc-modified-id="sortWith-1.3.4.4">sortWith</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#reduce" data-toc-modified-id="reduce-1.3.4.5">reduce</a></span></li></ul></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Arrays-with-a-variable-size" data-toc-modified-id="Arrays-with-a-variable-size-1.3.5">Arrays with a variable size</a></span></li></ul></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Main-collections" data-toc-modified-id="Main-collections-1.4">Main collections</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Principles" data-toc-modified-id="Principles-1.4.1">Principles</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Tuples" data-toc-modified-id="Tuples-1.4.2">Tuples</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Map" data-toc-modified-id="Map-1.4.3">Map</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Map-implementations" data-toc-modified-id="Map-implementations-1.4.3.1">Map implementations</a></span></li></ul></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Option" data-toc-modified-id="Option-1.4.4">Option</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Either" data-toc-modified-id="Either-1.4.5">Either</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Lists" data-toc-modified-id="Lists-1.4.6">Lists</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Set" data-toc-modified-id="Set-1.4.7">Set</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Set-Implementations" data-toc-modified-id="Set-Implementations-1.4.7.1">Set Implementations</a></span></li></ul></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Vector" data-toc-modified-id="Vector-1.4.8">Vector</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Stack" data-toc-modified-id="Stack-1.4.9">Stack</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Queue" data-toc-modified-id="Queue-1.4.10">Queue</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Range" data-toc-modified-id="Range-1.4.11">Range</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Streams" data-toc-modified-id="Streams-1.4.12">Streams</a></span></li></ul></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Collections-in-detail" data-toc-modified-id="Collections-in-detail-1.5">Collections in detail</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Traversable" data-toc-modified-id="Traversable-1.5.1">Traversable</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Iterable" data-toc-modified-id="Iterable-1.5.2">Iterable</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Seq" data-toc-modified-id="Seq-1.5.3">Seq</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Usual-operations" data-toc-modified-id="Usual-operations-1.5.4">Usual operations</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Add-/-remove-an-element" data-toc-modified-id="Add-/-remove-an-element-1.5.4.1">Add / remove an element</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Update" data-toc-modified-id="Update-1.5.4.2">Update</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Assemblist-operations" data-toc-modified-id="Assemblist-operations-1.5.4.3">Assemblist operations</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Cast" data-toc-modified-id="Cast-1.5.4.4">Cast</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Operations-of-Iterables" data-toc-modified-id="Operations-of-Iterables-1.5.4.5">Operations of Iterables</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Selection-and-cutting" data-toc-modified-id="Selection-and-cutting-1.5.4.6">Selection and cutting</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Transformation-of-a-collection" data-toc-modified-id="Transformation-of-a-collection-1.5.4.7">Transformation of a collection</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Operations-of-Seq" data-toc-modified-id="Operations-of-Seq-1.5.4.8">Operations of Seq</a></span></li></ul></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Parallel-collections" data-toc-modified-id="Parallel-collections-1.5.5">Parallel collections</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#par" data-toc-modified-id="par-1.5.5.1">par</a></span></li></ul></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Lazy-view" data-toc-modified-id="Lazy-view-1.5.6">Lazy view</a></span></li></ul></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Object-oriented-programming" data-toc-modified-id="Object-oriented-programming-1.6">Object oriented programming</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Class-statement" data-toc-modified-id="Class-statement-1.6.1">Class statement</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#public,-private-and-protected-access" data-toc-modified-id="public,-private-and-protected-access-1.6.2">public, private and protected access</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#public" data-toc-modified-id="public-1.6.2.1">public</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#private" data-toc-modified-id="private-1.6.2.2">private</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#protected" data-toc-modified-id="protected-1.6.2.3">protected</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Refine-the-scope-of-access" data-toc-modified-id="Refine-the-scope-of-access-1.6.2.4">Refine the scope of access</a></span></li></ul></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Getters-and-Setters" data-toc-modified-id="Getters-and-Setters-1.6.3">Getters and Setters</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Constructors" data-toc-modified-id="Constructors-1.6.4">Constructors</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Nested-Classes" data-toc-modified-id="Nested-Classes-1.6.5">Nested Classes</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Anonymous-Classes" data-toc-modified-id="Anonymous-Classes-1.6.6">Anonymous Classes</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Type-and-this" data-toc-modified-id="Type-and-this-1.6.7">Type and this</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Transtyping" data-toc-modified-id="Transtyping-1.6.8">Transtyping</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Object" data-toc-modified-id="Object-1.6.9">Object</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Singleton-Object" data-toc-modified-id="Singleton-Object-1.6.9.1">Singleton Object</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Any-Methods" data-toc-modified-id="Any-Methods-1.6.9.2">Any Methods</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Apply-and-Unapply" data-toc-modified-id="Apply-and-Unapply-1.6.9.3">Apply and Unapply</a></span></li></ul></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#case-class" data-toc-modified-id="case-class-1.6.10">case class</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Inheritance" data-toc-modified-id="Inheritance-1.6.11">Inheritance</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#extends" data-toc-modified-id="extends-1.6.11.1">extends</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Constructor-and-super-class" data-toc-modified-id="Constructor-and-super-class-1.6.11.2">Constructor and super-class</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#override" data-toc-modified-id="override-1.6.11.3">override</a></span></li></ul></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Abstract-class" data-toc-modified-id="Abstract-class-1.6.12">Abstract class</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#final" data-toc-modified-id="final-1.6.13">final</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Implicit-conversions" data-toc-modified-id="Implicit-conversions-1.6.14">Implicit conversions</a></span><ul class="toc-item"><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Implicit-class" data-toc-modified-id="Implicit-class-1.6.14.1">Implicit class</a></span></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#implicit-conversions-method" data-toc-modified-id="implicit-conversions-method-1.6.14.2">implicit conversions method</a></span></li></ul></li><li><span><a href="https://riiswa.github.io/Scala-CheatSheet/#Trait" data-toc-modified-id="Trait-1.6.15">Trait</a></span></li></ul></li></ul></li></ul></div>


## How to contribute

Install `beakerx`, edit `scala_cheatsheet.ipynb` and Pull Requests.

## Expected

- Pattern Matching
- Parametric types
- XML
- Future and Promise
- Akka actors
- Delimited continuations

