/*
 * Decompiled with CFR 0.152.
 */
package rife.bld.wrapper;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import rife.bld.wrapper.WrapperClassLoader;
import rife.tools.FileUtils;
import rife.tools.InnerClassException;
import rife.tools.exceptions.FileUtilsErrorException;

public class Wrapper {
    public static final String BUILD_ARGUMENT = "--build";
    public static final String OFFLINE_ARGUMENT = "--offline";
    public static final String WRAPPER_PREFIX = "bld-wrapper";
    public static final String WRAPPER_PROPERTIES = "bld-wrapper.properties";
    static final String MAVEN_CENTRAL = "https://repo1.maven.org/maven2/";
    static final String SONATYPE_SNAPSHOTS = "https://s01.oss.sonatype.org/content/repositories/snapshots/";
    static final String DOWNLOAD_LOCATION = "https://repo1.maven.org/maven2/com/uwyn/rife2/bld/${version}/";
    static final String DOWNLOAD_LOCATION_SNAPSHOT = "https://s01.oss.sonatype.org/content/repositories/snapshots/com/uwyn/rife2/bld/${version}/";
    static final String BLD_CACHE = "bld.cache";
    static final String BLD_FILENAME = "bld-${version}.jar";
    static final String BLD_SOURCES_FILENAME = "bld-${version}-sources.jar";
    static final String BLD_VERSION = "BLD_VERSION";
    static final String WRAPPER_JAR = "bld-wrapper.jar";
    static final String BLD_PROPERTY_VERSION = "bld.version";
    static final String RIFE2_PROPERTY_DOWNLOAD_LOCATION = "rife2.downloadLocation";
    static final String BLD_PROPERTY_DOWNLOAD_LOCATION = "bld.downloadLocation";
    static final String PROPERTY_REPOSITORIES = "bld.repositories";
    static final String PROPERTY_EXTENSION_PREFIX = "bld.extension";
    static final String PROPERTY_DOWNLOAD_EXTENSION_SOURCES = "bld.downloadExtensionSources";
    static final String PROPERTY_DOWNLOAD_EXTENSION_JAVADOC = "bld.downloadExtensionJavadoc";
    static final String PROPERTY_SOURCE_DIRECTORIES = "bld.sourceDirectories";
    static final String PROPERTY_JAVAC_OPTIONS = "bld.javacOptions";
    static final String PROPERTY_JAVA_OPTIONS = "bld.javaOptions";
    static final File BLD_USER_DIR = new File(System.getProperty("user.home"), ".bld");
    static final File DISTRIBUTIONS_DIR = new File(BLD_USER_DIR, "dist");
    static final Pattern META_DATA_LOCAL_COPY = Pattern.compile("<localCopy>\\s*true\\s*</localCopy>", 34);
    static final Pattern META_DATA_SNAPSHOT_VERSION = Pattern.compile("<snapshotVersion>.*?<value>([^<]+)</value>", 34);
    static final Pattern OPTIONS_PATTERN = Pattern.compile("\"[^\"]+\"|\\S+");
    static final Pattern JVM_PROPERTY_PATTERN = Pattern.compile("-D(.+?)=(.*)");
    private static final Pattern JAR_EXCLUDE_SOURCES_PATTERN = Pattern.compile("^.*-sources\\.jar$", 2);
    private static final Pattern JAR_EXCLUDE_JAVADOC_PATTERN = Pattern.compile("^.*-javadoc\\.jar$", 2);
    private static final Pattern[] CLASSPATH_INCLUDED_JARS = new Pattern[]{FileUtils.JAR_FILE_PATTERN};
    private static final Pattern[] CLASSPATH_EXCLUDED_JARS = new Pattern[]{JAR_EXCLUDE_SOURCES_PATTERN, JAR_EXCLUDE_JAVADOC_PATTERN, Pattern.compile("bld-wrapper.jar")};
    private File currentDir_ = new File(System.getProperty("user.dir"));
    private LaunchMode launchMode_ = LaunchMode.Cli;
    private boolean offline_ = false;
    private final Properties jvmProperties_ = new Properties();
    private final Properties wrapperProperties_ = new Properties();
    private File wrapperPropertiesFile_ = null;
    private final Set<String> repositories_ = new LinkedHashSet<String>();
    private final Set<String> extensions_ = new LinkedHashSet<String>();
    private boolean downloadExtensionSources_ = false;
    private boolean downloadExtensionJavadoc_ = false;
    private final byte[] buffer_ = new byte[1024];
    private WrapperClassLoader classloader_;
    private static final Pattern RIFE2_JAR_PATTERN = Pattern.compile("/\\.rife2/dist/rife2-[^\"/!]+(?<!sources)\\.jar");
    private static final Pattern RIFE2_SOURCES_JAR_PATTERN = Pattern.compile("/\\.rife2/dist/rife2-[^\"/!]+-sources\\.jar");
    private static final Pattern RIFE2_PROPERTY_VERSION_PATTERN = Pattern.compile(".*rife2\\.version.*");
    private static final Pattern BLD_JAR_PATTERN = Pattern.compile("/\\.bld/dist/bld-[^\"/!]+(?<!sources)\\.jar");
    private static final Pattern BLD_SOURCES_JAR_PATTERN = Pattern.compile("/\\.bld/dist/bld-[^\"/!]+-sources\\.jar");
    private static final Pattern BLD_PROPERTY_VERSION_PATTERN = Pattern.compile(".*bld\\.version.*");
    private static final Pattern JAR_DIRECTORY_LIB_COMPILE_RECURSIVE_PATTERN = Pattern.compile("<jarDirectory\\s+url=\"file://\\$PROJECT_DIR\\$/lib/compile\"\\s+recursive=\"false\"");
    private static final Pattern JAR_DIRECTORY_LIB_PROVIDED_RECURSIVE_PATTERN = Pattern.compile("<jarDirectory\\s+url=\"file://\\$PROJECT_DIR\\$/lib/provided\"\\s+recursive=\"false\"");
    private static final Pattern JAR_DIRECTORY_LIB_RUNTIME_RECURSIVE_PATTERN = Pattern.compile("<jarDirectory\\s+url=\"file://\\$PROJECT_DIR\\$/lib/runtime\"\\s+recursive=\"false\"");
    private static final Pattern JAR_DIRECTORY_LIB_TEST_RECURSIVE_PATTERN = Pattern.compile("<jarDirectory\\s+url=\"file://\\$PROJECT_DIR\\$/lib/test\"\\s+recursive=\"false\"");
    public static final char[] HEX_DIGITS_LOWER = "0123456789abcdef".toCharArray();

    public static void main(String[] arguments) {
        System.exit(new Wrapper().installAndLaunch(new ArrayList<String>(Arrays.asList(arguments))));
    }

    public void createWrapperFiles(File destinationDirectory, String version) throws IOException {
        this.createWrapperProperties(destinationDirectory, version);
        this.createWrapperJar(destinationDirectory);
    }

    public void upgradeIdeaBldLibrary(File destinationDirectory, String version) throws IOException {
        File libraries_test;
        File libraries_runtime;
        File libraries_compile;
        File libraries_bld = new File(destinationDirectory, Path.of("libraries", "bld.xml").toString());
        if (libraries_bld.exists()) {
            try {
                String content = FileUtils.readString(libraries_bld);
                content = BLD_JAR_PATTERN.matcher(content).replaceAll("/.bld/dist/bld-" + version + ".jar");
                content = BLD_SOURCES_JAR_PATTERN.matcher(content).replaceAll("/.bld/dist/bld-" + version + "-sources.jar");
                content = RIFE2_JAR_PATTERN.matcher(content).replaceAll("/.bld/dist/bld-" + version + ".jar");
                content = RIFE2_SOURCES_JAR_PATTERN.matcher(content).replaceAll("/.bld/dist/bld-" + version + "-sources.jar");
                FileUtils.writeString(content, libraries_bld);
            }
            catch (FileUtilsErrorException e) {
                throw new IOException(e);
            }
        }
        if ((libraries_compile = new File(destinationDirectory, Path.of("libraries", "compile.xml").toString())).exists()) {
            try {
                String content = FileUtils.readString(libraries_compile);
                content = JAR_DIRECTORY_LIB_COMPILE_RECURSIVE_PATTERN.matcher(content).replaceAll("<jarDirectory url=\"file://\\$PROJECT_DIR\\$/lib/compile\" recursive=\"true\"");
                content = JAR_DIRECTORY_LIB_PROVIDED_RECURSIVE_PATTERN.matcher(content).replaceAll("<jarDirectory url=\"file://\\$PROJECT_DIR\\$/lib/provided\" recursive=\"true\"");
                FileUtils.writeString(content, libraries_compile);
            }
            catch (FileUtilsErrorException e) {
                throw new IOException(e);
            }
        }
        if ((libraries_runtime = new File(destinationDirectory, Path.of("libraries", "runtime.xml").toString())).exists()) {
            try {
                String content = FileUtils.readString(libraries_runtime);
                content = JAR_DIRECTORY_LIB_RUNTIME_RECURSIVE_PATTERN.matcher(content).replaceAll("<jarDirectory url=\"file://\\$PROJECT_DIR\\$/lib/runtime\" recursive=\"true\"");
                FileUtils.writeString(content, libraries_runtime);
            }
            catch (FileUtilsErrorException e) {
                throw new IOException(e);
            }
        }
        if ((libraries_test = new File(destinationDirectory, Path.of("libraries", "test.xml").toString())).exists()) {
            try {
                String content = FileUtils.readString(libraries_test);
                content = JAR_DIRECTORY_LIB_PROVIDED_RECURSIVE_PATTERN.matcher(content).replaceAll("<jarDirectory url=\"file://\\$PROJECT_DIR\\$/lib/provided\" recursive=\"true\"");
                content = JAR_DIRECTORY_LIB_TEST_RECURSIVE_PATTERN.matcher(content).replaceAll("<jarDirectory url=\"file://\\$PROJECT_DIR\\$/lib/test\" recursive=\"true\"");
                FileUtils.writeString(content, libraries_test);
            }
            catch (FileUtilsErrorException e) {
                throw new IOException(e);
            }
        }
    }

    public void upgradeVscodeSettings(File destinationDirectory, String version) throws IOException {
        File file = new File(destinationDirectory, Path.of("settings.json", new String[0]).toString());
        if (file.exists()) {
            try {
                String content = FileUtils.readString(file);
                content = BLD_JAR_PATTERN.matcher(content).replaceAll("/.bld/dist/bld-" + version + ".jar");
                content = RIFE2_JAR_PATTERN.matcher(content).replaceAll("/.bld/dist/bld-" + version + ".jar");
                FileUtils.writeString(content, file);
            }
            catch (FileUtilsErrorException e) {
                throw new IOException(e);
            }
        }
    }

    private void createWrapperProperties(File destinationDirectory, String version) throws IOException {
        File file = new File(destinationDirectory, WRAPPER_PROPERTIES);
        if (file.exists()) {
            try {
                String contents = FileUtils.readString(file);
                contents = contents.replace(RIFE2_PROPERTY_DOWNLOAD_LOCATION, BLD_PROPERTY_DOWNLOAD_LOCATION);
                contents = BLD_PROPERTY_VERSION_PATTERN.matcher(contents).replaceAll("bld.version=" + version);
                contents = RIFE2_PROPERTY_VERSION_PATTERN.matcher(contents).replaceAll("bld.version=" + version);
                FileUtils.writeString(contents, file);
            }
            catch (FileUtilsErrorException e) {
                throw new IOException(e);
            }
        }
        String properties_blueprint = "bld.downloadExtensionJavadoc=false\nbld.downloadExtensionSources=true\nbld.downloadLocation=\nbld.extensions=\nbld.javaOptions=\nbld.javacOptions=\nbld.repositories=MAVEN_CENTRAL,RIFE2_RELEASES\nbld.sourceDirectories=\nbld.version=${version}\n".replace("${version}", version);
        Files.createDirectories(file.getAbsoluteFile().toPath().getParent(), new FileAttribute[0]);
        Files.deleteIfExists(file.toPath());
        try {
            FileUtils.writeString(properties_blueprint, file);
        }
        catch (FileUtilsErrorException e) {
            throw new IOException(e);
        }
    }

    private void createWrapperJar(File destinationDirectory) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, this.getClass().getName());
        try (JarOutputStream jar = new JarOutputStream((OutputStream)new FileOutputStream(new File(destinationDirectory, WRAPPER_JAR)), manifest);){
            this.addClassToJar(jar, Wrapper.class);
            this.addClassToJar(jar, LaunchMode.class);
            this.addClassToJar(jar, WrapperClassLoader.class);
            this.addClassToJar(jar, FileUtils.class);
            this.addClassToJar(jar, FileUtilsErrorException.class);
            this.addClassToJar(jar, InnerClassException.class);
            this.addFileToJar(jar, BLD_VERSION);
            jar.flush();
        }
    }

    public void currentDir(File dir) {
        this.currentDir_ = dir;
    }

    public void initWrapperProperties(String version) throws IOException {
        this.wrapperProperties_.put(PROPERTY_REPOSITORIES, MAVEN_CENTRAL);
        this.wrapperProperties_.put(BLD_PROPERTY_VERSION, version);
        File config = this.libBldDirectory(WRAPPER_PROPERTIES);
        if (config.exists()) {
            this.wrapperPropertiesFile_ = config;
            this.wrapperProperties_.load(new FileReader(config));
        } else {
            config = this.libDirectory(WRAPPER_PROPERTIES);
            if (config.exists()) {
                this.wrapperPropertiesFile_ = config;
                this.wrapperProperties_.load(new FileReader(config));
            }
        }
        if (this.wrapperProperties_.containsKey(PROPERTY_REPOSITORIES)) {
            for (String repository : this.wrapperProperties_.getProperty(PROPERTY_REPOSITORIES).split(",")) {
                if ((repository = repository.trim()).isBlank()) continue;
                this.repositories_.add(repository);
            }
        }
        for (Map.Entry entry : this.wrapperProperties_.entrySet()) {
            if (!entry.getKey().toString().startsWith(PROPERTY_EXTENSION_PREFIX)) continue;
            for (String extension : entry.getValue().toString().split(",")) {
                if ((extension = extension.trim()).isBlank()) continue;
                this.extensions_.add(extension);
            }
        }
        this.downloadExtensionSources_ = Boolean.parseBoolean(this.wrapperProperties_.getProperty(PROPERTY_DOWNLOAD_EXTENSION_SOURCES, "false"));
        this.downloadExtensionJavadoc_ = Boolean.parseBoolean(this.wrapperProperties_.getProperty(PROPERTY_DOWNLOAD_EXTENSION_JAVADOC, "false"));
    }

    public Set<String> repositories() {
        return this.repositories_;
    }

    public Set<String> extensions() {
        return this.extensions_;
    }

    public Properties wrapperProperties() {
        return this.wrapperProperties_;
    }

    public File wrapperPropertiesFile() {
        return this.wrapperPropertiesFile_;
    }

    private void addClassToJar(JarOutputStream jar, Class klass) throws IOException {
        this.addFileToJar(jar, klass.getName().replace('.', '/') + ".class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileToJar(JarOutputStream jar, String name) throws IOException {
        URL resource = this.getClass().getResource("/" + name);
        if (resource == null) {
            throw new IOException("Couldn't find resource '" + name + "'");
        }
        InputStream stream = null;
        try {
            URLConnection connection = resource.openConnection();
            connection.setUseCaches(false);
            stream = connection.getInputStream();
            JarEntry entry = new JarEntry(name);
            jar.putNextEntry(entry);
            try (BufferedInputStream in = new BufferedInputStream(stream);){
                int count;
                while ((count = in.read(this.buffer_)) != -1) {
                    jar.write(this.buffer_, 0, count);
                }
                jar.closeEntry();
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getVersion() throws IOException {
        try (InputStream in = this.getClass().getResource("/BLD_VERSION").openStream();){
            byte[] bytes = in.readAllBytes();
            String string = new String(bytes, StandardCharsets.UTF_8);
            return string;
        }
    }

    private int installAndLaunch(List<String> arguments) {
        if (!arguments.isEmpty()) {
            File current_file;
            try {
                current_file = new File(arguments.remove(0)).getCanonicalFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.currentDir_ = new File(current_file.getParent());
            if (!arguments.isEmpty() && BUILD_ARGUMENT.equals(arguments.get(0))) {
                this.launchMode_ = LaunchMode.Build;
                arguments.remove(0);
            }
            if (arguments.size() >= 2 && OFFLINE_ARGUMENT.equals(arguments.get(1))) {
                this.offline_ = true;
            }
        }
        try {
            this.extractJvmProperties(arguments);
            this.initWrapperProperties(this.getVersion());
            File distribution = this.installDistribution();
            return this.launchMain(distribution, arguments);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void extractJvmProperties(List<String> arguments) {
        for (String arg : arguments) {
            Matcher matcher = JVM_PROPERTY_PATTERN.matcher(arg);
            if (!matcher.matches()) continue;
            this.jvmProperties_.put(matcher.group(1), matcher.group(2));
        }
    }

    private File buildBldDirectory() {
        return Path.of(this.currentDir_.getAbsolutePath(), "build", "bld").toFile();
    }

    private File srcBldJavaDirectory() {
        return Path.of(this.currentDir_.getAbsolutePath(), "src", "bld", "java").toFile();
    }

    private File srcBldResourcesDirectory() {
        return Path.of(this.currentDir_.getAbsolutePath(), "src", "bld", "resources").toFile();
    }

    private File libBldDirectory() {
        return Path.of(this.currentDir_.getAbsolutePath(), "lib", "bld").toFile();
    }

    private File libDirectory(String path) {
        return Path.of(this.currentDir_.getAbsolutePath(), "..", "lib", path).toFile();
    }

    private File libBldDirectory(String path) {
        return Path.of(this.currentDir_.getAbsolutePath(), "lib", "bld", path).toFile();
    }

    private String getWrapperVersion() throws IOException {
        return this.wrapperProperties_.getProperty(BLD_PROPERTY_VERSION, this.getVersion());
    }

    private boolean isSnapshot(String version) {
        return version.endsWith("-SNAPSHOT");
    }

    private String getWrapperDownloadLocation(String version) {
        String location;
        String default_location = DOWNLOAD_LOCATION;
        if (this.isSnapshot(version)) {
            default_location = DOWNLOAD_LOCATION_SNAPSHOT;
        }
        if ((location = this.wrapperProperties_.getProperty(BLD_PROPERTY_DOWNLOAD_LOCATION, default_location)) == null || location.trim().isBlank()) {
            location = default_location;
        }
        return this.replaceVersion(location, version);
    }

    private String downloadUrl(String version, String fileName) {
        String location = this.getWrapperDownloadLocation(version);
        StringBuilder result = new StringBuilder(location);
        if (!location.endsWith("/")) {
            result.append('/');
        }
        result.append(fileName);
        return result.toString();
    }

    private String bldFileName(String version) {
        return this.replaceVersion(BLD_FILENAME, version);
    }

    private String bldSourcesFileName(String version) {
        return this.replaceVersion(BLD_SOURCES_FILENAME, version);
    }

    private String replaceVersion(String text, String version) {
        return text.replaceAll("\\$\\{version}", version);
    }

    private File installDistribution() throws IOException {
        String version;
        try {
            Files.createDirectories(DISTRIBUTIONS_DIR.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to create distribution directory " + DISTRIBUTIONS_DIR.getAbsolutePath() + ".");
            throw e;
        }
        try {
            version = this.getWrapperVersion();
        }
        catch (IOException e) {
            System.err.println("Failed to retrieve wrapper version number.");
            throw e;
        }
        String download_version = version;
        boolean is_snapshot = this.isSnapshot(version);
        boolean is_local = false;
        if (this.offline_) {
            System.out.println("Offline mode: no artifacts will be checked nor downloaded");
            System.out.flush();
        } else if (is_snapshot) {
            Matcher version_matcher;
            String meta_data = "";
            try {
                meta_data = this.readString(version, new URL(this.downloadUrl(version, "maven-metadata.xml")));
            }
            catch (IOException e) {
                try {
                    meta_data = this.readString(version, new URL(this.downloadUrl(version, "maven-metadata-local.xml")));
                }
                catch (IOException e2) {
                    throw e;
                }
            }
            Matcher local_matcher = META_DATA_LOCAL_COPY.matcher(meta_data);
            is_local = local_matcher.find();
            if (!is_local && (version_matcher = META_DATA_SNAPSHOT_VERSION.matcher(meta_data)).find()) {
                download_version = version_matcher.group(1);
            }
        }
        File distribution_file = new File(DISTRIBUTIONS_DIR, this.bldFileName(version));
        File distribution_sources_file = new File(DISTRIBUTIONS_DIR, this.bldSourcesFileName(version));
        if (!this.offline_) {
            if (is_snapshot && distribution_file.exists()) {
                boolean delete_distribution_files = is_local;
                if (!delete_distribution_files) {
                    String download_md5 = this.readString(version, new URL(this.downloadUrl(version, this.bldFileName(download_version)) + ".md5"));
                    try {
                        MessageDigest digest = MessageDigest.getInstance("MD5");
                        digest.update(FileUtils.readBytes(distribution_file));
                        if (!download_md5.equals(Wrapper.encodeHexLower(digest.digest()))) {
                            delete_distribution_files = true;
                        }
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        // empty catch block
                    }
                }
                if (delete_distribution_files) {
                    distribution_file.delete();
                    if (distribution_sources_file.exists()) {
                        distribution_sources_file.delete();
                    }
                }
            }
            if (!distribution_file.exists()) {
                this.downloadDistribution(distribution_file, this.downloadUrl(version, this.bldFileName(download_version)));
            }
            if (!distribution_sources_file.exists()) {
                try {
                    this.downloadDistribution(distribution_sources_file, this.downloadUrl(version, this.bldSourcesFileName(download_version)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.classloader_ = new WrapperClassLoader();
        this.classloader_.add(distribution_file.toURI().toURL());
        return distribution_file;
    }

    private void downloadDistribution(File file, String downloadUrl) throws IOException {
        try {
            System.out.print("Downloading: " + downloadUrl + " ... ");
            System.out.flush();
            URL url = new URL(downloadUrl);
            ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                System.out.print("done");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("not found");
            System.err.println("Failed to download file " + String.valueOf(file) + ".");
            throw e;
        }
        catch (IOException e) {
            System.err.println("error");
            System.err.println("Failed to download file " + String.valueOf(file) + " due to I/O issue.");
            Files.deleteIfExists(file.toPath());
            throw e;
        }
        finally {
            System.out.println();
        }
    }

    private void resolveExtensions() {
        if (null == this.classloader_ || null == this.wrapperPropertiesFile_ || this.offline_) {
            return;
        }
        try {
            Class<?> resolver_class = this.classloader_.loadClass("rife.bld.wrapper.WrapperExtensionResolver");
            Constructor<?> constructor = resolver_class.getConstructor(File.class, File.class, Properties.class, Properties.class, Collection.class, Collection.class, Boolean.TYPE, Boolean.TYPE);
            Method update_method = resolver_class.getMethod("updateExtensions", new Class[0]);
            Object resolver = constructor.newInstance(this.currentDir_, this.libBldDirectory(), this.jvmProperties_, this.wrapperProperties_, this.repositories_, this.extensions_, this.downloadExtensionSources_, this.downloadExtensionJavadoc_);
            update_method.invoke(resolver, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int launchMain(File jarFile, List<String> arguments) throws IOException, InterruptedException, FileUtilsErrorException {
        if (this.launchMode_ == LaunchMode.Cli) {
            return this.launchMainCli(jarFile, arguments);
        }
        return this.launchMainBuild(jarFile, arguments);
    }

    private int launchMainCli(File jarFile, List<String> arguments) throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(Wrapper.findJavaExecutable());
        Wrapper.includeJvmProperties(arguments, args);
        args.add("-cp");
        args.add(jarFile.getAbsolutePath());
        args.add("-jar");
        args.add(jarFile.getAbsolutePath());
        args.addAll(this.bldJavaOptions());
        args.addAll(arguments);
        ProcessBuilder process_builder = new ProcessBuilder(args);
        process_builder.inheritIO();
        Process process = process_builder.start();
        return process.waitFor();
    }

    private int launchMainBuild(File jarFile, List<String> arguments) throws IOException, InterruptedException {
        this.resolveExtensions();
        File build_bld_dir = this.buildBldDirectory();
        if (build_bld_dir.exists()) {
            FileUtils.deleteDirectory(this.buildBldDirectory());
        }
        this.buildBldDirectory().mkdirs();
        List<File> bld_classpath = this.bldClasspathJars();
        bld_classpath.add(jarFile);
        bld_classpath.add(this.buildBldDirectory());
        bld_classpath.add(this.srcBldResourcesDirectory());
        String classpath = FileUtils.joinPaths(FileUtils.combineToAbsolutePaths(bld_classpath));
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        try (StandardJavaFileManager file_manager = compiler.getStandardFileManager(null, null, null);){
            Iterable<? extends JavaFileObject> compilation_units = file_manager.getJavaFileObjectsFromFiles(this.bldSourceFiles());
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            ArrayList<String> options = new ArrayList<String>(List.of("-d", this.buildBldDirectory().getAbsolutePath(), "-cp", classpath));
            options.addAll(this.bldJavacOptions());
            JavaCompiler.CompilationTask compilation_task = compiler.getTask(null, file_manager, diagnostics, options, null, compilation_units);
            if (!compilation_task.call().booleanValue() && !diagnostics.getDiagnostics().isEmpty()) {
                for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                    System.err.print(diagnostic.toString() + System.lineSeparator());
                }
                int n = 1;
                return n;
            }
        }
        ArrayList<String> java_args = new ArrayList<String>();
        java_args.add(Wrapper.findJavaExecutable());
        Wrapper.includeJvmProperties(arguments, java_args);
        java_args.add("-cp");
        java_args.add(classpath);
        java_args.addAll(this.bldJavaOptions());
        java_args.addAll(arguments);
        ProcessBuilder process_builder = new ProcessBuilder(java_args);
        process_builder.directory(this.currentDir_);
        process_builder.inheritIO();
        Process process = process_builder.start();
        return process.waitFor();
    }

    private static String findJavaExecutable() {
        String executable = System.getProperty("os.name").toLowerCase().contains("win") ? "java.exe" : "java";
        String java_home = System.getProperty("java.home");
        if (null == java_home) {
            return executable;
        }
        return java_home + File.separator + "bin" + File.separator + executable;
    }

    private static void includeJvmProperties(List<String> arguments, List<String> javaArgs) {
        Iterator<String> i = arguments.iterator();
        while (i.hasNext()) {
            String arg = i.next();
            if (!JVM_PROPERTY_PATTERN.matcher(arg).matches()) continue;
            javaArgs.add(arg);
            i.remove();
        }
    }

    private List<File> bldClasspathJars() {
        File dir_abs = this.libBldDirectory().getAbsoluteFile();
        List<String> jar_files = FileUtils.getFileList(dir_abs, CLASSPATH_INCLUDED_JARS, CLASSPATH_EXCLUDED_JARS);
        return new ArrayList<File>(jar_files.stream().map(file -> new File(dir_abs, (String)file)).toList());
    }

    public List<File> bldSourceFiles() {
        ArrayList<File> source_directories = new ArrayList<File>();
        source_directories.add(this.srcBldJavaDirectory().getAbsoluteFile());
        if (this.wrapperProperties_.containsKey(PROPERTY_SOURCE_DIRECTORIES)) {
            String source_directories_property = this.wrapperProperties_.get(PROPERTY_SOURCE_DIRECTORIES).toString();
            for (String source_directory : source_directories_property.split(",")) {
                if ((source_directory = source_directory.trim()).isBlank()) continue;
                source_directories.add(new File(source_directory).getAbsoluteFile());
            }
        }
        ArrayList<File> source_files = new ArrayList<File>();
        for (File source_directory : source_directories) {
            source_files.addAll(FileUtils.getFileList(source_directory, FileUtils.JAVA_FILE_PATTERN, null).stream().map(file -> new File(source_directory, (String)file)).toList());
        }
        return source_files;
    }

    public List<String> bldJavacOptions() {
        if (!this.wrapperProperties_.containsKey(PROPERTY_JAVAC_OPTIONS)) {
            return Collections.emptyList();
        }
        return OPTIONS_PATTERN.matcher(this.wrapperProperties_.get(PROPERTY_JAVAC_OPTIONS).toString()).results().map(MatchResult::group).toList();
    }

    public List<String> bldJavaOptions() {
        if (!this.wrapperProperties_.containsKey(PROPERTY_JAVA_OPTIONS)) {
            return Collections.emptyList();
        }
        return OPTIONS_PATTERN.matcher(this.wrapperProperties_.get(PROPERTY_JAVA_OPTIONS).toString()).results().map(MatchResult::group).toList();
    }

    private String readString(String version, URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        connection.setRequestProperty("User-Agent", "bld " + version);
        try (InputStream in = connection.getInputStream();){
            String string = new String(in.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    public static void appendHexDigitLower(StringBuilder out, int number) {
        out.append(HEX_DIGITS_LOWER[number & 0xF]);
    }

    public static String encodeHexLower(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        for (byte b : bytes) {
            Wrapper.appendHexDigitLower(out, b >> 4);
            Wrapper.appendHexDigitLower(out, b);
        }
        return out.toString();
    }

    private static enum LaunchMode {
        Cli,
        Build;

    }
}

