CalendarKit actively accepts contributions in a form of pull requests (code changes) and issues (bug reports and feature requests). If you wish to submit a pull request, feel free to raise an issue first to discuss the implementation details and your approach.

## Need Help?
If you have a **programming question** about how to use CalendarKit in your application, [Create a new GitHub Issue with the question tag](https://github.com/richardtop/CalendarKit/issues/new?assignees=&labels=question&projects=&template=question.md&title=).

Check out the [Sample App](https://github.com/richardtop/CalendarApp) for reference.

[Create a new Issue from template](https://github.com/richardtop/CalendarKit/issues/new/choose) to report a bug or request a new feature.



## Code Style
When submitting a pull request, adhering to the code style is recommended, although not compulsory.

This project has the following code style (Xcode Default):

* Indent with spaces (not tabs)
* Tab width: 4 spaces
* Indent with: 4 spaces
* Curly braces open on the same line as the code

### Examples

**Incorrect:**

```Swift
//
//  File.swift
//  CalendarKit
//
//  Created by user on 29/09/2017.
//

import Foundation

class aClass
{
    func aFunction()
    {
        
    }
}
```

**Correct:**

```Swift
import Foundation

class aClass {
  func aFunction() {
    
  }
}

```
