if exists("b:current_syntax")
finish
endif
let s:cpo_save = &cpo
set cpo&vim
if !exists("hw_version")
let hw_version = 8
let hw_subversion = 0
elseif !exists("hw_subversion")
let hw_subversion = 0
endif
syn case match
syn sync minlines=100
syn region hwParen      transparent  start='(' end=')' contains=ALLBUT,hwParenError,hwTodo,hwSpecial,hwIfEndIf,hwElseIf,hwElse,hwBlock,hwLoopBlock,hwIn,hwStatement,hwStep,hwFallThrough,hwLineStatement
syn region hwTableBlock transparent matchgroup=hwTable start="{" end="}" contains=ALLBUT,hwBraceError,hwTodo,hwSpecial,hwIfEndIf,hwElseIf,hwElse,hwBlock,hwLoopBlock,hwIn,hwStatement,hwStep,hwFallThrough,hwLineStatement
syn match  hwParenError ")"
syn match  hwBraceError "}"
syn match  hwError "\<\%(If\|End\|Else\|ElseIf\|Then\|Until\|In\|EndIf\|EndSwitch\|FallThrough\|Case\|Default\|Wend\|Until\|Forever\)\>"
syn region hwFunctionBlock transparent matchgroup=hwFunction start="\<Function\>" end="\<EndFunction\>" contains=ALLBUT,hwTodo,hwSpecial,hwElseIf,hwElse,hwIn,hwStep,hwFallThrough,hwLineStatement
syn region hwIfThen transparent matchgroup=hwCond start="\<If\>" end="\<Then\>\{-}"me=e-4 skipwhite skipempty
syn region hwThenElse transparent matchgroup=hwCond start="\<Then\>" end="$" end="\<Else\>" contains=ALLBUT,hwTodo,hwSpecial,hwIn,hwStep,hwLineStatement,hwIfEndIf,hwElseEndif,hwIfThen,hwThenElse skipwhite skipempty
syn region hwIfEndIf transparent matchgroup=hwCond start="\<If\>\(\(.\{-}Then.\{-}\)\@!\)" end="\<EndIf\>" contains=ALLBUT,hwTodo,hwSpecial,hwIn,hwStep,hwLineStatement skipwhite skipempty
syn region hwElseEndIf contained transparent matchgroup=hwCond start="\<Else\>" end="\<EndIf\>"me=e-5 contains=ALLBUT,hwTodo,hwSpecial,hwElseIf,hwElseEndIf,hwIn,hwStep,hwFallThrough,hwLineStatement
syn keyword hwLineStatement Forever contained
syn keyword hwLineStatement Do contained
syn keyword hwElseIf ElseIf contained
syn region hwSwitchEnd transparent matchgroup=hwCond start="\<Switch\>" end="\<EndSwitch\>" contains=hwCase,hwDefCase skipwhite skipempty
syn region hwCase transparent matchgroup=hwCond start="\<Case\>" end="\<EndSwitch\>"me=e-9 end="\<Default\>:"me=e-8 end="\<Case\>"me=e-4 contains=ALLBUT,hwTodo,hwSpecial,hwElseIf,hwElseEndIf,hwLineStatement,hwIn,hwStep skipwhite skipempty
syn region hwDefCase transparent matchgroup=hwCond start="\<Default\>" end="\<EndSwitch\>"me=e-9 contains=ALLBUT,hwTodo,hwSpecial,hwElseIf,hwElseEndIf,hwIn,hwStep,hwCase,hwDefCase,hwFallThrough,hwLineStatement skipwhite skipempty
syn keyword hwFallThrough contained FallThrough
syn region hwBlock transparent matchgroup=hwStatement start="\<Block\>" end="\<EndBlock\>"  contains=ALLBUT,hwTodo,hwSpecial,hwElseIf,hwElse,hwIn,hwStep,hwLineStatement
syn region hwLoopBlock transparent matchgroup=hwRepeat start="\<Repeat\>" end="\<Forever\>" end="\<Until\>"   contains=ALLBUT,hwTodo,hwSpecial,hwElseIf,hwElse,hwIn,hwStep,hwLineStatement
syn region hwLoopBlock transparent matchgroup=hwRepeat start="\<While\>" end="\<Do\>" end="\<Wend\>" contains=ALLBUT,hwTodo,hwSpecial,hwElseIf,hwElse,hwIn,hwStep,hwLineStatement skipwhite skipempty
syn region hwForTo transparent matchgroup=hwRepeat start="\<For\>" end="\<To\>"me=e-2 skipwhite skipempty nextgroup=hwToNext
syn region hwToNext transparent matchgroup=hwRepeat start="\<To\>" end="\<Next\>"   contains=ALLBUT,hwTodo,hwSpecial,hwElseIf,hwElse,hwIn,hwLineStatement skipwhite skipempty
syn keyword hwStep contained Step
syn keyword hwIn contained In
syn keyword hwStatement Return Break Continue
syn keyword hwStatement Goto Gosub Dim DimStr Const Local Global
syn match hwLabel "::\I\i*::"
syn match hwOperator "\%(&\|\*\|+\|-\|\.\||\|//\|/\|:\|<\|=\|>\|<>\|<=\|=>\|\^\|\~\|\\\|\<And\>\|\<Not\>\|\<Or\>\)"
syn keyword hwConstant Nil
syn keyword hwConstant True False
syn match hwPreProcessor "@\<\%(BGPIC\|BRUSH\|ANIM\|SPRITE\|SAMPLE\|MUSIC\|FILE\|FONT\|VIDEO\|VERSION\|APPTITLE\|APPAUTHOR\|APPCOPYRIGHT\|APPDESCRIPTION\|APPVERSION\|APPICON\|BACKFILL\|SCREEN\|DISPLAY\|INCLUDE\|OPTIONS\|REQUIRE\|MENU\|APPIDENTIFIER\|WARNING\|ERROR\|IF\|ELSEIF\|ELSE\|ENDIF\)\>"ms=s+1
syn match hwConstant "#\<\%(ERR_PORTNOTAVAIL\|SEEK_END\|ERR_CREATESHORTCUT\|PURPLE\|ERR_ALLOCCHANNEL\|PRGTYPE_SCRIPT\|ERR_NORETVAL\|ERR_DDRECVIDEO\|ERR_FINDPATH\|LANGUAGE_RUNDI\|ERR_STRINGCST\|COUNTRY_COLOMBIA\|LANGUAGE_KOREAN\|ERR_USERABORT\|ERR_WENDWOWHILE\|FONT\|FILEATTR_WRITE_OTH\|ERR_MODIFYABGPIC\|COUNTRY_DRCONGO\|LANGUAGE_KIRGHIZ\|LANGUAGE_ROMANSH\|FILEATTR_EXECUTE_GRP\|ERR_READVIDEOPIXELS\|SCROLLTOP\|ERR_ANIMDISK\|COUNTRY_IVORYCOAST\|LANGUAGE_GUJARATI\|SHORT\|COUNTRY_SOUTHAFRICA\|VIDEO\|ERR_BLKWOENDBLK\|ERR_WRONGHEX\|SPRITE_VS_BRUSH\|LANGUAGE_HIRIMOTU\|ZOOMSOUTHEAST\|COUNTRY_SLOVAKIA\|COUNTRY_GIBRALTAR\|ERR_INVALIDDATE\|RTS_ON\|PIXELZOOM1\|ATTRFRAMEDELAY\|AQUA\|ATTRFONTSCALABLE\|FILEATTR_NORMAL\|COUNTRY_ALBANIA\|COUNTRY_JAMAICA\|FONTWEIGHT_MEDIUM\|ERR_MALFORMPAT1\|COUNTRY_FRENCHGUIANA\|ERR_MAXPARAMS\|ERR_FORWONEXT\|COUNTRY_CONGO\|COUNTRY_GAMBIA\|UPNDOWN\|COUNTRY_ANDORRA\|BRUSH\|ERR_SELECTALPHACHANNEL\|MODLCOMMAND\|CLIENT\|COUNTRY_TRINIDADANDTOBAGO\|DIRECTORY\|LANGUAGE_ESPERANTO\|ATTRRAWHEIGHT\|COUNTRY_DENMARK\|FILETYPE_SOUND\|CLIPBOARD_TEXT\|LANGUAGE_FULAH\|ATTRPOSITION\|PLUGINCAPS_CONVERT\|ERR_APPLETVERSION\|COUNTRY_VANUATU\|COUNTDIRECTORIES\|ATTRNOHIDE\|VSTRIPES64\|AMIGAICON_SETPOSITION\|PUSHBOTTOM\|ERR_BACKFILL\|COUNTRY_MOROCCO\|ERR_FILEFORMAT\|COUNTRY_CHILE\|ATTRHOSTSCALEY\|ERR_AHI\|HW_VERSION\|ERR_ALRDYDECLRD\|ATTRRAWWIDTH\|ERR_PIXELFORMAT\|IMGFMT_PLUGIN\|LANGUAGE_HEBREW\|ERR_SETMENU\|ERR_NOLAYERS\|CRUSHTOP\|ERR_MAXLINES\|ATTRHASMASK\|LEFT\|ERR_SELECTANIM\|WALLPAPERLEFT\|TEXTOBJECT\|ERR_AFILEPROP\|LANGUAGE_CZECH\|LANGUAGE_XHOSA\|ERR_PIPE\|LANGUAGE_MANX\|ERR_EXECUTE\|ERR_ENDDOUBLEBUFFER\|ATTRGROUP\|ERR_NAMETOOLONG\|ATTRBORDERRIGHT\|COUNTRY_BOSNIAANDHERZEGOVINA\|ATTRMARGINRIGHT\|RTS_OFF\|LANGUAGE_MARSHALLESE\|LANGUAGE_AZERBAIJANI\|LANGUAGE_TAHITIAN\|JOINMITER\|ATTRNOCLOSE\|REQICON_WARNING\|ERR_NOTPROTRACKER\|LANGUAGE_LAO\|ERR_EMPTYPATH\|ERR_NOCALLBACK\|COUNTRY_UGANDA\|ERR_READFUNC\|IMGFMT_UNKNOWN\|ADF_ANIM\|ERR_LAYERSWITCH\|ERR_RECVCLOSED\|ERR_CTRLSTRUCT\|ERR_TABLEOVERFLOW\|SCROLLBOTTOM\|VSTRIPES\|ERR_VAREXPECTED\|ERR_NOTIGER\|BEEPSYSTEM\|ERR_LOWFREQ\|COUNTFILES\|COUNTRY_MONACO\|BLUE\|ERR_VFONT\|STRUDEL\|REQ_GALLERY\|ERR_NOCOORDCST\|MENU\|HSTRIPES64\|COUNTRY_COCOSISLANDS\|LANGUAGE_SOUTHNDEBELE\|COUNTRY_FALKLANDISLANDS\|COUNTRY_UAE\|LANGUAGE_KANNADA\|ERR_VIDRECMULTI\|FILETYPE_VIDEO\|LANGUAGE_ESTONIAN\|COUNTRY_CAYMANISLANDS\|ERR_BADINTEGER\|MONO16\|COUNTRY_CAMEROON\|COUNTRY_GUAM\|ERR_DISPLAYDESKTOP\|ERR_SETENV\|ERR_INTERNAL\|MASKVISIBLE\|ERR_OPENFONT\|LANGUAGE_WELSH\|ATTRRAWXPOS\|LANGUAGE_THAI\|ATTRHOSTMONITORS\|LANGUAGE_GALICIAN\|COUNTRY_GUATEMALA\|ATTRYPOS\|COUNTRY_UZBEKISTAN\|ERR_ELSEIFAFTERELSE\|MODRCONTROL\|BAUD_4800\|JOYDOWNRIGHT\|COUNTRY_LUXEMBOURG\|COUNTRY_MOZAMBIQUE\|ERR_PAKFORMAT\|LANGUAGE_TAJIK\|LANGUAGE_PANJABI\|ERR_MISSINGFIELD\|PLUGINCAPS_LIBRARY\|ERR_FUNCARGS\|LANGUAGE_MALAY\|COUNTRY_PORTUGAL\|COUNTRY_JAPAN\|ERR_ICONPARMS\|COUNTRY_NEWCALEDONIA\|REMOVELAYER\|MOVEWINDOW\|ATTRFONTASCENDER\|PLUGINCAPS_DIRADAPTER\|ERR_VARLENGTH\|ATTRSIZEABLE\|ERR_SENDUNKNOWN\|MENUITEM_RADIO\|COUNTRY_BELIZE\|ERR_LABELDOUBLE\|QUADRECT\|VBLINDS8\|ERR_UNKNOWNCMD\|SCROLLEAST\|ONBUTTONCLICKALL\|RECTNORTHEAST\|FONTWEIGHT_EXTRABOLD\|COUNTRY_SAINTKITTSANDNEVIS\|ERR_CLOSEDDISPLAY\|PLUGINCAPS_SAVEANIM\|ERR_WINDOW\|LANGUAGE_ZHUANG\|CAPROUND\|ERR_OUTOFRANGE\|REQ_CAMERA\|ERR_WARPOS\|COUNTRY_ELSALVADOR\|ERR_GROUPNAMEUSED\|COUNTRY_GUYANA\|ERR_ALREADYASYNC\|COUNTRY_PALESTINE\|DISPMODE_FAKEFULLSCREEN\|ERR_SYNTAXLEVELS\|ERR_BADPLATFORM\|ERR_VERSION\|ATTRVISIBLE\|HSTRETCHCENTER\|COUNTRY_REUNION\|COUNTRY_INDIA\|STRETCHLEFT\|ERR_ZERODIVISION\|LANGUAGE_NORTHERNSAMI\|SIMPLEBUTTON\|ERR_FINDMENU\|ERR_EMPTYOBJ\|LANGUAGE_BIHARI\|LANGUAGE_LIMBURGAN\|LANGUAGE_BOSNIAN\|ERR_SYSTOOOLD\|ERR_WRITEJPEG\|STOP_1\|COPYFILE_OVERWRITE\|ERR_REVDWORD\|PLUGINCAPS_ANIM\|ERR_ASSERTFAILED\|ERR_BRACEOPEN\|ERR_NEEDMORPHOS2\|BLACK\|LANGUAGE_SWEDISH\|ERR_DBLENCODING\|COPYFILE_STATUS\|ERR_WRONGOPCST\|ERR_BADIP\|ERR_UNKNOWNSEQ\|LANGUAGE_LUXEMBOURGISH\|ERR_WITHWOENDWITH\|ERR_LABINIF\|LANGUAGE_TATAR\|ERR_VIDEOLAYERDRV\|ERR_LEGACYPTMOD\|ERR_SAVEPNG\|NOTRANSPARENCY\|ATTRMASKMODE\|LANGUAGE_VENDA\|ERR_NEWHWPLUGIN\|LANGUAGE_LATIN\|LANGUAGE_EWE\|MENUITEM_TOGGLE\|ERR_BRACKETOPEN\|JOYUP\|COUNTRY_SENEGAL\|LANGUAGE_CHURCHSLAVIC\|ERR_ZLIBIO\|RECTBACKNORTHWEST\|MOVELIST\|ERR_TEXTARG\|ONBUTTONOVER\|VIDDRV_HOLLYWOOD\|IMGFMT_JPEG\|REQ_MULTISELECT\|COUNTRY_NIGERIA\|LANGUAGE_GUARANI\|LANGUAGE_POLISH\|ERR_ICONSTANDARD\|REQ_HIDEICONS\|LANGUAGE_CORSICAN\|DISPMODE_MODEREQUESTER\|ERR_NOABSPATH\|LANGUAGE_GERMAN\|ERR_RANDOMIZE\|ERR_ARGS\|PLUGINCAPS_AUDIOADAPTER\|IMAGETYPE_VECTOR\|LANGUAGE_GREEK\|COUNTRY_HOLYSEE\|COUNTRY_NORTHKOREA\|LANGUAGE_MALAYALAM\|COUNTRY_BOTSWANA\|LANGUAGE_CREE\|ATTRNUMENTRIES\|REQICON_ERROR\|IMGFMT_GIF\|FTPBINARY\|WORD\|VIDDRV_OS\|ATTRDURATION\|LANGUAGE_AKAN\|ERR_FTPERROR\|PLUGINCAPS_VIDEO\|ERR_EXAMINE\|HSTRIPES8\|COUNTRY_OMAN\|CIRCLE\|ERR_BRUSHLINK\|ERR_STREAMASSAMPLE\|ERR_DISPLAYSIZE\|ERR_WRONGFLOAT\|PLUGINCAPS_FILEADAPTER\|ERR_UNSUPPORTEDFEAT\|DISPLAY\|ERR_MUSPAUSED\|INTEGER\|COUNTRY_BOLIVIA\|ERR_RECVTIMEOUT\|ATTRMONITOR\|LANGUAGE_INUKTITUT\|ATTRPAUSED\|LANGUAGE_LITHUANIAN\|DATEYEAR\|JOYUPRIGHT\|ERR_LAYERSOFF\|ERR_EMPTYSCRIPT\|LIGHTUSERDATA\|ERR_FINDTIMER\|ALPHACHANNEL\|LANGUAGE_WALLOON\|ERR_ADFWRONGDISP\|ERR_HTTPERROR\|ERR_REWINDDIR\|ERR_LOCKEDOBJ\|COUNTRY_NEPAL\|HSTRIPES2\|RECTSOUTH\|ERR_UNKPROTOCOL\|COUNTRY_CANADA\|COUNTRY_VENEZUELA\|COUNTRY_MALDIVES\|ERR_SQBRACKETCLOSE\|ERR_HTTPTE\|VSTRIPES2\|COUNTRY_NORWAY\|ERR_FIRSTPREPROC\|SNAPDESKTOP\|LANGUAGE_FINNISH\|COUNTRY_TURKEY\|LANGUAGE_VIETNAMESE\|VBLINDS64\|ERR_FONTFORMAT\|ERR_PIXELRANGE\|LANGUAGE_AVESTAN\|ERR_SYSIMAGE\|BIGSINE\|CLIPBOARD_EMPTY\|ERR_WRONGCLIPREG\|AMIGAICON_NONE\|FONTWEIGHT_EXTRABLACK\|LANGUAGE_IDO\|ATTRFORMAT\|ERR_FUNCJMP\|PARITY_NONE\|ATTRHOSTDEPTH\|ERR_RENDERCALLBACK\|ERR_FINDPORT\|LANGUAGE_NEPALI\|COUNTRY_AMERICANSAMOA\|ERR_MISSINGSEPARTR\|MODRALT\|COUNTRY_BESISLANDS\|LANGUAGE_AVARIC\|ERR_VIDNOTPAUSED\|TOPOUT\|ERR_VALUEEXPECTED\|ERR_WRONGUSAGE\|TURNDOWNLEFT\|ERR_ICONDIMS\|LANGUAGE_HAUSA\|ERR_TRANSBGMOBILE\|SEEK_CURRENT\|ERR_MONITORRANGE\|COUNTRY_FAROEISLANDS\|SHAPE\|COUNTRY_SOLOMONISLANDS\|NAVY\|ERR_PREPROCSYM\|COUNTRY_GEORGIA\|LANGUAGE_OSSETIAN\|ERR_THREAD\|DATA_5\|ERR_INISYNTAX\|ERR_MUSFMTSUPPORT\|LANGUAGE_YIDDISH\|ATTRLAYERS\|SMOOTHOUT\|LANGUAGE_KONGO\|COUNTRY_KYRGYZSTAN\|ATTRDOUBLEBUFFER\|TOP\|ERR_SYSBUTTON\|ERR_DATATYPESAVE\|COUNTRY_LIBYA\|ERR_FUNCWOENDFUNC\|ANIMSTREAM\|ATTRUSERDATA\|LANGUAGE_NORTHNDEBELE\|UDPCLIENT\|ERR_MUSNOTPLYNG\|FILEATTR_READ_OTH\|ERR_EVNTEXPCTED\|ERR_BADDIMENSIONS\|ATTROUTPUTDEVICE\|LANGUAGE_BULGARIAN\|LANGUAGE_SPANISH\|DISPMODE_FULLSCREENSCALE\|LANGUAGE_INTERLINGUE\|FASTSPEED\|ERR_NODISPMODES\|LANGUAGE_CHAMORRO\|ATTRACTIVE\|COUNTRY_TOGO\|INACTIVEWINDOW\|ERR_CREATEEVENT\|COUNTRY_SAUDIARABIA\|FILEATTR_EXECUTE_OTH\|IPAUTO\|SHDWNORTHEAST\|MEMORY\|ERR_XF86VIDMODEEXT\|ARC\|TIMER\|COUNTRY_ICELAND\|FUCHSIA\|NETWORKUDP\|ERR_FINDCLIPREGION\|NETWORKSERVER\|NETWORKCONNECTION\|ATTRFONTNAME\|UDPOBJECT\|ERR_UNTERMINTDSTR\|LANGUAGE_NORWEGIANNYNORSK\|RECTBACKCENTER\|COUNTRY_BANGLADESH\|UPLOADFILE_RESPONSE\|COUNTRY_ITALY\|MASKINVISIBLE\|UPLOADFILE_STATUS\|ERR_FOREVERWOREPEAT\|STRETCHBOTTOM\|STRETCHRIGHT\|MOVEFILE_COPY\|FTPASCII\|RECEIVELINE\|RECEIVEBYTES\|ERR_DRAWPATH\|ATTRFONTAA\|VSTRANGEPUSH\|ERR_BADBASE64\|ERR_NOCLIPREG\|SCROLLNORTHWEST\|RECEIVEALL\|ERR_PLUGINARCH\|DTR_OFF\|HEXNUMERICAL\|FLOW_XON_XOFF\|ERR_LAYERSUPPORT2\|FLOW_HARDWARE\|LANGUAGE_GAELIC\|FLOW_OFF\|COUNTRY_ANTARCTICA\|ERR_REQAUTH\|STOP_2\|SERIF\|ERR_FINDANIM\|PARITY_ODD\|DATA_8\|VSTRIPES32\|COUNTRY_FRANCE\|DATA_6\|BAUD_460800\|HKEY_CURRENT_USER\|COUNTRY_BELARUS\|BAUD_115200\|BAUD_57600\|BAUD_38400\|BAUD_19200\|VSTRIPES4\|COUNTRY_ALANDISLANDS\|LANGUAGE_UKRAINIAN\|ERR_ICONSIZE\|BAUD_9600\|COUNTRY_SYRIA\|COUNTRY_NICARAGUA\|COUNTRY_PERU\|ERR_SIGNAL\|BAUD_2400\|JOYDOWN\|BAUD_300\|FILLRULEEVENODD\|ERR_COMMODITY\|ERR_UNKNOWN\|LANGUAGE_CORNISH\|FONTWEIGHT_LIGHT\|ERR_BAD8SVX\|ONBUTTONOVERALL\|CROSSFADE\|CAPSQUARE\|CAPBUTT\|ERR_STRORNUM\|LANGUAGE_SINDHI\|BEEPQUESTION\|JOINBEVEL\|ERR_PLUGINDOUBLET\|JOINROUND\|LANGUAGE_WESTERNFRISIAN\|ERR_PROTMETATABLE\|LANGUAGE_TURKISH\|BOTTOM\|ZOOMNORTH\|ERR_DATATYPEALPHA\|ERR_FINDUDPOBJECT\|SUN\|TURNDOWNRIGHT\|UDPSERVER\|MODRCOMMAND\|LANGUAGE_SWATI\|COUNTRY_MALAWI\|KEEPASPRAT\|DEFAULTICON\|LANGUAGE_TONGA\|ERR_NUMCALLBACK\|STRING\|ATTRPITCH\|ERR_ELSEWOIF\|COUNTRY_SAMOA\|LANGUAGE_PASHTO\|CARDTOP\|DENSITY_NONE\|ITALIC\|PLUGINCAPS_DISPLAYADAPTER\|FILEATTR_READ_USR\|LANGUAGE_UIGHUR\|ERR_EMPTYTABLE\|COUNTRY_CAPEVERDE\|ERR_FGRABVIDSTATE\|ERR_LOCK2\|LANGUAGE_ICELANDIC\|LIME\|ATTRCURSUBSONG\|CENTER\|ERR_VECGFXPLUGIN\|THREAD\|SLIDERIGHT\|NORMALSPEED\|SELMODE_LAYERS\|SLIDELEFT\|HLOWFLIPCOIN\|HFLIPCOIN\|VLOWFLIPCOIN\|ERR_INVCAPIDX\|VFLIPCOIN\|ASYNCDRAW\|ERR_INCOMPATBRUSH\|RECTBACKWEST\|FILEATTR_WRITE_USR\|ATTRONSCREEN\|CRUSHRIGHT\|LANGUAGE_BRETON\|ERR_REPEATWOUNTIL\|ERR_NOLOOP\|ATTRDISPLAY\|ERR_FILENOTFOUND\|ATTRDENSITY\|ERR_GETMONITORINFO\|ERR_POINTERFORMAT\|ZOOMIN\|PIXELZOOM2\|HSTRANGEPUSH\|FILEATTR_SYSTEM\|ERR_COLORSPACE\|LANGUAGE_ZULU\|ATTRHOSTWIDTH\|LANGUAGE_SANGO\|ERR_SOCKET\|STAR\|ERR_FINDBUTTON\|CLOCKWIPE\|FILLCOLOR\|USELAYERPOSITION\|LANGUAGE_BELARUSIAN\|COUNTRY_MICRONESIA\|COPYFILE_UNPROTECT\|DISSOLVE\|UNDERLINED\|WATER4\|COUNTRY_BURKINAFASO\|LANGUAGE_LINGALA\|WATER3\|MASK\|ATTRNOMODESWITCH\|ERR_SETFILEATTR\|LANGUAGE_KASHMIRI\|FILEATTR_HIDDEN\|DELETEFILE_UNPROTECT\|COUNTRY_CUBA\|HKEY_USERS\|ATTRKEYBOARD\|COUNTBOTH\|ROLLLEFT\|HSTRIPES\|CRUSHBOTTOM\|RECTBACKSOUTHWEST\|LANGUAGE_TSONGA\|RECTBACKSOUTH\|ERR_DIFFDEPTH\|RECTBACKSOUTHEAST\|RECTBACKEAST\|ERR_TRIALLIMIT\|ERR_FINDMOVE\|ERR_SCREEN\|ERR_FINDPLUGIN\|LANGUAGE_ITALIAN\|ERR_MULTIBGPIC\|ERR_BADLAYERTYPE\|JUSTIFIED\|ERR_ADDAPPWIN\|LANGUAGE_NAURU\|ERR_UNKNOWNFILTER\|RECTBACKNORTHEAST\|JOYDOWNLEFT\|RECTBACKNORTH\|WALLPAPERTOP\|ROLLTOP\|ERR_NOFALLTHROUGH\|BRUSH_VS_BOX\|USERDATA\|RANDOMPARAMETER\|IMAGETYPE_RASTER\|NATIVE\|DIAGONAL\|COUNTRY_SUDAN\|PUZZLE\|ERR_ENDIFWOIF\|ERR_MEM\|ERR_OPENSERIAL\|PUSHRIGHT\|NEXTFRAME\|DOSTYPE_FILE\|PUSHLEFT\|ERR_SORTFUNC\|ENCODING_ISO8859_1\|VOPENGATE\|ERR_XFIXES\|HCLOSEGATE\|ZOOMSOUTHWEST\|HOPENGATE\|VFLOWRIGHT\|ERR_BADBYTECODE\|VFLOWLEFT\|HFLOWBOTTOM\|HFLOWTOP\|ERR_DLOPEN\|ZOOMNORTHWEST\|ZOOMWEST\|ERR_NODOUBLEBUFFER\|ZOOMSOUTH\|ZOOMEAST\|ZOOMNORTHEAST\|COUNTRY_UK\|ZOOMCENTER\|ERR_FINDMEMBLK\|ERR_BGPICBUTTON\|VSTRETCHCENTER\|ERR_FREEABGPIC\|STRETCHTOP\|SCROLLNORTHEAST\|ATTRFUNCTION\|ERR_TABLEINDEX\|ERR_MULDISMOBILE\|COUNTRY_INDONESIA\|SCROLLSOUTHEAST\|NOCOLOR\|ERR_SELECTBGPIC2\|JOYUPLEFT\|MASKAND\|CLIPBOARD_SOUND\|SCROLLSOUTH\|SCROLLNORTH\|ERR_NOMENU\|ERR_NOANMLAYER\|SCROLLWEST\|ERR_CHANNELRANGE\|ERR_STRTABLEARG\|SCROLLRIGHT\|SCROLLLEFT\|RECTNORTHWEST\|ERR_BEGINREFRESH\|COUNTRY_SPAIN\|RECTSOUTHWEST\|COUNTRY_PHILIPPINES\|RECTSOUTHEAST\|ERR_LOADSOUND\|RECTEAST\|RECTNORTH\|LANGUAGE_ARABIC\|COUNTRY_JORDAN\|RECTCENTER\|ERR_TRANSBRUSH\|BLEND\|ERR_PLUGINVER\|RANDOMEFFECT\|FILLRULEWINDING\|ANMFMT_GIF\|VLINES\|ERR_LABINFOR\|DISPMODE_SYSTEMSCALE\|VLINES2\|ERR_NOARGBVISUAL\|COUNTRY_YEMEN\|HSTRIPES32\|ERR_SAVESAMPLE\|ERR_CHRCSTEMPTY\|LANGUAGE_CATALAN\|ERR_SEEK\|SANS\|LANGUAGE_JAVANESE\|ATTRLAYERID\|ERR_BRACECLOSE\|ERR_CONSOLEARG\|ATTRXPOS\|PLUGINCAPS_REQUESTERADAPTER\|REVEALRIGHT\|ERR_FINDFONT2\|REVEALLEFT\|LANGUAGE_DUTCH\|ERR_CHRCSTLEN\|HCLOSECURTAIN\|ERR_SELECTBGPIC\|ERR_MAGICKEY\|SELMODE_COMBO\|HOPENCURTAIN\|ERR_ZLIBSTREAM\|CARDBOTTOM\|VBLINDS16\|HBLINDS128\|HBLINDS64\|DURATION_SHORT\|COUNTRY_GREECE\|COUNTRY_MARSHALLISLANDS\|LANGUAGE_KAZAKH\|ERR_BADCONSTANT\|MODLCONTROL\|HBLINDS16\|COUNTRY_NAURU\|HBLINDS8\|SILVER\|DATA_7\|DAMPED\|ATTRORIENTATION\|COUNTRY_UNKNOWN\|COUNTRY_CZECHREPUBLIC\|LANGUAGE_INDONESIAN\|LANGUAGE_NAVAJO\|ERR_NOBLOCKBREAK\|ERR_8OR16BITONLY\|BOLD\|VSTRIPES8\|ERR_FUNCEXPECTED\|COUNTRY_AZERBAIJAN\|COUNTRY_KAZAKHSTAN\|ERR_FINDFONT\|QUARTERS\|WATER1\|HSTRIPES4\|COUNTRY_BRUNEI\|VOPENCURTAIN\|MONO8\|ERR_ICONENTRY\|PLUGINCAPS_VECTOR\|ATTRFIXED\|ALPHABETICAL\|VANILLACOPY\|MASKOR\|MASKXOR\|ERR_STAT\|SMPFMT_WAVE\|HSPLIT\|LANGUAGE_ABKHAZIAN\|COUNTRY_GABON\|ERR_ADDSYSEVENT\|ERR_INTEXPECTED\|COUNTRY_ECUADOR\|STEREO16\|ERR_UPDATEICON\|ERR_LABELDECLA\|MENUITEM_DISABLED\|ERR_FILEEXIST\|LANGUAGE_DIVEHI\|ATTRHOSTTASKBAR\|ERR_FINDOBJECTDATA\|ERR_BADENCODING\|ERR_GTK\|DENSITY_MEDIUM\|DENSITY_LOW\|VSPLIT\|ORIENTATION_LANDSCAPEREV\|TEAL\|ERR_COMMENTSTRUCT\|ORIENTATION_LANDSCAPE\|ERR_FT2\|ORIENTATION_PORTRAITREV\|DATELOCALNATIVE\|ERR_MAXLOCALS\|POLYGON\|BRUSHPART\|COUNTRY_CHINA\|ORIENTATION_NONE\|ERR_FIELDINIT\|CLIPREGION\|ERR_DELETEFILE\|LANGUAGE_SLOVENIAN\|SCALEMODE_LAYER\|MILLISECONDS\|COUNTRY_MALI\|SCALEMODE_AUTO\|LAYERBUTTON\|ERR_LOADICON\|COUNTRY_AUSTRIA\|ERR_NOFUNCTION\|COUNTRY_MALTA\|HLINES\|ERR_NUMSTRCMP\|ERR_SQBRACKETOPEN\|ERR_MODIFYABG\|LANGUAGE_GEORGIAN\|DISPMODE_ASK\|ERR_READRANGE\|ERR_UNTILWOREPEAT\|DISPMODE_WINDOWED\|FONTWEIGHT_REGULAR\|LANGUAGE_QUECHUA\|DISPSTATE_MINIMIZED\|DISPSTATE_CLOSED\|DISPSTATE_OPEN\|ERR_FREECURPOINTER\|DEINTERLACE_DOUBLE\|DEINTERLACE_DEFAULT\|ENCODING_AMIGA\|ENCODING_UTF8\|ENCODING_RAW\|FONTSLANT_OBLIQUE\|ERR_STRTOOSHORT\|ANMFMT_MJPEG\|ERR_CLIPWRITE\|FONTSLANT_ROMAN\|PERMREQ_READEXTERNAL\|TURNDOWNBOTTOM\|FONTWEIGHT_HEAVY\|ATTRPLAYING\|FONTWEIGHT_ULTRABOLD\|LANGUAGE_RUSSIAN\|FONTWEIGHT_BOLD\|FONTWEIGHT_DEMIBOLD\|REQICON_QUESTION\|COUNTRY_TANZANIA\|COUNTRY_SAINTBARTHELEMY\|DISPMODE_FULLSCREEN\|FONTWEIGHT_NORMAL\|ERR_GUIGFX\|ERR_LOADFRAME\|HIDELAYER\|COUNTRY_SAOTOMEANDPRINCIPE\|FONTWEIGHT_ULTRALIGHT\|ERR_GRABSCREEN\|SPIRAL\|FONTWEIGHT_THIN\|FONTENGINE_INBUILT\|COUNTRY_TIMOR\|ATTRDRIVER\|MONOSPACE\|ERR_SYNTAXERROR\|PRGTYPE_APPLET\|COUNTRY_URUGUAY\|PARITY_EVEN\|COUNTRY_ERITREA\|MODE_READ\|LANGUAGE_CENTRALKHMER\|ERR_SHORTIF\|BITMAP_DEFAULT\|ERR_ESCREPLACE\|ERR_FINDMUSIC\|ERR_MEMCODE\|ATTRMENU\|ERR_DISPMINIMIZED\|JOYNODIR\|ATTRMODE\|ERR_FINDDISPLAY\|ERR_BADWAVE\|LANGUAGE_PERSIAN\|SHDWSOUTHWEST\|ERR_ADDTASK\|ERR_NAMEUSED\|ERR_CLIPREAD\|LANGUAGE_TSWANA\|ATTRBORDERBOTTOM\|SPRITE\|ERR_DOUBLEMENU\|ERR_TOKENEXPECTED\|EDGE\|FILLTEXTURE\|IO_BUFFERED\|ERR_JAVAMETHOD\|GRAY\|NUMERICAL\|ERR_VFONTTYPE\|COUNTRY_LIECHTENSTEIN\|COUNTRY_GHANA\|ERR_LAYERSON\|LANGUAGE_BASQUE\|SERIAL\|ALL\|ERR_SELECTMASK\|COUNTRY_CYPRUS\|LANGUAGE_MAORI\|ERR_DBTRANSWIN\|ATTRID\|ERR_NUMBEREXPECTED\|ANTIALIAS\|SCROLLSOUTHWEST\|ERR_PLUGINSUPPORT\|ERR_WRONGID\|COUNTRY_SRILANKA\|ERR_SENDTIMEOUT\|ERR_EQUALEXPECTED\|ERR_SERIALIO\|COUNTRY_LESOTHO\|ERR_CREATEDOCKY\|ERR_INITSERIAL\|COUNTRY_SLOVENIA\|COUNTRY_AFGHANISTAN\|ERR_FUNCDECLA\|HW_REVISION\|ERR_MALFORMPAT2\|ERR_RENDERER\|COUNTRY_KUWAIT\|ERR_SURFACE\|ERR_FINDARRAY\|ERR_MULTIDISPLAYS\|ERR_TEXTSYNTAX\|ERR_ICONVECTOR\|ERR_BRACKETCLOSE\|SELMODE_NORMAL\|SCALEMODE_NONE\|LANGUAGE_KINYARWANDA\|ERR_CORETEXT\|COUNTRY_MONTENEGRO\|ERR_VIDEOINIT\|LANGUAGE_LUBAKATANGA\|ERR_TRIALINCLUDE\|ERR_READFILE\|ERR_TRIALSAVEVID\|ERR_ATSUI\|ERR_TRIALCOMPILE\|ERR_RADIOTOGGLEMENU\|LANGUAGE_MALAGASY\|COUNTRY_ALGERIA\|ERR_TABEXPECTED3\|LANGUAGE_TIBETAN\|ERR_ELSETWICE\|ERR_FINDSELECTOR\|ERR_FRAMEGRABBER\|ERR_COREFOUNDATION\|COUNTRY_HONDURAS\|ERR_FINDICON\|FILEATTR_READONLY\|ERR_INVALIDUTF8ARG\|ERR_DIFFENCODING\|COUNTRY_BARBADOS\|ERR_INVALIDUTF8\|ERR_INVREPLACE\|ERR_COMPLEXPATTERN\|ERR_AMIGAGUIDE\|LANGUAGE_AFRIKAANS\|ERR_LINKPLUGIN\|ERR_STACK\|MASKVANILLACOPY\|MODE_READWRITE\|ERR_FILESIZE\|ERR_MUSPLAYING\|ERR_VIDNOTPLAYING\|COUNTRY_DJIBOUTI\|ERR_ALLOCMASK\|ERR_ALLOCALPHA\|ERR_KEYFILE\|ERR_VISUALINFO\|ERR_FINDCLIENT\|ERR_SENDDATA\|LANGUAGE_NDONGA\|COUNTRY_DOMINICANREPUBLIC\|ERR_UNEXPECTEDSYM\|ERR_FULLSCREEN\|ERR_SCREENMODE\|ATTRBORDERLEFT\|COUNTRY_SWEDEN\|ERR_TFIMAGE\|ERR_LOCKBMAP\|ERR_FINDMONITOR\|COUNTRY_ROMANIA\|ATTRCURSORX\|ERR_NOCONTEXTMENU\|ERR_ACCELERATOR\|ERR_VECTORBRUSH\|FILEATTR_ARCHIVE\|ERR_ENDWITHWOWITH\|ERR_CONTEXTMENU\|SHDWNORTH\|SHDWNORTHWEST\|ERR_EMPTYMENUTREE\|ERR_FINDMENUITEM\|COUNTRY_RUSSIA\|ERR_DEFFONT\|ERR_CREATEMENU\|ANIM\|COUNTRY_ETHIOPIA\|ERR_MENUCOMPLEXITY\|MODLALT\|ERR_WRONGCMDRECVIDEO\|ERR_REGISTRYWRITE\|HIDEBRUSH\|ERR_SENDMESSAGE\|COUNTRY_LIBERIA\|ERR_FINDAPPLICATION\|ERR_NEEDAPPLICATION\|ERR_COORDSRANGE\|JOYRIGHT\|ERR_UNKNOWNATTR\|ERR_APPLICATION\|COUNTRY_FIJI\|ERR_SEEKFILE\|ERR_TABLEDECLA\|ERR_FINDDIR\|AMIGAICON_DRAWER\|COUNTRY_COMOROS\|ERR_MODIFYSPRITE\|STEREO8\|ERR_DDMOBILE\|ERR_HWBMCLOSEDISP\|ERR_HWDBFREEDISP\|BOTTOMOUT\|ERR_FINDBGPIC\|ERR_RETWOGOSUB\|ERR_BITMAP\|ERR_REQUIREPLUGIN\|ERR_DISPLAYADAPTERSUPPORT\|ERR_SOCKNAME\|RED\|ERR_SCRPIXFMT\|PI\|ERR_FINDSPRITE\|LANGUAGE_OJIBWA\|ERR_REQUIREFIELD\|COUNTRY_TAJIKISTAN\|ERR_WRITEONLY\|ERR_VIDLAYERFUNC\|ERR_VIDSTOPPED\|ERR_VIDEOLAYER\|ERR_CMDASVAR\|ERR_REGCLASS\|AMIGAICON_TOOL\|RECTWEST\|ERR_FINDACTIVITY\|ERR_JAVA\|ERR_UDEXPECTED\|LANGUAGE_CHICHEWA\|ERR_NOMIMEVIEWER\|ACTIVEWINDOW\|FILEATTR_SCRIPT\|ERR_GETSHORTCUT\|IMGFMT_PNG\|LAYER_VS_BOX\|LANGUAGE_MALTESE\|ATTRXSERVER\|ERR_CREATEICON\|LANGUAGE_DANISH\|ERR_SATFREEDISP\|ERR_PERCENTFORMATSTR\|COUNTRY_BELGIUM\|ERR_VIDPLAYING\|ERR_VIDPAUSED\|SECONDS\|ERR_SAVERALPHA\|ATTRMAXWIDTH\|ERR_HWBRUSHFUNC\|COUNTRY_ARGENTINA\|LANGUAGE_TIGRINYA\|SLOWSPEED\|LANGUAGE_NORWEGIAN\|ERR_HWBRUSH\|COUNTRY_BENIN\|DENSITY_HIGH\|ERR_PLUGINSYMBOL\|BARS\|ERR_UNKNOWNSMPOUT\|ERR_SAVEANIM\|ERR_FINDPOINTER\|ERR_UNKNOWNANMOUT\|LANGUAGE_FRENCH\|ERR_SAVEIMAGE\|ATTRSCALEMODE\|ERR_UNKNOWNIMGOUT\|CONICAL\|ERR_NOFMBHANDLER\|ERR_NOMUSICCB\|FILETYPE_ANIM\|LANGUAGE_SOMALI\|ATTRFONTSIZE\|COUNTRY_PARAGUAY\|COUNTRY_TURKMENISTAN\|ERR_SEEKFORMAT\|ERR_DBVIDEOLAYER\|LANGUAGE_IRISH\|COUNTRY_MAYOTTE\|ERR_BADCALLBACKRET\|YELLOW\|ERR_MODIFYPSMP\|DELETEFILE_STATUS\|ERR_DSOUNDNOTIPOS\|ERR_READONLY\|ERR_MOBILE\|ERR_MONITORFULLSCREEN\|ERR_WRONGDTYPE\|COUNTRY_CHAD\|LINEAR\|ONKEYDOWNALL\|ERR_INVNEXTKEY\|WHITE\|ATTRSIZE\|ATTRMAXHEIGHT\|ERR_FINDSERIAL\|LITTLEENDIAN\|ERR_NOCOLON\|ERR_LOADPLUGIN\|ERR_VIDEOTRANS\|COUNTRY_TUNISIA\|ERR_WRITE\|COUNTRY_PALAU\|ERR_SELECTBG\|ERR_VIDEOFRAME\|LANGUAGE_BURMESE\|SWISS\|COUNTRY_GREENLAND\|ERR_VIDATTACHED\|PLOT\|ERR_SOCKOPT\|ERR_QUICKTIME\|LANGUAGE_ARMENIAN\|REQICON_INFORMATION\|ERR_OLDAPPLET\|ERR_LOADVIDEO\|ERR_MOVEFILE\|ERR_ENDBLKWOBLK\|ERR_NOTENOUGHPIXELS\|ATTRSCALEHEIGHT\|LANGUAGE_SAMOAN\|VCLOSECURTAIN\|COUNTRY_IRELAND\|ERR_OPENAUDIO\|ERR_NOFILTERNAME\|ATTRMAXIMIZED\|ADF_FX\|COUNTRY_SAINTVINCENT\|RECEIVEDATA_PACKET\|COUNTRY_ARUBA\|ERR_UNSETENV\|ERR_ALSAPCM\|ERR_XCURSOR\|LANGUAGE_ALBANIAN\|HLINES2\|LANGUAGE_KURDISH\|ERR_CREATEGC\|ERR_TOOSMALL2\|COUNTRY_TUVALU\|BIGENDIAN\|LANGUAGE_GREENLANDIC\|ERR_UPLOADFORBIDDEN\|ERR_DINPUT\|TICKS\|ERR_NOCOMPRESS\|ERR_BADURL\|ERR_NOLOOPCONT\|ERR_HOSTNAME\|ERR_PEERNAME\|DOUBLE\|ERR_FINDSERVER\|ERR_OPENSOCKET\|ATTRHOSTSCALE\|ERR_XDISPLAY\|ERR_TFVBRUSH\|ERR_TOOMANYARGS\|DATELOCAL\|ERR_DEMO\|ERR_NOJOYATPORT\|COUNTRY_USA\|ERR_RENDERADLAYER\|ERR_OPENLIB\|COUNTRY_EGYPT\|DTR_ON\|FADE\|COUNTRY_MARTINIQUE\|HKEY_CLASSES_ROOT\|ERR_NOACCESS\|ERR_TFVBGPICBRUSH\|ERR_CLOSEFILE\|ERR_BGPICTYPE\|LANGUAGE_AFAR\|ERR_DEMO2\|VCLOSEGATE\|ERR_LINKFONT\|ERR_FTPAUTH\|ERR_WRONGSPRITESIZE\|ERR_SPRITELINK\|ERR_ADFFREEDISP\|ERR_MONITORDIR\|ERR_REGISTRYREAD\|ERR_REMADLAYER\|ERR_FINDINTERVAL\|ATTRSTATE\|ERR_FINDLAYER\|FONTSLANT_ITALIC\|ERR_SCALEBGPIC\|SHDWSOUTHEAST\|ERR_CLIPOPEN\|ERR_BRUSHTYPE\|ERR_CLIPFORMAT\|ERR_LOADPICTURE2\|ERR_OPENSOUND2\|ATTRZPOS\|ERR_OPENANIM2\|ERR_NEEDOS41\|LANGUAGE_JAPANESE\|ERR_TABEXPECTED\|ATTRTEXT\|ERR_FINDBRUSH\|COUNTRY_BRAZIL\|COUNTRY_SINGAPORE\|LANGUAGE_SANSKRIT\|ERR_ADDAPPICON\|LOWERCURVE\|ERR_FREEADISPLAY\|ERR_ARRAYDECLA\|ERR_SMODEALPHA\|ERR_FINDANIMSTREAM\|ATTRSCALEWIDTH\|ERR_MODIFYAANIM\|CLIPBOARD_UNKNOWN\|ERR_FONTPATH\|COUNTRY_BAHAMAS\|ERR_NEGCOORDS\|ERR_JOYSTICK\|ERR_CASECST\|LANGUAGE_TAGALOG\|LANGUAGE_KANURI\|COUNTRY_PITCAIRN\|NONE\|ERR_WRONGVSTRATEGY\|ERR_APPLET\|ERR_VIDEOSTRATEGY\|ERR_READTABLE\|COUNTRY_SWAZILAND\|BEEPWARNING\|BOUNCE\|LANGUAGE_SLOVAK\|LANGUAGE_SERBIAN\|ERR_FINDASYNCDRAW\|ERR_SPRITEONSCREEN2\|ERR_NOHWFUNC\|ERR_POINTERIMG\|ERR_MUSNOTPLYNG2\|ERR_NODISLAYERS\|ERR_NUMCONCAT\|COUNTRY_PUERTORICO\|ERR_DDAUTOSCALE\|ERR_DIRECTSHOW\|ATTRALPHAINTENSITY\|FILLNONE\|SHDWSOUTH\|ERR_ZLIBVERSION\|IMGFMT_BMP\|LANGUAGE_BENGALI\|COUNTRY_HAITI\|COUNTRY_GRENADA\|VBLINDS128\|ERR_TABCALLBACK\|FILETYPE_IMAGE\|BOOLEAN\|ERR_TEXTCONVERT\|ERR_MSGPORT\|ERR_LOADPICTURE\|VSTRIPES16\|ERR_SEMAPHORE\|ERR_MASKNALPHA\|ERR_TIMER\|PRINT\|ERR_HEXPOINT\|ERR_NODIRPATTERN\|ONBUTTONRIGHTCLICKALL\|ERR_NOTXTLAYER\|ERR_STRCALLBACK\|ERR_CONCAT\|ERR_COMPLEXWHILE\|REQ_NORMAL\|ERR_NOCHANNEL\|FONTWEIGHT_EXTRALIGHT\|COUNTRY_FRENCHPOLYNESIA\|FILEATTR_PURE\|ERR_SETFILEDATE\|HSTRIPES16\|COUNTRY_SEYCHELLES\|ERR_DEMO3\|COUNTRY_HONGKONG\|FASTMEMORY\|ERR_KEYNOTFOUND\|FONTWEIGHT_BOOK\|ERR_DATATYPESAVE2\|ERR_ZLIBDATA\|TEXTOUT\|ATTRCOUNT\|SHDWWEST\|ERR_RENAME\|ERR_CMPUNSUPPORTED\|COUNTRY_MAURITIUS\|ERR_DSOUNDPLAY\|ERR_UNIMPLCMD\|AMIGAICON_DISK\|ERR_NOREXX\|COUNTRY_LAOS\|LANGUAGE_ENGLISH\|ERR_ANTIALIAS\|ERR_MENUATTACHED\|COUNTRY_MAURITANIA\|LANGUAGE_TAMIL\|ERR_UNKTEXTFMT\|ERR_NOTADIR\|ERR_REQUIRETAGFMT\|COUNTRY_CROATIA\|ERR_CACHEERROR\|ERR_TASKSETUP\|LANGUAGE_YORUBA\|ERR_CSTDOUBLEDEF\|NATIVEENDIAN\|ATTRNUMFRAMES\|ATTRSTANDARD\|LANGUAGE_SICHUANYI\|LANGUAGE_WOLOF\|LANGUAGE_SHONA\|ONKEYDOWN\|VOID\|COUNTRY_NIUE\|ERR_UNKNOWNMUSFMT\|ATTRSPRITES\|ERR_MIXMUSMOD\|ERR_SEEKRANGE\|COUNTRY_NEWZEALAND\|LANGUAGE_PALI\|FILLGRADIENT\|ERR_NOKEYWORDS\|ERR_UNKNOWNTAG\|COUNTRY_MYANMAR\|STDPTR_BUSY\|RIGHTOUT\|COUNTRY_JERSEY\|MOVEFILE_UNPROTECT\|IPUNKNOWN\|ERR_FUNCREMOVED\|MENUITEM_SELECTED\|COUNTRY_NORFOLKISLAND\|ERR_OPENANIM\|CHIPMEMORY\|COUNTRY_MADAGASCAR\|ERR_NUMTABLEARG\|ATTRCLIPREGION\|LANGUAGE_SUNDANESE\|ERR_TOOMANYCAPTURES\|ERR_NOALPHA\|ERR_BADSIGNATURE\|ERR_BADUPVALUES\|FILEATTR_DELETE_USR\|COUNTRY_LATVIA\|REQ_SAVEMODE\|ERR_VMMISMATCH\|ERR_NUMEXPECTED\|ERR_UNEXPECTEDEOF\|ERR_UNKNOWNCOND\|ERR_STRINGEXPECTED\|DURATION_LONG\|LANGUAGE_GANDA\|PRGTYPE_PROGRAM\|COUNTRY_CENTRALAFRICANREPUBLIC\|CLIPBOARD_IMAGE\|ERR_LOCK\|ERR_INVINSERT\|ERR_LAYERSUPPORT\|LANGUAGE_ASSAMESE\|COUNTRY_ANTIGUAANDBARBUDA\|FLOAT\|COUNTRY_RWANDA\|FILEATTR_READ_GRP\|LANGUAGE_TELUGU\|COUNTRY_GUINEABISSAU\|JOYLEFT\|SHDWEAST\|BGPIC\|ERR_VARSYNTAX\|ATTRNUMSUBSONGS\|PLUGINCAPS_TIMERADAPTER\|ERR_UNMPARENTHESES\|ERR_ERRORCALLED\|ERR_PERCENTFORMAT\|COUNTRY_GERMANY\|LANGUAGE_BISLAMA\|UNDO\|ERR_FINDFILE\|LANGUAGE_URDU\|PLUGINCAPS_REQUIRE\|SINE\|ERR_FINDTEXTOBJECT\|LANGUAGE_AMHARIC\|REVEALTOP\|COUNTRY_SAINTLUCIA\|ERR_DIRLOCK\|MODE_WRITE\|LANGUAGE_TURKMEN\|ERR_VIDRECTRANS\|LINE\|COUNTRY_NAMIBIA\|FILETYPEFLAGS_SAVE\|LANGUAGE_SARDINIAN\|ERR_NOMASKBRUSH\|ERR_MUSNOTPAUSED\|IPV4\|ERR_UNKNUMFMT\|ERR_DOUBLEDECLA\|ERR_INVPATCAP\|LANGUAGE_HUNGARIAN\|COUNTRY_MONTSERRAT\|LANGUAGE_FAROESE\|LANGUAGE_DZONGKHA\|ERR_LOOPRANGE\|ATTRHASALPHA\|ERR_ENDSWCHWOSWCH\|POINTER\|COUNTRY_BOUVETISLAND\|BYTE\|FILE\|ATTRRAWYPOS\|FONTWEIGHT_ULTRABLACK\|ERR_EXETYPE\|ERR_UNBALANCEDPAT\|COUNTRY_NIGER\|EOF\|ERR_LABMAINBLK\|RIGHT\|LANGUAGE_KUANYAMA\|KEEPPOSITION\|ERR_BRUSHSIZE\|LANGUAGE_KIKUYU\|CLOSEWINDOW\|ERR_CREATEPORT\|ZOOMOUT\|ERR_MODIFYABR\|IMGFMT_TIFF\|ERR_MISSINGPARAMTR\|NORMAL\|STDPTR_CUSTOM\|ERR_MEMRANGE\|LEFTOUT\|LANGUAGE_CHECHEN\|COUNTRY_BERMUDA\|MOVEFILE_DELETE\|SPRITE_VS_BOX\|LANGUAGE_BASHKIR\|ERR_SPRITEONSCREEN\|ERR_SETADAPTER\|LANGUAGE_INUPIAQ\|ALPHANUMERICAL\|COUNTRY_MACEDONIA\|COUNTRY_KENYA\|COUNTRY_PAKISTAN\|BGPICPART\|IO_UNBUFFERED\|FILETYPEFLAGS_ALPHA\|COUNTRY_ZAMBIA\|ERR_STREXPECTED\|ATTRTITLE\|UPPERCURVE\|ERR_MEMCST\|ERR_SELECTBRUSH\|ERR_NOTRANSPARENCY\|COUNTRY_SWITZERLAND\|ERR_INTERNAL1\|LANGUAGE_SINHALA\|ERR_UNKNOWNSEC\|ATTRCANSEEK\|COUNTRY_ISRAEL\|COUNTRY_SANMARINO\|VECTORPATH\|ERR_PLUGINTYPE\|ERR_CONFIG2\|ERR_SWCHWOENDSWCH\|DOUBLEBUFFER\|ERR_TABLEORNIL\|DOSTYPE_DIRECTORY\|MAROON\|ATTRBORDERTOP\|SAMPLE\|ATTRBGPIC\|PLUGINCAPS_SAVESAMPLE\|ERR_SCREENSIZE\|AMIGAICON_PROJECT\|SNAPDISPLAY\|COUNTRY_GUINEA\|SHADOW\|ERR_MAXUPVALS\|ORIENTATION_PORTRAIT\|COUNTRY_CAMBODIA\|ERR_TABEXPECTED2\|ERR_NOCHAR\|ERR_DSOUNDNOTIFY\|ERR_UNFINISHEDCAPTURE\|ATTRBITRATE\|ERR_NOCOMMA\|ERR_IFWOENDIF\|STDPTR_SYSTEM\|LANGUAGE_IGBO\|HKEY_CURRENT_CONFIG\|LANGUAGE_INTERLINGUA\|AMIGAICON_SHOW\|IPV6\|ERR_CONFIG\|ERR_COMPLEXEXPR\|ERR_FINDSAMPLE\|MODLSHIFT\|ERR_ENDFUNCWOFUNC\|PLUGINCAPS_IMAGE\|UDPNONE\|LANGUAGE_OROMO\|ERR_NEEDCOMPOSITE\|ATTRBORDERLESS\|ERR_SETFILECOMMENT\|LANGUAGE_MARATHI\|ERR_LFSYNTAX\|COUNTRY_BULGARIA\|ERR_FINDTIMEOUT\|ERR_RECVUNKNOWN\|ERR_RENDER\|ERR_CREATEDIR\|WATER2\|SLIDETOP\|ERR_PALSCREEN\|CRUSHLEFT\|COUNTRY_UKRAINE\|RADIAL\|ERR_WRONGOP\|COUNTRY_CURACAO\|ERR_NOCONSTANTS\|COUNTRY_IRAN\|FONTWEIGHT_BLACK\|REVEALBOTTOM\|ERR_PLAYERCOMP\|COUNTRY_PANAMA\|COUNTRY_ARMENIA\|INSERTBRUSH\|LANGUAGE_KOMI\|DATEDAY\|TABLE\|ATTRHARDWARE\|ONBUTTONRIGHTCLICK\|AMIGAICON_HIDE\|ERR_OPENSOUND\|SIZEWINDOW\|ATTRHOSTSCALEX\|FONTENGINE_NATIVE\|COUNTRY_IRAQ\|COUNTRY_ISLEOFMAN\|NUMBER\|HOLLYWOOD\|COUNTRY_SERBIA\|AMIGAICON_SETTITLE\|ERR_NEXTWOFOR\|FUNCTION\|ERR_GETDISKOBJ\|MODRSHIFT\|ERR_WRITEFILE\|LANGUAGE_ARAGONESE\|FILEATTR_WRITE_GRP\|LANGUAGE_UNKNOWN\|ERR_KICKSTART\|ERR_KEYWORD\|PLUGINCAPS_SAVEIMAGE\|FREESPACE\|COUNTRY_BHUTAN\|ERR_AUDIOCONVERTER\|TIMEOUT\|PERMREQ_WRITEEXTERNAL\|ERR_FINDCST\|ATTRTYPE\|ATTRHOSTTITLEBARHEIGHT\|ERR_TEXTURE\|OLIVE\|ERR_SATELLITE\|USEDSPACE\|LANGUAGE_HAITIAN\|COUNTRY_SOUTHSUDAN\|ERR_LABINWHILE\|COUNTRY_BAHRAIN\|ERR_WHILEWOWEND\|LANGUAGE_CROATIAN\|LANGUAGE_TWI\|ERR_NOAPPLET\|COUNTRY_QATAR\|ONBUTTONCLICK\|PUSHTOP\|ERR_READ\|BOX\|ADF_MOVEOBJECT\|COUNTRY_COSTARICA\|COUNTRY_POLAND\|ERR_NONE\|INTERVAL\|SLIDEBOTTOM\|HBLINDS32\|LANGUAGE_CHUVASH\|VBLINDS32\|BEEPINFORMATION\|COUNTRY_NETHERLANDS\|BEEPERROR\|FILETYPEFLAGS_FPS\|ATTRADAPTER\|COUNTRY_TONGA\|LANGUAGE_HINDI\|ERR_UNKNOWNMIMETYPE\|ERR_ANIMFRAME\|ERR_NOSPRITES\|IMGFMT_NATIVE\|LAYER\|MUSIC\|COUNTRY_LITHUANIA\|PLUGINCAPS_SOUND\|ELLIPSE\|COUNTRY_VIETNAM\|LANGUAGE_NORWEGIANBOKMAL\|ERR_IMAGEERROR\|REQICON_NONE\|FONTWEIGHT_SEMIBOLD\|SNAPWINDOW\|ATTRLOADER\|ATTRCURFRAME\|LANGUAGE_PORTUGUESE\|NEXTFRAME2\|COUNTRY_SURINAME\|ATTRXDPI\|LANGUAGE_CHINESE\|DATEMONTH\|ATTRMARGINLEFT\|COUNTRY_SOMALIA\|ERR_CONITEMS\|LANGUAGE_FIJIAN\|COUNTRY_SIERRALEONE\|LANGUAGE_OCCITAN\|LANGUAGE_SOUTHERNSOTHO\|COUNTRY_DOMINICA\|LANGUAGE_HERERO\|LANGUAGE_SWAHILI\|COUNTRY_PAPUANEWGUINEA\|COUNTRY_COOKISLANDS\|ATTRFONTDESCENDER\|COUNTRY_HUNGARY\|ERR_MODIFYSPRITE2\|DEFAULTSPEED\|TRUETYPE_DEFAULT\|LANGUAGE_AYMARA\|COUNTRY_MONGOLIA\|ATTRCURSORY\|COUNTRY_MOLDOVA\|COUNTRY_MEXICO\|ERR_PUBSCREEN\|ERR_LAYERRANGE\|ATTRLAYERSON\|DOWNLOADFILE_STATUS\|NIL\|COUNTRY_MALAYSIA\|LONG\|COUNTRY_MACAO\|LANGUAGE_LATVIAN\|COUNTRY_LEBANON\|SERVER\|COUNTRY_SOUTHKOREA\|COUNTRY_KIRIBATI\|COUNTRY_ESTONIA\|COUNTRY_ANGUILLA\|COUNTRY_TAIWAN\|ERR_TAGEXPECTED\|ATTRHEIGHT\|ERR_TFVBRUSHBGPIC\|ATTRYDPI\|COUNTRY_EQUATORIALGUINEA\|DATETIME\|LANGUAGE_BAMBARA\|EVENTHANDLER\|ATTRPOINTER\|FILETYPEFLAGS_QUALITY\|ERR_FINDVIDEO\|TURNDOWNTOP\|COUNTRY_CHRISTMASISLAND\|COUNTRY_BURUNDI\|COUNTRY_FINLAND\|ERR_MISSINGBRACKET\|LANGUAGE_ORIYA\|LANGUAGE_MONGOLIAN\|COUNTRY_THAILAND\|HKEY_LOCAL_MACHINE\|ATTRTRANSPARENTCOLOR\|COUNTRY_AUSTRALIA\|LANGUAGE_UZBEK\|ERR_SMPRANGE\|ATTRHOSTHEIGHT\|LANGUAGE_ROMANIAN\|LANGUAGE_MACEDONIAN\|COUNTRY_ANGOLA\|SEEK_BEGINNING\|IMGFMT_ILBM\|COUNTRY_GUADELOUPE\|DATEUTC\|ERR_REXXERR\|ATTRWIDTH\|FILEATTR_EXECUTE_USR\|COUNTRY_SAINTHELENA\|ICON\|ERR_LABINFUNC\|ATTRPUBSCREEN\|COUNTRY_GUERNSEY\|ERR_FINDLAYERDATA\|GREEN\|ERR_MISSINGOPBRACK\|HW_AMIGA\|HW_MACOS\|HW_LINUX\|HW_WINDOWS\|HW_ANDROID\|HW_IOS\|HW_LITTLE_ENDIAN\|HW_64BIT\|HW_AMIGAOS4\|HW_MORPHOS\|HW_AROS\|HW_WARPOS\|HW_AMIGAOS3\)\>"
syn keyword hwFunction LowerStr UpperStr Val StrStr UnrightStr UnleftStr Chr MidStr RightStr LeftStr FindStr AddStr HexStr Asc StrLen ReplaceStr BinStr SplitStr PadNum StrToArray TrimStr ToString ToNumber UnmidStr CountStr InsertStr RepeatStr MD5Str CRC32Str FormatStr PatternFindStr PatternReplaceStr Eval PatternFindStrDirect PatternFindStrShort ArrayToStr Base64Str ToUserData ByteOffset CharOffset CharWidth ValidateStr ConvertStr ReverseStr ByteLen IsAlNum IsAlpha IsCntrl IsDigit IsGraph IsLower IsPrint IsPunct IsSpace IsUpper IsXDigit CompareStr ByteAsc ByteChr StartsWith EndsWith StripStr EmptyStr ByteVal ByteStrStr Abs Sin Cos Tan ASin ACos ATan ATan2 Ceil Floor Mod FrExp LdExp Sqrt Min Max Log Ld Ln Exp Deg Pow Rad Rnd RndF Add Sub Div Mul Round Int Frac Shr Shl Rt Wrap Limit BitSet BitTest BitClear BitXor BitComplement Sgn Sar Ror Rol Cast Hypot EndianSwap RndStrong Red Green Blue RGB ARGB MovePointer HidePointer SetPointer ShowPointer GetAttribute GetPen VWait SetFPSLimit GetFPSLimit IsPicture GetRealColor SaveSnapshot MixRGB CreateClipRegion SetClipRegion FreeClipRegion CreatePointer FreePointer AsyncDrawFrame CancelAsyncDraw FinishAsyncDraw DumpVideoTime GetRandomColor SetDrawTagsDefault BeginRefresh EndRefresh Intersection Box Plot Ellipse Line Circle Polygon SetFillStyle ReadPixel Cls Arc SetFormStyle SetLineWidth GetFillStyle GetFormStyle GetLineWidth MoveBrush MoveAnim MoveTextObject MoveLayer MoveSprite OpenFile Eof ReadChr ReadLine ReadString Seek WriteChr WriteLine WriteString Exists FileSize PathPart FilePart MakeDirectory GetVolumeInfo DeleteFile Execute Run ChangeDirectory GetVolumeName CloseFile ReadDirectory FullPath CopyFile Rename IsDirectory CRC32 WriteShort WriteInt WriteFloat ReadShort ReadInt ReadFloat FilePos MatchPattern FlushFile SetIOMode GetFileAttributes SetFileAttributes GetTempFileName FileLength CompressFile DecompressFile OpenDirectory CloseDirectory NextDirectoryEntry WriteFunction ReadFunction DefineVirtualFile ReadTable WriteTable GetCurrentDirectory ApplyPatch DefineVirtualFileFromString UndefineVirtualStringFile FileToString StringToFile GetEnv SetEnv UnsetEnv MD5 FileLines FileAttributes GetAsset ReadByte WriteByte ReadBytes WriteBytes DirectoryItems MoveFile UseCarriageReturn HaveVolume GetDirectoryEntry RewindDirectory CountDirectoryEntries MonitorDirectory WaitLeftMouse WaitRightMouse WaitKeyDown IsKeyDown WhileRightMouseDown WhileMouseDown WhileKeyDown IsLeftMouse IsRightMouse BreakWhileMouseOn SetEventTimeout GetEventCode LeftMouseQuit EscapeQuit CtrlCQuit EnableEvent DisableEvent RemoveButton RemoveKeyDown ModifyButton ModifyKeyDown WhileMouseOn CreateButton CreateKeyDown FreeEventCache ClearEvents CheckEvent WaitEvent MouseX MouseY MakeButton DeleteButton DisableButton EnableButton InstallEventHandler SetInterval SetTimeout ClearInterval ClearTimeout ChangeInterval DumpButtons WaitMidMouse IsMidMouse ResetKeyStates JoyDir JoyFire CountJoysticks BreakEventHandler CheckEvents CreatePort SendMessage ShowKeyboard HideKeyboard Wait OpenCatalog CloseCatalog GetCatalogString GetDate GetTime GetWeekday GetDateNum GetTimer PauseTimer ResumeTimer StartTimer StopTimer SystemRequest GetMemoryInfo End GetErrorName Sort DebugStr DebugVal DebugPrint ExitOnError GetLastError DebugOutput GetType IIf InsertItem RemoveItem ListItems StringRequest Unpack SetMetaTable GetMetaTable RawEqual RawGet RawSet GCInfo CollectGarbage Error WaitTimer FileRequest PathRequest IPairs Pairs NextItem GetVersion GetCommandLine GetProgramInfo ResetTimer GetConstant SetClipboard GetClipboard PeekClipboard ClearClipboard CompareDates OpenURL CopyTable FontRequest ListRequest ColorRequest GetSystemLanguage GetSystemCountry DebugPrompt GetFileArgument Assert ForEach ForEachI Concat GetObjectType GetObjectData SetObjectData ClearObjectData CopyObjectData HaveObjectData GetObjects RaiseOnError HaveObject GetPlugins IsNil HaveItem DisablePlugin EnablePlugin LoadPlugin HavePlugin GetSystemInfo LegacyControl DisableLineHook EnableLineHook IncreasePointer DecreasePointer GetApplicationInfo DebugPrintNR TableItems IsTableEmpty LoadPrefs SavePrefs DeletePrefs IsUnicode GetTimestamp GetCountryInfo GetLanguageInfo GetTimeZone TimestampToDate DateToTimestamp ParseDate MakeDate DateToUTC UTCToDate ValidateDate Pack ConsolePrint ConsolePrintNR ConsolePrompt Beep ShowNotification GetIconProperties SetIconProperties SetWBIcon OpenAmigaGuide CloseAmigaGuide ShowRinghioMessage GetApplicationList SendApplicationMessage ChangeApplicationIcon ReadRegistryKey WriteRegistryKey CreateShortcut SetTrayIcon GetShortcutPath ShowToast PerformSelector OpenResourceMonitor CloseResourceMonitor ImageRequest PermissionRequest Vibrate CallJavaMethod Undo EnableLayers DisableLayers SwapLayers InsertLayer ShowLayer HideLayer RemoveLayer SetLayerTransparency SetLayerLight SetLayerTint AddMove ClearMove DoMove FreeLayers NextFrame SetLayerName Collision DumpLayers ScaleLayer RotateLayer SetLayerStyle GetLayerStyle TransformLayer SetLayerAnchor LayerExists SetLayerZPos TranslateLayer SelectLayer CreateLayer ModifyLayerFrames GetLayerAtPos SetLayerShadow SetLayerFilter SetLayerBorder LayerToFront LayerToBack PlayLayer StopLayer PauseLayer ResumeLayer SeekLayer SetLayerVolume RemoveLayers SetFont SetFontColor TextHeight TextWidth ResetTabs AddTab Locate SetMargins SetFontStyle Print NPrint TextOut CreateTextObject DisplayTextObject FreeTextObject InKeyStr TextExtent ScaleTextObject CopyTextObject RotateTextObject OpenFont CloseFont UseFont GetAvailableFonts FreeGlyphCache SetDefaultEncoding AddFontPath GetKerningPair GetDefaultEncoding GetFontColor GetFontStyle PlayAnim FreeAnim ScaleAnim PlayAnimDisk LoadAnimFrame LoadAnim IsAnim CreateAnim CopyAnim GetAnimFrame DisplayAnimFrame ModifyAnimFrames SelectAnim SaveAnim BeginAnimStream WriteAnimFrame FinishAnimStream SetAnimFrameDelay ChangeDisplaySize SetTitle MoveDisplay HideDisplay ShowDisplay SetDisplayAttributes CreateDisplay FreeDisplay OpenDisplay CloseDisplay SelectDisplay ActivateDisplay ChangeDisplayMode GetDisplayModes GetMonitors CreateMenu FreeMenu SelectMenuItem DeselectMenuItem IsMenuItemSelected DisableMenuItem EnableMenuItem IsMenuItemDisabled GetPubScreens ShowScreen HideScreen SetScreenTitle GetFrontScreen SetSubtitle FreeSample LoadSample IsSound GetPatternPosition GetSongPosition PlaySubsong WaitPatternPosition WaitSongPosition WaitSampleEnd IsSamplePlaying SetVolume SetPitch SetPanning StopSample PlaySample SetMasterVolume IsSample CreateSample OpenMusic CloseMusic PlayMusic StopMusic PauseMusic ResumeMusic SeekMusic SetMusicVolume IsMusic IsMusicPlaying PlayModule StopModule PauseModule ResumeModule LoadModule FreeModule IsModule SaveSample GetSampleData CreateMusic FillMusicBuffer MixSample CopySample InsertSample FlushMusicBuffer IsChannelPlaying HaveFreeChannel StopChannel GetChannels SetChannelVolume OpenAudio CloseAudio ForceSound CreateBrush DisplayBrush DisplayBrushPart ScaleBrush FreeBrush TintBrush ReplaceColors InvertBrush FlipBrush MixBrush BrushToGray RotateBrush GetBrushLink SelectBrush CopyBrush SetBrushTransparency LoadBrush SelectMask SetMaskMode SaveBrush SelectAlphaChannel SetAlphaIntensity DeleteAlphaChannel CropBrush InvertMask InvertAlphaChannel FloodFill DeleteMask BeginDoubleBuffer EndDoubleBuffer Flip ConvertToBrush GrabDesktop TransformBrush TrimBrush RasterizeBrush BlurBrush EmbossBrush EdgeBrush SharpenBrush SolarizeBrush GammaBrush ContrastBrush ModulateBrush SepiaToneBrush CharcoalBrush SwirlBrush PixelateBrush BrushToMonochrome ChangeBrushTransparency CreateShadowBrush CreateBorderBrush WaterRippleBrush OilPaintBrush BrushToRGBArray RGBArrayToBrush PerspectiveDistortBrush ArcDistortBrush PolarDistortBrush BarrelDistortBrush CreateGradientBrush CreateTexturedBrush ReadBrushPixel WriteBrushPixel QuantizeBrush ReduceAlphaChannel IsBrushEmpty DisplayBGPic DisplayBGPicPart ScaleBGPic CreateGradientBGPic CreateRainbowBGPic CreateTexturedBGPic BrushToBGPic BGPicToBrush CreateBGPic FreeBGPic LoadBGPic SelectBGPic EndSelect CopyBGPic DisplayBrushFX DisplayTextObjectFX DisplayTransitionFX DisplayBGPicPartFX UndoFX ShowLayerFX HideLayerFX RemoveLayerFX GetRandomFX ClearScreen CreateSprite DisplaySprite RemoveSprite FreeSprite LoadSprite ScaleSprite CopySprite FlipSprite RemoveSprites SetSpriteZPos AllocMem FreeMem Poke Peek FillMem CopyMem ReadMem WriteMem DumpMem MemToTable TableToMem GetMemPointer GetMemString AllocMemFromPointer AllocMemFromVirtualFile MoveTo LineTo CurveTo RelMoveTo RelLineTo RelCurveTo DrawPath StartPath StartSubPath ClosePath AddArcToPath AddCircleToPath AddEllipseToPath AddBoxToPath SetLineJoin SetLineCap SetDash SetFillRule FreePath ClearPath IsPathEmpty GetCurrentPoint GetPathExtents CopyPath AppendPath AddTextToPath TranslatePath NormalizePath ForcePathUse SetVectorEngine PathItems PathToBrush GetFillRule GetLineJoin GetLineCap GetDash SetMiterLimit GetMiterLimit CreateIcon FreeIcon LoadIcon SaveIcon AddIconImage RemoveIconImage SetStandardIconImage OpenSerialPort CloseSerialPort ReadSerialData WriteSerialData FlushSerialPort SetBaudRate SetStopBits SetDataBits SetParity SetFlowControl SetDTR SetRTS GetBaudRate GetStopBits GetDataBits GetParity GetFlowControl GetDTR GetRTS PollSerialQueue ClearSerialQueue OpenConnection CloseConnection CreateServer CloseServer SendData ReceiveData GetConnectionIP GetConnectionPort GetHostName ToIP ToHostName DownloadFile UploadFile SetNetworkTimeout GetLocalIP GetLocalPort CreateUDPObject CloseUDPObject SendUDPData ReceiveUDPData IsOnline GetMACAddress GetConnectionProtocol GetLocalProtocol SetNetworkProtocol ResolveHostName OpenVideo CloseVideo PlayVideo StopVideo PauseVideo ResumeVideo SeekVideo IsVideo SetVideoSize SetVideoPosition SetVideoVolume GetVideoFrame IsVideoPlaying ForceVideoMode ForceVideoDriver DumpVideo DisplayVideoFrame SendRexxCommand RunRexxScript CreateRexxPort
syn match hwUserConstant "#\<\u\+\>"
syn match hwUserFunction "\<p_\w\{-1,}\>("me=e-1
syn keyword hwTodo      contained TODO FIXME XXX
syn match  hwComment    ";.*$" contains=hwTodo,@Spell
syn region hwComment    matchgroup=hwComment start="/\*" end="\*/"  contains=hwTodo,@Spell
syn match  hwSpecial contained #\\[\\abfnrtvz'"]\|\\x[[:xdigit:]]\{2}\|\\[[:digit:]]\{,3}#
syn region hwString  start=+'+hs=s+1 end=+'+he=e-1 skip=+\\\\\|\\'+ contains=hwSpecial,@Spell
syn region hwString  start=+"+hs=s+1 end=+"+he=e-1 skip=+\\\\\|\\"+ contains=hwSpecial,@Spell
syn match hwNumber "\<\d\+\>"
syn match hwNumber  "\<\d\+\.\d*\%([eE][-+]\=\d\+\)\=\>"
syn match hwNumber  "\.\d\+\%([eE][-+]\=\d\+\)\=\>"
syn match hwNumber  "\<\d\+[eE][-+]\=\d\+\>"
syn match hwNumber "\<0[xX]\x\+\>"
syn match hwNumber "\<0[xX][[:xdigit:].]\+\%([pP][-+]\=\d\+\)\=\>"
hi def link hwPreProcessor	PreProc
hi def link hwStatement		Statement
hi def link hwFallThrough	Statement
hi def link hwRepeat		Repeat
hi def link hwFor		Repeat
hi def link hwString		PmenuSel
hi def link hwNumber		Number
hi def link hwOperator		Operator
hi def link hwStep		Operator
hi def link hwIn		Operator
hi def link hwUserConstant	Constant
hi def link hwConstant		Constant
hi def link hwLineStatement	Conditional
hi def link hwCond		Conditional
hi def link hwElseIf		Conditional
hi def link hwFunction		Function
hi def link hwUserFunction	Function
hi def link hwComment		MoreMsg
hi def link hwTodo		Todo
hi def link hwTable		Structure
hi def link hwError		Error
hi def link hwParenError	Error
hi def link hwBraceError	Error
hi def link hwSpecial		SpecialChar
hi def link hwLabel		Label
let b:current_syntax = "hollywood"
let &cpo = s:cpo_save
unlet s:cpo_save
