let b:completingLangExtension = 0
let b:completingOptionsGHC    = 0
let b:completingModule        = 0
function! haskellcomplete#Complete(findstart, base)
if a:findstart
let l:line = getline('.')
let l:start = col('.') - 1
if l:line =~ '^\s*{-#\s*LANGUAGE.*'
while l:start >= 0 && l:line[l:start - 1] !~ '[, ]'
let l:start -= 1
endwhile
let b:completingLangExtension = 1
return l:start
elseif l:line =~ '^\s*{-#\s*OPTIONS_GHC.*'
while l:start >= 0 && l:line[l:start - 1] !~ '[, ]'
let l:start -= 1
endwhile
let b:completingOptionsGHC = 1
return l:start
elseif l:line =~ '^\s*import\s*.*'
while l:start >= 0 && l:line[l:start - 1] !~ ' '
let l:start -= 1
endwhile
let b:completingModule = 1
return l:start
endif
return start
endif
if b:completingLangExtension
if a:base ==? ""
return s:langExtensions
else
let l:matches = []
for extension in s:langExtensions
if extension =~? '^' . a:base
call add(l:matches, extension)
endif
endfor
let b:completingLangExtension = 0
return l:matches
endif
elseif b:completingOptionsGHC
if a:base ==? ""
return s:optionsGHC
else
let l:matches = []
for flag in s:optionsGHC
if flag =~? '^' . a:base
call add(l:matches, flag)
endif
endfor
let b:completingOptionsGHC = 0
return l:matches
endif
elseif b:completingModule
if a:base ==? ""
return s:commonModules
else
let l:matches = []
for module in s:commonModules
if module =~? '^' . a:base
call add(l:matches, module)
endif
endfor
let b:completingModule = 0
return l:matches
endif
endif
return -1
endfunction
let s:langExtensions =
\ [ "OverlappingInstances"
\ , "UndecidableInstances"
\ , "IncoherentInstances"
\ , "DoRec"
\ , "RecursiveDo"
\ , "ParallelListComp"
\ , "MultiParamTypeClasses"
\ , "MonomorphismRestriction"
\ , "FunctionalDependencies"
\ , "Rank2Types"
\ , "RankNTypes"
\ , "PolymorphicComponents"
\ , "ExistentialQuantification"
\ , "ScopedTypeVariables"
\ , "PatternSignatures"
\ , "ImplicitParams"
\ , "FlexibleContexts"
\ , "FlexibleInstances"
\ , "EmptyDataDecls"
\ , "CPP"
\ , "KindSignatures"
\ , "BangPatterns"
\ , "TypeSynonymInstances"
\ , "TemplateHaskell"
\ , "ForeignFunctionInterface"
\ , "Arrows"
\ , "Generics"
\ , "ImplicitPrelude"
\ , "NamedFieldPuns"
\ , "PatternGuards"
\ , "GeneralizedNewtypeDeriving"
\ , "ExtensibleRecords"
\ , "RestrictedTypeSynonyms"
\ , "HereDocuments"
\ , "MagicHash"
\ , "TypeFamilies"
\ , "StandaloneDeriving"
\ , "UnicodeSyntax"
\ , "UnliftedFFITypes"
\ , "InterruptibleFFI"
\ , "CApiFFI"
\ , "LiberalTypeSynonyms"
\ , "TypeOperators"
\ , "RecordWildCards"
\ , "RecordPuns"
\ , "DisambiguateRecordFields"
\ , "TraditionalRecordSyntax"
\ , "OverloadedStrings"
\ , "GADTs"
\ , "GADTSyntax"
\ , "MonoPatBinds"
\ , "RelaxedPolyRec"
\ , "ExtendedDefaultRules"
\ , "UnboxedTuples"
\ , "DeriveDataTypeable"
\ , "DeriveGeneric"
\ , "DefaultSignatures"
\ , "InstanceSigs"
\ , "ConstrainedClassMethods"
\ , "PackageImports"
\ , "ImpredicativeTypes"
\ , "NewQualifiedOperators"
\ , "PostfixOperators"
\ , "QuasiQuotes"
\ , "TransformListComp"
\ , "MonadComprehensions"
\ , "ViewPatterns"
\ , "XmlSyntax"
\ , "RegularPatterns"
\ , "TupleSections"
\ , "GHCForeignImportPrim"
\ , "NPlusKPatterns"
\ , "DoAndIfThenElse"
\ , "MultiWayIf"
\ , "LambdaCase"
\ , "RebindableSyntax"
\ , "ExplicitForAll"
\ , "DatatypeContexts"
\ , "MonoLocalBinds"
\ , "DeriveFunctor"
\ , "DeriveTraversable"
\ , "DeriveFoldable"
\ , "NondecreasingIndentation"
\ , "SafeImports"
\ , "Safe"
\ , "Trustworthy"
\ , "Unsafe"
\ , "ConstraintKinds"
\ , "PolyKinds"
\ , "DataKinds"
\ , "ParallelArrays"
\ , "RoleAnnotations"
\ , "OverloadedLists"
\ , "EmptyCase"
\ , "AutoDeriveTypeable"
\ , "NegativeLiterals"
\ , "BinaryLiterals"
\ , "NumDecimals"
\ , "NullaryTypeClasses"
\ , "ExplicitNamespaces"
\ , "AllowAmbiguousTypes"
\ , "JavaScriptFFI"
\ , "PatternSynonyms"
\ , "PartialTypeSignatures"
\ , "NamedWildCards"
\ , "DeriveAnyClass"
\ , "DeriveLift"
\ , "StaticPointers"
\ , "StrictData"
\ , "Strict"
\ , "ApplicativeDo"
\ , "DuplicateRecordFields"
\ , "TypeApplications"
\ , "TypeInType"
\ , "UndecidableSuperClasses"
\ , "MonadFailDesugaring"
\ , "TemplateHaskellQuotes"
\ , "OverloadedLabels"
\ , "TypeFamilyDependencies"
\ , "DerivingStrategies"
\ , "UnboxedSums"
\ , "HexFloatLiterals"
\ ]
let s:optionsGHC =
\ [ "-n"
\ , "-v"
\ , "-vn"
\ , "-c"
\ , "-hcsuf"
\ , "-hidir"
\ , "-hisuf"
\ , "-o"
\ , "-odir"
\ , "-ohi"
\ , "-osuf"
\ , "-stubdir"
\ , "-outputdir"
\ , "-keep-hc-file"
\ , "-keep-llvm-file"
\ , "-keep-s-file"
\ , "-keep-raw-s-file"
\ , "-keep-tmp-files"
\ , "-tmpdir"
\ , "-ddump-hi"
\ , "-ddump-hi-diffs"
\ , "-ddump-minimal-imports"
\ , "-fforce-recomp"
\ , "-fno-force-recomp"
\ , "-fbreak-on-exception"
\ , "-fno-break-on-exception"
\ , "-fbreak-on-error"
\ , "-fno-break-on-error"
\ , "-fprint-evld-with-show"
\ , "-fno-print-evld-with-show"
\ , "-fprint-bind-result"
\ , "-fno-print-bind-result"
\ , "-fno-print-bind-contents"
\ , "-fno-implicit-import-qualified"
\ , "-package-name"
\ , "-no-auto-link-packages"
\ , "-fglasgow-exts"
\ , "-fno-glasgow-exts"
\ , "-XOverlappingInstances"
\ , "-XNoOverlappingInstances"
\ , "-XIncoherentInstances"
\ , "-XNoIncoherentInstances"
\ , "-XUndecidableInstances"
\ , "-XNoUndecidableInstances"
\ , "-fcontext-stack=Nn"
\ , "-XArrows"
\ , "-XNoArrows"
\ , "-XDisambiguateRecordFields"
\ , "-XNoDisambiguateRecordFields"
\ , "-XForeignFunctionInterface"
\ , "-XNoForeignFunctionInterface"
\ , "-XGenerics"
\ , "-XNoGenerics"
\ , "-XImplicitParams"
\ , "-XNoImplicitParams"
\ , "-firrefutable-tuples"
\ , "-fno-irrefutable-tuples"
\ , "-XNoImplicitPrelude"
\ , "-XImplicitPrelude"
\ , "-XRebindableSyntax"
\ , "-XNoRebindableSyntax"
\ , "-XNoMonomorphismRestriction"
\ , "-XMonomorphismRrestriction"
\ , "-XNoNPlusKPatterns"
\ , "-XNPlusKPatterns"
\ , "-XNoMonoPatBinds"
\ , "-XMonoPatBinds"
\ , "-XRelaxedPolyRec"
\ , "-XNoRelaxedPolyRec"
\ , "-XExtendedDefaultRules"
\ , "-XNoExtendedDefaultRules"
\ , "-XOverloadedStrings"
\ , "-XNoOverloadedStrings"
\ , "-XGADTs"
\ , "-XNoGADTs"
\ , "-XTypeFamilies"
\ , "-XNoTypeFamilies"
\ , "-XScopedTypeVariables"
\ , "-XNoScopedTypeVariables"
\ , "-XMonoLocalBinds"
\ , "-XNoMonoLocalBinds"
\ , "-XTemplateHaskell"
\ , "-XNoTemplateHaskell"
\ , "-XQuasiQuotes"
\ , "-XNoQuasiQuotes"
\ , "-XBangPatterns"
\ , "-XNoBangPatterns"
\ , "-XCPP"
\ , "-XNoCPP"
\ , "-XPatternGuards"
\ , "-XNoPatternGuards"
\ , "-XViewPatterns"
\ , "-XNoViewPatterns"
\ , "-XUnicodeSyntax"
\ , "-XNoUnicodeSyntax"
\ , "-XMagicHash"
\ , "-XNoMagicHash"
\ , "-XNewQualifiedOperators"
\ , "-XNoNewQualifiedOperators"
\ , "-XExplicitForALl"
\ , "-XNoExplicitForAll"
\ , "-XPolymorphicComponents"
\ , "-XNoPolymorphicComponents"
\ , "-XRank2Types"
\ , "-XNoRank2Types"
\ , "-XRankNTypes"
\ , "-XNoRankNTypes"
\ , "-XImpredicativeTypes"
\ , "-XNoImpredicativeTypes"
\ , "-XExistentialQuantification"
\ , "-XNoExistentialQuantification"
\ , "-XKindSignatures"
\ , "-XNoKindSignatures"
\ , "-XEmptyDataDecls"
\ , "-XNoEmptyDataDecls"
\ , "-XParallelListComp"
\ , "-XNoParallelListComp"
\ , "-XTransformListComp"
\ , "-XNoTransformListComp"
\ , "-XUnliftedFFITypes"
\ , "-XNoUnliftedFFITypes"
\ , "-XLiberalTypeSynonyms"
\ , "-XNoLiberalTypeSynonyms"
\ , "-XTypeOperators"
\ , "-XNoTypeOperators"
\ , "-XDoRec"
\ , "-XNoDoRec"
\ , "-XRecursiveDo"
\ , "-XNoRecursiveDo"
\ , "-XPArr"
\ , "-XNoPArr"
\ , "-XRecordWildCards"
\ , "-XNoRecordWildCards"
\ , "-XNamedFieldPuns"
\ , "-XNoNamedFieldPuns"
\ , "-XDisambiguateRecordFields"
\ , "-XNoDisambiguateRecordFields"
\ , "-XUnboxedTuples"
\ , "-XNoUnboxedTuples"
\ , "-XStandaloneDeriving"
\ , "-XNoStandaloneDeriving"
\ , "-XDeriveDataTypeable"
\ , "-XNoDeriveDataTypeable"
\ , "-XGeneralizedNewtypeDeriving"
\ , "-XNoGeneralizedNewtypeDeriving"
\ , "-XTypeSynonymInstances"
\ , "-XNoTypeSynonymInstances"
\ , "-XFlexibleContexts"
\ , "-XNoFlexibleContexts"
\ , "-XFlexibleInstances"
\ , "-XNoFlexibleInstances"
\ , "-XConstrainedClassMethods"
\ , "-XNoConstrainedClassMethods"
\ , "-XMultiParamTypeClasses"
\ , "-XNoMultiParamTypeClasses"
\ , "-XFunctionalDependencies"
\ , "-XNoFunctionalDependencies"
\ , "-XPackageImports"
\ , "-XNoPackageImports"
\ , "-W"
\ , "-w"
\ , "-w"
\ , "-Wall"
\ , "-w"
\ , "-Werror"
\ , "-Wwarn"
\ , "-Wwarn"
\ , "-Werror"
\ , "-fwarn-unrecognised-pragmas"
\ , "-fno-warn-unrecognised-pragmas"
\ , "-fwarn-warnings-deprecations"
\ , "-fno-warn-warnings-deprecations"
\ , "-fwarn-deprecated-flags"
\ , "-fno-warn-deprecated-flags"
\ , "-fwarn-duplicate-exports"
\ , "-fno-warn-duplicate-exports"
\ , "-fwarn-hi-shadowing"
\ , "-fno-warn-hi-shadowing"
\ , "-fwarn-implicit-prelude"
\ , "-fno-warn-implicit-prelude"
\ , "-fwarn-incomplete-patterns"
\ , "-fno-warn-incomplete-patterns"
\ , "-fwarn-incomplete-record-updates"
\ , "-fno-warn-incomplete-record-updates"
\ , "-fwarn-lazy-unlifted-bindings"
\ , "-fno-warn-lazy-unlifted-bindings"
\ , "-fwarn-missing-fields"
\ , "-fno-warn-missing-fields"
\ , "-fwarn-missing-import-lists"
\ , "-fnowarn-missing-import-lists"
\ , "-fwarn-missing-methods"
\ , "-fno-warn-missing-methods"
\ , "-fwarn-missing-signatures"
\ , "-fno-warn-missing-signatures"
\ , "-fwarn-name-shadowing"
\ , "-fno-warn-name-shadowing"
\ , "-fwarn-orphans"
\ , "-fno-warn-orphans"
\ , "-fwarn-overlapping-patterns"
\ , "-fno-warn-overlapping-patterns"
\ , "-fwarn-tabs"
\ , "-fno-warn-tabs"
\ , "-fwarn-type-defaults"
\ , "-fno-warn-type-defaults"
\ , "-fwarn-monomorphism-restriction"
\ , "-fno-warn-monomorphism-restriction"
\ , "-fwarn-unused-binds"
\ , "-fno-warn-unused-binds"
\ , "-fwarn-unused-imports"
\ , "-fno-warn-unused-imports"
\ , "-fwarn-unused-matches"
\ , "-fno-warn-unused-matches"
\ , "-fwarn-unused-do-bind"
\ , "-fno-warn-unused-do-bind"
\ , "-fwarn-wrong-do-bind"
\ , "-fno-warn-wrong-do-bind"
\ , "-O"
\ , "-O0"
\ , "-On"
\ , "-O0"
\ , "-fcase-merge"
\ , "-fno-case-merge"
\ , "-fmethod-sharing"
\ , "-fno-method-sharing"
\ , "-fdo-eta-reduction"
\ , "-fno-do-eta-reduction"
\ , "-fdo-lambda-eta-expansion"
\ , "-fno-do-lambda-eta-expansion"
\ , "-fexcess-precision"
\ , "-fno-excess-precision"
\ , "-fignore-asserts"
\ , "-fno-ignore-asserts"
\ , "-fignore-interface-pragmas"
\ , "-fno-ignore-interface-pragmas"
\ , "-fomit-interface-pragmas"
\ , "-fno-omit-interface-pragmas"
\ , "-fsimplifier-phases"
\ , "-fmax-simplifier-iterations"
\ , "-fcse"
\ , "-fno-cse"
\ , "-fspecialise"
\ , "-fno-specialise"
\ , "-ffull-laziness"
\ , "-fno-full-laziness"
\ , "-ffloat-in"
\ , "-fno-float-in"
\ , "-fenable-rewrite-rules"
\ , "-fno-enable-rewrite-rules"
\ , "-fstrictness"
\ , "-fno-strictness"
\ , "-fstrictness=before=n"
\ , "-fspec-constr"
\ , "-fno-spec-constr"
\ , "-fliberate-case"
\ , "-fno-liberate-case"
\ , "-fstatic-argument-transformation"
\ , "-fno-static-argument-transformation"
\ , "-funbox-strict-fields"
\ , "-fno-unbox-strict-fields"
\ , "-feager-blackholing"
\ , "-auto"
\ , "-no-auto"
\ , "-auto-all"
\ , "-no-auto-all"
\ , "-caf-all"
\ , "-no-caf-all"
\ , "-hpcdir"
\ , "-F"
\ , "-cpp"
\ , "-Dsymbol[=value]"
\ , "-Usymbol"
\ , "-Usymbol"
\ , "-Idir"
\ , "-fasm"
\ , "-fvia-C"
\ , "-fvia-C"
\ , "-fasm"
\ , "-fllvm"
\ , "-fasm"
\ , "-fno-code"
\ , "-fbyte-code"
\ , "-fobject-code"
\ , "-shared"
\ , "-dynamic"
\ , "-framework"
\ , "-framework-path"
\ , "-llib"
\ , "-Ldir"
\ , "-main-is"
\ , "--mk-dll"
\ , "-no-hs-main"
\ , "-rtsopts,"
\ , "-with-rtsopts=opts"
\ , "-no-link"
\ , "-split-objs"
\ , "-fno-gen-manifest"
\ , "-fno-embed-manifest"
\ , "-fno-shared-implib"
\ , "-dylib-install-name"
\ , "-pgmL"
\ , "-pgmP"
\ , "-pgmc"
\ , "-pgmm"
\ , "-pgms"
\ , "-pgma"
\ , "-pgml"
\ , "-pgmdll"
\ , "-pgmF"
\ , "-pgmwindres"
\ , "-optL"
\ , "-optP"
\ , "-optF"
\ , "-optc"
\ , "-optlo"
\ , "-optlc"
\ , "-optm"
\ , "-opta"
\ , "-optl"
\ , "-optdll"
\ , "-optwindres"
\ , "-msse2"
\ , "-monly-[432]-regs"
\ , "-fext-core"
\ , "-dcore-lint"
\ , "-ddump-asm"
\ , "-ddump-bcos"
\ , "-ddump-cmm"
\ , "-ddump-cpranal"
\ , "-ddump-cse"
\ , "-ddump-deriv"
\ , "-ddump-ds"
\ , "-ddump-flatC"
\ , "-ddump-foreign"
\ , "-ddump-hpc"
\ , "-ddump-inlinings"
\ , "-ddump-llvm"
\ , "-ddump-occur-anal"
\ , "-ddump-opt-cmm"
\ , "-ddump-parsed"
\ , "-ddump-prep"
\ , "-ddump-rn"
\ , "-ddump-rules"
\ , "-ddump-simpl"
\ , "-ddump-simpl-phases"
\ , "-ddump-simpl-iterations"
\ , "-ddump-spec"
\ , "-ddump-splices"
\ , "-ddump-stg"
\ , "-ddump-stranal"
\ , "-ddump-tc"
\ , "-ddump-types"
\ , "-ddump-worker-wrapper"
\ , "-ddump-if-trace"
\ , "-ddump-tc-trace"
\ , "-ddump-rn-trace"
\ , "-ddump-rn-stats"
\ , "-ddump-simpl-stats"
\ , "-dsource-stats"
\ , "-dcmm-lint"
\ , "-dstg-lint"
\ , "-dstg-stats"
\ , "-dverbose-core2core"
\ , "-dverbose-stg2stg"
\ , "-dshow-passes"
\ , "-dfaststring-stats"
\ , "-fno-asm-mangling"
\ , "-fno-ghci-sandbox"
\ , "-fdiagnostics-color="
\ , "-fdiagnostics-show-caret"
\ , "-fno-diagnostics-show-caret"
\ , "-ferror-spans"
\ , "-fhide-source-paths"
\ , "-fprint-equality-relations"
\ , "-fno-print-equality-relations"
\ , "-fprint-expanded-synonyms"
\ , "-fno-print-expanded-synonyms"
\ , "-fprint-explicit-coercions"
\ , "-fno-print-explicit-coercions"
\ , "-fprint-explicit-foralls"
\ , "-fno-print-explicit-foralls"
\ , "-fprint-explicit-kinds"
\ , "-fno-print-explicit-kinds"
\ , "-fprint-explicit-runtime-rep"
\ , "-fno-print-explicit-runtime-reps"
\ , "-fprint-explicit-runtime-reps"
\ , "-fno-print-explicit-runtime-reps"
\ , "-fprint-potential-instances"
\ , "-fno-print-potential-instances"
\ , "-fprint-typechecker-elaboration"
\ , "-fno-print-typechecker-elaboration"
\ , "-fprint-unicode-syntax"
\ , "-fno-print-unicode-syntax"
\ , "-fshow-hole-constraints"
\ , "-Rghc-timing"
\ , "-v"
\ , "-v"
\ , "-F"
\ , "-x"
\ , "--exclude-module="
\ , "-ddump-mod-cycles"
\ , "-dep-makefile"
\ , "-dep-suffix"
\ , "-dumpdir"
\ , "-hcsuf"
\ , "-hidir"
\ , "-hisuf"
\ , "-include-pkg-deps"
\ , "-o"
\ , "-odir"
\ , "-ohi"
\ , "-osuf"
\ , "-outputdir"
\ , "-stubdir"
\ , "-keep-hc-file,"
\ , "-keep-hi-files"
\ , "-no-keep-hi-files"
\ , "-keep-llvm-file,"
\ , "-keep-o-files"
\ , "-no-keep-o-files"
\ , "-keep-s-file,"
\ , "-keep-tmp-files"
\ , "-tmpdir"
\ , "-i"
\ , "-i[:]*"
\ , "-ddump-hi"
\ , "-ddump-hi-diffs"
\ , "-ddump-minimal-imports"
\ , "-fforce-recomp"
\ , "-fno-force-recomp"
\ , "-fignore-hpc-changes"
\ , "-fno-ignore-hpc-changes"
\ , "-fignore-optim-changes"
\ , "-fno-ignore-optim-changes"
\ , "-fbreak-on-error"
\ , "-fno-break-on-error"
\ , "-fbreak-on-exception"
\ , "-fno-break-on-exception"
\ , "-fghci-hist-size="
\ , "-flocal-ghci-history"
\ , "-fno-local-ghci-history"
\ , "-fprint-bind-result"
\ , "-fno-print-bind-result"
\ , "-fshow-loaded-modules"
\ , "-ghci-script"
\ , "-ignore-dot-ghci"
\ , "-interactive-print"
\ , "-clear-package-db"
\ , "-distrust"
\ , "-distrust-all-packages"
\ , "-fpackage-trust"
\ , "-global-package-db"
\ , "-hide-all-packages"
\ , "-hide-package"
\ , "-ignore-package"
\ , "-no-auto-link-packages"
\ , "-no-global-package-db"
\ , "-no-user-package-db"
\ , "-package"
\ , "-package-db"
\ , "-package-env"
\ , "-package-id"
\ , "-this-unit-id"
\ , "-trust"
\ , "-user-package-db"
\ , "-fdefer-out-of-scope-variables"
\ , "-fno-defer-out-of-scope-variables"
\ , "-fdefer-type-errors"
\ , "-fno-defer-type-errors"
\ , "-fdefer-typed-holes"
\ , "-fno-defer-typed-holes"
\ , "-fhelpful-errors"
\ , "-fno-helpful-errors"
\ , "-fmax-pmcheck-iterations="
\ , "-fshow-warning-groups"
\ , "-fno-show-warning-groups"
\ , "-W"
\ , "-w"
\ , "-w"
\ , "-Wall"
\ , "-w"
\ , "-Wall-missed-specialisations"
\ , "-Wno-all-missed-specialisations"
\ , "-Wamp"
\ , "-Wno-amp"
\ , "-Wcompat"
\ , "-Wno-compat"
\ , "-Wcpp-undef"
\ , "-Wdeferred-out-of-scope-variables"
\ , "-Wno-deferred-out-of-scope-variables"
\ , "-Wdeferred-type-errors"
\ , "-Wno-deferred-type-errors"
\ , "-Wdeprecated-flags"
\ , "-Wno-deprecated-flags"
\ , "-Wdeprecations"
\ , "-Wno-deprecations"
\ , "-Wdodgy-exports"
\ , "-Wno-dodgy-exports"
\ , "-Wdodgy-foreign-imports"
\ , "-Wno-dodgy-foreign-import"
\ , "-Wdodgy-imports"
\ , "-Wno-dodgy-imports"
\ , "-Wduplicate-constraints"
\ , "-Wno-duplicate-constraints"
\ , "-Wduplicate-exports"
\ , "-Wno-duplicate-exports"
\ , "-Wempty-enumerations"
\ , "-Wno-empty-enumerations"
\ , "-Werror"
\ , "-Wwarn"
\ , "-Weverything"
\ , "-Whi-shadowing"
\ , "-Wno-hi-shadowing"
\ , "-Widentities"
\ , "-Wno-identities"
\ , "-Wimplicit-prelude"
\ , "-Wno-implicit-prelude"
\ , "-Wincomplete-patterns"
\ , "-Wno-incomplete-patterns"
\ , "-Wincomplete-record-updates"
\ , "-Wno-incomplete-record-updates"
\ , "-Wincomplete-uni-patterns"
\ , "-Wno-incomplete-uni-patterns"
\ , "-Winline-rule-shadowing"
\ , "-Wno-inline-rule-shadowing"
\ , "-Wmissed-specialisations"
\ , "-Wno-missed-specialisations"
\ , "-Wmissing-export-lists"
\ , "-fnowarn-missing-export-lists"
\ , "-Wmissing-exported-signatures"
\ , "-Wno-missing-exported-signatures"
\ , "-Wmissing-exported-sigs"
\ , "-Wno-missing-exported-sigs"
\ , "-Wmissing-fields"
\ , "-Wno-missing-fields"
\ , "-Wmissing-home-modules"
\ , "-Wno-missing-home-modules"
\ , "-Wmissing-import-lists"
\ , "-fnowarn-missing-import-lists"
\ , "-Wmissing-local-signatures"
\ , "-Wno-missing-local-signatures"
\ , "-Wmissing-local-sigs"
\ , "-Wno-missing-local-sigs"
\ , "-Wmissing-methods"
\ , "-Wno-missing-methods"
\ , "-Wmissing-monadfail-instances"
\ , "-Wno-missing-monadfail-instances"
\ , "-Wmissing-pattern-synonym-signatures"
\ , "-Wno-missing-pattern-synonym-signatures"
\ , "-Wmissing-signatures"
\ , "-Wno-missing-signatures"
\ , "-Wmonomorphism-restriction"
\ , "-Wno-monomorphism-restriction"
\ , "-Wname-shadowing"
\ , "-Wno-name-shadowing"
\ , "-Wno-compat"
\ , "-Wcompat"
\ , "-Wnoncanonical-monad-instances"
\ , "-Wno-noncanonical-monad-instances"
\ , "-Wnoncanonical-monadfail-instances"
\ , "-Wno-noncanonical-monadfail-instances"
\ , "-Wnoncanonical-monoid-instances"
\ , "-Wno-noncanonical-monoid-instances"
\ , "-Worphans"
\ , "-Wno-orphans"
\ , "-Woverflowed-literals"
\ , "-Wno-overflowed-literals"
\ , "-Woverlapping-patterns"
\ , "-Wno-overlapping-patterns"
\ , "-Wpartial-fields"
\ , "-Wno-partial-fields"
\ , "-Wpartial-type-signatures"
\ , "-Wno-partial-type-signatures"
\ , "-Wredundant-constraints"
\ , "-Wno-redundant-constraints"
\ , "-Wsafe"
\ , "-Wno-safe"
\ , "-Wsemigroup"
\ , "-Wno-semigroup"
\ , "-Wsimplifiable-class-constraints"
\ , "-Wno-overlapping-patterns"
\ , "-Wtabs"
\ , "-Wno-tabs"
\ , "-Wtrustworthy-safe"
\ , "-Wno-safe"
\ , "-Wtype-defaults"
\ , "-Wno-type-defaults"
\ , "-Wtyped-holes"
\ , "-Wno-typed-holes"
\ , "-Wunbanged-strict-patterns"
\ , "-Wno-unbanged-strict-patterns"
\ , "-Wunrecognised-pragmas"
\ , "-Wno-unrecognised-pragmas"
\ , "-Wunrecognised-warning-flags"
\ , "-Wno-unrecognised-warning-flags"
\ , "-Wunsafe"
\ , "-Wno-unsafe"
\ , "-Wunsupported-calling-conventions"
\ , "-Wno-unsupported-calling-conventions"
\ , "-Wunsupported-llvm-version"
\ , "-Wno-monomorphism-restriction"
\ , "-Wunticked-promoted-constructors"
\ , "-Wno-unticked-promoted-constructors"
\ , "-Wunused-binds"
\ , "-Wno-unused-binds"
\ , "-Wunused-do-bind"
\ , "-Wno-unused-do-bind"
\ , "-Wunused-foralls"
\ , "-Wno-unused-foralls"
\ , "-Wunused-imports"
\ , "-Wno-unused-imports"
\ , "-Wunused-local-binds"
\ , "-Wno-unused-local-binds"
\ , "-Wunused-matches"
\ , "-Wno-unused-matches"
\ , "-Wunused-pattern-binds"
\ , "-Wno-unused-pattern-binds"
\ , "-Wunused-top-binds"
\ , "-Wno-unused-top-binds"
\ , "-Wunused-type-patterns"
\ , "-Wno-unused-type-patterns"
\ , "-Wwarn"
\ , "-Werror"
\ , "-Wwarnings-deprecations"
\ , "-Wno-warnings-deprecations"
\ , "-Wwrong-do-bind"
\ , "-Wno-wrong-do-bind"
\ , "-O,"
\ , "-O0"
\ , "-O0"
\ , "-O2"
\ , "-O0"
\ , "-Odph"
\ , "-fcall-arity"
\ , "-fno-call-arity"
\ , "-fcase-folding"
\ , "-fno-case-folding"
\ , "-fcase-merge"
\ , "-fno-case-merge"
\ , "-fcmm-elim-common-blocks"
\ , "-fno-cmm-elim-common-blocks"
\ , "-fcmm-sink"
\ , "-fno-cmm-sink"
\ , "-fcpr-anal"
\ , "-fno-cpr-anal"
\ , "-fcross-module-specialise"
\ , "-fno-cross-module-specialise"
\ , "-fcse"
\ , "-fno-cse"
\ , "-fdicts-cheap"
\ , "-fno-dicts-cheap"
\ , "-fdicts-strict"
\ , "-fno-dicts-strict"
\ , "-fdmd-tx-dict-sel"
\ , "-fno-dmd-tx-dict-sel"
\ , "-fdo-eta-reduction"
\ , "-fno-do-eta-reduction"
\ , "-fdo-lambda-eta-expansion"
\ , "-fno-do-lambda-eta-expansion"
\ , "-feager-blackholing"
\ , "-fenable-rewrite-rules"
\ , "-fno-enable-rewrite-rules"
\ , "-fexcess-precision"
\ , "-fno-excess-precision"
\ , "-fexitification"
\ , "-fno-exitification"
\ , "-fexpose-all-unfoldings"
\ , "-fno-expose-all-unfoldings"
\ , "-ffloat-in"
\ , "-fno-float-in"
\ , "-ffull-laziness"
\ , "-fno-full-laziness"
\ , "-ffun-to-thunk"
\ , "-fno-fun-to-thunk"
\ , "-fignore-asserts"
\ , "-fno-ignore-asserts"
\ , "-fignore-interface-pragmas"
\ , "-fno-ignore-interface-pragmas"
\ , "-flate-dmd-anal"
\ , "-fno-late-dmd-anal"
\ , "-fliberate-case"
\ , "-fno-liberate-case"
\ , "-fliberate-case-threshold="
\ , "-fno-liberate-case-threshold"
\ , "-fllvm-pass-vectors-in-regs"
\ , "-fno-llvm-pass-vectors-in-regs"
\ , "-floopification"
\ , "-fno-loopification"
\ , "-fmax-inline-alloc-size="
\ , "-fmax-inline-memcpy-insns="
\ , "-fmax-inline-memset-insns="
\ , "-fmax-relevant-binds="
\ , "-fno-max-relevant-bindings"
\ , "-fmax-simplifier-iterations="
\ , "-fmax-uncovered-patterns="
\ , "-fmax-valid-substitutions="
\ , "-fno-max-valid-substitutions"
\ , "-fmax-worker-args="
\ , "-fno-opt-coercion"
\ , "-fno-pre-inlining"
\ , "-fno-state-hack"
\ , "-fomit-interface-pragmas"
\ , "-fno-omit-interface-pragmas"
\ , "-fomit-yields"
\ , "-fno-omit-yields"
\ , "-foptimal-applicative-do"
\ , "-fno-optimal-applicative-do"
\ , "-fpedantic-bottoms"
\ , "-fno-pedantic-bottoms"
\ , "-fregs-graph"
\ , "-fno-regs-graph"
\ , "-fregs-iterative"
\ , "-fno-regs-iterative"
\ , "-fsimpl-tick-factor="
\ , "-fsimplifier-phases="
\ , "-fsolve-constant-dicts"
\ , "-fno-solve-constant-dicts"
\ , "-fspec-constr"
\ , "-fno-spec-constr"
\ , "-fspec-constr-count="
\ , "-fno-spec-constr-count"
\ , "-fspec-constr-keen"
\ , "-fno-spec-constr-keen"
\ , "-fspec-constr-threshold="
\ , "-fno-spec-constr-threshold"
\ , "-fspecialise"
\ , "-fno-specialise"
\ , "-fspecialise-aggressively"
\ , "-fno-specialise-aggressively"
\ , "-fstatic-argument-transformation"
\ , "-fno-static-argument-transformation"
\ , "-fstg-cse"
\ , "-fno-stg-cse"
\ , "-fstrictness"
\ , "-fno-strictness"
\ , "-fstrictness-before="
\ , "-funbox-small-strict-fields"
\ , "-fno-unbox-small-strict-fields"
\ , "-funbox-strict-fields"
\ , "-fno-unbox-strict-fields"
\ , "-funfolding-creation-threshold="
\ , "-funfolding-dict-discount="
\ , "-funfolding-fun-discount="
\ , "-funfolding-keeness-factor="
\ , "-funfolding-use-threshold="
\ , "-fvectorisation-avoidance"
\ , "-fno-vectorisation-avoidance"
\ , "-fvectorise"
\ , "-fno-vectorise"
\ , "-fno-prof-auto"
\ , "-fprof-auto"
\ , "-fno-prof-cafs"
\ , "-fprof-cafs"
\ , "-fno-prof-count-entries"
\ , "-fprof-count-entries"
\ , "-fprof-auto"
\ , "-fno-prof-auto"
\ , "-fprof-auto-calls"
\ , "-fno-prof-auto-calls"
\ , "-fprof-auto-exported"
\ , "-fno-prof-auto"
\ , "-fprof-auto-top"
\ , "-fno-prof-auto"
\ , "-fprof-cafs"
\ , "-fno-prof-cafs"
\ , "-prof"
\ , "-ticky"
\ , "-fhpc"
\ , "-cpp"
\ , "-D[=]"
\ , "-U"
\ , "-I"
\ , "-U"
\ , "-dynamic"
\ , "-too"
\ , "-fasm"
\ , "-fllvm"
\ , "-fbyte-code"
\ , "-fllvm"
\ , "-fasm"
\ , "-fno-code"
\ , "-fobject-code"
\ , "-fPIC"
\ , "-fPIE"
\ , "-fwrite-interface"
\ , "-debug"
\ , "-dylib-install-name"
\ , "-dynamic"
\ , "-dynload"
\ , "-eventlog"
\ , "-fno-embed-manifest"
\ , "-fno-gen-manifest"
\ , "-fno-shared-implib"
\ , "-framework"
\ , "-framework-path"
\ , "-fwhole-archive-hs-libs"
\ , "-L"
\ , "-l"
\ , "-main-is"
\ , "-no-hs-main"
\ , "-no-rtsopts-suggestions"
\ , "-package"
\ , "-pie"
\ , "-rdynamic"
\ , "-rtsopts[=]"
\ , "-shared"
\ , "-split-objs"
\ , "-split-sections"
\ , "-static"
\ , "-staticlib"
\ , "-threaded"
\ , "-with-rtsopts="
\ , "-fplugin-opt=:"
\ , "-fplugin="
\ , "-hide-all-plugin-packages"
\ , "-plugin-package"
\ , "-plugin-package-id"
\ , "-pgma"
\ , "-pgmc"
\ , "-pgmdll"
\ , "-pgmF"
\ , "-pgmi"
\ , "-pgmL"
\ , "-pgml"
\ , "-pgmlc"
\ , "-pgmlibtool"
\ , "-pgmlo"
\ , "-pgmP"
\ , "-pgms"
\ , "-pgmwindres"
\ , "-opta"
\ , "-optc"
\ , "-optdll"
\ , "-optF"
\ , "-opti"
\ , "-optL"
\ , "-optl"
\ , "-optlc"
\ , "-optlo"
\ , "-optP"
\ , "-optwindres"
\ , "-msse2"
\ , "-msse4.2"
\ , "-dcmm-lint"
\ , "-dcore-lint"
\ , "-ddump-asm"
\ , "-ddump-asm-expanded"
\ , "-ddump-asm-liveness"
\ , "-ddump-asm-native"
\ , "-ddump-asm-regalloc"
\ , "-ddump-asm-regalloc-stages"
\ , "-ddump-asm-stats"
\ , "-ddump-bcos"
\ , "-ddump-cmm"
\ , "-ddump-cmm-caf"
\ , "-ddump-cmm-cbe"
\ , "-ddump-cmm-cfg"
\ , "-ddump-cmm-cps"
\ , "-ddump-cmm-from-stg"
\ , "-ddump-cmm-info"
\ , "-ddump-cmm-proc"
\ , "-ddump-cmm-procmap"
\ , "-ddump-cmm-raw"
\ , "-ddump-cmm-sink"
\ , "-ddump-cmm-sp"
\ , "-ddump-cmm-split"
\ , "-ddump-cmm-switch"
\ , "-ddump-cmm-verbose"
\ , "-ddump-core-stats"
\ , "-ddump-cse"
\ , "-ddump-deriv"
\ , "-ddump-ds"
\ , "-ddump-ec-trace"
\ , "-ddump-foreign"
\ , "-ddump-if-trace"
\ , "-ddump-inlinings"
\ , "-ddump-json"
\ , "-ddump-llvm"
\ , "-ddump-occur-anal"
\ , "-ddump-opt-cmm"
\ , "-ddump-parsed"
\ , "-ddump-parsed-ast"
\ , "-ddump-prep"
\ , "-ddump-rn"
\ , "-ddump-rn-ast"
\ , "-ddump-rn-stats"
\ , "-ddump-rn-trace"
\ , "-ddump-rule-firings"
\ , "-ddump-rule-rewrites"
\ , "-ddump-rules"
\ , "-ddump-simpl"
\ , "-ddump-simpl-iterations"
\ , "-ddump-simpl-stats"
\ , "-ddump-spec"
\ , "-ddump-splices"
\ , "-ddump-stg"
\ , "-ddump-str-signatures"
\ , "-ddump-stranal"
\ , "-ddump-tc"
\ , "-ddump-tc-ast"
\ , "-ddump-tc-trace"
\ , "-ddump-timings"
\ , "-ddump-to-file"
\ , "-ddump-types"
\ , "-ddump-vect"
\ , "-ddump-vt-trace"
\ , "-ddump-worker-wrapper"
\ , "-dfaststring-stats"
\ , "-dinitial-unique="
\ , "-dno-debug-output"
\ , "-ddebug-output"
\ , "-dppr-case-as-let"
\ , "-dppr-cols="
\ , "-dppr-debug"
\ , "-dppr-user-length"
\ , "-dshow-passes"
\ , "-dstg-lint"
\ , "-dsuppress-all"
\ , "-dsuppress-coercions"
\ , "-dsuppress-idinfo"
\ , "-dsuppress-module-prefixes"
\ , "-dsuppress-stg-free-vars"
\ , "-dsuppress-ticks"
\ , "-dsuppress-type-applications"
\ , "-dsuppress-type-signatures"
\ , "-dsuppress-unfoldings"
\ , "-dsuppress-uniques"
\ , "-dsuppress-var-kinds"
\ , "-dth-dec-file="
\ , "-dunique-increment="
\ , "-dverbose-core2core"
\ , "-dverbose-stg2stg"
\ , "-falignment-sanitisation"
\ , "-fcatch-bottoms"
\ , "-fllvm-fill-undef-with-garbage"
\ , "-g,"
\ , "-fexternal-interpreter"
\ , "-fglasgow-exts"
\ , "-fno-glasgow-exts"
\ , "-ghcversion-file"
\ , "-H"
\ , "-j[]"
\ ]
let s:commonModules =
\ [ "Distribution.Backpack"
\ , "Distribution.Backpack.ComponentsGraph"
\ , "Distribution.Backpack.Configure"
\ , "Distribution.Backpack.ConfiguredComponent"
\ , "Distribution.Backpack.DescribeUnitId"
\ , "Distribution.Backpack.FullUnitId"
\ , "Distribution.Backpack.LinkedComponent"
\ , "Distribution.Backpack.ModSubst"
\ , "Distribution.Backpack.ModuleShape"
\ , "Distribution.Backpack.PreModuleShape"
\ , "Distribution.CabalSpecVersion"
\ , "Distribution.Compat.Binary"
\ , "Distribution.Compat.CharParsing"
\ , "Distribution.Compat.CreatePipe"
\ , "Distribution.Compat.DList"
\ , "Distribution.Compat.Directory"
\ , "Distribution.Compat.Environment"
\ , "Distribution.Compat.Exception"
\ , "Distribution.Compat.Graph"
\ , "Distribution.Compat.Internal.TempFile"
\ , "Distribution.Compat.Lens"
\ , "Distribution.Compat.Map.Strict"
\ , "Distribution.Compat.Newtype"
\ , "Distribution.Compat.Parsing"
\ , "Distribution.Compat.Prelude.Internal"
\ , "Distribution.Compat.ReadP"
\ , "Distribution.Compat.Semigroup"
\ , "Distribution.Compat.Stack"
\ , "Distribution.Compat.Time"
\ , "Distribution.Compiler"
\ , "Distribution.FieldGrammar"
\ , "Distribution.FieldGrammar.Class"
\ , "Distribution.FieldGrammar.FieldDescrs"
\ , "Distribution.FieldGrammar.Parsec"
\ , "Distribution.FieldGrammar.Pretty"
\ , "Distribution.InstalledPackageInfo"
\ , "Distribution.License"
\ , "Distribution.Make"
\ , "Distribution.ModuleName"
\ , "Distribution.Package"
\ , "Distribution.PackageDescription"
\ , "Distribution.PackageDescription.Check"
\ , "Distribution.PackageDescription.Configuration"
\ , "Distribution.PackageDescription.FieldGrammar"
\ , "Distribution.PackageDescription.Parsec"
\ , "Distribution.PackageDescription.PrettyPrint"
\ , "Distribution.PackageDescription.Quirks"
\ , "Distribution.PackageDescription.Utils"
\ , "Distribution.ParseUtils"
\ , "Distribution.Parsec.Class"
\ , "Distribution.Parsec.Common"
\ , "Distribution.Parsec.ConfVar"
\ , "Distribution.Parsec.Field"
\ , "Distribution.Parsec.FieldLineStream"
\ , "Distribution.Parsec.Lexer"
\ , "Distribution.Parsec.LexerMonad"
\ , "Distribution.Parsec.Newtypes"
\ , "Distribution.Parsec.ParseResult"
\ , "Distribution.Parsec.Parser"
\ , "Distribution.Pretty"
\ , "Distribution.PrettyUtils"
\ , "Distribution.ReadE"
\ , "Distribution.SPDX"
\ , "Distribution.SPDX.License"
\ , "Distribution.SPDX.LicenseExceptionId"
\ , "Distribution.SPDX.LicenseExpression"
\ , "Distribution.SPDX.LicenseId"
\ , "Distribution.SPDX.LicenseReference"
\ , "Distribution.Simple"
\ , "Distribution.Simple.Bench"
\ , "Distribution.Simple.Build"
\ , "Distribution.Simple.Build.Macros"
\ , "Distribution.Simple.Build.PathsModule"
\ , "Distribution.Simple.BuildPaths"
\ , "Distribution.Simple.BuildTarget"
\ , "Distribution.Simple.BuildToolDepends"
\ , "Distribution.Simple.CCompiler"
\ , "Distribution.Simple.Command"
\ , "Distribution.Simple.Compiler"
\ , "Distribution.Simple.Configure"
\ , "Distribution.Simple.Doctest"
\ , "Distribution.Simple.GHC"
\ , "Distribution.Simple.GHCJS"
\ , "Distribution.Simple.Haddock"
\ , "Distribution.Simple.HaskellSuite"
\ , "Distribution.Simple.Hpc"
\ , "Distribution.Simple.Install"
\ , "Distribution.Simple.InstallDirs"
\ , "Distribution.Simple.JHC"
\ , "Distribution.Simple.LHC"
\ , "Distribution.Simple.LocalBuildInfo"
\ , "Distribution.Simple.PackageIndex"
\ , "Distribution.Simple.PreProcess"
\ , "Distribution.Simple.PreProcess.Unlit"
\ , "Distribution.Simple.Program"
\ , "Distribution.Simple.Program.Ar"
\ , "Distribution.Simple.Program.Builtin"
\ , "Distribution.Simple.Program.Db"
\ , "Distribution.Simple.Program.Find"
\ , "Distribution.Simple.Program.GHC"
\ , "Distribution.Simple.Program.HcPkg"
\ , "Distribution.Simple.Program.Hpc"
\ , "Distribution.Simple.Program.Internal"
\ , "Distribution.Simple.Program.Ld"
\ , "Distribution.Simple.Program.ResponseFile"
\ , "Distribution.Simple.Program.Run"
\ , "Distribution.Simple.Program.Script"
\ , "Distribution.Simple.Program.Strip"
\ , "Distribution.Simple.Program.Types"
\ , "Distribution.Simple.Register"
\ , "Distribution.Simple.Setup"
\ , "Distribution.Simple.SrcDist"
\ , "Distribution.Simple.Test"
\ , "Distribution.Simple.Test.ExeV10"
\ , "Distribution.Simple.Test.LibV09"
\ , "Distribution.Simple.Test.Log"
\ , "Distribution.Simple.UHC"
\ , "Distribution.Simple.UserHooks"
\ , "Distribution.Simple.Utils"
\ , "Distribution.System"
\ , "Distribution.TestSuite"
\ , "Distribution.Text"
\ , "Distribution.Types.AbiDependency"
\ , "Distribution.Types.AbiHash"
\ , "Distribution.Types.AnnotatedId"
\ , "Distribution.Types.Benchmark"
\ , "Distribution.Types.Benchmark.Lens"
\ , "Distribution.Types.BenchmarkInterface"
\ , "Distribution.Types.BenchmarkType"
\ , "Distribution.Types.BuildInfo"
\ , "Distribution.Types.BuildInfo.Lens"
\ , "Distribution.Types.BuildType"
\ , "Distribution.Types.Component"
\ , "Distribution.Types.ComponentId"
\ , "Distribution.Types.ComponentInclude"
\ , "Distribution.Types.ComponentLocalBuildInfo"
\ , "Distribution.Types.ComponentName"
\ , "Distribution.Types.ComponentRequestedSpec"
\ , "Distribution.Types.CondTree"
\ , "Distribution.Types.Condition"
\ , "Distribution.Types.Dependency"
\ , "Distribution.Types.DependencyMap"
\ , "Distribution.Types.ExeDependency"
\ , "Distribution.Types.Executable"
\ , "Distribution.Types.Executable.Lens"
\ , "Distribution.Types.ExecutableScope"
\ , "Distribution.Types.ExposedModule"
\ , "Distribution.Types.ForeignLib"
\ , "Distribution.Types.ForeignLib.Lens"
\ , "Distribution.Types.ForeignLibOption"
\ , "Distribution.Types.ForeignLibType"
\ , "Distribution.Types.GenericPackageDescription"
\ , "Distribution.Types.GenericPackageDescription.Lens"
\ , "Distribution.Types.HookedBuildInfo"
\ , "Distribution.Types.IncludeRenaming"
\ , "Distribution.Types.InstalledPackageInfo"
\ , "Distribution.Types.InstalledPackageInfo.FieldGrammar"
\ , "Distribution.Types.InstalledPackageInfo.Lens"
\ , "Distribution.Types.LegacyExeDependency"
\ , "Distribution.Types.Lens"
\ , "Distribution.Types.Library"
\ , "Distribution.Types.Library.Lens"
\ , "Distribution.Types.LocalBuildInfo"
\ , "Distribution.Types.Mixin"
\ , "Distribution.Types.Module"
\ , "Distribution.Types.ModuleReexport"
\ , "Distribution.Types.ModuleRenaming"
\ , "Distribution.Types.MungedPackageId"
\ , "Distribution.Types.MungedPackageName"
\ , "Distribution.Types.PackageDescription"
\ , "Distribution.Types.PackageDescription.Lens"
\ , "Distribution.Types.PackageId"
\ , "Distribution.Types.PackageId.Lens"
\ , "Distribution.Types.PackageName"
\ , "Distribution.Types.PkgconfigDependency"
\ , "Distribution.Types.PkgconfigName"
\ , "Distribution.Types.SetupBuildInfo"
\ , "Distribution.Types.SetupBuildInfo.Lens"
\ , "Distribution.Types.SourceRepo"
\ , "Distribution.Types.SourceRepo.Lens"
\ , "Distribution.Types.TargetInfo"
\ , "Distribution.Types.TestSuite"
\ , "Distribution.Types.TestSuite.Lens"
\ , "Distribution.Types.TestSuiteInterface"
\ , "Distribution.Types.TestType"
\ , "Distribution.Types.UnitId"
\ , "Distribution.Types.UnqualComponentName"
\ , "Distribution.Types.Version"
\ , "Distribution.Types.VersionInterval"
\ , "Distribution.Types.VersionRange"
\ , "Distribution.Utils.Generic"
\ , "Distribution.Utils.IOData"
\ , "Distribution.Utils.LogProgress"
\ , "Distribution.Utils.MapAccum"
\ , "Distribution.Utils.NubList"
\ , "Distribution.Utils.Progress"
\ , "Distribution.Utils.ShortText"
\ , "Distribution.Verbosity"
\ , "Distribution.Version"
\ , "Language.Haskell.Extension"
\ , "Graphics.GLU"
\ , "Graphics.GLU.Callbacks"
\ , "Graphics.GLU.Functions"
\ , "Graphics.GLU.Tokens"
\ , "Graphics.GLU.Types"
\ , "Graphics.UI.GLUT"
\ , "Graphics.UI.GLUT.Begin"
\ , "Graphics.UI.GLUT.Callbacks"
\ , "Graphics.UI.GLUT.Callbacks.Global"
\ , "Graphics.UI.GLUT.Callbacks.Window"
\ , "Graphics.UI.GLUT.Colormap"
\ , "Graphics.UI.GLUT.Debugging"
\ , "Graphics.UI.GLUT.DeviceControl"
\ , "Graphics.UI.GLUT.Fonts"
\ , "Graphics.UI.GLUT.GameMode"
\ , "Graphics.UI.GLUT.Initialization"
\ , "Graphics.UI.GLUT.Menu"
\ , "Graphics.UI.GLUT.Objects"
\ , "Graphics.UI.GLUT.Overlay"
\ , "Graphics.UI.GLUT.State"
\ , "Graphics.UI.GLUT.Window"
\ , "Network.Browser"
\ , "Network.BufferType"
\ , "Network.HTTP"
\ , "Network.HTTP.Auth"
\ , "Network.HTTP.Base"
\ , "Network.HTTP.Cookie"
\ , "Network.HTTP.HandleStream"
\ , "Network.HTTP.Headers"
\ , "Network.HTTP.Proxy"
\ , "Network.HTTP.Stream"
\ , "Network.Stream"
\ , "Network.StreamDebugger"
\ , "Network.StreamSocket"
\ , "Network.TCP"
\ , "Test.HUnit"
\ , "Test.HUnit.Base"
\ , "Test.HUnit.Lang"
\ , "Test.HUnit.Terminal"
\ , "Test.HUnit.Text"
\ , "Data.ObjectName"
\ , "Graphics.Rendering.OpenGL"
\ , "Graphics.Rendering.OpenGL.GL"
\ , "Graphics.Rendering.OpenGL.GL.Antialiasing"
\ , "Graphics.Rendering.OpenGL.GL.BeginEnd"
\ , "Graphics.Rendering.OpenGL.GL.Bitmaps"
\ , "Graphics.Rendering.OpenGL.GL.BufferObjects"
\ , "Graphics.Rendering.OpenGL.GL.Clipping"
\ , "Graphics.Rendering.OpenGL.GL.ColorSum"
\ , "Graphics.Rendering.OpenGL.GL.Colors"
\ , "Graphics.Rendering.OpenGL.GL.ConditionalRendering"
\ , "Graphics.Rendering.OpenGL.GL.CoordTrans"
\ , "Graphics.Rendering.OpenGL.GL.DebugOutput"
\ , "Graphics.Rendering.OpenGL.GL.DisplayLists"
\ , "Graphics.Rendering.OpenGL.GL.Evaluators"
\ , "Graphics.Rendering.OpenGL.GL.Feedback"
\ , "Graphics.Rendering.OpenGL.GL.FlushFinish"
\ , "Graphics.Rendering.OpenGL.GL.Fog"
\ , "Graphics.Rendering.OpenGL.GL.Framebuffer"
\ , "Graphics.Rendering.OpenGL.GL.FramebufferObjects"
\ , "Graphics.Rendering.OpenGL.GL.FramebufferObjects.Attachments"
\ , "Graphics.Rendering.OpenGL.GL.FramebufferObjects.FramebufferObjects"
\ , "Graphics.Rendering.OpenGL.GL.FramebufferObjects.Queries"
\ , "Graphics.Rendering.OpenGL.GL.FramebufferObjects.RenderbufferObjects"
\ , "Graphics.Rendering.OpenGL.GL.Hints"
\ , "Graphics.Rendering.OpenGL.GL.LineSegments"
\ , "Graphics.Rendering.OpenGL.GL.PerFragment"
\ , "Graphics.Rendering.OpenGL.GL.PixelRectangles"
\ , "Graphics.Rendering.OpenGL.GL.PixelRectangles.ColorTable"
\ , "Graphics.Rendering.OpenGL.GL.PixelRectangles.Convolution"
\ , "Graphics.Rendering.OpenGL.GL.PixelRectangles.Histogram"
\ , "Graphics.Rendering.OpenGL.GL.PixelRectangles.Minmax"
\ , "Graphics.Rendering.OpenGL.GL.PixelRectangles.PixelMap"
\ , "Graphics.Rendering.OpenGL.GL.PixelRectangles.PixelStorage"
\ , "Graphics.Rendering.OpenGL.GL.PixelRectangles.PixelTransfer"
\ , "Graphics.Rendering.OpenGL.GL.PixelRectangles.Rasterization"
\ , "Graphics.Rendering.OpenGL.GL.PixellikeObject"
\ , "Graphics.Rendering.OpenGL.GL.Points"
\ , "Graphics.Rendering.OpenGL.GL.Polygons"
\ , "Graphics.Rendering.OpenGL.GL.PrimitiveMode"
\ , "Graphics.Rendering.OpenGL.GL.QueryObjects"
\ , "Graphics.Rendering.OpenGL.GL.RasterPos"
\ , "Graphics.Rendering.OpenGL.GL.ReadCopyPixels"
\ , "Graphics.Rendering.OpenGL.GL.Rectangles"
\ , "Graphics.Rendering.OpenGL.GL.SavingState"
\ , "Graphics.Rendering.OpenGL.GL.Selection"
\ , "Graphics.Rendering.OpenGL.GL.Shaders"
\ , "Graphics.Rendering.OpenGL.GL.Shaders.Attribs"
\ , "Graphics.Rendering.OpenGL.GL.Shaders.Limits"
\ , "Graphics.Rendering.OpenGL.GL.Shaders.ProgramBinaries"
\ , "Graphics.Rendering.OpenGL.GL.Shaders.ProgramObjects"
\ , "Graphics.Rendering.OpenGL.GL.Shaders.ShaderBinaries"
\ , "Graphics.Rendering.OpenGL.GL.Shaders.ShaderObjects"
\ , "Graphics.Rendering.OpenGL.GL.Shaders.Uniform"
\ , "Graphics.Rendering.OpenGL.GL.StringQueries"
\ , "Graphics.Rendering.OpenGL.GL.SyncObjects"
\ , "Graphics.Rendering.OpenGL.GL.Tensor"
\ , "Graphics.Rendering.OpenGL.GL.Texturing"
\ , "Graphics.Rendering.OpenGL.GL.Texturing.Application"
\ , "Graphics.Rendering.OpenGL.GL.Texturing.Environments"
\ , "Graphics.Rendering.OpenGL.GL.Texturing.Objects"
\ , "Graphics.Rendering.OpenGL.GL.Texturing.Parameters"
\ , "Graphics.Rendering.OpenGL.GL.Texturing.Queries"
\ , "Graphics.Rendering.OpenGL.GL.Texturing.Specification"
\ , "Graphics.Rendering.OpenGL.GL.TransformFeedback"
\ , "Graphics.Rendering.OpenGL.GL.VertexArrayObjects"
\ , "Graphics.Rendering.OpenGL.GL.VertexArrays"
\ , "Graphics.Rendering.OpenGL.GL.VertexSpec"
\ , "Graphics.Rendering.OpenGL.GLU"
\ , "Graphics.Rendering.OpenGL.GLU.Errors"
\ , "Graphics.Rendering.OpenGL.GLU.Initialization"
\ , "Graphics.Rendering.OpenGL.GLU.Matrix"
\ , "Graphics.Rendering.OpenGL.GLU.Mipmapping"
\ , "Graphics.Rendering.OpenGL.GLU.NURBS"
\ , "Graphics.Rendering.OpenGL.GLU.Quadrics"
\ , "Graphics.Rendering.OpenGL.GLU.Tessellation"
\ , "Graphics.GL"
\ , "Graphics.GL.AMD"
\ , "Graphics.GL.AMD.BlendMinmaxFactor"
\ , "Graphics.GL.AMD.DebugOutput"
\ , "Graphics.GL.AMD.DepthClampSeparate"
\ , "Graphics.GL.AMD.DrawBuffersBlend"
\ , "Graphics.GL.AMD.FramebufferMultisampleAdvanced"
\ , "Graphics.GL.AMD.FramebufferSamplePositions"
\ , "Graphics.GL.AMD.GPUShaderHalfFloat"
\ , "Graphics.GL.AMD.GPUShaderInt64"
\ , "Graphics.GL.AMD.InterleavedElements"
\ , "Graphics.GL.AMD.MultiDrawIndirect"
\ , "Graphics.GL.AMD.NameGenDelete"
\ , "Graphics.GL.AMD.OcclusionQueryEvent"
\ , "Graphics.GL.AMD.PerformanceMonitor"
\ , "Graphics.GL.AMD.PinnedMemory"
\ , "Graphics.GL.AMD.QueryBufferObject"
\ , "Graphics.GL.AMD.SamplePositions"
\ , "Graphics.GL.AMD.SeamlessCubemapPerTexture"
\ , "Graphics.GL.AMD.SparseTexture"
\ , "Graphics.GL.AMD.StencilOperationExtended"
\ , "Graphics.GL.AMD.TransformFeedback4"
\ , "Graphics.GL.AMD.VertexShaderTessellator"
\ , "Graphics.GL.APPLE"
\ , "Graphics.GL.APPLE.AuxDepthStencil"
\ , "Graphics.GL.APPLE.ClientStorage"
\ , "Graphics.GL.APPLE.ElementArray"
\ , "Graphics.GL.APPLE.Fence"
\ , "Graphics.GL.APPLE.FloatPixels"
\ , "Graphics.GL.APPLE.FlushBufferRange"
\ , "Graphics.GL.APPLE.ObjectPurgeable"
\ , "Graphics.GL.APPLE.RGB422"
\ , "Graphics.GL.APPLE.RowBytes"
\ , "Graphics.GL.APPLE.SpecularVector"
\ , "Graphics.GL.APPLE.TextureRange"
\ , "Graphics.GL.APPLE.TransformHint"
\ , "Graphics.GL.APPLE.VertexArrayObject"
\ , "Graphics.GL.APPLE.VertexArrayRange"
\ , "Graphics.GL.APPLE.VertexProgramEvaluators"
\ , "Graphics.GL.APPLE.YCbCr422"
\ , "Graphics.GL.ARB"
\ , "Graphics.GL.ARB.BaseInstance"
\ , "Graphics.GL.ARB.BindlessTexture"
\ , "Graphics.GL.ARB.BlendFuncExtended"
\ , "Graphics.GL.ARB.BufferStorage"
\ , "Graphics.GL.ARB.CLEvent"
\ , "Graphics.GL.ARB.ClearBufferObject"
\ , "Graphics.GL.ARB.ClearTexture"
\ , "Graphics.GL.ARB.ClipControl"
\ , "Graphics.GL.ARB.ColorBufferFloat"
\ , "Graphics.GL.ARB.CompressedTexturePixelStorage"
\ , "Graphics.GL.ARB.ComputeShader"
\ , "Graphics.GL.ARB.ComputeVariableGroupSize"
\ , "Graphics.GL.ARB.ConditionalRenderInverted"
\ , "Graphics.GL.ARB.CopyBuffer"
\ , "Graphics.GL.ARB.CopyImage"
\ , "Graphics.GL.ARB.CullDistance"
\ , "Graphics.GL.ARB.DebugOutput"
\ , "Graphics.GL.ARB.DepthBufferFloat"
\ , "Graphics.GL.ARB.DepthClamp"
\ , "Graphics.GL.ARB.DepthTexture"
\ , "Graphics.GL.ARB.DirectStateAccess"
\ , "Graphics.GL.ARB.DrawBuffers"
\ , "Graphics.GL.ARB.DrawBuffersBlend"
\ , "Graphics.GL.ARB.DrawElementsBaseVertex"
\ , "Graphics.GL.ARB.DrawIndirect"
\ , "Graphics.GL.ARB.DrawInstanced"
\ , "Graphics.GL.ARB.ES2Compatibility"
\ , "Graphics.GL.ARB.ES31Compatibility"
\ , "Graphics.GL.ARB.ES32Compatibility"
\ , "Graphics.GL.ARB.ES3Compatibility"
\ , "Graphics.GL.ARB.EnhancedLayouts"
\ , "Graphics.GL.ARB.ExplicitUniformLocation"
\ , "Graphics.GL.ARB.FragmentProgram"
\ , "Graphics.GL.ARB.FragmentShader"
\ , "Graphics.GL.ARB.FramebufferNoAttachments"
\ , "Graphics.GL.ARB.FramebufferObjectCompatibility"
\ , "Graphics.GL.ARB.FramebufferObjectCore"
\ , "Graphics.GL.ARB.FramebufferSRGB"
\ , "Graphics.GL.ARB.GPUShader5"
\ , "Graphics.GL.ARB.GPUShaderFP64"
\ , "Graphics.GL.ARB.GPUShaderInt64"
\ , "Graphics.GL.ARB.GeometryShader4"
\ , "Graphics.GL.ARB.GetProgramBinary"
\ , "Graphics.GL.ARB.GetTextureSubImage"
\ , "Graphics.GL.ARB.GlSpirv"
\ , "Graphics.GL.ARB.HalfFloatPixel"
\ , "Graphics.GL.ARB.HalfFloatVertex"
\ , "Graphics.GL.ARB.ImagingCompatibility"
\ , "Graphics.GL.ARB.ImagingCore"
\ , "Graphics.GL.ARB.IndirectParameters"
\ , "Graphics.GL.ARB.InstancedArrays"
\ , "Graphics.GL.ARB.InternalformatQuery"
\ , "Graphics.GL.ARB.InternalformatQuery2"
\ , "Graphics.GL.ARB.InvalidateSubdata"
\ , "Graphics.GL.ARB.MapBufferAlignment"
\ , "Graphics.GL.ARB.MapBufferRange"
\ , "Graphics.GL.ARB.MatrixPalette"
\ , "Graphics.GL.ARB.MultiBind"
\ , "Graphics.GL.ARB.MultiDrawIndirect"
\ , "Graphics.GL.ARB.Multisample"
\ , "Graphics.GL.ARB.Multitexture"
\ , "Graphics.GL.ARB.OcclusionQuery"
\ , "Graphics.GL.ARB.OcclusionQuery2"
\ , "Graphics.GL.ARB.ParallelShaderCompile"
\ , "Graphics.GL.ARB.PipelineStatisticsQuery"
\ , "Graphics.GL.ARB.PixelBufferObject"
\ , "Graphics.GL.ARB.PointParameters"
\ , "Graphics.GL.ARB.PointSprite"
\ , "Graphics.GL.ARB.PolygonOffsetClamp"
\ , "Graphics.GL.ARB.ProgramInterfaceQuery"
\ , "Graphics.GL.ARB.ProvokingVertex"
\ , "Graphics.GL.ARB.QueryBufferObject"
\ , "Graphics.GL.ARB.RobustnessCompatibility"
\ , "Graphics.GL.ARB.RobustnessCore"
\ , "Graphics.GL.ARB.SampleLocations"
\ , "Graphics.GL.ARB.SampleShading"
\ , "Graphics.GL.ARB.SamplerObjects"
\ , "Graphics.GL.ARB.SeamlessCubeMap"
\ , "Graphics.GL.ARB.SeamlessCubemapPerTexture"
\ , "Graphics.GL.ARB.SeparateShaderObjects"
\ , "Graphics.GL.ARB.ShaderAtomicCounters"
\ , "Graphics.GL.ARB.ShaderImageLoadStore"
\ , "Graphics.GL.ARB.ShaderObjects"
\ , "Graphics.GL.ARB.ShaderStorageBufferObject"
\ , "Graphics.GL.ARB.ShaderSubroutine"
\ , "Graphics.GL.ARB.ShadingLanguage100"
\ , "Graphics.GL.ARB.ShadingLanguageInclude"
\ , "Graphics.GL.ARB.Shadow"
\ , "Graphics.GL.ARB.ShadowAmbient"
\ , "Graphics.GL.ARB.SparseBuffer"
\ , "Graphics.GL.ARB.SparseTexture"
\ , "Graphics.GL.ARB.SpirvExtensions"
\ , "Graphics.GL.ARB.StencilTexturing"
\ , "Graphics.GL.ARB.Sync"
\ , "Graphics.GL.ARB.TessellationShader"
\ , "Graphics.GL.ARB.TextureBarrier"
\ , "Graphics.GL.ARB.TextureBorderClamp"
\ , "Graphics.GL.ARB.TextureBufferObject"
\ , "Graphics.GL.ARB.TextureBufferObjectRGB32"
\ , "Graphics.GL.ARB.TextureBufferRange"
\ , "Graphics.GL.ARB.TextureCompression"
\ , "Graphics.GL.ARB.TextureCompressionBPTC"
\ , "Graphics.GL.ARB.TextureCompressionRGTC"
\ , "Graphics.GL.ARB.TextureCubeMap"
\ , "Graphics.GL.ARB.TextureCubeMapArray"
\ , "Graphics.GL.ARB.TextureEnvCombine"
\ , "Graphics.GL.ARB.TextureEnvDot3"
\ , "Graphics.GL.ARB.TextureFilterAnisotropic"
\ , "Graphics.GL.ARB.TextureFilterMinmax"
\ , "Graphics.GL.ARB.TextureFloat"
\ , "Graphics.GL.ARB.TextureGather"
\ , "Graphics.GL.ARB.TextureMirrorClampToEdge"
\ , "Graphics.GL.ARB.TextureMirroredRepeat"
\ , "Graphics.GL.ARB.TextureMultisample"
\ , "Graphics.GL.ARB.TextureRG"
\ , "Graphics.GL.ARB.TextureRGB10A2UI"
\ , "Graphics.GL.ARB.TextureRectangle"
\ , "Graphics.GL.ARB.TextureStencil8"
\ , "Graphics.GL.ARB.TextureStorage"
\ , "Graphics.GL.ARB.TextureStorageMultisample"
\ , "Graphics.GL.ARB.TextureSwizzle"
\ , "Graphics.GL.ARB.TextureView"
\ , "Graphics.GL.ARB.TimerQuery"
\ , "Graphics.GL.ARB.TransformFeedback2"
\ , "Graphics.GL.ARB.TransformFeedback3"
\ , "Graphics.GL.ARB.TransformFeedbackInstanced"
\ , "Graphics.GL.ARB.TransformFeedbackOverflowQuery"
\ , "Graphics.GL.ARB.TransposeMatrix"
\ , "Graphics.GL.ARB.UniformBufferObject"
\ , "Graphics.GL.ARB.VertexArrayBGRA"
\ , "Graphics.GL.ARB.VertexArrayObject"
\ , "Graphics.GL.ARB.VertexAttrib64Bit"
\ , "Graphics.GL.ARB.VertexAttribBinding"
\ , "Graphics.GL.ARB.VertexBlend"
\ , "Graphics.GL.ARB.VertexBufferObject"
\ , "Graphics.GL.ARB.VertexProgram"
\ , "Graphics.GL.ARB.VertexShader"
\ , "Graphics.GL.ARB.VertexType10f11f11fRev"
\ , "Graphics.GL.ARB.VertexType2101010RevCompatibility"
\ , "Graphics.GL.ARB.VertexType2101010RevCore"
\ , "Graphics.GL.ARB.ViewportArray"
\ , "Graphics.GL.ARB.WindowPos"
\ , "Graphics.GL.ATI"
\ , "Graphics.GL.ATI.DrawBuffers"
\ , "Graphics.GL.ATI.ElementArray"
\ , "Graphics.GL.ATI.EnvmapBumpmap"
\ , "Graphics.GL.ATI.FragmentShader"
\ , "Graphics.GL.ATI.MapObjectBuffer"
\ , "Graphics.GL.ATI.Meminfo"
\ , "Graphics.GL.ATI.PNTriangles"
\ , "Graphics.GL.ATI.PixelFormatFloat"
\ , "Graphics.GL.ATI.SeparateStencil"
\ , "Graphics.GL.ATI.TextFragmentShader"
\ , "Graphics.GL.ATI.TextureEnvCombine3"
\ , "Graphics.GL.ATI.TextureFloat"
\ , "Graphics.GL.ATI.TextureMirrorOnce"
\ , "Graphics.GL.ATI.VertexArrayObject"
\ , "Graphics.GL.ATI.VertexAttribArrayObject"
\ , "Graphics.GL.ATI.VertexStreams"
\ , "Graphics.GL.Compatibility30"
\ , "Graphics.GL.Compatibility31"
\ , "Graphics.GL.Compatibility32"
\ , "Graphics.GL.Compatibility33"
\ , "Graphics.GL.Compatibility40"
\ , "Graphics.GL.Compatibility41"
\ , "Graphics.GL.Compatibility42"
\ , "Graphics.GL.Compatibility43"
\ , "Graphics.GL.Compatibility44"
\ , "Graphics.GL.Compatibility45"
\ , "Graphics.GL.Compatibility46"
\ , "Graphics.GL.Core30"
\ , "Graphics.GL.Core31"
\ , "Graphics.GL.Core32"
\ , "Graphics.GL.Core33"
\ , "Graphics.GL.Core40"
\ , "Graphics.GL.Core41"
\ , "Graphics.GL.Core42"
\ , "Graphics.GL.Core43"
\ , "Graphics.GL.Core44"
\ , "Graphics.GL.Core45"
\ , "Graphics.GL.Core46"
\ , "Graphics.GL.EXT"
\ , "Graphics.GL.EXT.ABGR"
\ , "Graphics.GL.EXT.BGRA"
\ , "Graphics.GL.EXT.BindableUniform"
\ , "Graphics.GL.EXT.BlendColor"
\ , "Graphics.GL.EXT.BlendEquationSeparate"
\ , "Graphics.GL.EXT.BlendFuncSeparate"
\ , "Graphics.GL.EXT.BlendMinmax"
\ , "Graphics.GL.EXT.BlendSubtract"
\ , "Graphics.GL.EXT.CMYKA"
\ , "Graphics.GL.EXT.ClipVolumeHint"
\ , "Graphics.GL.EXT.ColorSubtable"
\ , "Graphics.GL.EXT.CompiledVertexArray"
\ , "Graphics.GL.EXT.Convolution"
\ , "Graphics.GL.EXT.CoordinateFrame"
\ , "Graphics.GL.EXT.CopyTexture"
\ , "Graphics.GL.EXT.CullVertex"
\ , "Graphics.GL.EXT.DebugLabel"
\ , "Graphics.GL.EXT.DebugMarker"
\ , "Graphics.GL.EXT.DepthBoundsTest"
\ , "Graphics.GL.EXT.DirectStateAccess"
\ , "Graphics.GL.EXT.DrawBuffers2"
\ , "Graphics.GL.EXT.DrawInstanced"
\ , "Graphics.GL.EXT.DrawRangeElements"
\ , "Graphics.GL.EXT.EglImageStorage"
\ , "Graphics.GL.EXT.ExternalBuffer"
\ , "Graphics.GL.EXT.FogCoord"
\ , "Graphics.GL.EXT.FourTwoTwoPixels"
\ , "Graphics.GL.EXT.FramebufferBlit"
\ , "Graphics.GL.EXT.FramebufferMultisample"
\ , "Graphics.GL.EXT.FramebufferMultisampleBlitScaled"
\ , "Graphics.GL.EXT.FramebufferObject"
\ , "Graphics.GL.EXT.FramebufferSRGB"
\ , "Graphics.GL.EXT.GPUProgramParameters"
\ , "Graphics.GL.EXT.GPUShader4"
\ , "Graphics.GL.EXT.GeometryShader4"
\ , "Graphics.GL.EXT.Histogram"
\ , "Graphics.GL.EXT.IndexArrayFormats"
\ , "Graphics.GL.EXT.IndexFunc"
\ , "Graphics.GL.EXT.IndexMaterial"
\ , "Graphics.GL.EXT.LightTexture"
\ , "Graphics.GL.EXT.MemoryObject"
\ , "Graphics.GL.EXT.MemoryObjectFd"
\ , "Graphics.GL.EXT.MemoryObjectWin32"
\ , "Graphics.GL.EXT.MultiDrawArrays"
\ , "Graphics.GL.EXT.Multisample"
\ , "Graphics.GL.EXT.PackedDepthStencil"
\ , "Graphics.GL.EXT.PackedFloat"
\ , "Graphics.GL.EXT.PackedPixels"
\ , "Graphics.GL.EXT.PalettedTexture"
\ , "Graphics.GL.EXT.PixelBufferObject"
\ , "Graphics.GL.EXT.PixelTransform"
\ , "Graphics.GL.EXT.PointParameters"
\ , "Graphics.GL.EXT.PolygonOffset"
\ , "Graphics.GL.EXT.PolygonOffsetClamp"
\ , "Graphics.GL.EXT.ProvokingVertex"
\ , "Graphics.GL.EXT.RasterMultisample"
\ , "Graphics.GL.EXT.RescaleNormal"
\ , "Graphics.GL.EXT.SecondaryColor"
\ , "Graphics.GL.EXT.Semaphore"
\ , "Graphics.GL.EXT.SemaphoreFd"
\ , "Graphics.GL.EXT.SemaphoreWin32"
\ , "Graphics.GL.EXT.SeparateShaderObjects"
\ , "Graphics.GL.EXT.SeparateSpecularColor"
\ , "Graphics.GL.EXT.ShaderFramebufferFetch"
\ , "Graphics.GL.EXT.ShaderFramebufferFetchNonCoherent"
\ , "Graphics.GL.EXT.ShaderImageLoadStore"
\ , "Graphics.GL.EXT.SharedTexturePalette"
\ , "Graphics.GL.EXT.StencilClearTag"
\ , "Graphics.GL.EXT.StencilTwoSide"
\ , "Graphics.GL.EXT.StencilWrap"
\ , "Graphics.GL.EXT.Subtexture"
\ , "Graphics.GL.EXT.Texture"
\ , "Graphics.GL.EXT.Texture3D"
\ , "Graphics.GL.EXT.TextureArray"
\ , "Graphics.GL.EXT.TextureBufferObject"
\ , "Graphics.GL.EXT.TextureCompressionLATC"
\ , "Graphics.GL.EXT.TextureCompressionRGTC"
\ , "Graphics.GL.EXT.TextureCompressionS3TC"
\ , "Graphics.GL.EXT.TextureCubeMap"
\ , "Graphics.GL.EXT.TextureEnvCombine"
\ , "Graphics.GL.EXT.TextureEnvDot3"
\ , "Graphics.GL.EXT.TextureFilterAnisotropic"
\ , "Graphics.GL.EXT.TextureFilterMinmax"
\ , "Graphics.GL.EXT.TextureInteger"
\ , "Graphics.GL.EXT.TextureLODBias"
\ , "Graphics.GL.EXT.TextureMirrorClamp"
\ , "Graphics.GL.EXT.TextureObject"
\ , "Graphics.GL.EXT.TexturePerturbNormal"
\ , "Graphics.GL.EXT.TextureSNorm"
\ , "Graphics.GL.EXT.TextureSRGB"
\ , "Graphics.GL.EXT.TextureSRGBDecode"
\ , "Graphics.GL.EXT.TextureSharedExponent"
\ , "Graphics.GL.EXT.TextureSwizzle"
\ , "Graphics.GL.EXT.TimerQuery"
\ , "Graphics.GL.EXT.TransformFeedback"
\ , "Graphics.GL.EXT.VertexArray"
\ , "Graphics.GL.EXT.VertexArrayBGRA"
\ , "Graphics.GL.EXT.VertexAttrib64Bit"
\ , "Graphics.GL.EXT.VertexShader"
\ , "Graphics.GL.EXT.VertexWeighting"
\ , "Graphics.GL.EXT.Win32KeyedMutex"
\ , "Graphics.GL.EXT.WindowRectangles"
\ , "Graphics.GL.EXT.X11SyncObject"
\ , "Graphics.GL.Functions"
\ , "Graphics.GL.GREMEDY"
\ , "Graphics.GL.GREMEDY.FrameTerminator"
\ , "Graphics.GL.GREMEDY.StringMarker"
\ , "Graphics.GL.GetProcAddress"
\ , "Graphics.GL.Groups"
\ , "Graphics.GL.HP"
\ , "Graphics.GL.HP.ConvolutionBorderModes"
\ , "Graphics.GL.HP.ImageTransform"
\ , "Graphics.GL.HP.OcclusionTest"
\ , "Graphics.GL.HP.TextureLighting"
\ , "Graphics.GL.IBM"
\ , "Graphics.GL.IBM.CullVertex"
\ , "Graphics.GL.IBM.MultimodeDrawArrays"
\ , "Graphics.GL.IBM.RasterposClip"
\ , "Graphics.GL.IBM.StaticData"
\ , "Graphics.GL.IBM.TextureMirroredRepeat"
\ , "Graphics.GL.IBM.VertexArrayLists"
\ , "Graphics.GL.INGR"
\ , "Graphics.GL.INGR.BlendFuncSeparate"
\ , "Graphics.GL.INGR.ColorClamp"
\ , "Graphics.GL.INGR.InterlaceRead"
\ , "Graphics.GL.INTEL"
\ , "Graphics.GL.INTEL.BlackholeRender"
\ , "Graphics.GL.INTEL.ConservativeRasterization"
\ , "Graphics.GL.INTEL.FramebufferCmaa"
\ , "Graphics.GL.INTEL.MapTexture"
\ , "Graphics.GL.INTEL.ParallelArrays"
\ , "Graphics.GL.INTEL.PerformanceQuery"
\ , "Graphics.GL.KHR"
\ , "Graphics.GL.KHR.BlendEquationAdvanced"
\ , "Graphics.GL.KHR.BlendEquationAdvancedCoherent"
\ , "Graphics.GL.KHR.ContextFlushControl"
\ , "Graphics.GL.KHR.DebugCompatibility"
\ , "Graphics.GL.KHR.DebugCore"
\ , "Graphics.GL.KHR.NoError"
\ , "Graphics.GL.KHR.ParallelShaderCompile"
\ , "Graphics.GL.KHR.Robustness"
\ , "Graphics.GL.KHR.TextureCompressionASTCHDR"
\ , "Graphics.GL.KHR.TextureCompressionASTCLDR"
\ , "Graphics.GL.MESA"
\ , "Graphics.GL.MESA.PackInvert"
\ , "Graphics.GL.MESA.ProgramBinaryFormats"
\ , "Graphics.GL.MESA.ResizeBuffers"
\ , "Graphics.GL.MESA.TileRasterOrder"
\ , "Graphics.GL.MESA.WindowPos"
\ , "Graphics.GL.MESA.YCbCrTexture"
\ , "Graphics.GL.MESAX"
\ , "Graphics.GL.MESAX.TextureStack"
\ , "Graphics.GL.NV"
\ , "Graphics.GL.NV.AlphaToCoverageDitherControl"
\ , "Graphics.GL.NV.BindlessMultiDrawIndirect"
\ , "Graphics.GL.NV.BindlessMultiDrawIndirectCount"
\ , "Graphics.GL.NV.BindlessTexture"
\ , "Graphics.GL.NV.BlendEquationAdvanced"
\ , "Graphics.GL.NV.BlendEquationAdvancedCoherent"
\ , "Graphics.GL.NV.BlendMinmaxFactor"
\ , "Graphics.GL.NV.ClipSpaceWScaling"
\ , "Graphics.GL.NV.CommandList"
\ , "Graphics.GL.NV.ComputeProgram5"
\ , "Graphics.GL.NV.ConditionalRender"
\ , "Graphics.GL.NV.ConservativeRaster"
\ , "Graphics.GL.NV.ConservativeRasterDilate"
\ , "Graphics.GL.NV.ConservativeRasterPreSnap"
\ , "Graphics.GL.NV.ConservativeRasterPreSnapTriangles"
\ , "Graphics.GL.NV.CopyDepthToColor"
\ , "Graphics.GL.NV.CopyImage"
\ , "Graphics.GL.NV.DeepTexture3D"
\ , "Graphics.GL.NV.DepthBufferFloat"
\ , "Graphics.GL.NV.DepthClamp"
\ , "Graphics.GL.NV.DrawTexture"
\ , "Graphics.GL.NV.DrawVulkanImage"
\ , "Graphics.GL.NV.Evaluators"
\ , "Graphics.GL.NV.ExplicitMultisample"
\ , "Graphics.GL.NV.Fence"
\ , "Graphics.GL.NV.FillRectangle"
\ , "Graphics.GL.NV.FloatBuffer"
\ , "Graphics.GL.NV.FogDistance"
\ , "Graphics.GL.NV.FragmentCoverageToColor"
\ , "Graphics.GL.NV.FragmentProgram"
\ , "Graphics.GL.NV.FragmentProgram2"
\ , "Graphics.GL.NV.FramebufferMixedSamples"
\ , "Graphics.GL.NV.FramebufferMultisampleCoverage"
\ , "Graphics.GL.NV.GPUMulticast"
\ , "Graphics.GL.NV.GPUProgram4"
\ , "Graphics.GL.NV.GPUProgram5"
\ , "Graphics.GL.NV.GPUShader5"
\ , "Graphics.GL.NV.GeometryProgram4"
\ , "Graphics.GL.NV.HalfFloat"
\ , "Graphics.GL.NV.InternalformatSampleQuery"
\ , "Graphics.GL.NV.LightMaxExponent"
\ , "Graphics.GL.NV.MultisampleCoverage"
\ , "Graphics.GL.NV.MultisampleFilterHint"
\ , "Graphics.GL.NV.OcclusionQuery"
\ , "Graphics.GL.NV.PackedDepthStencil"
\ , "Graphics.GL.NV.ParameterBufferObject"
\ , "Graphics.GL.NV.PathRenderingCompatibility"
\ , "Graphics.GL.NV.PathRenderingCore"
\ , "Graphics.GL.NV.PathRenderingSharedEdge"
\ , "Graphics.GL.NV.PixelDataRange"
\ , "Graphics.GL.NV.PointSprite"
\ , "Graphics.GL.NV.PresentVideo"
\ , "Graphics.GL.NV.PrimitiveRestart"
\ , "Graphics.GL.NV.QueryResource"
\ , "Graphics.GL.NV.QueryResourceTag"
\ , "Graphics.GL.NV.RegisterCombiners"
\ , "Graphics.GL.NV.RegisterCombiners2"
\ , "Graphics.GL.NV.RobustnessVideoMemoryPurge"
\ , "Graphics.GL.NV.SampleLocations"
\ , "Graphics.GL.NV.ShaderBufferLoad"
\ , "Graphics.GL.NV.ShaderBufferStore"
\ , "Graphics.GL.NV.ShaderThreadGroup"
\ , "Graphics.GL.NV.TessellationProgram5"
\ , "Graphics.GL.NV.TexgenEmboss"
\ , "Graphics.GL.NV.TexgenReflection"
\ , "Graphics.GL.NV.TextureBarrier"
\ , "Graphics.GL.NV.TextureEnvCombine4"
\ , "Graphics.GL.NV.TextureExpandNormal"
\ , "Graphics.GL.NV.TextureMultisample"
\ , "Graphics.GL.NV.TextureRectangle"
\ , "Graphics.GL.NV.TextureShader"
\ , "Graphics.GL.NV.TextureShader2"
\ , "Graphics.GL.NV.TextureShader3"
\ , "Graphics.GL.NV.TransformFeedback"
\ , "Graphics.GL.NV.TransformFeedback2"
\ , "Graphics.GL.NV.UniformBufferUnifiedMemory"
\ , "Graphics.GL.NV.VDPAUInterop"
\ , "Graphics.GL.NV.VertexArrayRange"
\ , "Graphics.GL.NV.VertexArrayRange2"
\ , "Graphics.GL.NV.VertexAttribInteger64Bit"
\ , "Graphics.GL.NV.VertexBufferUnifiedMemory"
\ , "Graphics.GL.NV.VertexProgram"
\ , "Graphics.GL.NV.VertexProgram2Option"
\ , "Graphics.GL.NV.VertexProgram3"
\ , "Graphics.GL.NV.VertexProgram4"
\ , "Graphics.GL.NV.VideoCapture"
\ , "Graphics.GL.NV.ViewportSwizzle"
\ , "Graphics.GL.NVX"
\ , "Graphics.GL.NVX.ConditionalRender"
\ , "Graphics.GL.NVX.GPUMemoryInfo"
\ , "Graphics.GL.NVX.LinkedGPUMulticast"
\ , "Graphics.GL.OES"
\ , "Graphics.GL.OES.ByteCoordinates"
\ , "Graphics.GL.OES.CompressedPalettedTexture"
\ , "Graphics.GL.OES.FixedPoint"
\ , "Graphics.GL.OES.QueryMatrix"
\ , "Graphics.GL.OES.ReadFormat"
\ , "Graphics.GL.OES.SinglePrecision"
\ , "Graphics.GL.OML"
\ , "Graphics.GL.OML.Interlace"
\ , "Graphics.GL.OML.Resample"
\ , "Graphics.GL.OML.Subsample"
\ , "Graphics.GL.OVR"
\ , "Graphics.GL.OVR.Multiview"
\ , "Graphics.GL.PGI"
\ , "Graphics.GL.PGI.MiscHints"
\ , "Graphics.GL.PGI.VertexHints"
\ , "Graphics.GL.REND"
\ , "Graphics.GL.REND.ScreenCoordinates"
\ , "Graphics.GL.S3"
\ , "Graphics.GL.S3.S3TC"
\ , "Graphics.GL.SGI"
\ , "Graphics.GL.SGI.ColorMatrix"
\ , "Graphics.GL.SGI.ColorTable"
\ , "Graphics.GL.SGI.TextureColorTable"
\ , "Graphics.GL.SGIS"
\ , "Graphics.GL.SGIS.DetailTexture"
\ , "Graphics.GL.SGIS.FogFunction"
\ , "Graphics.GL.SGIS.GenerateMipmap"
\ , "Graphics.GL.SGIS.Multisample"
\ , "Graphics.GL.SGIS.PixelTexture"
\ , "Graphics.GL.SGIS.PointLineTexgen"
\ , "Graphics.GL.SGIS.PointParameters"
\ , "Graphics.GL.SGIS.SharpenTexture"
\ , "Graphics.GL.SGIS.Texture4D"
\ , "Graphics.GL.SGIS.TextureBorderClamp"
\ , "Graphics.GL.SGIS.TextureColorMask"
\ , "Graphics.GL.SGIS.TextureEdgeClamp"
\ , "Graphics.GL.SGIS.TextureFilter4"
\ , "Graphics.GL.SGIS.TextureLOD"
\ , "Graphics.GL.SGIS.TextureSelect"
\ , "Graphics.GL.SGIX"
\ , "Graphics.GL.SGIX.Async"
\ , "Graphics.GL.SGIX.AsyncHistogram"
\ , "Graphics.GL.SGIX.AsyncPixel"
\ , "Graphics.GL.SGIX.BlendAlphaMinmax"
\ , "Graphics.GL.SGIX.CalligraphicFragment"
\ , "Graphics.GL.SGIX.Clipmap"
\ , "Graphics.GL.SGIX.ConvolutionAccuracy"
\ , "Graphics.GL.SGIX.DepthTexture"
\ , "Graphics.GL.SGIX.FlushRaster"
\ , "Graphics.GL.SGIX.FogOffset"
\ , "Graphics.GL.SGIX.FragmentLighting"
\ , "Graphics.GL.SGIX.Framezoom"
\ , "Graphics.GL.SGIX.IglooInterface"
\ , "Graphics.GL.SGIX.Instruments"
\ , "Graphics.GL.SGIX.Interlace"
\ , "Graphics.GL.SGIX.IrInstrument1"
\ , "Graphics.GL.SGIX.ListPriority"
\ , "Graphics.GL.SGIX.PixelTexture"
\ , "Graphics.GL.SGIX.PixelTiles"
\ , "Graphics.GL.SGIX.PolynomialFFD"
\ , "Graphics.GL.SGIX.ReferencePlane"
\ , "Graphics.GL.SGIX.Resample"
\ , "Graphics.GL.SGIX.ScalebiasHint"
\ , "Graphics.GL.SGIX.Shadow"
\ , "Graphics.GL.SGIX.ShadowAmbient"
\ , "Graphics.GL.SGIX.Sprite"
\ , "Graphics.GL.SGIX.Subsample"
\ , "Graphics.GL.SGIX.TagSampleBuffer"
\ , "Graphics.GL.SGIX.TextureAddEnv"
\ , "Graphics.GL.SGIX.TextureCoordinateClamp"
\ , "Graphics.GL.SGIX.TextureLODBias"
\ , "Graphics.GL.SGIX.TextureMultiBuffer"
\ , "Graphics.GL.SGIX.TextureScaleBias"
\ , "Graphics.GL.SGIX.VertexPreclip"
\ , "Graphics.GL.SGIX.YCrCb"
\ , "Graphics.GL.SGIX.YCrCbA"
\ , "Graphics.GL.SUN"
\ , "Graphics.GL.SUN.ConvolutionBorderModes"
\ , "Graphics.GL.SUN.GlobalAlpha"
\ , "Graphics.GL.SUN.MeshArray"
\ , "Graphics.GL.SUN.SliceAccum"
\ , "Graphics.GL.SUN.TriangleList"
\ , "Graphics.GL.SUN.Vertex"
\ , "Graphics.GL.SUNX"
\ , "Graphics.GL.SUNX.ConstantData"
\ , "Graphics.GL.ThreeDFX"
\ , "Graphics.GL.ThreeDFX.Multisample"
\ , "Graphics.GL.ThreeDFX.Tbuffer"
\ , "Graphics.GL.ThreeDFX.TextureCompressionFXT1"
\ , "Graphics.GL.Tokens"
\ , "Graphics.GL.Types"
\ , "Graphics.GL.Version10"
\ , "Graphics.GL.Version11"
\ , "Graphics.GL.Version12"
\ , "Graphics.GL.Version13"
\ , "Graphics.GL.Version14"
\ , "Graphics.GL.Version15"
\ , "Graphics.GL.Version20"
\ , "Graphics.GL.Version21"
\ , "Graphics.GL.WIN"
\ , "Graphics.GL.WIN.PhongShading"
\ , "Graphics.GL.WIN.SpecularFog"
\ , "Test.QuickCheck"
\ , "Test.QuickCheck.All"
\ , "Test.QuickCheck.Arbitrary"
\ , "Test.QuickCheck.Exception"
\ , "Test.QuickCheck.Function"
\ , "Test.QuickCheck.Gen"
\ , "Test.QuickCheck.Gen.Unsafe"
\ , "Test.QuickCheck.Modifiers"
\ , "Test.QuickCheck.Monadic"
\ , "Test.QuickCheck.Poly"
\ , "Test.QuickCheck.Property"
\ , "Test.QuickCheck.Random"
\ , "Test.QuickCheck.State"
\ , "Test.QuickCheck.Test"
\ , "Test.QuickCheck.Text"
\ , "Data.StateVar"
\ , "Graphics.Win32"
\ , "Graphics.Win32.Control"
\ , "Graphics.Win32.Dialogue"
\ , "Graphics.Win32.GDI"
\ , "Graphics.Win32.GDI.AlphaBlend"
\ , "Graphics.Win32.GDI.Bitmap"
\ , "Graphics.Win32.GDI.Brush"
\ , "Graphics.Win32.GDI.Clip"
\ , "Graphics.Win32.GDI.Font"
\ , "Graphics.Win32.GDI.Graphics2D"
\ , "Graphics.Win32.GDI.HDC"
\ , "Graphics.Win32.GDI.Palette"
\ , "Graphics.Win32.GDI.Path"
\ , "Graphics.Win32.GDI.Pen"
\ , "Graphics.Win32.GDI.Region"
\ , "Graphics.Win32.GDI.Types"
\ , "Graphics.Win32.Icon"
\ , "Graphics.Win32.Key"
\ , "Graphics.Win32.LayeredWindow"
\ , "Graphics.Win32.Menu"
\ , "Graphics.Win32.Message"
\ , "Graphics.Win32.Misc"
\ , "Graphics.Win32.Resource"
\ , "Graphics.Win32.Window"
\ , "Graphics.Win32.Window.AnimateWindow"
\ , "Graphics.Win32.Window.ForegroundWindow"
\ , "Graphics.Win32.Window.HotKey"
\ , "Graphics.Win32.Window.IMM"
\ , "Graphics.Win32.Window.PostMessage"
\ , "Media.Win32"
\ , "System.Win32"
\ , "System.Win32.Automation"
\ , "System.Win32.Automation.Input"
\ , "System.Win32.Automation.Input.Key"
\ , "System.Win32.Automation.Input.Mouse"
\ , "System.Win32.Console"
\ , "System.Win32.Console.CtrlHandler"
\ , "System.Win32.Console.HWND"
\ , "System.Win32.Console.Title"
\ , "System.Win32.DLL"
\ , "System.Win32.DebugApi"
\ , "System.Win32.Encoding"
\ , "System.Win32.Exception.Unsupported"
\ , "System.Win32.File"
\ , "System.Win32.FileMapping"
\ , "System.Win32.HardLink"
\ , "System.Win32.Info"
\ , "System.Win32.Info.Computer"
\ , "System.Win32.Info.Version"
\ , "System.Win32.Mem"
\ , "System.Win32.MinTTY"
\ , "System.Win32.NLS"
\ , "System.Win32.Path"
\ , "System.Win32.Process"
\ , "System.Win32.Registry"
\ , "System.Win32.Security"
\ , "System.Win32.Shell"
\ , "System.Win32.SimpleMAPI"
\ , "System.Win32.String"
\ , "System.Win32.SymbolicLink"
\ , "System.Win32.Thread"
\ , "System.Win32.Time"
\ , "System.Win32.Types"
\ , "System.Win32.Utils"
\ , "System.Win32.Word"
\ , "Data.Array"
\ , "Data.Array.Base"
\ , "Data.Array.IArray"
\ , "Data.Array.IO"
\ , "Data.Array.IO.Internals"
\ , "Data.Array.IO.Safe"
\ , "Data.Array.MArray"
\ , "Data.Array.MArray.Safe"
\ , "Data.Array.ST"
\ , "Data.Array.ST.Safe"
\ , "Data.Array.Storable"
\ , "Data.Array.Storable.Internals"
\ , "Data.Array.Storable.Safe"
\ , "Data.Array.Unboxed"
\ , "Data.Array.Unsafe"
\ , "Control.Concurrent.Async"
\ , "Data.Attoparsec"
\ , "Data.Attoparsec.ByteString"
\ , "Data.Attoparsec.ByteString.Char8"
\ , "Data.Attoparsec.ByteString.Lazy"
\ , "Data.Attoparsec.Char8"
\ , "Data.Attoparsec.Combinator"
\ , "Data.Attoparsec.Internal"
\ , "Data.Attoparsec.Internal.Types"
\ , "Data.Attoparsec.Lazy"
\ , "Data.Attoparsec.Number"
\ , "Data.Attoparsec.Text"
\ , "Data.Attoparsec.Text.Lazy"
\ , "Data.Attoparsec.Types"
\ , "Data.Attoparsec.Zepto"
\ , "Control.Applicative"
\ , "Control.Arrow"
\ , "Control.Category"
\ , "Control.Concurrent"
\ , "Control.Concurrent.Chan"
\ , "Control.Concurrent.MVar"
\ , "Control.Concurrent.QSem"
\ , "Control.Concurrent.QSemN"
\ , "Control.Exception"
\ , "Control.Exception.Base"
\ , "Control.Monad"
\ , "Control.Monad.Fail"
\ , "Control.Monad.Fix"
\ , "Control.Monad.IO.Class"
\ , "Control.Monad.Instances"
\ , "Control.Monad.ST"
\ , "Control.Monad.ST.Lazy"
\ , "Control.Monad.ST.Lazy.Safe"
\ , "Control.Monad.ST.Lazy.Unsafe"
\ , "Control.Monad.ST.Safe"
\ , "Control.Monad.ST.Strict"
\ , "Control.Monad.ST.Unsafe"
\ , "Control.Monad.Zip"
\ , "Data.Bifoldable"
\ , "Data.Bifunctor"
\ , "Data.Bitraversable"
\ , "Data.Bits"
\ , "Data.Bool"
\ , "Data.Char"
\ , "Data.Coerce"
\ , "Data.Complex"
\ , "Data.Data"
\ , "Data.Dynamic"
\ , "Data.Either"
\ , "Data.Eq"
\ , "Data.Fixed"
\ , "Data.Foldable"
\ , "Data.Function"
\ , "Data.Functor"
\ , "Data.Functor.Classes"
\ , "Data.Functor.Compose"
\ , "Data.Functor.Const"
\ , "Data.Functor.Identity"
\ , "Data.Functor.Product"
\ , "Data.Functor.Sum"
\ , "Data.IORef"
\ , "Data.Int"
\ , "Data.Ix"
\ , "Data.Kind"
\ , "Data.List"
\ , "Data.List.NonEmpty"
\ , "Data.Maybe"
\ , "Data.Monoid"
\ , "Data.Ord"
\ , "Data.Proxy"
\ , "Data.Ratio"
\ , "Data.STRef"
\ , "Data.STRef.Lazy"
\ , "Data.STRef.Strict"
\ , "Data.Semigroup"
\ , "Data.String"
\ , "Data.Traversable"
\ , "Data.Tuple"
\ , "Data.Type.Bool"
\ , "Data.Type.Coercion"
\ , "Data.Type.Equality"
\ , "Data.Typeable"
\ , "Data.Unique"
\ , "Data.Version"
\ , "Data.Void"
\ , "Data.Word"
\ , "Debug.Trace"
\ , "Foreign"
\ , "Foreign.C"
\ , "Foreign.C.Error"
\ , "Foreign.C.String"
\ , "Foreign.C.Types"
\ , "Foreign.Concurrent"
\ , "Foreign.ForeignPtr"
\ , "Foreign.ForeignPtr.Safe"
\ , "Foreign.ForeignPtr.Unsafe"
\ , "Foreign.Marshal"
\ , "Foreign.Marshal.Alloc"
\ , "Foreign.Marshal.Array"
\ , "Foreign.Marshal.Error"
\ , "Foreign.Marshal.Pool"
\ , "Foreign.Marshal.Safe"
\ , "Foreign.Marshal.Unsafe"
\ , "Foreign.Marshal.Utils"
\ , "Foreign.Ptr"
\ , "Foreign.Safe"
\ , "Foreign.StablePtr"
\ , "Foreign.Storable"
\ , "GHC.Arr"
\ , "GHC.Base"
\ , "GHC.ByteOrder"
\ , "GHC.Char"
\ , "GHC.Clock"
\ , "GHC.Conc"
\ , "GHC.Conc.IO"
\ , "GHC.Conc.Signal"
\ , "GHC.Conc.Sync"
\ , "GHC.ConsoleHandler"
\ , "GHC.Constants"
\ , "GHC.Desugar"
\ , "GHC.Enum"
\ , "GHC.Environment"
\ , "GHC.Err"
\ , "GHC.Event"
\ , "GHC.Exception"
\ , "GHC.ExecutionStack"
\ , "GHC.ExecutionStack.Internal"
\ , "GHC.Exts"
\ , "GHC.Fingerprint"
\ , "GHC.Fingerprint.Type"
\ , "GHC.Float"
\ , "GHC.Float.ConversionUtils"
\ , "GHC.Float.RealFracMethods"
\ , "GHC.Foreign"
\ , "GHC.ForeignPtr"
\ , "GHC.GHCi"
\ , "GHC.Generics"
\ , "GHC.IO"
\ , "GHC.IO.Buffer"
\ , "GHC.IO.BufferedIO"
\ , "GHC.IO.Device"
\ , "GHC.IO.Encoding"
\ , "GHC.IO.Encoding.CodePage"
\ , "GHC.IO.Encoding.Failure"
\ , "GHC.IO.Encoding.Iconv"
\ , "GHC.IO.Encoding.Latin1"
\ , "GHC.IO.Encoding.Types"
\ , "GHC.IO.Encoding.UTF16"
\ , "GHC.IO.Encoding.UTF32"
\ , "GHC.IO.Encoding.UTF8"
\ , "GHC.IO.Exception"
\ , "GHC.IO.FD"
\ , "GHC.IO.Handle"
\ , "GHC.IO.Handle.FD"
\ , "GHC.IO.Handle.Internals"
\ , "GHC.IO.Handle.Lock"
\ , "GHC.IO.Handle.Text"
\ , "GHC.IO.Handle.Types"
\ , "GHC.IO.IOMode"
\ , "GHC.IO.Unsafe"
\ , "GHC.IOArray"
\ , "GHC.IORef"
\ , "GHC.Int"
\ , "GHC.List"
\ , "GHC.MVar"
\ , "GHC.Natural"
\ , "GHC.Num"
\ , "GHC.OldList"
\ , "GHC.OverloadedLabels"
\ , "GHC.PArr"
\ , "GHC.Pack"
\ , "GHC.Profiling"
\ , "GHC.Ptr"
\ , "GHC.RTS.Flags"
\ , "GHC.Read"
\ , "GHC.Real"
\ , "GHC.Records"
\ , "GHC.ST"
\ , "GHC.STRef"
\ , "GHC.Show"
\ , "GHC.Stable"
\ , "GHC.Stack"
\ , "GHC.Stack.CCS"
\ , "GHC.Stack.Types"
\ , "GHC.StaticPtr"
\ , "GHC.Stats"
\ , "GHC.Storable"
\ , "GHC.TopHandler"
\ , "GHC.TypeLits"
\ , "GHC.TypeNats"
\ , "GHC.Unicode"
\ , "GHC.Weak"
\ , "GHC.Word"
\ , "Numeric"
\ , "Numeric.Natural"
\ , "Prelude"
\ , "System.CPUTime"
\ , "System.Console.GetOpt"
\ , "System.Environment"
\ , "System.Environment.Blank"
\ , "System.Exit"
\ , "System.IO"
\ , "System.IO.Error"
\ , "System.IO.Unsafe"
\ , "System.Info"
\ , "System.Mem"
\ , "System.Mem.StableName"
\ , "System.Mem.Weak"
\ , "System.Posix.Internals"
\ , "System.Posix.Types"
\ , "System.Timeout"
\ , "Text.ParserCombinators.ReadP"
\ , "Text.ParserCombinators.ReadPrec"
\ , "Text.Printf"
\ , "Text.Read"
\ , "Text.Read.Lex"
\ , "Text.Show"
\ , "Text.Show.Functions"
\ , "Type.Reflection"
\ , "Type.Reflection.Unsafe"
\ , "Unsafe.Coerce"
\ , "Data.ByteString"
\ , "Data.ByteString.Builder"
\ , "Data.ByteString.Builder.Extra"
\ , "Data.ByteString.Builder.Internal"
\ , "Data.ByteString.Builder.Prim"
\ , "Data.ByteString.Builder.Prim.Internal"
\ , "Data.ByteString.Char8"
\ , "Data.ByteString.Internal"
\ , "Data.ByteString.Lazy"
\ , "Data.ByteString.Lazy.Builder"
\ , "Data.ByteString.Lazy.Builder.ASCII"
\ , "Data.ByteString.Lazy.Builder.Extras"
\ , "Data.ByteString.Lazy.Char8"
\ , "Data.ByteString.Lazy.Internal"
\ , "Data.ByteString.Short"
\ , "Data.ByteString.Short.Internal"
\ , "Data.ByteString.Unsafe"
\ , "Data.CallStack"
\ , "Data.CaseInsensitive"
\ , "Data.CaseInsensitive.Unsafe"
\ , "Network.CGI"
\ , "Network.CGI.Compat"
\ , "Network.CGI.Cookie"
\ , "Network.CGI.Monad"
\ , "Network.CGI.Protocol"
\ , "Data.Graph"
\ , "Data.IntMap"
\ , "Data.IntMap.Internal"
\ , "Data.IntMap.Internal.Debug"
\ , "Data.IntMap.Lazy"
\ , "Data.IntMap.Merge.Lazy"
\ , "Data.IntMap.Merge.Strict"
\ , "Data.IntMap.Strict"
\ , "Data.IntSet"
\ , "Data.IntSet.Internal"
\ , "Data.Map"
\ , "Data.Map.Internal"
\ , "Data.Map.Internal.Debug"
\ , "Data.Map.Lazy"
\ , "Data.Map.Lazy.Merge"
\ , "Data.Map.Merge.Lazy"
\ , "Data.Map.Merge.Strict"
\ , "Data.Map.Strict"
\ , "Data.Map.Strict.Internal"
\ , "Data.Map.Strict.Merge"
\ , "Data.Sequence"
\ , "Data.Sequence.Internal"
\ , "Data.Sequence.Internal.Sorting"
\ , "Data.Set"
\ , "Data.Set.Internal"
\ , "Data.Tree"
\ , "Utils.Containers.Internal.BitQueue"
\ , "Utils.Containers.Internal.BitUtil"
\ , "Utils.Containers.Internal.StrictPair"
\ , "Control.DeepSeq"
\ , "System.Directory"
\ , "System.Directory.Internal"
\ , "System.Directory.Internal.Prelude"
\ , "Control.Monad.Catch"
\ , "Control.Monad.Catch.Pure"
\ , "Control.Exception.Extensible"
\ , "Data.Graph.Inductive"
\ , "Data.Graph.Inductive.Basic"
\ , "Data.Graph.Inductive.Example"
\ , "Data.Graph.Inductive.Graph"
\ , "Data.Graph.Inductive.Internal.Heap"
\ , "Data.Graph.Inductive.Internal.Queue"
\ , "Data.Graph.Inductive.Internal.RootPath"
\ , "Data.Graph.Inductive.Internal.Thread"
\ , "Data.Graph.Inductive.Monad"
\ , "Data.Graph.Inductive.Monad.IOArray"
\ , "Data.Graph.Inductive.Monad.STArray"
\ , "Data.Graph.Inductive.NodeMap"
\ , "Data.Graph.Inductive.PatriciaTree"
\ , "Data.Graph.Inductive.Query"
\ , "Data.Graph.Inductive.Query.ArtPoint"
\ , "Data.Graph.Inductive.Query.BCC"
\ , "Data.Graph.Inductive.Query.BFS"
\ , "Data.Graph.Inductive.Query.DFS"
\ , "Data.Graph.Inductive.Query.Dominators"
\ , "Data.Graph.Inductive.Query.GVD"
\ , "Data.Graph.Inductive.Query.Indep"
\ , "Data.Graph.Inductive.Query.MST"
\ , "Data.Graph.Inductive.Query.MaxFlow"
\ , "Data.Graph.Inductive.Query.MaxFlow2"
\ , "Data.Graph.Inductive.Query.Monad"
\ , "Data.Graph.Inductive.Query.SP"
\ , "Data.Graph.Inductive.Query.TransClos"
\ , "Data.Graph.Inductive.Tree"
\ , "System.FilePath"
\ , "System.FilePath.Posix"
\ , "System.FilePath.Windows"
\ , "Numeric.Fixed"
\ , "Annotations"
\ , "ApiAnnotation"
\ , "Ar"
\ , "AsmCodeGen"
\ , "AsmUtils"
\ , "Avail"
\ , "Bag"
\ , "BasicTypes"
\ , "BinFingerprint"
\ , "BinIface"
\ , "Binary"
\ , "Bitmap"
\ , "BkpSyn"
\ , "BlockId"
\ , "BooleanFormula"
\ , "BufWrite"
\ , "BuildTyCl"
\ , "ByteCodeAsm"
\ , "ByteCodeGen"
\ , "ByteCodeInstr"
\ , "ByteCodeItbls"
\ , "ByteCodeLink"
\ , "ByteCodeTypes"
\ , "CLabel"
\ , "CPrim"
\ , "CSE"
\ , "CallArity"
\ , "CgUtils"
\ , "Check"
\ , "Class"
\ , "CmdLineParser"
\ , "Cmm"
\ , "CmmBuildInfoTables"
\ , "CmmCallConv"
\ , "CmmCommonBlockElim"
\ , "CmmContFlowOpt"
\ , "CmmExpr"
\ , "CmmImplementSwitchPlans"
\ , "CmmInfo"
\ , "CmmLayoutStack"
\ , "CmmLex"
\ , "CmmLint"
\ , "CmmLive"
\ , "CmmMachOp"
\ , "CmmMonad"
\ , "CmmNode"
\ , "CmmOpt"
\ , "CmmParse"
\ , "CmmPipeline"
\ , "CmmProcPoint"
\ , "CmmSink"
\ , "CmmSwitch"
\ , "CmmType"
\ , "CmmUtils"
\ , "CoAxiom"
\ , "CodeGen.Platform"
\ , "CodeGen.Platform.ARM"
\ , "CodeGen.Platform.ARM64"
\ , "CodeGen.Platform.NoRegs"
\ , "CodeGen.Platform.PPC"
\ , "CodeGen.Platform.PPC_Darwin"
\ , "CodeGen.Platform.SPARC"
\ , "CodeGen.Platform.X86"
\ , "CodeGen.Platform.X86_64"
\ , "CodeOutput"
\ , "Coercion"
\ , "ConLike"
\ , "Config"
\ , "Constants"
\ , "Convert"
\ , "CoreArity"
\ , "CoreFVs"
\ , "CoreLint"
\ , "CoreMonad"
\ , "CoreOpt"
\ , "CorePrep"
\ , "CoreSeq"
\ , "CoreStats"
\ , "CoreSubst"
\ , "CoreSyn"
\ , "CoreTidy"
\ , "CoreToStg"
\ , "CoreUnfold"
\ , "CoreUtils"
\ , "CostCentre"
\ , "Coverage"
\ , "Ctype"
\ , "DataCon"
\ , "Debug"
\ , "Debugger"
\ , "DebuggerUtils"
\ , "Demand"
\ , "Desugar"
\ , "Digraph"
\ , "DmdAnal"
\ , "DriverBkp"
\ , "DriverMkDepend"
\ , "DriverPhases"
\ , "DriverPipeline"
\ , "DsArrows"
\ , "DsBinds"
\ , "DsCCall"
\ , "DsExpr"
\ , "DsForeign"
\ , "DsGRHSs"
\ , "DsListComp"
\ , "DsMeta"
\ , "DsMonad"
\ , "DsUsage"
\ , "DsUtils"
\ , "Dwarf"
\ , "Dwarf.Constants"
\ , "Dwarf.Types"
\ , "DynFlags"
\ , "DynamicLoading"
\ , "Elf"
\ , "Encoding"
\ , "EnumSet"
\ , "ErrUtils"
\ , "Exception"
\ , "Exitify"
\ , "FV"
\ , "FamInst"
\ , "FamInstEnv"
\ , "FastFunctions"
\ , "FastMutInt"
\ , "FastString"
\ , "FastStringEnv"
\ , "FieldLabel"
\ , "FileCleanup"
\ , "Finder"
\ , "Fingerprint"
\ , "FiniteMap"
\ , "FlagChecker"
\ , "FloatIn"
\ , "FloatOut"
\ , "ForeignCall"
\ , "Format"
\ , "FunDeps"
\ , "GHC"
\ , "GHCi"
\ , "GhcMake"
\ , "GhcMonad"
\ , "GhcPlugins"
\ , "GraphBase"
\ , "GraphColor"
\ , "GraphOps"
\ , "GraphPpr"
\ , "HaddockUtils"
\ , "HeaderInfo"
\ , "Hooks"
\ , "Hoopl.Block"
\ , "Hoopl.Collections"
\ , "Hoopl.Dataflow"
\ , "Hoopl.Graph"
\ , "Hoopl.Label"
\ , "Hoopl.Unique"
\ , "HsBinds"
\ , "HsDecls"
\ , "HsDoc"
\ , "HsDumpAst"
\ , "HsExpr"
\ , "HsExtension"
\ , "HsImpExp"
\ , "HsLit"
\ , "HsPat"
\ , "HsSyn"
\ , "HsTypes"
\ , "HsUtils"
\ , "HscMain"
\ , "HscStats"
\ , "HscTypes"
\ , "IOEnv"
\ , "Id"
\ , "IdInfo"
\ , "IfaceEnv"
\ , "IfaceSyn"
\ , "IfaceType"
\ , "Inst"
\ , "InstEnv"
\ , "Instruction"
\ , "InteractiveEval"
\ , "InteractiveEvalTypes"
\ , "Json"
\ , "Kind"
\ , "KnownUniques"
\ , "Lexeme"
\ , "Lexer"
\ , "LiberateCase"
\ , "Linker"
\ , "ListSetOps"
\ , "ListT"
\ , "Literal"
\ , "Llvm"
\ , "Llvm.AbsSyn"
\ , "Llvm.MetaData"
\ , "Llvm.PpLlvm"
\ , "Llvm.Types"
\ , "LlvmCodeGen"
\ , "LlvmCodeGen.Base"
\ , "LlvmCodeGen.CodeGen"
\ , "LlvmCodeGen.Data"
\ , "LlvmCodeGen.Ppr"
\ , "LlvmCodeGen.Regs"
\ , "LlvmMangler"
\ , "LoadIface"
\ , "Match"
\ , "MatchCon"
\ , "MatchLit"
\ , "Maybes"
\ , "MkCore"
\ , "MkGraph"
\ , "MkId"
\ , "MkIface"
\ , "Module"
\ , "MonadUtils"
\ , "NCGMonad"
\ , "Name"
\ , "NameCache"
\ , "NameEnv"
\ , "NameSet"
\ , "NameShape"
\ , "OccName"
\ , "OccurAnal"
\ , "OptCoercion"
\ , "OrdList"
\ , "Outputable"
\ , "PIC"
\ , "PPC.CodeGen"
\ , "PPC.Cond"
\ , "PPC.Instr"
\ , "PPC.Ppr"
\ , "PPC.RegInfo"
\ , "PPC.Regs"
\ , "PackageConfig"
\ , "Packages"
\ , "Pair"
\ , "Panic"
\ , "Parser"
\ , "PatSyn"
\ , "PipelineMonad"
\ , "PlaceHolder"
\ , "Platform"
\ , "PlatformConstants"
\ , "Plugins"
\ , "PmExpr"
\ , "PprBase"
\ , "PprC"
\ , "PprCmm"
\ , "PprCmmDecl"
\ , "PprCmmExpr"
\ , "PprColour"
\ , "PprCore"
\ , "PprTyThing"
\ , "PrelInfo"
\ , "PrelNames"
\ , "PrelRules"
\ , "Pretty"
\ , "PrimOp"
\ , "ProfInit"
\ , "RdrHsSyn"
\ , "RdrName"
\ , "Reg"
\ , "RegAlloc.Graph.ArchBase"
\ , "RegAlloc.Graph.ArchX86"
\ , "RegAlloc.Graph.Coalesce"
\ , "RegAlloc.Graph.Main"
\ , "RegAlloc.Graph.Spill"
\ , "RegAlloc.Graph.SpillClean"
\ , "RegAlloc.Graph.SpillCost"
\ , "RegAlloc.Graph.Stats"
\ , "RegAlloc.Graph.TrivColorable"
\ , "RegAlloc.Linear.Base"
\ , "RegAlloc.Linear.FreeRegs"
\ , "RegAlloc.Linear.JoinToTargets"
\ , "RegAlloc.Linear.Main"
\ , "RegAlloc.Linear.PPC.FreeRegs"
\ , "RegAlloc.Linear.SPARC.FreeRegs"
\ , "RegAlloc.Linear.StackMap"
\ , "RegAlloc.Linear.State"
\ , "RegAlloc.Linear.Stats"
\ , "RegAlloc.Linear.X86.FreeRegs"
\ , "RegAlloc.Linear.X86_64.FreeRegs"
\ , "RegAlloc.Liveness"
\ , "RegClass"
\ , "RepType"
\ , "RnBinds"
\ , "RnEnv"
\ , "RnExpr"
\ , "RnFixity"
\ , "RnHsDoc"
\ , "RnModIface"
\ , "RnNames"
\ , "RnPat"
\ , "RnSource"
\ , "RnSplice"
\ , "RnTypes"
\ , "RnUnbound"
\ , "RnUtils"
\ , "RtClosureInspect"
\ , "Rules"
\ , "SAT"
\ , "SMRep"
\ , "SPARC.AddrMode"
\ , "SPARC.Base"
\ , "SPARC.CodeGen"
\ , "SPARC.CodeGen.Amode"
\ , "SPARC.CodeGen.Base"
\ , "SPARC.CodeGen.CondCode"
\ , "SPARC.CodeGen.Expand"
\ , "SPARC.CodeGen.Gen32"
\ , "SPARC.CodeGen.Gen64"
\ , "SPARC.CodeGen.Sanity"
\ , "SPARC.Cond"
\ , "SPARC.Imm"
\ , "SPARC.Instr"
\ , "SPARC.Ppr"
\ , "SPARC.Regs"
\ , "SPARC.ShortcutJump"
\ , "SPARC.Stack"
\ , "SetLevels"
\ , "SimplCore"
\ , "SimplEnv"
\ , "SimplMonad"
\ , "SimplStg"
\ , "SimplUtils"
\ , "Simplify"
\ , "SpecConstr"
\ , "Specialise"
\ , "SrcLoc"
\ , "State"
\ , "StaticPtrTable"
\ , "StgCmm"
\ , "StgCmmArgRep"
\ , "StgCmmBind"
\ , "StgCmmClosure"
\ , "StgCmmCon"
\ , "StgCmmEnv"
\ , "StgCmmExpr"
\ , "StgCmmExtCode"
\ , "StgCmmForeign"
\ , "StgCmmHeap"
\ , "StgCmmHpc"
\ , "StgCmmLayout"
\ , "StgCmmMonad"
\ , "StgCmmPrim"
\ , "StgCmmProf"
\ , "StgCmmTicky"
\ , "StgCmmUtils"
\ , "StgCse"
\ , "StgLint"
\ , "StgStats"
\ , "StgSyn"
\ , "Stream"
\ , "StringBuffer"
\ , "SysTools"
\ , "SysTools.BaseDir"
\ , "SysTools.ExtraObj"
\ , "SysTools.Info"
\ , "SysTools.Process"
\ , "SysTools.Tasks"
\ , "SysTools.Terminal"
\ , "THNames"
\ , "TargetReg"
\ , "TcAnnotations"
\ , "TcArrows"
\ , "TcBackpack"
\ , "TcBinds"
\ , "TcCanonical"
\ , "TcClassDcl"
\ , "TcDefaults"
\ , "TcDeriv"
\ , "TcDerivInfer"
\ , "TcDerivUtils"
\ , "TcEnv"
\ , "TcErrors"
\ , "TcEvidence"
\ , "TcExpr"
\ , "TcFlatten"
\ , "TcForeign"
\ , "TcGenDeriv"
\ , "TcGenFunctor"
\ , "TcGenGenerics"
\ , "TcHsSyn"
\ , "TcHsType"
\ , "TcIface"
\ , "TcInstDcls"
\ , "TcInteract"
\ , "TcMType"
\ , "TcMatches"
\ , "TcPat"
\ , "TcPatSyn"
\ , "TcPluginM"
\ , "TcRnDriver"
\ , "TcRnExports"
\ , "TcRnMonad"
\ , "TcRnTypes"
\ , "TcRules"
\ , "TcSMonad"
\ , "TcSigs"
\ , "TcSimplify"
\ , "TcSplice"
\ , "TcTyClsDecls"
\ , "TcTyDecls"
\ , "TcType"
\ , "TcTypeNats"
\ , "TcTypeable"
\ , "TcUnify"
\ , "TcValidity"
\ , "TidyPgm"
\ , "TmOracle"
\ , "ToIface"
\ , "TrieMap"
\ , "TyCoRep"
\ , "TyCon"
\ , "Type"
\ , "TysPrim"
\ , "TysWiredIn"
\ , "UnVarGraph"
\ , "UnariseStg"
\ , "Unify"
\ , "UniqDFM"
\ , "UniqDSet"
\ , "UniqFM"
\ , "UniqMap"
\ , "UniqSet"
\ , "UniqSupply"
\ , "Unique"
\ , "Util"
\ , "Var"
\ , "VarEnv"
\ , "VarSet"
\ , "Vectorise"
\ , "Vectorise.Builtins"
\ , "Vectorise.Builtins.Base"
\ , "Vectorise.Builtins.Initialise"
\ , "Vectorise.Convert"
\ , "Vectorise.Env"
\ , "Vectorise.Exp"
\ , "Vectorise.Generic.Description"
\ , "Vectorise.Generic.PADict"
\ , "Vectorise.Generic.PAMethods"
\ , "Vectorise.Generic.PData"
\ , "Vectorise.Monad"
\ , "Vectorise.Monad.Base"
\ , "Vectorise.Monad.Global"
\ , "Vectorise.Monad.InstEnv"
\ , "Vectorise.Monad.Local"
\ , "Vectorise.Monad.Naming"
\ , "Vectorise.Type.Classify"
\ , "Vectorise.Type.Env"
\ , "Vectorise.Type.TyConDecl"
\ , "Vectorise.Type.Type"
\ , "Vectorise.Utils"
\ , "Vectorise.Utils.Base"
\ , "Vectorise.Utils.Closure"
\ , "Vectorise.Utils.Hoisting"
\ , "Vectorise.Utils.PADict"
\ , "Vectorise.Utils.Poly"
\ , "Vectorise.Var"
\ , "Vectorise.Vect"
\ , "WorkWrap"
\ , "WwLib"
\ , "X86.CodeGen"
\ , "X86.Cond"
\ , "X86.Instr"
\ , "X86.Ppr"
\ , "X86.RegInfo"
\ , "X86.Regs"
\ , "Numeric.Half"
\ , "Data.Hashable"
\ , "Data.Hashable.Lifted"
\ , "Language.Haskell.Lexer"
\ , "Language.Haskell.ParseMonad"
\ , "Language.Haskell.ParseUtils"
\ , "Language.Haskell.Parser"
\ , "Language.Haskell.Pretty"
\ , "Language.Haskell.Syntax"
\ , "Control.Monad"
\ , "Data.Array"
\ , "Data.Bits"
\ , "Data.Char"
\ , "Data.Complex"
\ , "Data.Int"
\ , "Data.Ix"
\ , "Data.List"
\ , "Data.Maybe"
\ , "Data.Ratio"
\ , "Data.Word"
\ , "Foreign"
\ , "Foreign.C"
\ , "Foreign.C.Error"
\ , "Foreign.C.String"
\ , "Foreign.C.Types"
\ , "Foreign.ForeignPtr"
\ , "Foreign.Marshal"
\ , "Foreign.Marshal.Alloc"
\ , "Foreign.Marshal.Array"
\ , "Foreign.Marshal.Error"
\ , "Foreign.Marshal.Utils"
\ , "Foreign.Ptr"
\ , "Foreign.StablePtr"
\ , "Foreign.Storable"
\ , "Numeric"
\ , "Prelude"
\ , "System.Environment"
\ , "System.Exit"
\ , "System.IO"
\ , "System.IO.Error"
\ , "Array"
\ , "Bits"
\ , "CError"
\ , "CForeign"
\ , "CPUTime"
\ , "CString"
\ , "CTypes"
\ , "Char"
\ , "Complex"
\ , "Directory"
\ , "ForeignPtr"
\ , "IO"
\ , "Int"
\ , "Ix"
\ , "List"
\ , "Locale"
\ , "MarshalAlloc"
\ , "MarshalArray"
\ , "MarshalError"
\ , "MarshalUtils"
\ , "Maybe"
\ , "Monad"
\ , "Numeric"
\ , "Prelude"
\ , "Ptr"
\ , "Random"
\ , "Ratio"
\ , "StablePtr"
\ , "Storable"
\ , "System"
\ , "Time"
\ , "Word"
\ , "Trace.Hpc.Mix"
\ , "Trace.Hpc.Reflect"
\ , "Trace.Hpc.Tix"
\ , "Trace.Hpc.Util"
\ , "Text.Html"
\ , "Text.Html.BlockTable"
\ , "GHC.Integer.Logarithms.Compat"
\ , "Math.NumberTheory.Logarithms"
\ , "Math.NumberTheory.Powers.Integer"
\ , "Math.NumberTheory.Powers.Natural"
\ , "Control.Monad.Cont"
\ , "Control.Monad.Cont.Class"
\ , "Control.Monad.Error"
\ , "Control.Monad.Error.Class"
\ , "Control.Monad.Except"
\ , "Control.Monad.Identity"
\ , "Control.Monad.List"
\ , "Control.Monad.RWS"
\ , "Control.Monad.RWS.Class"
\ , "Control.Monad.RWS.Lazy"
\ , "Control.Monad.RWS.Strict"
\ , "Control.Monad.Reader"
\ , "Control.Monad.Reader.Class"
\ , "Control.Monad.State"
\ , "Control.Monad.State.Class"
\ , "Control.Monad.State.Lazy"
\ , "Control.Monad.State.Strict"
\ , "Control.Monad.Trans"
\ , "Control.Monad.Writer"
\ , "Control.Monad.Writer.Class"
\ , "Control.Monad.Writer.Lazy"
\ , "Control.Monad.Writer.Strict"
\ , "Network.Multipart"
\ , "Network.Multipart.Header"
\ , "Network"
\ , "Network.BSD"
\ , "Network.Socket"
\ , "Network.Socket.ByteString"
\ , "Network.Socket.ByteString.Lazy"
\ , "Network.Socket.Internal"
\ , "Network.URI"
\ , "System.Locale"
\ , "System.Time"
\ , "Control.Parallel"
\ , "Control.Parallel.Strategies"
\ , "Control.Seq"
\ , "Text.Parsec"
\ , "Text.Parsec.ByteString"
\ , "Text.Parsec.ByteString.Lazy"
\ , "Text.Parsec.Char"
\ , "Text.Parsec.Combinator"
\ , "Text.Parsec.Error"
\ , "Text.Parsec.Expr"
\ , "Text.Parsec.Language"
\ , "Text.Parsec.Perm"
\ , "Text.Parsec.Pos"
\ , "Text.Parsec.Prim"
\ , "Text.Parsec.String"
\ , "Text.Parsec.Text"
\ , "Text.Parsec.Text.Lazy"
\ , "Text.Parsec.Token"
\ , "Text.ParserCombinators.Parsec"
\ , "Text.ParserCombinators.Parsec.Char"
\ , "Text.ParserCombinators.Parsec.Combinator"
\ , "Text.ParserCombinators.Parsec.Error"
\ , "Text.ParserCombinators.Parsec.Expr"
\ , "Text.ParserCombinators.Parsec.Language"
\ , "Text.ParserCombinators.Parsec.Perm"
\ , "Text.ParserCombinators.Parsec.Pos"
\ , "Text.ParserCombinators.Parsec.Prim"
\ , "Text.ParserCombinators.Parsec.Token"
\ , "Text.PrettyPrint"
\ , "Text.PrettyPrint.Annotated"
\ , "Text.PrettyPrint.Annotated.HughesPJ"
\ , "Text.PrettyPrint.Annotated.HughesPJClass"
\ , "Text.PrettyPrint.HughesPJ"
\ , "Text.PrettyPrint.HughesPJClass"
\ , "Control.Monad.Primitive"
\ , "Data.Primitive"
\ , "Data.Primitive.Addr"
\ , "Data.Primitive.Array"
\ , "Data.Primitive.ByteArray"
\ , "Data.Primitive.MVar"
\ , "Data.Primitive.MachDeps"
\ , "Data.Primitive.MutVar"
\ , "Data.Primitive.PrimArray"
\ , "Data.Primitive.Ptr"
\ , "Data.Primitive.SmallArray"
\ , "Data.Primitive.Types"
\ , "Data.Primitive.UnliftedArray"
\ , "System.Cmd"
\ , "System.Process"
\ , "System.Process.Internals"
\ , "System.Random"
\ , "Text.Regex.Base"
\ , "Text.Regex.Base.Context"
\ , "Text.Regex.Base.Impl"
\ , "Text.Regex.Base.RegexLike"
\ , "Text.Regex"
\ , "Text.Regex.Posix"
\ , "Text.Regex.Posix.ByteString"
\ , "Text.Regex.Posix.ByteString.Lazy"
\ , "Text.Regex.Posix.Sequence"
\ , "Text.Regex.Posix.String"
\ , "Text.Regex.Posix.Wrap"
\ , "Data.ByteString.Builder.Scientific"
\ , "Data.Scientific"
\ , "Data.Text.Lazy.Builder.Scientific"
\ , "Data.List.Split"
\ , "Data.List.Split.Internals"
\ , "Control.Concurrent.STM"
\ , "Control.Concurrent.STM.TArray"
\ , "Control.Concurrent.STM.TBQueue"
\ , "Control.Concurrent.STM.TChan"
\ , "Control.Concurrent.STM.TMVar"
\ , "Control.Concurrent.STM.TQueue"
\ , "Control.Concurrent.STM.TSem"
\ , "Control.Concurrent.STM.TVar"
\ , "Control.Monad.STM"
\ , "Data.Generics"
\ , "Data.Generics.Aliases"
\ , "Data.Generics.Basics"
\ , "Data.Generics.Builders"
\ , "Data.Generics.Instances"
\ , "Data.Generics.Schemes"
\ , "Data.Generics.Text"
\ , "Data.Generics.Twins"
\ , "Generics.SYB"
\ , "Generics.SYB.Aliases"
\ , "Generics.SYB.Basics"
\ , "Generics.SYB.Builders"
\ , "Generics.SYB.Instances"
\ , "Generics.SYB.Schemes"
\ , "Generics.SYB.Text"
\ , "Generics.SYB.Twins"
\ , "Language.Haskell.TH"
\ , "Language.Haskell.TH.LanguageExtensions"
\ , "Language.Haskell.TH.Lib"
\ , "Language.Haskell.TH.Lib.Internal"
\ , "Language.Haskell.TH.Ppr"
\ , "Language.Haskell.TH.PprLib"
\ , "Language.Haskell.TH.Quote"
\ , "Language.Haskell.TH.Syntax"
\ , "Data.Text"
\ , "Data.Text.Array"
\ , "Data.Text.Encoding"
\ , "Data.Text.Encoding.Error"
\ , "Data.Text.Foreign"
\ , "Data.Text.IO"
\ , "Data.Text.Internal"
\ , "Data.Text.Internal.Builder"
\ , "Data.Text.Internal.Builder.Functions"
\ , "Data.Text.Internal.Builder.Int.Digits"
\ , "Data.Text.Internal.Builder.RealFloat.Functions"
\ , "Data.Text.Internal.Encoding.Fusion"
\ , "Data.Text.Internal.Encoding.Fusion.Common"
\ , "Data.Text.Internal.Encoding.Utf16"
\ , "Data.Text.Internal.Encoding.Utf32"
\ , "Data.Text.Internal.Encoding.Utf8"
\ , "Data.Text.Internal.Functions"
\ , "Data.Text.Internal.Fusion"
\ , "Data.Text.Internal.Fusion.CaseMapping"
\ , "Data.Text.Internal.Fusion.Common"
\ , "Data.Text.Internal.Fusion.Size"
\ , "Data.Text.Internal.Fusion.Types"
\ , "Data.Text.Internal.IO"
\ , "Data.Text.Internal.Lazy"
\ , "Data.Text.Internal.Lazy.Encoding.Fusion"
\ , "Data.Text.Internal.Lazy.Fusion"
\ , "Data.Text.Internal.Lazy.Search"
\ , "Data.Text.Internal.Private"
\ , "Data.Text.Internal.Read"
\ , "Data.Text.Internal.Search"
\ , "Data.Text.Internal.Unsafe"
\ , "Data.Text.Internal.Unsafe.Char"
\ , "Data.Text.Internal.Unsafe.Shift"
\ , "Data.Text.Lazy"
\ , "Data.Text.Lazy.Builder"
\ , "Data.Text.Lazy.Builder.Int"
\ , "Data.Text.Lazy.Builder.RealFloat"
\ , "Data.Text.Lazy.Encoding"
\ , "Data.Text.Lazy.IO"
\ , "Data.Text.Lazy.Internal"
\ , "Data.Text.Lazy.Read"
\ , "Data.Text.Read"
\ , "Data.Text.Unsafe"
\ , "System.Random.TF"
\ , "System.Random.TF.Gen"
\ , "System.Random.TF.Init"
\ , "System.Random.TF.Instances"
\ , "Data.Time"
\ , "Data.Time.Calendar"
\ , "Data.Time.Calendar.Easter"
\ , "Data.Time.Calendar.Julian"
\ , "Data.Time.Calendar.MonthDay"
\ , "Data.Time.Calendar.OrdinalDate"
\ , "Data.Time.Calendar.WeekDate"
\ , "Data.Time.Clock"
\ , "Data.Time.Clock.POSIX"
\ , "Data.Time.Clock.System"
\ , "Data.Time.Clock.TAI"
\ , "Data.Time.Format"
\ , "Data.Time.LocalTime"
\ , "Control.Applicative.Backwards"
\ , "Control.Applicative.Lift"
\ , "Control.Monad.Signatures"
\ , "Control.Monad.Trans.Accum"
\ , "Control.Monad.Trans.Class"
\ , "Control.Monad.Trans.Cont"
\ , "Control.Monad.Trans.Error"
\ , "Control.Monad.Trans.Except"
\ , "Control.Monad.Trans.Identity"
\ , "Control.Monad.Trans.List"
\ , "Control.Monad.Trans.Maybe"
\ , "Control.Monad.Trans.RWS"
\ , "Control.Monad.Trans.RWS.Lazy"
\ , "Control.Monad.Trans.RWS.Strict"
\ , "Control.Monad.Trans.Reader"
\ , "Control.Monad.Trans.Select"
\ , "Control.Monad.Trans.State"
\ , "Control.Monad.Trans.State.Lazy"
\ , "Control.Monad.Trans.State.Strict"
\ , "Control.Monad.Trans.Writer"
\ , "Control.Monad.Trans.Writer.Lazy"
\ , "Control.Monad.Trans.Writer.Strict"
\ , "Data.Functor.Constant"
\ , "Data.Functor.Reverse"
\ , "Control.Monad.Trans.Instances"
\ , "Data.Functor.Classes.Generic"
\ , "Data.Functor.Classes.Generic.Internal"
\ , "System.Posix"
\ , "System.Posix.ByteString"
\ , "System.Posix.ByteString.FilePath"
\ , "System.Posix.Directory"
\ , "System.Posix.Directory.ByteString"
\ , "System.Posix.DynamicLinker"
\ , "System.Posix.DynamicLinker.ByteString"
\ , "System.Posix.DynamicLinker.Module"
\ , "System.Posix.DynamicLinker.Module.ByteString"
\ , "System.Posix.DynamicLinker.Prim"
\ , "System.Posix.Env"
\ , "System.Posix.Env.ByteString"
\ , "System.Posix.Error"
\ , "System.Posix.Fcntl"
\ , "System.Posix.Files"
\ , "System.Posix.Files.ByteString"
\ , "System.Posix.IO"
\ , "System.Posix.IO.ByteString"
\ , "System.Posix.Process"
\ , "System.Posix.Process.ByteString"
\ , "System.Posix.Process.Internals"
\ , "System.Posix.Resource"
\ , "System.Posix.Semaphore"
\ , "System.Posix.SharedMem"
\ , "System.Posix.Signals"
\ , "System.Posix.Signals.Exts"
\ , "System.Posix.Temp"
\ , "System.Posix.Temp.ByteString"
\ , "System.Posix.Terminal"
\ , "System.Posix.Terminal.ByteString"
\ , "System.Posix.Time"
\ , "System.Posix.Unistd"
\ , "System.Posix.User"
\ , "Data.HashMap.Lazy"
\ , "Data.HashMap.Strict"
\ , "Data.HashSet"
\ , "Data.Vector"
\ , "Data.Vector.Fusion.Bundle"
\ , "Data.Vector.Fusion.Bundle.Monadic"
\ , "Data.Vector.Fusion.Bundle.Size"
\ , "Data.Vector.Fusion.Stream.Monadic"
\ , "Data.Vector.Fusion.Util"
\ , "Data.Vector.Generic"
\ , "Data.Vector.Generic.Base"
\ , "Data.Vector.Generic.Mutable"
\ , "Data.Vector.Generic.Mutable.Base"
\ , "Data.Vector.Generic.New"
\ , "Data.Vector.Internal.Check"
\ , "Data.Vector.Mutable"
\ , "Data.Vector.Primitive"
\ , "Data.Vector.Primitive.Mutable"
\ , "Data.Vector.Storable"
\ , "Data.Vector.Storable.Internal"
\ , "Data.Vector.Storable.Mutable"
\ , "Data.Vector.Unboxed"
\ , "Data.Vector.Unboxed.Base"
\ , "Data.Vector.Unboxed.Mutable"
\ , "Text.XHtml"
\ , "Text.XHtml.Debug"
\ , "Text.XHtml.Frameset"
\ , "Text.XHtml.Strict"
\ , "Text.XHtml.Table"
\ , "Text.XHtml.Transitional"
\ , "Codec.Compression.GZip"
\ , "Codec.Compression.Zlib"
\ , "Codec.Compression.Zlib.Internal"
\ , "Codec.Compression.Zlib.Raw"
\ , "Web.Spock"
\ , "Web.Spock.Config"
\ , "Web.Spock.Internal.SessionManager"
\ , "Web.Spock.Internal.SessionVault"
\ , "Web.Spock.SessionActions"
\ , "Web.Spock.Api"
\ , "Web.Spock.Auth"
\ , "Web.Spock.Action"
\ , "Web.Spock.Core"
\ , "Web.Spock.Internal.Cookies"
\ , "Web.Spock.Internal.Util"
\ , "Web.Spock.Routing"
\ , "Web.Spock.Digestive"
\ , "Database.Esqueleto"
\ , "Database.Esqueleto.Internal.Language"
\ , "Database.Esqueleto.Internal.Sql"
\ , "Database.Esqueleto.PostgreSQL"
\ , "Database.Persist"
\ , "Database.Persist.Class"
\ , "Database.Persist.Quasi"
\ , "Database.Persist.Sql"
\ , "Database.Persist.Sql.Types.Internal"
\ , "Database.Persist.Sql.Util"
\ , "Database.Persist.Types"
\ , "Database.Persist.MySQL"
\ , "Database.Persist.Postgresql"
\ , "Database.Persist.Postgresql.JSON"
\ , "Database.Persist.Redis"
\ , "Database.Persist.Sqlite"
\ , "Database.Sqlite"
\ , "Servant.API"
\ , "Servant.API.Alternative"
\ , "Servant.API.BasicAuth"
\ , "Servant.API.Capture"
\ , "Servant.API.ContentTypes"
\ , "Servant.API.Description"
\ , "Servant.API.Empty"
\ , "Servant.API.Experimental.Auth"
\ , "Servant.API.Generic"
\ , "Servant.API.Header"
\ , "Servant.API.HttpVersion"
\ , "Servant.API.Internal.Test.ComprehensiveAPI"
\ , "Servant.API.IsSecure"
\ , "Servant.API.Modifiers"
\ , "Servant.API.QueryParam"
\ , "Servant.API.Raw"
\ , "Servant.API.RemoteHost"
\ , "Servant.API.ReqBody"
\ , "Servant.API.ResponseHeaders"
\ , "Servant.API.Stream"
\ , "Servant.API.Sub"
\ , "Servant.API.TypeLevel"
\ , "Servant.API.Vault"
\ , "Servant.API.Verbs"
\ , "Servant.API.WithNamedContext"
\ , "Servant.Links"
\ , "Servant.Utils.Enter"
\ , "Servant.Utils.Links"
\ , "Servant.Auth"
\ , "Servant.Client"
\ , "Servant.Client.Internal.HttpClient"
\ , "Servant"
\ , "Servant.Server"
\ , "Servant.Server.Experimental.Auth"
\ , "Servant.Server.Generic"
\ , "Servant.Server.Internal"
\ , "Servant.Server.Internal.BasicAuth"
\ , "Servant.Server.Internal.Context"
\ , "Servant.Server.Internal.Handler"
\ , "Servant.Server.Internal.Router"
\ , "Servant.Server.Internal.RoutingApplication"
\ , "Servant.Server.Internal.ServantErr"
\ , "Servant.Server.StaticFiles"
\ , "Servant.Utils.StaticFiles"
\ ]
