class Spree::Promotion::Rules::ItemTotalDashboard < Spree::Promotion::Rules::BaseDashboard
  # ATTRIBUTE_TYPES
  # a hash that describes the type of each of the model's fields.
  #
  # Each different type represents an Administrate::Field object,
  # which determines how the attribute is displayed
  # on pages throughout the dashboard.
  ATTRIBUTE_TYPES = {
    id: Field::Number,
    type: Field::String,
    code: Field::String,
    promotion: Field::BelongsTo,
    product_group_id: Field::Number,
    preferences: Field::Text,
    created_at: Field::DateTime,
    updated_at: Field::DateTime,

    preferred_amount: Field::Money,
    preferred_currency: Field::Select.with_options(collection: Spree::Config.available_currencies.map(&:iso_code), selected: Spree::Config.currency),
    preferred_operator: Field::Select.with_options(collection: Spree::Promotion::Rules::ItemTotal.operator_options),
  }.freeze

  # COLLECTION_ATTRIBUTES
  # an array of attributes that will be displayed on the model's index page.
  #
  # By default, it's limited to four items to reduce clutter on index pages.
  # Feel free to add, remove, or rearrange items.
  COLLECTION_ATTRIBUTES = %i[
    promotion
    type
  ].freeze

  # SHOW_PAGE_ATTRIBUTES
  # an array of attributes that will be displayed on the model's show page.
  SHOW_PAGE_ATTRIBUTES = %i[
    id
    promotion
    type
    code
    product_group_id
    preferences
    created_at
    updated_at
  ].freeze

  # FORM_ATTRIBUTES
  # an array of attributes that will be displayed
  # on the model's form (`new` and `edit`) pages.
  FORM_ATTRIBUTES = %i[
    preferred_operator
    preferred_amount
    preferred_currency
  ].freeze

  # COLLECTION_FILTERS
  # a hash that defines filters that can be used while searching via the search
  # field of the dashboard.
  #
  # For example to add an option to search for open resources by typing "open:"
  # in the search field:
  #
  #   COLLECTION_FILTERS = {
  #     open: ->(resources) { resources.where(open: true) }
  #   }.freeze
  COLLECTION_FILTERS = {}.freeze

  # Overwrite this method to customize how item totals are displayed
  # across all pages of the admin dashboard.
  #
  def display_resource(item_total)
    translated_operator = resource_class.operator_options.detect { |a| a[1] == item_total.preferred_operator.to_sym }.first

    "Item total #{translated_operator} #{item_total.preferred_amount} #{item_total.preferred_currency}"
  end
end
