module Admin
  class Spree::Order::CustomersController < Spree::Order::BaseController
    def resource_class
      return ::Spree.user_class if %w[index show].include?(action_name)

      ::Spree::Order
    end

    # Overwrite any of the RESTful controller actions to implement custom behavior
    # For example, you may want to send an email after a foo is updated.
    #
    # def update
    #   super
    #   send_foo_updated_email(requested_resource)
    # end

    # Override this method to specify custom lookup behavior.
    # This will be used to set the resource for the `show`, `edit`, and `update`
    # actions.
    #
    # def find_resource(param)
    #   Foo.find_by!(slug: param)
    # end

    private

    # The result of this lookup will be available as `requested_resource`

    # Override this if you have certain roles that require a subset
    # this will be used to set the records shown on the `index` action.
    #
    def scoped_resource
      scoped_resource ||= resource_class.where(email: requested_parent_resource.email)
                                        .or(resource_class.where(id: requested_parent_resource.user_id))

      # Administrate ransack
      @ransack_results = authorized_scope(scoped_resource).ransack(params[:q])
      @ransack_results.result(distinct: true)
    end

    def requested_resource
      @requested_resource ||= find_resource.tap do |resource|
        authorize_resource(resource)
      end
    end

    def find_resource
      resource = scoped_resource.first

      resource ||= resource_class.new(email: requested_parent_resource.email)
    end

    # Override `resource_params` if you want to transform the submitted
    # data before it's persisted. For example, the following would turn all
    # empty values into nil values. It uses other APIs such as `resource_class`
    # and `dashboard`:
    #
    # def resource_params
    #   params.require(resource_class.model_name.param_key).
    #     permit(dashboard.permitted_attributes).
    #     transform_values { |value| value == "" ? nil : value }
    # end

    # See https://administrate-prototype.herokuapp.com/customizing_controller_actions
    # for more information
  end
end
