<p align="center">
  <img src="https://github.com/amirhnajafiz/Seo3000/blob/master/seo.jpg" width=700 /><br />
  <img src="https://camo.githubusercontent.com/8b52e302122a31c683c4a9cf8e71d29cc8aba3ebb6a5ac7ae7818b5b14ba1c15/68747470733a2f2f6564656e742e6769746875622e696f2f537570657254696e7949636f6e732f696d616765732f7376672f676f6f676c652e737667" width=50 />
  <img src="https://camo.githubusercontent.com/79ff395e59e194893fea2c005c0c8157c8ee2fb0dde70ae7be6ce1cde044cde8/68747470733a2f2f6564656e742e6769746875622e696f2f537570657254696e7949636f6e732f696d616765732f7376672f676f6f676c655f706f6463617374732e737667" width=50 />
</p>

## Introduction
<h4><a href="https://www.googleadservices.com/pagead/aclk?sa=L&ai=DChcSEwiwo9GD3pPvAhULzXcKHTh-BUAYABAAGgJlZg&ohost=www.google.com&cid=CAESQeD253MtUXmiy4W7FNvwOxrlQ_51PBwljA6FkXK-cmGZb9-QriSX8bza5B--KXnZjxAWB7XloifNh5T13raHfj9i&sig=AOD64_3hN6OKYdT6aZdUjReLrK1VrxSMfg&q&adurl&ved=2ahUKEwjM5cqD3pPvAhVOPOwKHRltAjAQ0Qx6BAgHEAE">What is Seo ?</a></h4>
<p>
Search engine optimization (SEO) is the process of improving the quality and quantity of website traffic to a website or a web page from search engines. 
SEO targets unpaid traffic (known as "natural" or "organic" results) rather than direct traffic or paid traffic. 
Unpaid traffic may originate from different kinds of searches, including image search, video search, academic search, news search, and industry-specific vertical search engines.

As an Internet marketing strategy, SEO considers how search engines work, the computer-programmed algorithms that dictate search engine behavior, what people search for, the actual search terms or keywords typed into search engines, and which search engines are preferred by their targeted audience. SEO is performed because a website will receive more visitors from a search engine when websites rank higher on the search engine results page (SERP). These visitors can then potentially be converted into customers.
</p>

<a href="https://en.wikipedia.org/wiki/Search_engine_optimization#History">Check the history</a>

<h4>How does Seo work ?</h4>
<p>
Search engines such as Google and Bing use bots to crawl pages on the web, going from site to site, collecting information about those pages and putting them in an index. Next, algorithms analyze pages in the index, taking into account hundreds of ranking factors or signals, to determine the order pages should appear in the search results for a given query.

Search ranking factors can be considered proxies for aspects of the user experience. Our Periodic Table of SEO Factors organizes the factors into six main categories and weights each based on its overall importance to SEO. For example, content quality and keyword research are key factors of content optimization, and crawlability and mobile-friendliness are important site architecture factors.

The search algorithms are designed to surface relevant, authoritative pages and provide users with an efficient search experience. Optimizing your site and content with these factors in mind can help your pages rank higher in the search results.

Unlike paid search ads, you can’t pay search engines to get higher organic search rankings.
</p>

<a href="https://searchengineland.com/guide/what-is-seo">Check the full information</a>

<a href="https://digitalmarketinginstitute.com/blog/what-is-seo-and-why-is-it-important">What is SEO and Why is it Important ?</a>

<h4>What is this repository for ?</h4>
<p>
Since there are various sources for learning seo, I decided to collect good sources and useful tools of Seo.
This repository contains all of the subjects you need to know about Seo and tools for using it in your website.
</p>

## Content
  * #### Learning Seo
    * [Learn Seo](https://github.com/dwyl/learn-seo)
    * [Beginners Guide to Seo](https://moz.com/beginners-guide-to-seo)
    * [Basic Learning](https://www.simplilearn.com/digital-marketing/seo-basics-training-course?utm_source=google&utm_medium=cpc&utm_term=&utm_content=378783214504&utm_device=c&utm_campaign=Search-DigitalBusinessCluster-DM-DMDSA-ROW-Main-AllDevice-adgroup-Category&gclid=CjwKCAiAu8SABhAxEiwAsodSZMzaOVf6SiIUzwHJ72irAaRHk4PJEiY6GeWrY-y-IAvY6uGz2qzWYBoCIDoQAvD_BwE)
    * [Steps to a Google friendly site](https://support.google.com/webmasters/answer/40349?hl=en)
    * [Ultimate WordPress SEO Guide for Beginners](https://www.wpbeginner.com/wordpress-seo/)
    * [5 Easy tips](https://searchengineland.com/seo-simple-child-can-5-easy-steps-237473)
    * [Basic Seo](https://ahrefs.com/blog/seo-basics/)
    * [An Overview of SEO](https://www.bluehost.com/blog/an-overview-of-seo/?utm_source=google&utm_medium=genericsearch&gclid=CjwKCAjwgZuDBhBTEiwAXNofRMWTELURMGQmfTNIeGz8A-lD74BhiyfXBWjurpGFtCogGCtR0o7YghoClMkQAvD_BwE&gclsrc=aw.ds)
    * [Search Engine Optimization (SEO) Starter Guide](https://developers.google.com/search/docs/beginner/seo-starter-guide)
  * #### Seo do it yourself
    * [11 Do it yourself](https://www.practicalecommerce.com/10-do-it-yourself-seo-tips-to-save-money)
    * [Guide to Seo](https://neilpatel.com/blog/simple-guide-to-seo/)
    * [9 Essential Rules for SEO Copywriting in 2020](https://www.wordstream.com/blog/ws/2019/12/03/seo-copywriting)
    * [Deep into Seo](https://www.singlegrain.com/seo/effective-seo-techniques-that-work/)
    * [Advance Seo Techniques](https://neilpatel.com/blog/10-advanced-seo-techniques-thatll-double-your-search-traffic/)
  * #### Seo Friendly Pdfs
    * [13 tips](https://www.searchenginejournal.com/pdf-seo-best-practices/59975/)
    * [How to do](https://www.contentkingapp.com/academy/seo-optimize-your-pdf-files/)
    * [Why PDFs are not ideal for SEO](https://blog.marketmuse.com/why-pdfs-are-not-ideal-for-seo/)
  * #### Tools
    * [Search Engine Optimization Tools](https://www.capterra.com/sem-compare/seo-software?gclid=CjwKCAiA6aSABhApEiwA6Cbm_4sAAAb5g8rHUveINIgycRPV58lmSCj0pzSWDhk5NAgUHofw-JONRBoCHJ4QAvD_BwE)
    * [Seo Service](https://seosherpa.com/services/?utm_source=google&utm_medium=cpc&utm_campaign=adwords_express&utm_term=&utm_content=The_leaders_in_Dubai_SEO&gclid=Cj0KCQiA0rSABhDlARIsAJtjfCcidOJUk9kmGCYSTps2eN4zzM94aCAdjI2t-dkNBcmVA4jZYWXzomYaAsFcEALw_wcB)
    * [Google Trends](https://trends.google.com/trends/)
    * [Moz keyword explorer](https://moz.com/explorer)
    * [Google keyword planner](http://adwords.google.com/keywordplanner)
    * [Seo tools](https://www.verbolia.com/seo-tools/?utm_term=%2Bbest%20%2Bseo%20%2Btools&utm_campaign=Search+-+Generic&utm_source=adwords&utm_medium=ppc&hsa_acc=5582735397&hsa_cam=11693895249&hsa_grp=116383019969&hsa_ad=481998358011&hsa_src=g&hsa_tgt=kwd-21454981279&hsa_kw=%2Bbest%20%2Bseo%20%2Btools&hsa_mt=b&hsa_net=adwords&hsa_ver=3&gclid=Cj0KCQiAmL-ABhDFARIsAKywVafRc0rfQ6myyv5Nxa-qPtsQIDz0Ld1_-2Fsf9uGSAEEJjoazEfuDTUaAmXQEALw_wcB)
    * [Ultimate Seo tools](https://seranking.com/ultimate-seo-tools.html?sou1=Adw&gr1=Search_616700562&tg1=New&kw1=best%20seo%20tool&gclid=Cj0KCQiAmL-ABhDFARIsAKywVaefoZhd_lDeLDGhLvnCtt_svFsKYz6Pjwfrs5Q5yGLEjFfxrohSV74aAqbjEALw_wcB)
    * [Python Seo Data Refrence](https://www.searchenginejournal.com/python-seo-data-reference-guide/287927/#close)
    * [Neos Seo](https://github.com/neos/neos-seo)
    * [Python for Seo](https://www.jcchouinard.com/python-for-seo/)
    * [Duplicate Content](https://yoast.com/duplicate-content/)
    * [Website SEO checker](https://www.semrush.com/lp/site-audit-new/en/?kw=%2Bseo%20%2Bsite%20%2Breport&cmp=WW_SRCH_Site_Audit_EN&label=site_audit&Network=g&Device=c&utm_content=455422558317&kwid=kwd-38285303472&cmpid=10803399811&agpid=113197629344&BU=Core&extid=&adpos=&gclid=CjwKCAiAjeSABhAPEiwAqfxURRKFQvjhM1oz3FhtqsoG-JzMiZ1I9OIFW11RnYL0kAoCuz3p7C_kWxoCtocQAvD_BwE)
    * [Automate your SEO reporting and dashboards with Supermetrics](https://supermetrics.com/seo?utm_source=google&utm_medium=cpc&utm_campaign=searchremarketing&utm_adgroup=seo&utm_category=adw-retargeting&utm_term=seo&location=&gclid=CjwKCAjwxuuCBhATEiwAIIIz0fugraPMiMTVS5_Nv2NJUm-lkNKx2jslq7g4SMR6TZ0UE0IPrKpG5hoCZnYQAvD_BwE)
    * [Check your website SEO](https://web.dev/measure/?gclid=CjwKCAjwu5CDBhB9EiwA0w6sLUmhN6YJvbxQmpOCJVAs3v20ou5ZwUiZnpkIwCce4ZO6GowMO8P2gxoCzRsQAvD_BwE)
    * [Keyword Research & Analysis Tools](https://www.similarweb.com/corp/marketing/keyword-research/?utm_source=adwords&utm_medium=paid&utm_content=seotool&utm_campaign=gs_seotool_europe_dsk_nt&gclid=CjwKCAjw3pWDBhB3EiwAV1c5rDGvcuvqZNtIljJdxTwP6WMhYLlI3v5qBm1V_gnfjGnQAlrgKhUFjBoCGRAQAvD_BwE)
  * #### SEO in Wordpress 
    * [Wordpress Seo Plugin](https://wordpress.org/plugins/wordpress-seo/)
    * [Wordpress RankBear](https://rankbear.com/?gclid=CjwKCAiAr6-ABhAfEiwADO4sfan1aAA7DGPpOHD3VbW9RRW75ACAoFBlQBiwsWCVSbd0MQy6sMrNBhoCW0EQAvD_BwE)
    * [YOAST](https://yoast.com/)
  * #### Other contents
    * [10 things SEO is not](https://infomedia.com/blog/10-things-seo-is-not/)
    * [Are getting SEO basics right ?](https://www.semrush.com/blog/seo-basics)
    * [Customer Journey and SEO](https://www.searchenginejournal.com/customer-journey-seo/351938/)
    * [The Customer Journey and Search Engine Optimization](https://seoforgrowth.com/customer-journey-seo/)
    * [12 Reasons Why SEO is importent for business](https://www.searchenginejournal.com/why-seo-is-important-for-business/248101/)
    * [22 Reasons why your search ranking drops](https://www.searchenginejournal.com/why-search-rankings-traffic-drop/264617/)
    * [22 essentials you need for optimizing your site](https://www.searchenginewatch.com/2016/01/21/seo-basics-22-essentials-you-need-for-optimizing-your-site/)
    * [11 Most Common On-Site SEO Mistakes](https://www.semrush.com/blog/semrush-study-on-site-seo-issues/?kw=&cmp=EE_SRCH_DSA_Blog_Core_BU_EN&label=dsa_pagefeed&Network=g&Device=c&utm_content=484311153250&kwid=dsa-1057183196355&cmpid=11776420745&agpid=113999302226&BU=Core&extid=167385106020&adpos=&gclid=CjwKCAjw6fCCBhBNEiwAem5SOz6tfLpKuK9fihFdf4d-XUokqUm8bF-u_TsGe72bmO5poNQc-VBhZRoCWwoQAvD_BwE)
    * [Good vs Bad SEO: How to Not Get Penalized](https://www.spiralytics.com/blog/good-vs-bad-seo-not-get-penalized/)
    * [What Is Negative SEO? (And How To Tackle It)](https://www.semrush.com/blog/what-is-negative-seo/?kw=&cmp=EE_SRCH_DSA_Blog_Core_BU_EN&label=dsa_pagefeed&Network=g&Device=c&utm_content=484308653496&kwid=dsa-1053501807827&cmpid=11776420745&agpid=113999312786&BU=Core&extid=167385869633&adpos=&gclid=CjwKCAjwr_uCBhAFEiwAX8YJgemOZwJpe1hhebfvvoEf10CuJsQpN7jyvHH8fFaBH9ySbHa69ToyEhoCxp0QAvD_BwE)
    * [10 Ways to improve SEO in 2021](https://www.semrush.com/blog/improve-seo/?kw=&cmp=EE_SRCH_DSA_Blog_Core_BU_EN&label=dsa_pagefeed&Network=g&Device=c&utm_content=484308655416&kwid=aud-298650603765:dsa-1053501806547&cmpid=11776420745&agpid=113999315266&BU=Core&extid=167385869672&adpos=&gclid=Cj0KCQjw9YWDBhDyARIsADt6sGaigE_F04Wof-nuRgIRRqSDSAjHjl6r-19Am2qARkMy0KnM4-TxuAEaArZwEALw_wcB)
    * [Get more sales and rank higher on search](https://www.brandpush.co/?utm_source=GoogleAds&utm_medium=Search&utm_campaign=BP%20-%20Search%20CPA&utm_term=SEO&utm_content=Responsive%20Ad&campaignid=12047018827&adgroupid=116408986539&adid=490886406941&gclid=Cj0KCQjwmIuDBhDXARIsAFITC_79JrL4w5Sq3KvETAMLRPHA8WBl1YLHX9qrxmaAroQH3w8Uc1-D50gaArSoEALw_wcB)
    * [How to Get SEO Clients from Just 1 Hour a Day](https://growhackscale.com/blog/how-to-get-seo-clients)
    * [Best SEO Software](https://www.g2.com/categories/seo)

## Source Links
<ul>
  <li><a href="https://www.linkedin.com/learning-login/share?forceAccount=false&redirect=https%3A%2F%2Fwww.linkedin.com%2Flearning%2Fseo-foundations-2%3Ftrk%3Dshare_ent_url%26shareId%3D934094eb-7823-4abd-8e88-6722975e2040" target="blank"> Linkedin Seo Course By "David Booth" </a></li>
  <li><a href="https://trends.google.com/trends/explore" target="blank"> Google Keywords Trends </a></li>
  <li><a href="https://schema.org/docs/schemas.html" target="blank"> Schema site for images </a></li>
  <li><a href="https://www.searchberg.com/?gclid=Cj0KCQiAmfmABhCHARIsACwPRABxnolCkp9OwQrP2lmy5eVcN7hb7ht7Nvebf8wAog1wHUg3qQMIo4QaAgahEALw_wcB" target="blank"> Seo Service </a></li>
  <li><a href="https://moz.com/beginners-guide-to-seo/why-search-engine-marketing-is-necessary" target="blank"> SEO 101: What is it ? </a></li>
  <li><a href="https://samuelschmitt.com/beginner-journey-into-seo/" target="blank"> Samuel Schmitt Journey in SEO </a></li>
  <li><a href="https://www.udemy.com/courses/marketing/search-engine-optimization/" target="blank"> Udmey Course </a></li>
  <li><a href="https://www.linkedin.com/learning/seo-link-building" target="blank"> SEO: link building Course By Anson Alexander </a></li>
  <li><a href="https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=&cad=rja&uact=8&ved=2ahUKEwiO1b6gofPvAhVTyzgGHbnsAj8QwqsBMBF6BAguEAM&url=https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DOYRkIGaP80M&usg=AOvVaw2hG5eg7EtV_JsRn5btq-xj" target="blank"> Complete SEO Course for beginners </a></li>
</ul>

## Source Books
<ol>
 <li> SEJ’s SEO 101: Learn The Basics of Search Engine Optimization</li><br />
 <li> The Art of SEO: Mastering Search Engine Optimization</li><br />
 <li> Search Engine Optimization All-in-One for Dummies</li><br />
 <li> SEO 2017: Learn Search Engine Optimization With Smart Internet Marketing Strategies</li><br />
 <li> Seo 2018 Learn Search Engine Optimization With Smart Internet Marketing Strateg by Adam Clarke</li><br />
 <li> Marketing in the Age of Google</li><br />
 <li> Ultimate Guide to Link Building: How to Build Backlinks, Authority and Credibility for Your Website, and Increase Click Traffic and Search Ranking</li><br />
 <li> The Link Building Book</li><br />
 <li> Content Machine: Use Content Marketing to Build a 7-Figure Business With Zero Advertising</li><br />
 <li> Everybody Writes: Your Go-To Guide to Creating Ridiculously Good Content</li><br />
 <li> The Art of Social Media: Power Tips for Power Users</li><br />
 <li> Jab, Jab, Jab, Right Hook: How to Tell Your Story in a Noisy, Social World</li><br />
 <li>Mastering in-house SEO, Simon Schnieders</li><br />
 <li>3 Months to No.1: The "No-Nonsense" SEO Playbook for Getting Your Website Found on Google, Will Coombe</li><br />
  <li>SEO Fitness Workbook: The Seven Steps to Search Engine Optimization, Jason McDonald</li><br />
</ol>
