+++
title = "hexo init blog"
description = "Hello World!"
date = 2015-04-24T01:57:13-08:00
[taxonomies]
tags = ["hacks", "Hexo", "blogging"]
+++
I've been wanting to start a blog for a long time now. Today I'm pulling the
trigger on that with a simple `hexo init blog`. Well, it wasn't _that_ simple,
so I feel like it's worth talking about a few of the complications I had.

<!-- more -->


[Hexo](https://hexo.io/), my chosen blogging framework, has made some
interesting decisions. Running `tree -aACL 1` shows the directory structure for
my new Hexo blog.

```
.
├── _config.yml
├── db.json
├── .deploy_git
├── .gitignore
├── node_modules
├── package.json
├── public
├── scaffolds
├── source
└── themes

6 directories, 4 files
```

Hexo keeps its generated static files in the `public` directory. When deploying
with git, as I choose to do, it uses the hidden `.deploy_git` directory to keep
changes to `public` under version control. When generating static files Hexo
obliterates anything in the `public` directory it doesn't know about. This
means that even if the user wants to add some static files of their own they'll
just be [baleeted](https://www.youtube.com/watch?v=07h0ksKx5sM) when Hexo
clears out the `.deploy_git` directory and copies the `public` directory in.


This isn't a big deal if you don't care about having any static files not
generated by Hexo on your site. It just so happens that I'm very keen on having
my [proof](https://tuckersiemens.com/keybase.txt) for
[Keybase](https://keybase.io). In order to prove ownership of a website Keybase
requires that you keep a file called `keybase.txt` or `.well-known/keybase.txt`
from the root of your site.


So, how do you serve a custom static file when your blogging framework is
intent on keeping you from doing so? I suppose I could do the responsible thing
and submit a pull request upstream for a configuration option to preserve
certain files, but I'm much too lazy for that. Instead I've enlisted
[nginx](http://nginx.org/) for a band-aid solution.

```
location =/keybase.txt {
    root /srv;
}
```

Most requests to my site pass through nginx to my default root, but any
requests for `keybase.txt` get served out of a separate directory where it
safely sits.
