---
title: "Task Complete: Vow of Silence"
excerpt: I'm back to blogging, and I have good news.
date: 2024-03-01
tags:
  - rambling
  - godot
  - mono
  - unity
---

### Hello Again

This blog is about to become more personal and active. Originally, software was thought to be central to the theme, but it is shaped only in response to human aspiration and thought. Following an extended vow of (relative) silence with respect to my online presence, several realizations swept over me while I focused on the important stuff in my life. The act of fixing some superficial bugs in the operating system of my body and mind revealed that the underlying architecture was all wrong.

So, I replaced it with a cutting-edge, experimental, and massively more performant alternative. Is this core pattern of my character an echo of my software career, or something deeper? Now I'm convinced of the latter, fashionably late to the party of those who know me better than myself.

A drastic dietary change, complemented by a demanding exercise regimen and mindfulness, has tuned and honed my outlook. I used to be a very negative, cynical, and distrusting person. My anxiety and lack of self-awareness has been plainly evident to anyone who interacted with me online or in-person. After having burst forth from my self-imposed Torvaldsian cocoon, I can safely say that a transformation to the opposite end of the spectrum has been a boon to my productivity. After all, it's not like I've been sitting around doing nothing. Oh, I've been doing _things_, I tell you. Things, man.

(Things in addition to playing Baldur's Gate 3.)

### Software Projects

Taking on the odd contract hasn't been enough for me. There are a couple of intertwined software projects I've been building through the aforementioned spirit journey, if you will. Each passing day, I am increasingly excited about them. One is a novel C# abstraction layer (a framework?! an engine?!) that will make game development a dream for my friends in Unity, Godot, and Mono. Ever the tease, I know you want more, but I can only slow-drip information at this point. For reference, this may be the most outlandish thing I've ever done software-wise. It involves code generation, so....

As for the other thing, an indie game(!!!), well, let's just say it has become a testbed for the abstraction layer. It came first, in fact—it has been _hoisted_ on top of said layer over the past few months. What's the timeline here? In 2022, I found myself displaced in more ways than one after moving across the US for the zillionth time. By happenstance, I picked up [Axiom Verge](https://www.axiomverge.com/) for the Nintendo Switch from my local library (support your library!). It floored me, so much so that I learned more about its creator, [Thomas Happ](https://www.thomashapp.com/), and his development process. Mine is alternatively inverted from his: I've focused on code first, and art second, so that during the course of testing I will (theoretically) catch more bugs prior to release.

Since I started in late 2022, I had to expand my repertoire beyond code for this game: music production and pixel art are relatively new to me. I dabbled in creative writing when I was much younger, but not worldbuilding. I wouldn't say I've mastered any of this stuff, but remarking upon one of my maniacal weekend music fugues, my wife made the comment that I should have just become a musician, which was simultaneously insulting and heartening. Don't get me wrong, I'm just haphazardly chopping filtered samples together, but I do seem to have a latent knack for composition absent any understanding of music theory. You can be the judge of that later. Modern digital audio workstations (DAWs) make audio production much more accessible than times past.

Anyway, you'll find out more about these projects Soon™. I intend to roll out the game prior to the abstraction layer, so it'll be awhile. There is a ton to do yet for my so-called _market slice_, a term that combines the _minimally viable product_ (MVP), familiar to most in the software industry, and the _vertical slice_, a game-centric term. The market slice, which I coined, is just another way of saying, "initially marketable." There is some porting to the abstraction layer left, and then months of art, animation, character, and level design remaining before the market slice can be considered done-ish. At least a certain critical mass has been reached such that I can start talking about what I'm doing now, thank goodness.

Porting the game to the abstraction layer will end up delaying its marketing and release by about six months. This is normal for a port. While unfortunate, the reward is worth it, in my opinion, and not just for this specific game I'm working on. It will eventually become clear why I did this. Again, more details to follow later.

### Other Stuff

Outside these two software projects that have dominated my life, there have been others in the real world. I became the part-owner (and rehabilitator) of a modest 1970s-era condominium in the Northwestern Chicago burbs, where I can assure you that I'm _not_ being robbed and murdered to death. Back when I lived in Southern Illinois (where I spent my teenage years and later studied computer science), I recall all the dehumanizing and racist talk about this area. Nah, it's awesome and filled with so many kinds of wonderful people. Some people are assholes, of course, but even assholes have desirable qualities. As it happens, Chicagoans and Chiburbanites alike mainly fund Southern Illinois' infrastructure with our taxes.

> **Aside:** Those who monologued to me about invading welfare queens from Chicago were projecting—turns out they themselves were the welfare queens all along.

I conclude by informing you that I'm writing this blog out of a small closet I have converted into a minimalist office, and I can assure you that it's better than it sounds. It's my focus zone. The desk folds into a cabinet when I'm done for the day. I installed surrounding shelving (and not without my trusty Japanese pull saw!), hosting a couple of figurines and chocolate-covered coffee beans. Some delicacies cannot be foregone, especially in this line of work. Caffeine is part of my technodharmic practice.

I hope you got something out of this update. There are many more to come. Please, join me. Don't forget you can reach out at [contact@reese.codes](mailto:contact@reese.codes).
