---
title: "Constrained Canvases: The Art of Focused Game Settings"
excerpt: Addressing game scope and immersion through a deliberately myopic spectacle.
date: 2024-03-08
tags:
  - rambling
---

### The Woes of Finite Resources

One of the greatest challenges in game development is limiting scope without compromising the creative vision. All developers must constrain scope, regardless of their resources, as those resources are finite. The game's setting presents an effective starting point for scope limitation. If you're an indie developer or part of a small studio, strategically constraining the portrayal of your imagined world is crucial—it can determine whether you successfully finish development. Larger studios can cut promised or advertised features and weather backlash through clever PR and appeasement.

However, preventing such issues from the outset is ideal.

### A Classic Counterexample

By thoughtfully portraying the setting, indies and small teams can maximize their creative potential within practical boundaries. An example of how _not_ to do this would be No Man's Sky. The small team behind No Man's Sky, Hello Games, pitched an incredibly ambitious, procedurally-generated universe filled with vibrant planets to explore...

![a screenshot of alien creatures in no man's sky](/blog/media/no-mans-sky-creatures.png)

<p class="caption">Screenshot from the <a href="https://www.nomanssky.com">No Man's Sky website</a>.</p>

However, they significantly underestimated the scope and ran into major development challenges trying to realize their grand vision with limited resources. This resulted in a product that failed to deliver on many promised features at launch, leading to harsh criticism. While the game has improved substantially through updates over time, the initial pitfalls highlight the risks of over-scoping a setting beyond the realistic capabilities of a small team.

It should be stressed that the comeback of No Man's Sky was only made possible through the continued hard work and commitment of the developers over several years of major updates and expansions. By focusing their efforts after launch on steadily improving and building upon the core experience, Hello Games was eventually able to deliver more closely on the original vision, but this redemptive path required an immense amount of additional time, resources, and emotional resilience that may not be feasible for every indie studio facing backlash. The safer approach is to carefully plan the scope of the game world from the beginning to align with the team's realistic capabilities.

### An Exemplary Constrained Canvas

Early on, while discussing ways to limit the scope of a game I've been solo-developing, my uncle, an avid gamer, pointed to BioShock's setting as an inspirational example. He was absolutely right. It evokes the idyllic constrained canvas.

![a screenshot of the underwater city of rapture in bioshock](/blog/media/edveenn-bioshock.jpg)

<p class="caption">BioShock screenshot by DeviantArt user <a href="https://www.deviantart.com/edveenn/art/BioShock-Screenshot-33-860817703">edveenn</a>.</p>

By setting most of the game within Rapture, an undersea city, the relatively small team at 2K Games (now Irrational Games) crafted an incredibly rich, atmospheric world brimming with environmental storytelling. Instead of building a sprawling open world, they created intricate art deco interiors, populating corridors with memorable characters and adversaries, and imbued every corner with haunting glimpses into Rapture's fallen utopia. The limited setting became a strength, facilitating dense level design and tightly-controlled narrative pacing. BioShock exemplifies how constraining the game world can enable impactful worldbuilding and storytelling when leveraged properly by developers.

Sequels to BioShock have retained the constrained canvas formula, further exemplifying the strengths of a limited game world. BioShock 2 remained set within the decaying undersea confines of Rapture, allowing the developers to build upon the rich world and environmental storytelling established in the first game. While BioShock Infinite broke new ground by shifting to the floating sky-city of Columbia, the setting still provided a distinct, self-contained space ripe for dense worldbuilding. By avoiding an open world, the BioShock series could maintain its benchmark visual fidelity, tightly-crafted levels, and focused narrative experiences that immersed players in its thought-provoking dystopias.

Constrained canvases have become a BioShock hallmark.

### Unconstrained Worlds

Just because the BioShock franchise constrains its canvas, does not mean that it constrains its world. **Spoiler alert:** BioShock's characters and places exist in a fictional multiverse spanning infinite realities. While each individual game takes place within a focused, meticulously crafted area like Rapture or Columbia, the overarching narrative weaves these pocket universes together through entanglement and convergence.

![a screenshot of the floating sky city of columbia in bioshock infinite](/blog/media/bioshock-infinite.jpg)

<p class="caption">BioShock Infinite screenshot from 2K and Irrational Games.</p>

Souls such as Booker DeWitt and Elizabeth can transcend and traverse the boundaries of said multiverse. The games' audiovisual feedback is deliberate, a mere looking glass into the slice of life that the developers constructed—it is not and cannot be everything. The lesson here is that game developers need not try to design the whole world, or have all the answers. Through crafting a focused experience tailored to the project's scope, developers can imply a larger, richer fictional cosmos for players to ponder beyond what is directly shown or playable. Sequels (and prequels) can help, obviously.

We, as game developers, must trust our players' imagination. By presenting a thoughtfully crafted, focused game world, we provide a canvas upon which players may project their own ideas, interpretations, and unanswered questions about the broader fiction. The explicit environmental details, character arcs, and narrative threads lay a vivid foundation; but, more important is the negative space, the selective omissions and implied aspects beyond our constrained framing that allow players to actively engage their minds in filling the gaps.

**Players are co-creators of the experience!** They expand the conceived boundaries of the game world based on the suggestive seeds we sow. This collaborative dynamic between developer vision and audience imagination breeds vastly more resonant fictional realms than if we hand-fed players every answer and exhaustively mapped out the farthest reaches of a game's encompassing environment. Instead, by revealing only the tip of the iceberg, game developers cultivate an underlying sense of mystery that enhances immersion, while reducing the need for exhaustive world-building and exhausting implementation efforts.

> **Food for thought:** Have you played a game with a constrained canvas? And what of a game in dire need of a constrained canvas? How would these games inform your development efforts?

So, thanks for reading, and mind the scope of your setting!
