import { Metadata } from '@redwoodjs/web'
import Hero from 'src/components/Hero/Hero'
import { useTranslation, Trans } from 'react-i18next'
import Highlight from 'react-highlight'

const HomePage = () => {
  const { t } = useTranslation()

  return (
    <>
      <Metadata
        title="RedwoodJS: The Full-stack JS Framework"
        description="Grow from side project to startup with RedwoodJS. Combines React, GraphQL and Prisma for a full-stack app framework."
      />

      <div className="bg-white">
        <section className="max-w-screen-lg mx-auto pt-48 pb-32 text-center">
          <h1 className="flex flex-col text-7xl leading-tighter text-center text-stone-800">
            <span>From side project</span>
            <span>to startup</span>
          </h1>
          <h2 className="mt-4 text-xl text-stone-500">
            RedwoodJS is the full-stack app framework that grows with you
          </h2>
          <div className="w-24 mx-auto mt-12 ">
            <svg
              viewBox="0 0 39 42"
              fill="none"
              xmlns="http://www.w3.org/2000/svg"
            >
              <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M10.4814 6.07243L18.6366 11.6391C18.8206 11.7617 19.0356 11.8288 19.2563 11.8326C19.4773 11.831 19.6928 11.7637 19.876 11.6391L28.0374 6.0537C28.3545 5.82665 28.5294 5.44815 28.4976 5.05762C28.4658 4.66709 28.2321 4.32232 27.8825 4.1503L19.7272 0.11258C19.4179 -0.0375265 19.0575 -0.0375265 18.7481 0.11258L10.6177 4.1503C10.2618 4.32324 10.025 4.67468 9.99683 5.0716C9.96867 5.46853 10.1535 5.8503 10.4814 6.07243ZM22.0264 13.3865C22.027 13.7557 22.2077 14.1009 22.5097 14.3101L29.0475 18.7785C29.466 19.067 30.026 19.031 30.4047 18.6911L35.889 13.7859C36.1334 13.5675 36.2691 13.2513 36.2595 12.9224C36.25 12.5935 36.0961 12.2858 35.8394 12.0822L30.603 7.89471C30.2223 7.59234 29.6914 7.57216 29.2892 7.84479L22.5097 12.4816C22.213 12.687 22.033 13.024 22.0264 13.3865ZM5.76549 19.4649C6.02972 19.7023 6.16556 20.0524 6.13111 20.4073C6.09678 20.7642 5.89064 21.0814 5.57958 21.256L1.67549 23.5962C1.27973 23.8328 0.780044 23.7987 0.419608 23.5105C0.0591727 23.2224 -0.0871399 22.74 0.0518789 22.2982L1.49577 17.755C1.60904 17.395 1.89615 17.1176 2.258 17.0186C2.61958 16.9133 3.00948 17.0056 3.2867 17.262L5.76549 19.4649ZM26.9405 19.9392L19.8822 15.1089C19.5071 14.8565 19.0179 14.8565 18.6428 15.1089L11.5844 19.9392C11.3037 20.1335 11.1259 20.4458 11.1011 20.7879C11.0828 21.1325 11.2193 21.467 11.4729 21.6991L18.525 28.0084C18.7284 28.1898 18.9908 28.2897 19.2625 28.2892C19.534 28.2891 19.7963 28.1893 19.9999 28.0084L27.0521 21.6991C27.3064 21.468 27.4412 21.1321 27.4177 20.7879C27.398 20.4458 27.2217 20.1322 26.9405 19.9392ZM8.11413 18.6911L2.63601 13.7859C2.38952 13.562 2.2535 13.2401 2.26419 12.906C2.27015 12.5767 2.42255 12.2674 2.67939 12.0635L7.91583 7.85102C8.2991 7.54952 8.83113 7.5294 9.23578 7.8011L16.0091 12.4379C16.3234 12.6441 16.513 12.9962 16.513 13.374C16.513 13.7518 16.3234 14.104 16.0091 14.3101L9.47747 18.7784C9.05639 19.0657 8.49565 19.0298 8.11413 18.6911ZM36.2422 25.7368L30.6649 22.398C30.2507 22.1484 29.7235 22.199 29.3635 22.5229L22.5469 28.6075C22.2593 28.8643 22.1243 29.2527 22.1899 29.6341C22.2556 30.0154 22.5125 30.3354 22.8691 30.4797L32.3257 34.3115C32.4554 34.3654 32.5944 34.393 32.7347 34.3926C33.1736 34.394 33.572 34.1347 33.751 33.7311L36.6822 27.1659C36.9207 26.6464 36.7308 26.0293 36.2422 25.7368ZM37.0168 17.755L38.4607 22.2982H38.4483C38.5551 22.638 38.4944 23.0088 38.285 23.2961C38.0756 23.5835 37.7426 23.7529 37.3886 23.7523C37.1901 23.7529 36.9951 23.699 36.8247 23.5963L32.9144 21.256C32.6097 21.0778 32.4108 20.7609 32.3815 20.4073C32.3449 20.0521 32.4811 19.7011 32.7471 19.4649L35.2259 17.2557C35.5059 17.0048 35.8929 16.9132 36.2546 17.0123C36.6162 17.1156 36.9023 17.3945 37.0168 17.755ZM16.3313 29.631C16.398 29.2512 16.2643 28.8638 15.9781 28.6075L9.16143 22.5229C8.80149 22.199 8.27425 22.1484 7.86007 22.398L2.28279 25.7368C1.79989 26.0306 1.60883 26.6399 1.83661 27.1597L4.77398 33.7249C5.01733 34.2723 5.6465 34.5285 6.19928 34.3053L15.6497 30.4735C16.0064 30.3304 16.2642 30.0117 16.3313 29.631ZM19.6777 31.5032L27.2628 34.5736C27.6337 34.7323 27.8899 35.0811 27.9321 35.4847C27.9801 35.8934 27.7986 36.295 27.4611 36.5269L19.8698 41.8003C19.6879 41.9281 19.4719 41.9977 19.2501 42C19.0285 41.9966 18.8129 41.9271 18.6304 41.8003L11.0453 36.5269C10.7066 36.2956 10.5229 35.8944 10.5682 35.4847C10.6188 35.0769 10.8842 34.7285 11.2622 34.5736L18.8473 31.5032C19.114 31.3968 19.411 31.3968 19.6777 31.5032Z"
                fill="#BF4722"
              />
            </svg>
          </div>
          <ul className="flex items-center justify-center space-x-6 mt-12">
            <li>
              <button type="button" className="button">
                Start the Tutorial
              </button>
            </li>
            <li>
              <button
                type="button"
                className="button-invert border border-teal-600 hover:border-teal-100"
              >
                Read the Docs
              </button>
            </li>
          </ul>
        </section>

        <section className="bg-orange-50 pt-24 pb-36">
          <h2 className="text-center text-6xl font-black text-orange-900">
            Built with the best parts of
          </h2>
          <ul className="mt-24 max-w-screen-lg mx-auto flex items-stretch justify-center space-x-8">
            <li className="bg-white border border-orange-200 hover:border-orange-300 p-8 rounded-lg cursor-pointer transition duration-100">
              <h3 className="title">React</h3>
              <p className="mt-2 text-sm">
                Selfies actually succulents pork belly shabby chic trust fund
                small batch, wolf ramps brooklyn post-ironic. Copper mug
                aesthetic banh mi cliche heirloom iceland 90's skateboard
              </p>
            </li>
            <li className="bg-white border border-orange-200 hover:border-orange-300 p-8 rounded-lg cursor-pointer transition duration-100">
              <h3 className="title">GraphQL</h3>
              <p className="mt-2 text-sm">
                Selfies actually succulents pork belly shabby chic trust fund
                small batch, wolf ramps brooklyn post-ironic. Copper mug
                aesthetic banh mi cliche heirloom iceland 90's skateboard
              </p>
            </li>
            <li className="bg-white border border-orange-200 hover:border-orange-300 p-8 rounded-lg cursor-pointer transition duration-100">
              <h3 className="title">Prisma</h3>
              <p className="mt-2 text-sm">
                Selfies actually succulents pork belly shabby chic trust fund
                small batch, wolf ramps brooklyn post-ironic. Copper mug
                aesthetic banh mi cliche heirloom iceland 90's skateboard
              </p>
            </li>
          </ul>
          <ul className="mt-12 max-w-screen-lg mx-auto flex items-stretch justify-center space-x-8">
            <li className="bg-white border border-orange-200 hover:border-orange-300 p-8 rounded-lg cursor-pointer transition duration-100">
              <h3 className="title">Typescript</h3>
              <p className="mt-2 text-sm">
                Selfies actually succulents pork belly shabby chic trust fund
                small batch, wolf ramps brooklyn post-ironic. Copper mug
                aesthetic banh mi cliche heirloom iceland 90's skateboard
              </p>
            </li>
            <li className="bg-white border border-orange-200 hover:border-orange-300 p-8 rounded-lg cursor-pointer transition duration-100">
              <h3 className="title">Jest</h3>
              <p className="mt-2 text-sm">
                Selfies actually succulents pork belly shabby chic trust fund
                small batch, wolf ramps brooklyn post-ironic. Copper mug
                aesthetic banh mi cliche heirloom iceland 90's skateboard
              </p>
            </li>
            <li className="bg-white border border-orange-200 hover:border-orange-300 p-8 rounded-lg cursor-pointer transition duration-100">
              <h3 className="title">Storybook</h3>
              <p className="mt-2 text-sm">
                Selfies actually succulents pork belly shabby chic trust fund
                small batch, wolf ramps brooklyn post-ironic. Copper mug
                aesthetic banh mi cliche heirloom iceland 90's skateboard
              </p>
            </li>
          </ul>
        </section>

        <section className="bg-gradient-to-r from-orange-900 to-orange-800 text-white py-16">
          <div className="flex items-center justify-center max-w-screen-lg mx-auto">
            <div className="text-5xl text-orange-300 font-black text-right px-4">
              Startups using Redwood <br />
              have raised over
            </div>
            <div className="text-8xl text-orange-100 font-black px-4">$19m</div>
          </div>
          <div className="max-w-screen-lg mx-auto pt-12 pb-4">
            <ul className="flex items-center justify-center space-x-48">
              <li>
                <svg
                  viewBox="0 0 2698.39 585.2"
                  className="w-full fill-current text-orange-600"
                >
                  <path d="M342.87 585.2c-15.25 0-31.68-8.15-51.71-25.64-9.68-8.46-17.65-16.89-20.29-19.74C150.66 426.64 76.88 346.6 38.72 288 2.85 232.89 0 200.58 0 164.06c0-37 18.05-78.13 48.29-110.12C80.66 19.7 123.08 0 164.67 0h.14c124.29 0 200.77 144.46 204 150.61a324.3 324.3 0 0044.79 62.16c34.4 37.23 69.66 56.12 104.74 56.12h1A106 106 0 00593.5 238a103.07 103.07 0 0030.55-73.53A104.57 104.57 0 00519.61 60c-27.55 0-60.14 5.08-93 42.71a30 30 0 11-45.22-39.44C430.85 6.58 483.93 0 519.57 0 610.24 0 684 73.79 684 164.44a162.68 162.68 0 01-48.2 116 165.65 165.65 0 01-115.93 48.4h-1.59c-123.06 0-198.89-143.09-202.78-150.6a324.66 324.66 0 00-44.77-61.77C246.84 90.73 209 60 164.8 60h-.08C139.54 60 113 72.84 91.89 95.16 72.22 116 60 142.37 60 164.06c0 25 0 46.64 29 91.19 35.08 53.89 108.29 132.93 223.8 241.63.6.56 1.17 1.15 1.72 1.76a183.91 183.91 0 0025.4 23.18c10.12-8.28 29.55-25.8 61.73-57.93 29.93-29.88 63.73-65.3 82.2-86.13a30 30 0 0144.9 39.8c-18 20.28-55.35 59.78-92 96-19.27 19-35.44 34.35-48.06 45.47-23.03 20.3-33.31 26.17-45.82 26.17z"></path>
                  <path d="M2647.26 153h-10.77v-4h25.94v4h-10.77v23.72h-4.4zm20-4h4.4l11.07 22.17L2694 149h4.4v27.72h-4.4v-19.3l-9.26 19.25h-3.64l-9.4-19.25v19.25h-4.4zM1038.53 356.2H865c8.48 29.53 36.13 44.92 70.92 44.92 22.75 0 42.82-5.82 59.77-19.55l27.21 27c-19.18 22.46-52.63 38.26-93.67 38.26-63.78 0-120.88-40.34-120.88-112.3 0-72.79 58-112.31 117.31-112.31 58.9.04 125.81 38.72 112.87 133.98zm-174.4-40.77h121.32c-3.57-30.78-31.22-46.17-59.32-46.17-27.66 0-54.42 14.98-62 46.17zM1037.06 226.42h61.11l64.23 150.16 63.78-150.16h61.56l-97.69 216.29h-55.75zM1514.1 356.2h-173.51c8.47 29.53 36.13 44.92 70.92 44.92 22.75 0 42.82-5.82 59.77-19.55l27.21 27c-19.18 22.46-52.64 38.26-93.67 38.26-63.79 0-120.88-40.34-120.88-112.3 0-72.79 58-112.31 117.31-112.31 58.88.04 125.75 38.72 112.85 133.98zm-174.41-40.77H1461c-3.57-30.78-31.22-46.17-59.33-46.17-27.67 0-54.39 14.98-61.98 46.17zM1691.49 223.92v53.25a92.5 92.5 0 00-15.17-1.25c-45 0-73.15 29.11-73.15 72.37v94.42h-59.77V226.42h59.77v56.15c8-33.27 30.78-60.31 72.71-60.31a66.9 66.9 0 0115.61 1.66zM1794.56 218.52v7.9h59.77v44.51h-59.77v171.78h-59.77V270.93h-29.44v-44.51h29.44v-14.14c0-63.65 47.28-74 78.06-74 12 0 28.55 1.24 41.48 8.32v43.67c-11.15-5-21.85-4.58-25.87-4.58-22.75-.04-33.9 11.61-33.9 32.83zM2096 226.42v216.29h-59.77v-29.53c-12.93 19.14-36.57 33.69-71.37 33.69-47.28 0-87.42-27.45-87.42-93.17V226.42h59.77v118.13c0 31.61 18.29 52.41 49.51 52.41 30.33 0 49.51-20.8 49.51-52.41V226.42zM2356.25 315.43v127.28h-59.77V324.58c0-31.61-18.28-52.41-49.51-52.41-30.77 0-49.51 20.8-49.51 52.41v118.13h-59.77V226.42h59.77V256c12.94-19.13 36.13-33.69 70.92-33.69 47.73-.05 87.87 27.4 87.87 93.12zM2618.75 147.39v295.32H2559V413.6h-1.34c-5.8 12.06-32.56 33.27-74 33.27-54 0-111.52-37.43-111.52-112.3s57.54-112.31 111.52-112.31c41.48 0 68.24 21.21 74 33.27h.89V147.39zm-58.43 187.18c0-40.77-31.23-62.4-64.68-62.4s-64.64 22.05-64.64 62.4 31.19 62.43 64.64 62.43 64.68-21.67 64.68-62.43z"></path>
                </svg>
              </li>
              <li>
                <svg
                  viewBox="0 0 165 46"
                  className="w-full fill-current text-orange-600"
                  xmlns="http://www.w3.org/2000/svg"
                >
                  <path d="M63.2517 30.2877C65.177 30.2877 66.6919 29.8622 67.7966 29.0112C68.3374 28.5994 68.7703 28.0648 69.0587 27.4525C69.3471 26.8402 69.4825 26.1681 69.4535 25.493C69.4757 24.7969 69.3046 24.1081 68.959 23.5015C68.5642 22.8939 68.0051 22.4083 67.3453 22.1C66.3727 21.6219 65.3464 21.2594 64.2877 21.0202C63.0844 20.7199 62.1783 20.4624 61.5695 20.2479C61.1153 20.1111 60.6949 19.8822 60.3349 19.5757C60.1186 19.3435 60.002 19.037 60.01 18.7212C60.008 18.4395 60.0853 18.1628 60.2332 17.9222C60.3812 17.6816 60.5939 17.4865 60.8475 17.359C61.5088 17.0008 62.2627 16.8452 63.0134 16.912C63.8285 16.9154 64.6231 17.1649 65.2913 17.6271C65.7051 17.9146 66.019 18.3217 66.1902 18.7927C66.2334 18.9355 66.3265 19.0585 66.4528 19.1397C66.579 19.2209 66.7303 19.2551 66.8797 19.2361L68.8471 18.8785C68.9148 18.8687 68.9799 18.8453 69.0381 18.8097C69.0964 18.7741 69.1467 18.727 69.186 18.6714C69.2252 18.6158 69.2525 18.5528 69.2662 18.4864C69.28 18.4199 69.2798 18.3514 69.2658 18.285C69.0048 17.1692 68.3229 16.1945 67.3598 15.5605C66.0663 14.7103 64.5359 14.2838 62.9845 14.3413C61.1916 14.3413 59.7476 14.7573 58.6526 15.5891C58.1311 15.9661 57.7103 16.4634 57.4266 17.0378C57.1429 17.6122 57.0049 18.2465 57.0246 18.8857C57.0046 19.548 57.1708 20.2028 57.5047 20.7771C57.9279 21.3549 58.5002 21.8094 59.1616 22.0928C60.1663 22.5579 61.2146 22.9244 62.2914 23.1869C63.4947 23.5039 64.3864 23.7697 64.9664 23.9842C65.4032 24.107 65.7985 24.3442 66.1107 24.6707C66.3116 24.9371 66.4124 25.2646 66.3959 25.5967C66.4067 25.8997 66.3394 26.2005 66.2005 26.4707C66.0615 26.7409 65.8555 26.9717 65.6017 27.1413C64.9572 27.549 64.1994 27.7454 63.4358 27.7026C62.5327 27.7339 61.6406 27.4987 60.8727 27.0269C60.3526 26.6942 59.9501 26.2093 59.7212 25.6396C59.6743 25.5109 59.5851 25.4014 59.4679 25.3288C59.3508 25.2562 59.2124 25.2246 59.075 25.2392L57.0932 25.5431C57.0218 25.5521 56.9533 25.5759 56.8919 25.6131C56.8306 25.6502 56.7779 25.6998 56.7373 25.7586C56.6967 25.8174 56.6692 25.884 56.6565 25.9541C56.6437 26.0242 56.6462 26.0961 56.6636 26.1652C56.9629 27.3423 57.6839 28.3715 58.6923 29.0613C59.8764 29.8789 61.3962 30.2877 63.2517 30.2877Z" />
                  <path d="M73.9883 29.3438C73.9892 29.4864 74.0471 29.6228 74.1492 29.7232C74.2513 29.8237 74.3894 29.8801 74.5334 29.8801H76.4466C76.5903 29.8801 76.728 29.8236 76.8295 29.723C76.9311 29.6224 76.9881 29.486 76.9881 29.3438V21.9999C76.9467 21.0195 77.1268 20.0423 77.5152 19.1396C77.8116 18.4877 78.3064 17.9439 78.9303 17.5843C79.525 17.2648 80.1923 17.1011 80.8688 17.1087C81.5635 17.0774 82.2523 17.2476 82.8506 17.5986C83.3525 17.9167 83.7589 18.3625 84.0275 18.8893C84.3028 19.4361 84.4892 20.0226 84.5798 20.6269C84.6804 21.2249 84.7323 21.8299 84.735 22.4361V29.3438C84.735 29.4145 84.7492 29.4846 84.7766 29.5499C84.804 29.6152 84.8442 29.6745 84.8949 29.7243C84.9456 29.7742 85.0057 29.8136 85.0718 29.8403C85.1379 29.8671 85.2087 29.8806 85.2801 29.8801H87.1898C87.2612 29.8806 87.332 29.8671 87.3981 29.8403C87.4642 29.8136 87.5243 29.7742 87.575 29.7243C87.6257 29.6745 87.6659 29.6152 87.6933 29.5499C87.7208 29.4846 87.7349 29.4145 87.7349 29.3438V21.4779C87.7283 20.9335 87.6861 20.3901 87.6085 19.8511C87.5152 19.2058 87.3543 18.5719 87.1284 17.9597C86.8895 17.3092 86.539 16.7044 86.0924 16.172C85.624 15.6004 85.0285 15.144 84.3524 14.8384C83.5138 14.4785 82.6053 14.3064 81.6919 14.3342C80.6783 14.3156 79.6728 14.5169 78.7462 14.9242C78.3391 15.1103 77.9541 15.3405 77.5982 15.6106C77.5139 15.6743 77.4142 15.7149 77.3091 15.7282C77.2039 15.7415 77.0971 15.7271 76.9993 15.6865C76.9016 15.6459 76.8164 15.5805 76.7523 15.4969C76.6882 15.4132 76.6475 15.3144 76.6344 15.2102V15.2102C76.6344 15.086 76.5845 14.9668 76.4958 14.879C76.4072 14.7911 76.2869 14.7418 76.1615 14.7418H74.5334C74.3888 14.7418 74.2502 14.7987 74.1479 14.8999C74.0457 15.0012 73.9883 15.1385 73.9883 15.2817V29.3438Z" />
                  <path d="M97.1561 30.3164C98.9322 30.3164 100.388 29.8528 101.524 28.9256C101.928 28.5966 102.665 28.854 102.665 29.3689C102.665 29.5083 102.721 29.642 102.82 29.7406C102.92 29.8391 103.055 29.8945 103.195 29.8945H104.737C104.808 29.895 104.879 29.8814 104.945 29.8547C105.011 29.828 105.071 29.7885 105.122 29.7387C105.173 29.6888 105.213 29.6296 105.24 29.5643C105.268 29.499 105.282 29.4289 105.282 29.3582V20.5555C105.282 19.9227 105.253 19.3292 105.199 18.7678C105.142 18.2221 104.988 17.6907 104.744 17.1982C104.296 16.2203 103.499 15.4409 102.506 15.0101C101.384 14.5159 100.167 14.2718 98.9394 14.295C97.1753 14.295 95.7602 14.6787 94.6941 15.4462C93.7808 16.0934 93.0872 16.9997 92.705 18.0456C92.6819 18.1119 92.6731 18.1823 92.679 18.2523C92.6849 18.3222 92.7056 18.3901 92.7395 18.4517C92.7735 18.5133 92.8201 18.5672 92.8763 18.6099C92.9326 18.6527 92.9972 18.6833 93.066 18.6999L94.8024 19.229C94.9461 19.2676 95.099 19.2525 95.2322 19.1865C95.3653 19.1206 95.4693 19.0085 95.5244 18.8715C95.7747 18.3141 96.1985 17.8505 96.7337 17.5486C97.4063 17.1727 98.1671 16.9791 98.9394 16.9872C100.143 16.9872 101.002 17.2399 101.517 17.7453C102.004 18.2359 102.3 18.8822 102.351 19.5687C102.366 19.7014 102.327 19.8347 102.243 19.9393C102.16 20.0439 102.037 20.1112 101.903 20.1265C100.82 20.2731 99.7733 20.4304 98.7408 20.5913C97.691 20.741 96.6517 20.9559 95.6291 21.2348C94.5877 21.5227 93.6525 22.1026 92.9361 22.9046C92.3027 23.7062 91.9777 24.7049 92.0192 25.722C92.011 26.5166 92.21 27.2998 92.5967 27.996C93.0128 28.6964 93.6162 29.2693 94.3403 29.6514C95.2093 30.0993 96.1765 30.3277 97.1561 30.3164ZM97.6795 27.9173C96.7373 27.9173 96.037 27.7028 95.5858 27.2737C95.3737 27.079 95.2048 26.8427 95.0899 26.5799C94.9749 26.317 94.9163 26.0334 94.9179 25.747C94.9027 25.4797 94.9484 25.2124 95.0515 24.9648C95.1546 24.7173 95.3125 24.4958 95.5136 24.3168C95.9607 23.9469 96.4754 23.6653 97.0297 23.4874C97.7734 23.2784 98.5293 23.1148 99.2932 22.9975C100.015 22.8831 100.817 22.7639 101.697 22.64C101.775 22.6275 101.855 22.6326 101.931 22.6548C102.007 22.677 102.077 22.7158 102.135 22.7683C102.194 22.8209 102.24 22.8858 102.269 22.9582C102.299 23.0307 102.312 23.1089 102.307 23.187C102.307 23.3622 102.282 23.5446 102.268 23.7376C102.237 24.1382 102.156 24.5334 102.026 24.914C101.899 25.4391 101.652 25.9285 101.304 26.3441C100.916 26.8269 100.422 27.2157 99.8599 27.4811C99.1751 27.7845 98.4293 27.9288 97.6795 27.903V27.9173Z" />
                  <path d="M110.361 36.0727C110.361 36.2159 110.419 36.3532 110.521 36.4545C110.623 36.5557 110.762 36.6126 110.906 36.6126H112.787C112.932 36.6126 113.07 36.5557 113.173 36.4545C113.275 36.3532 113.332 36.2159 113.332 36.0727V30.0231C113.342 29.9136 113.38 29.8083 113.442 29.717C113.504 29.6257 113.588 29.5513 113.686 29.5006C113.785 29.45 113.895 29.4249 114.006 29.4275C114.117 29.43 114.225 29.4603 114.321 29.5154C114.598 29.6709 114.888 29.8025 115.188 29.9087C115.945 30.1804 116.747 30.3137 117.552 30.302C118.867 30.3379 120.16 29.968 121.252 29.2437C122.297 28.5238 123.124 27.5347 123.642 26.3834C124.226 25.1021 124.517 23.7092 124.494 22.3038C124.519 20.8983 124.228 19.5048 123.642 18.2243C123.124 17.0646 122.285 16.0732 121.224 15.3639C120.125 14.6454 118.829 14.2784 117.513 14.3128C116.639 14.3 115.772 14.463 114.964 14.7919C114.533 14.9654 114.124 15.1899 113.747 15.4605C113.681 15.5046 113.604 15.531 113.524 15.5369C113.443 15.5429 113.363 15.5282 113.291 15.4944C113.218 15.4606 113.155 15.4088 113.109 15.3439C113.062 15.2791 113.034 15.2035 113.025 15.1244V15.1244C113.025 15.021 112.984 14.9219 112.91 14.8488C112.836 14.7757 112.736 14.7346 112.632 14.7346H110.939C110.867 14.7342 110.796 14.7478 110.73 14.7748C110.663 14.8017 110.603 14.8415 110.552 14.8917C110.502 14.942 110.462 15.0017 110.434 15.0674C110.407 15.1331 110.393 15.2035 110.394 15.2745L110.361 36.0727ZM117.141 27.6526C115.697 27.6526 114.64 27.1521 113.971 26.1509C113.302 25.1498 112.976 23.8651 112.993 22.2967C112.993 20.7259 113.319 19.4447 113.971 18.4531C114.623 17.4615 115.647 16.9657 117.043 16.9657C117.907 16.9307 118.759 17.1824 119.462 17.6808C120.107 18.1745 120.595 18.8425 120.866 19.6044C121.186 20.466 121.344 21.3786 121.332 22.2967C121.344 23.2228 121.191 24.1438 120.881 25.0175C120.611 25.7752 120.129 26.4411 119.491 26.9375C118.813 27.4342 117.984 27.6865 117.141 27.6526V27.6526Z" />
                  <path d="M129.299 29.3438C129.3 29.4863 129.358 29.6227 129.46 29.7232C129.562 29.8237 129.7 29.8801 129.844 29.8801H131.721C131.792 29.8806 131.863 29.867 131.929 29.8403C131.996 29.8135 132.056 29.7741 132.106 29.7243C132.157 29.6744 132.197 29.6151 132.225 29.5498C132.252 29.4845 132.266 29.4145 132.266 29.3438V9.80771C132.266 9.66453 132.209 9.5272 132.107 9.42595C132.004 9.3247 131.866 9.26782 131.721 9.26782H129.844C129.7 9.26876 129.562 9.32595 129.46 9.427C129.358 9.52804 129.3 9.66482 129.299 9.80771V29.3438Z" />
                  <path d="M144.717 30.3162C146.141 30.3334 147.541 29.949 148.753 29.2079C149.79 28.5706 150.635 27.6676 151.197 26.5942C151.23 26.5277 151.248 26.4547 151.25 26.3806C151.251 26.3064 151.237 26.2327 151.207 26.1647C151.177 26.0966 151.133 26.0359 151.077 25.9866C151.021 25.9372 150.954 25.9006 150.883 25.8792L149.006 25.2928C148.879 25.256 148.744 25.2628 148.622 25.3122C148.5 25.3615 148.398 25.4505 148.334 25.5645C147.536 26.8946 146.287 27.5632 144.576 27.5632C144.018 27.5921 143.46 27.5046 142.938 27.3063C142.416 27.1079 141.943 26.8032 141.547 26.4119C140.875 25.6662 140.45 24.7338 140.331 23.7411C140.32 23.6676 140.326 23.5927 140.348 23.5216C140.369 23.4506 140.406 23.385 140.456 23.3296C140.506 23.2741 140.567 23.2301 140.636 23.2005C140.705 23.1709 140.779 23.1565 140.854 23.1583H151.143C151.281 23.1602 151.415 23.108 151.515 23.013C151.615 22.918 151.673 22.7878 151.677 22.6506C151.743 21.2231 151.515 19.7971 151.005 18.4602C150.528 17.2179 149.671 16.1542 148.554 15.4175C147.368 14.6757 145.985 14.3022 144.583 14.3449C143.207 14.2984 141.844 14.6287 140.645 15.2995C139.514 15.9712 138.6 16.9486 138.01 18.1169C137.361 19.4542 137.041 20.9243 137.075 22.4074C137.044 23.838 137.371 25.2538 138.024 26.5299C138.64 27.679 139.566 28.6359 140.699 29.2937C141.923 29.9811 143.31 30.334 144.717 30.3162ZM144.692 16.9263C146.819 16.9263 148.099 18.0395 148.533 20.2658C148.546 20.3403 148.542 20.4168 148.522 20.4898C148.502 20.5629 148.466 20.6305 148.416 20.688C148.367 20.7455 148.305 20.7913 148.235 20.8222C148.165 20.853 148.089 20.8681 148.013 20.8664H140.948C140.871 20.8682 140.794 20.8525 140.723 20.8205C140.653 20.7886 140.591 20.7413 140.541 20.6821C140.492 20.6229 140.457 20.5534 140.438 20.4788C140.42 20.4042 140.419 20.3265 140.436 20.2514C140.61 19.3716 141.047 18.5642 141.692 17.9346C142.421 17.2481 143.414 16.912 144.681 16.912L144.692 16.9263Z" />
                  <path d="M164.545 29.9588C164.669 29.9376 164.781 29.8735 164.862 29.7779C164.943 29.6823 164.986 29.5614 164.985 29.4368V28.0245C164.985 27.9462 164.968 27.8689 164.935 27.7977C164.902 27.7265 164.855 27.663 164.795 27.6113C164.736 27.5596 164.666 27.521 164.591 27.4979C164.515 27.4748 164.436 27.4679 164.357 27.4775C163.695 27.5485 163.027 27.5485 162.365 27.4775C162.034 27.4521 161.715 27.3481 161.434 27.1745C161.154 27.0008 160.919 26.7625 160.751 26.4799C160.56 26.1318 160.459 25.7426 160.455 25.3465C160.455 24.896 160.455 24.3668 160.455 23.759V17.6129C160.455 17.4697 160.512 17.3324 160.615 17.2311C160.717 17.1299 160.855 17.073 161 17.073H164.455C164.599 17.0721 164.737 17.0149 164.839 16.9138C164.941 16.8128 164.999 16.676 165 16.5331V15.2567C165 15.1135 164.942 14.9762 164.84 14.8749C164.738 14.7737 164.599 14.7168 164.455 14.7168H161C160.856 14.7159 160.718 14.6587 160.616 14.5576C160.514 14.4566 160.456 14.3198 160.455 14.1769V11.0484C160.454 10.9055 160.396 10.7688 160.294 10.6677C160.192 10.5667 160.054 10.5095 159.91 10.5085H158.025C157.881 10.5095 157.743 10.5667 157.641 10.6677C157.539 10.7688 157.481 10.9055 157.48 11.0484V14.1769C157.48 14.3195 157.423 14.4563 157.322 14.5574C157.221 14.6586 157.083 14.7159 156.939 14.7168H155.094C155.023 14.7168 154.952 14.7308 154.886 14.758C154.82 14.7851 154.76 14.825 154.71 14.8752C154.66 14.9253 154.62 14.9849 154.593 15.0504C154.566 15.1159 154.552 15.186 154.553 15.2567V16.5331C154.553 16.6757 154.61 16.8125 154.711 16.9136C154.813 17.0148 154.95 17.0721 155.094 17.073H156.939C157.01 17.073 157.081 17.087 157.147 17.1142C157.213 17.1414 157.273 17.1812 157.323 17.2314C157.373 17.2815 157.413 17.3411 157.44 17.4066C157.467 17.472 157.481 17.5422 157.48 17.6129V23.902C157.48 24.7244 157.49 25.4621 157.509 26.1152C157.545 26.7831 157.728 27.435 158.047 28.0245C158.408 28.7088 158.992 29.2519 159.704 29.5655C160.485 29.9053 161.327 30.0865 162.181 30.0982C162.971 30.1269 163.763 30.0802 164.545 29.9588V29.9588Z" />
                  <path d="M12.6978 37.7885C13.9379 37.7885 15.1273 37.3008 16.0045 36.4327C16.8818 35.5646 17.3751 34.387 17.3762 33.1588C17.3762 32.5504 17.2551 31.9481 17.02 31.3861C16.7848 30.8242 16.4402 30.3136 16.0057 29.8837C15.5712 29.4537 15.0554 29.1128 14.4879 28.8803C13.9203 28.6479 13.312 28.5285 12.6978 28.5291C11.4581 28.5291 10.2692 29.0168 9.39254 29.8851C8.51592 30.7533 8.02344 31.9309 8.02344 33.1588C8.02448 34.3863 8.5173 35.5633 9.39369 36.4313C10.2701 37.2993 11.4584 37.7874 12.6978 37.7885V37.7885Z" />
                  <path d="M36.4967 33.819C37.1109 33.8195 37.7191 33.7001 38.2867 33.4677C38.8543 33.2353 39.37 32.8943 39.8045 32.4644C40.239 32.0344 40.5837 31.5238 40.8188 30.9619C41.054 30.3999 41.175 29.7976 41.175 29.1893C41.174 27.961 40.6806 26.7835 39.8034 25.9153C38.9261 25.0472 37.7368 24.5596 36.4967 24.5596C35.2573 24.5606 34.0689 25.0487 33.1925 25.9167C32.3161 26.7847 31.8233 27.9617 31.8223 29.1893C31.8223 30.4171 32.3147 31.5948 33.1914 32.463C34.068 33.3312 35.2569 33.819 36.4967 33.819Z" />
                  <path d="M1.19056 45.0243C1.04358 45.0249 0.897769 44.9984 0.760589 44.9461C0.614571 44.8908 0.481068 44.8074 0.367791 44.7007C0.254515 44.5939 0.163711 44.4661 0.100625 44.3244C0.0375395 44.1827 0.00342228 44.03 0.000244509 43.8752C-0.00293326 43.7204 0.0248914 43.5665 0.0821112 43.4224C0.109724 43.3443 1.23 40.164 1.74675 29.3887C2.02682 23.5283 2.03471 20.9537 1.55741 15.1988C1.09588 9.69 1.84931 6.45117 3.77824 5.56429C6.48426 4.33361 8.93783 6.31832 11.3125 8.24053C13.9317 10.362 16.6378 12.5382 20.2668 12.0146C22.7401 11.6474 23.6474 9.354 24.748 5.89637C25.6079 3.2045 26.4915 0.426674 29.0871 0.035981C30.3099 -0.139831 31.655 0.329007 33.083 1.43467C39.9388 6.74418 47.9977 25.56 49.3546 39.4256C49.3699 39.5791 49.3544 39.734 49.3091 39.8815C49.2638 40.029 49.1895 40.1662 49.0906 40.2853C48.9916 40.4043 48.87 40.5028 48.7325 40.5752C48.5951 40.6476 48.4445 40.6924 48.2896 40.7071C47.9773 40.7365 47.6661 40.6419 47.4242 40.4441C47.1823 40.2463 47.0296 39.9615 46.9997 39.6522C45.6072 25.3959 37.3826 7.73656 31.6156 3.27875C30.7438 2.60676 29.9667 2.27465 29.4184 2.3567C28.2784 2.5247 27.6512 4.50162 26.9806 6.59964C25.9708 9.77207 24.7164 13.7181 20.5982 14.3314C15.9317 15.0269 12.5235 12.2686 9.78987 10.0338C7.50593 8.18584 6.03852 7.08409 4.74073 7.68966C4.19243 7.93971 3.4745 10.1432 3.8808 14.9995C4.36994 20.8873 4.3581 23.5127 4.07409 29.4903C3.52578 40.8946 2.30689 44.1218 2.25561 44.2546C2.17519 44.4731 2.03098 44.6629 1.84132 44.7999C1.65167 44.937 1.42514 45.0151 1.19056 45.0243V45.0243Z" />
                  <path d="M6.70257 35.8898C6.58688 35.8888 6.47392 35.8548 6.37733 35.7917C6.28074 35.7286 6.20464 35.6392 6.15821 35.5342C6.12575 35.4628 6.10808 35.3857 6.10622 35.3074C6.10437 35.2291 6.11839 35.1512 6.14744 35.0784C6.17649 35.0055 6.21999 34.9392 6.27536 34.8833C6.33074 34.8274 6.39687 34.783 6.46984 34.7528L11.1206 32.7759L6.23711 31.7914C6.16111 31.7765 6.08884 31.7468 6.02446 31.7041C5.96007 31.6614 5.90485 31.6066 5.86196 31.5426C5.81906 31.4787 5.78935 31.4071 5.77453 31.3318C5.75971 31.2564 5.76006 31.1789 5.77558 31.1038C5.7902 31.0281 5.81982 30.9561 5.86273 30.8919C5.90563 30.8277 5.96097 30.7726 6.02554 30.7297C6.09011 30.6868 6.16263 30.6571 6.2389 30.6422C6.31516 30.6272 6.39366 30.6274 6.46984 30.6427L13.2112 32.0024C13.3349 32.0266 13.4475 32.0893 13.5326 32.1814C13.6178 32.2735 13.671 32.39 13.6846 32.5142C13.697 32.6387 13.6693 32.7639 13.6056 32.872C13.5418 32.98 13.4452 33.0654 13.3296 33.1158L6.93531 35.839C6.86251 35.8728 6.783 35.8902 6.70257 35.8898V35.8898Z" />
                  <path d="M42.4956 30.1779H42.464L35.5175 29.8068C35.3956 29.8024 35.278 29.7606 35.1812 29.6871C35.0844 29.6135 35.013 29.512 34.9771 29.3965C34.9461 29.2758 34.9551 29.1484 35.0026 29.033C35.0502 28.9177 35.1339 28.8205 35.2414 28.7558L41.0992 25.181C41.2329 25.1009 41.393 25.0761 41.545 25.112C41.697 25.1478 41.8287 25.2413 41.9118 25.3724C41.9928 25.5055 42.0179 25.6647 41.9818 25.8158C41.9456 25.967 41.8511 26.0982 41.7185 26.1811L37.474 28.7675L42.5271 29.0371C42.6838 29.0462 42.8304 29.1161 42.9353 29.2317C43.0402 29.3473 43.0948 29.4992 43.0873 29.6544C43.0708 29.7984 43.0014 29.9314 42.8922 30.0279C42.7831 30.1245 42.6419 30.1779 42.4956 30.1779V30.1779Z" />
                  <path d="M23.9951 34.2058C23.0279 34.2468 22.0744 33.9687 21.2841 33.415C20.4938 32.8614 19.9114 32.0635 19.6284 31.1467C19.5683 30.9524 19.5869 30.7425 19.6805 30.5616C19.774 30.3807 19.935 30.243 20.1293 30.1778C20.3265 30.109 20.5433 30.1205 20.7319 30.2099C20.9205 30.2993 21.0655 30.4591 21.1352 30.6544C21.652 32.2172 23.0129 32.897 24.8708 32.5649C26.7287 32.2328 27.7228 31.1037 27.6873 29.4628C27.6873 29.2555 27.7704 29.0568 27.9183 28.9103C28.0663 28.7637 28.267 28.6814 28.4762 28.6814C28.6854 28.6814 28.8861 28.7637 29.034 28.9103C29.182 29.0568 29.2651 29.2555 29.2651 29.4628C29.3164 31.8773 27.7385 33.6666 25.1509 34.1316C24.7686 34.1903 24.3818 34.2151 23.9951 34.2058V34.2058Z" />
                  <path d="M10.7924 27.2477C10.7347 27.2537 10.6765 27.2537 10.6188 27.2477C10.4149 27.202 10.2376 27.078 10.1259 26.9029C10.0142 26.7278 9.97725 26.516 10.0232 26.3139C10.4176 24.6379 12.5754 22.0398 15.2459 21.6256C17.9164 21.2115 20.6421 23.1884 21.0918 24.7082C21.1208 24.8067 21.13 24.9099 21.1187 25.0119C21.1075 25.1139 21.076 25.2127 21.0262 25.3027C20.9764 25.3927 20.9092 25.4721 20.8284 25.5363C20.7476 25.6005 20.6548 25.6484 20.5554 25.6771C20.355 25.7353 20.1396 25.7124 19.9562 25.6136C19.7728 25.5147 19.6365 25.3479 19.5771 25.1497C19.3562 24.3996 17.4233 22.8641 15.4944 23.1689C13.5655 23.4736 11.8338 25.4661 11.5497 26.6851C11.502 26.8474 11.4023 26.99 11.2657 27.0914C11.1292 27.1929 10.9631 27.2477 10.7924 27.2477Z" />
                  <path d="M26.1721 24.6456C26.0985 24.6466 26.0253 24.6361 25.9551 24.6143C25.8554 24.5864 25.7622 24.5392 25.6808 24.4756C25.5995 24.412 25.5316 24.3331 25.4811 24.2435C25.4305 24.1539 25.3983 24.0553 25.3862 23.9533C25.3742 23.8513 25.3825 23.748 25.4108 23.6493C25.8052 22.231 27.2371 19.715 29.9905 19.2813C32.4953 18.8906 35.3789 20.5511 36.1875 22.2467C36.231 22.3405 36.2553 22.4419 36.259 22.5451C36.2627 22.6483 36.2457 22.7511 36.2091 22.8478C36.1724 22.9444 36.1167 23.0329 36.0453 23.1081C35.9739 23.1833 35.8882 23.2437 35.7931 23.2859C35.6981 23.3296 35.5954 23.3542 35.4908 23.3582C35.3862 23.3621 35.2819 23.3455 35.1838 23.3091C35.0858 23.2727 34.9961 23.2174 34.9198 23.1464C34.8436 23.0753 34.7824 22.9899 34.7398 22.8952C34.2507 21.8677 32.0851 20.5081 30.2193 20.805C28.247 21.1137 27.1937 23.0672 26.9097 24.0595C26.8672 24.223 26.7724 24.3685 26.6394 24.4741C26.5064 24.5798 26.3425 24.6399 26.1721 24.6456Z" />
                  <path d="M30.4359 27.4431C28.7783 27.441 27.1892 26.7879 26.0171 25.6271C24.8555 24.4765 24.1975 22.9203 24.1838 21.2944C23.9498 21.2556 23.7127 21.2357 23.4748 21.235C22.6909 21.2352 21.9267 21.4484 21.2627 21.8452C21.488 22.4887 21.6067 23.1705 21.608 23.8644C21.6059 25.5061 20.9466 27.08 19.7745 28.2408C18.6024 29.4017 17.0133 30.0548 15.3558 30.0568C13.6982 30.0548 12.1091 29.4017 10.9371 28.2408C9.90723 27.2208 9.27319 25.882 9.13306 24.4584L7.90041 24.6809C7.8423 24.6958 7.78284 24.7049 7.7229 24.7082C7.4922 24.7072 7.26916 24.6261 7.09258 24.4791C6.916 24.332 6.79707 24.1283 6.75646 23.9034C6.7331 23.7777 6.73498 23.6487 6.76199 23.5237C6.789 23.3987 6.84061 23.2802 6.91388 23.175C6.98714 23.0697 7.08063 22.9799 7.18899 22.9104C7.29735 22.841 7.41846 22.7934 7.54539 22.7704L9.26997 22.4556C9.5347 21.3417 10.108 20.3124 10.9385 19.4904C12.1104 18.3304 13.6989 17.6778 15.3558 17.6758C17.0126 17.6778 18.6011 18.3304 19.7731 19.4904C19.9735 19.6888 20.159 19.8993 20.3287 20.1201C21.2783 19.5719 22.363 19.278 23.4748 19.2776C23.8136 19.2771 24.1514 19.3042 24.4847 19.3585C24.7865 18.4301 25.308 17.5765 26.0171 16.8741C27.1892 15.7133 28.7783 15.0602 30.4359 15.0581C32.0934 15.0602 33.6825 15.7133 34.8546 16.8741C35.1197 17.1367 35.3586 17.4205 35.5696 17.7214C35.5862 17.7175 35.6029 17.7139 35.6197 17.7108L37.1068 17.4412C37.363 17.3956 37.627 17.4521 37.8413 17.5984C38.0556 17.7448 38.2028 17.9692 38.2507 18.2226C38.298 18.477 38.2415 18.7395 38.0936 18.9526C37.9457 19.1657 37.7185 19.3121 37.4618 19.3595L36.4441 19.544C36.6039 20.0941 36.6874 20.6681 36.6881 21.2506C36.686 22.8923 36.0266 24.4662 34.8546 25.6271C33.6825 26.7879 32.0934 27.441 30.4359 27.4431ZM30.4359 17.0116C29.3011 17.0126 28.213 17.4596 27.4106 18.2543C26.6082 19.049 26.157 20.1267 26.1559 21.2506C26.158 22.3742 26.6096 23.4512 27.4118 24.2458C28.214 25.0403 29.3014 25.4875 30.4359 25.4896C31.5703 25.4875 32.6577 25.0403 33.4599 24.2458C34.2621 23.4512 34.7137 22.3742 34.7158 21.2506C34.7147 20.1267 34.2635 19.049 33.4611 18.2543C32.6587 17.4596 31.5706 17.0126 30.4359 17.0116ZM15.3558 19.6253C14.2213 19.6274 13.1339 20.0747 12.3317 20.8692C11.5295 21.6637 11.0779 22.7407 11.0758 23.8644C11.0779 24.988 11.5295 26.065 12.3317 26.8595C13.1339 27.654 14.2213 28.1013 15.3558 28.1034C16.4902 28.1013 17.5776 27.654 18.3798 26.8595C19.182 26.065 19.6336 24.988 19.6357 23.8644C19.6326 22.7414 19.1805 21.6654 18.3785 20.8717C17.5764 20.078 16.4896 19.6313 15.3558 19.6292V19.6253Z" />
                </svg>
              </li>
              <li>
                <svg
                  viewBox="0 0 175 32"
                  className="w-full fill-current text-orange-600"
                  xmlns="http://www.w3.org/2000/svg"
                >
                  <path d="M42.9209 0.943769H51.4958V5.28719C53.5236 2.04402 56.8851 0.0162354 61.6955 0.0162354C69.2277 0.0162354 72.8899 4.81383 72.8899 14.038V31.0727H64.187V14.5018C64.187 10.0976 61.9834 7.43332 58.2764 7.43332C54.1025 7.43332 51.4958 10.6765 51.4958 15.6596V31.0727H42.9209V0.943769Z" />
                  <path d="M76.4114 15.9504C76.4114 6.62069 83.0161 0.0159912 92.4609 0.0159912C101.906 0.0159912 108.568 6.62069 108.568 15.9504C108.568 25.3377 101.906 32 92.4609 32C83.0161 32 76.4114 25.3377 76.4114 15.9504ZM99.9356 15.9504C99.9356 10.9673 96.8651 7.43308 92.4609 7.43308C88.1143 7.43308 85.0439 10.9673 85.0439 15.9504C85.0439 20.9911 88.1143 24.5861 92.4609 24.5861C96.8651 24.5829 99.9324 20.9911 99.9324 15.9504H99.9356Z" />
                  <path d="M142.058 31.0724H133.483V26.7258C131.456 29.9722 128.094 31.9999 123.281 31.9999C115.748 31.9999 112.086 27.2023 112.086 17.9782V0.943481H120.779V17.5144C120.779 21.9186 122.98 24.5828 126.69 24.5828C130.848 24.5828 133.467 21.3397 133.467 16.3566V0.943481H142.042L142.058 31.0724Z" />
                  <path d="M146.232 21.4453H154.75C154.865 24.343 157.472 26.0222 161.063 26.0222C164.367 26.0222 166.28 24.4006 166.28 22.6031C166.28 16.4622 146.984 22.6606 146.984 9.91503C146.984 3.83808 152.316 0 161.182 0C169.235 0 174.334 4.05557 174.855 10.7178H166.395C166.222 7.76252 164.137 5.96821 160.66 5.96821C157.462 5.96821 155.617 7.41708 155.617 9.56001C155.617 15.4131 174.855 9.21139 174.855 22.3088C174.855 28.277 169.581 31.984 160.833 31.984C151.91 32 146.405 28.0595 146.232 21.4453Z" />
                  <path d="M0 31H30.6858V15.6571C30.6858 7.18349 23.8165 0.31424 15.3429 0.31424V0.31424C6.86925 0.31424 0 7.18348 0 15.6571V31Z" />
                </svg>
              </li>
            </ul>
          </div>
        </section>

        <section className="bg-orange-50 pt-24 pb-36">
          <ul className="max-w-screen-lg mx-auto flex items-start space-x-12">
            <li className="mt-6 w-1/3 relative">
              <p className="bg-white border border-orange-200 text-sm leading-6 p-6 rounded-lg">
                "I needed to be able to run the most efficient crypto scam
                possible. I finally found the framework that made it simple.
                Thanks Redwood!"
              </p>
              <div className="-mb-9 -mr-6 flex items-end justify-right absolute bottom-0 right-0">
                <div className="flex flex-col items-end text-xs mr-2">
                  <span className="text-orange-800 font-semibold">
                    Rob Cameron
                  </span>
                  <span className="text-stone-500">Creator, Algostake</span>
                </div>
                <img
                  src="/images/rob.jpg"
                  alt="author"
                  className="block rounded-full border-4 border-orange-50 w-16 mt-12"
                />
              </div>
            </li>
            <li className="w-1/3 relative">
              <p className="bg-white border-2 border-orange-200 text-base leading-7 p-6 rounded-lg">
                "My frontend, database access, open API, and great testing was a
                breeze with Redwood. It freed me up to focus on my real product:
                illustrated images of cat anuses."
              </p>
              <div className="-mb-11 -mr-6 flex items-end justify-right absolute bottom-0 right-0">
                <div className="flex flex-col items-end text-sm mr-2">
                  <span className="text-orange-800 font-semibold">
                    Peter Pistorius
                  </span>
                  <span className="text-stone-500">Creator & CEO, Snaplet</span>
                </div>
                <img
                  src="/images/peter.gif"
                  alt="author"
                  className="block rounded-full border-4 border-orange-50 w-20 -mb-2 -mr-2"
                />
              </div>
            </li>
            <li className="mt-6 w-1/3 relative">
              <p className="bg-white border border-orange-200 text-sm leading-6 p-6 rounded-lg">
                "But what about CI/CD?"
              </p>
              <div className="-mb-9 -mr-6 flex items-end justify-right absolute bottom-0 right-0">
                <div className="flex flex-col items-end text-xs mr-2">
                  <span className="text-orange-800 font-semibold">
                    David Price
                  </span>
                  <span className="text-stone-500">CI/CD Enthusiast</span>
                </div>
                <img
                  src="/images/david.jpg"
                  alt="author"
                  className="block border-4 border-orange-50 rounded-full w-16 mt-12"
                />
              </div>
            </li>
          </ul>
        </section>

        <section className="max-w-screen-lg mx-auto py-24">
          <h2 className="text-center text-6xl font-black text-orange-900">
            Your Redwood Journey
          </h2>

          <div className="mt-12 w-full flex items-end justify-center">
            <div className="w-36 mx-auto">
              <img src="/images/sprout.svg" alt="Sprout" />
            </div>
            <div className="w-36 mx-auto">
              <img src="/images/sapling.svg" alt="sapling" />
            </div>
            <div className="w-36 mx-auto">
              <img src="/images/tree.svg" alt="tree" />
            </div>
          </div>

          <div className="flex items-start justify-center">
            <div className="w-1/3 text-center px-8">
              <h3 className="mt-4 title text-orange-700">
                Complete the Tutorial
              </h3>
              <p className="mt-2 text-sm text-stone-500 text-center leading-6">
                The best way to learn Redwood is to build something! The Redwood
                tutorial takes you through building a blog from scratch and
                touches on all the major features of the framework.
              </p>
            </div>
            <div className="w-1/3 text-center px-8">
              <h3 className="mt-4 title text-orange-700">Join the Community</h3>
              <p className="mt-2 text-sm text-stone-500 text-center leading-6">
                Join hundreds of other developers in their Redwood journey.
                Forums, chat and get togethers on Zoom. Make some friends while
                building your app.
              </p>
            </div>
            <div className="w-1/3 text-center px-8">
              <h3 className="mt-4 title text-orange-700">Build an App</h3>
              <p className="mt-2 text-sm text-stone-500 text-center leading-6">
                Take one of those domains you bought on a whim and start
                building it. Use your new network to help you if you get stuck
                and give back to others so we all grow together.
              </p>
            </div>
          </div>

          <div className="mt-8 flex items-start justify-center">
            <div className="w-1/3 flex justify-center">
              <button type="button" className="button">
                Get Started
              </button>
            </div>
            <div className="w-1/3 flex justify-center">
              <button type="button" className="button">
                Grow with Community
              </button>
            </div>
            <div className="w-1/3 flex justify-center">
              <button type="button" className="button">
                Start Building
              </button>
            </div>
          </div>
        </section>

        <section className="bg-orange-100">
          <div className="max-w-screen-lg mx-auto py-24">
            <h2 className="text-center text-6xl font-black text-orange-900">
              One API to Rule Them All
            </h2>
            <h3 className="text-center mt-4 text-xl text-stone-500">
              With GraphQL at the core, support any client you can dream of
            </h3>

            <div className="mt-24 flex justify-center">
              <div className="">
                <img src="/images/graphql_map.svg" alt="GraphQL clients" />
              </div>
            </div>
          </div>
        </section>

        <section className="bg-orange-50 py-24">
          <div className="max-w-screen-lg mx-auto">
            <h2 className="text-center text-6xl font-black text-teal-800">
              End-to-end Development the Redwood Way
            </h2>
            <h3 className="text-center mt-4 text-xl text-stone-500">
              From design to deployment, Redwood includes everything you need
              for modern app development
            </h3>

            <div className="mt-24 flex flex-col space-y-8">
              <div className="relative flex items-end">
                <div className="w-2/5 bg-white border-4 border-orange-400 hover:border-orange-300 p-8 pl-12 rounded-lg cursor-pointer transition duration-100">
                  <h3 className="title">Design</h3>
                  <p className="mt-2 text-sm">
                    Mockup, build and verify components in{' '}
                    <a href="#">Storybook</a>, even in complete isolation from
                    the backend. Work on design without worrying about data.
                  </p>
                  <div className="absolute top-1/2 left-0 transform -translate-y-1/2 -translate-x-1/2 flex items-center justify-center bg-white border-4 w-20 h-20 border-orange-400 rounded-full">
                    <span className="icon md-48 text-teal-500">touch_app</span>
                  </div>
                </div>

                <svg
                  viewBox="0 0 68 50"
                  xmlns="http://www.w3.org/2000/svg"
                  className="w-16 -ml-1 -mb-4 fill-current text-orange-400"
                >
                  <clipPath id="a">
                    <path d="m0 0h68v50h-68z" />
                  </clipPath>
                  <g clipPath="url(#a)">
                    <path
                      clipRule="evenodd"
                      d="m3 .00000308c-1.38071.00000009-2.5 1.11928692-2.5 2.49999692 0 1.38072 1.11929 2.5 2.5 2.5h43.5v35.9645l-11.6421-11.6422c-.9763-.9763-2.5592-.9763-3.5356 0-.9763.9763-.9763 2.5593 0 3.5356l15.9099 15.9099c.9763.9763 2.5593.9763 3.5356 0l15.9099-15.9099c.9763-.9763.9763-2.5593 0-3.5356s-2.5592-.9763-3.5356 0l-11.6421 11.6422v-37.9645c0-.08439-.0042-.16778-.0123-.25002.0081-.08222.0123-.16561.0123-.24998 0-1.38071-1.1193-2.5-2.5-2.5z"
                      fillRule="evenodd"
                    />
                  </g>
                </svg>
              </div>

              <div className="flex items-end">
                <div className="w-1/6"></div>
                <div className="relative w-2/5 -ml-8 bg-white border-4 border-orange-500 hover:border-orange-300 p-8 pl-12 rounded-lg cursor-pointer transition duration-100">
                  <h3 className="title">Test</h3>
                  <p className="mt-2 text-sm">
                    Whether it's{' '}
                    <span
                      className="border-b border-dashed border-stone-400 cursor-help"
                      title="Test Driven Development"
                    >
                      TDD
                    </span>{' '}
                    or{' '}
                    <span
                      className="border-b border-dashed border-stone-400 cursor-help"
                      title="Development Driven Testing"
                    >
                      DDT
                    </span>
                    , Redwood uses <a href="#">Jest</a> along with{' '}
                    <a href="#">mocks</a> and <a href="#">scenarios</a> to
                    verify functionality on the frontend and the backend.
                  </p>
                  <div className="absolute top-1/2 left-0 transform -translate-y-1/2 -translate-x-1/2 -ml-[2px] flex items-center justify-center bg-white border-4 w-20 h-20 border-orange-500 rounded-full">
                    <span className="icon md-48 text-teal-600">bug_report</span>
                  </div>
                </div>

                <svg
                  viewBox="0 0 68 50"
                  xmlns="http://www.w3.org/2000/svg"
                  className="w-16 -ml-1 -mb-4 fill-current text-orange-500"
                >
                  <clipPath id="a">
                    <path d="m0 0h68v50h-68z" />
                  </clipPath>
                  <g clipPath="url(#a)">
                    <path
                      clipRule="evenodd"
                      d="m3 .00000308c-1.38071.00000009-2.5 1.11928692-2.5 2.49999692 0 1.38072 1.11929 2.5 2.5 2.5h43.5v35.9645l-11.6421-11.6422c-.9763-.9763-2.5592-.9763-3.5356 0-.9763.9763-.9763 2.5593 0 3.5356l15.9099 15.9099c.9763.9763 2.5593.9763 3.5356 0l15.9099-15.9099c.9763-.9763.9763-2.5593 0-3.5356s-2.5592-.9763-3.5356 0l-11.6421 11.6422v-37.9645c0-.08439-.0042-.16778-.0123-.25002.0081-.08222.0123-.16561.0123-.24998 0-1.38071-1.1193-2.5-2.5-2.5z"
                      fillRule="evenodd"
                    />
                  </g>
                </svg>
              </div>

              <div className="flex items-end">
                <div className="w-2/6"></div>
                <div className="relative w-2/5 -ml-8 bg-white border-4 border-orange-600 hover:border-orange-300 p-8 pl-12 rounded-lg cursor-pointer transition duration-100">
                  <h3 className="title">Auth & Security</h3>
                  <p className="mt-2 text-sm">
                    Lock down your front and backends with your own{' '}
                    <a href="#">hosted auth</a> or integrate with nearly a dozen{' '}
                    <a href="#">third party auth providers</a>. Verify access
                    with <a href="#">RBAC</a> and <a href="#">Validators</a>.
                  </p>
                  <div className="absolute top-1/2 left-0 transform -translate-y-1/2 -translate-x-1/2 -ml-[2px] flex items-center justify-center bg-white border-4 w-20 h-20 border-orange-600 rounded-full">
                    <span className="icon md-48 text-teal-700">lock</span>
                  </div>
                </div>
                <svg
                  viewBox="0 0 68 50"
                  xmlns="http://www.w3.org/2000/svg"
                  className="w-16 -ml-1 -mb-4 fill-current text-orange-600"
                >
                  <clipPath id="a">
                    <path d="m0 0h68v50h-68z" />
                  </clipPath>
                  <g clipPath="url(#a)">
                    <path
                      clipRule="evenodd"
                      d="m3 .00000308c-1.38071.00000009-2.5 1.11928692-2.5 2.49999692 0 1.38072 1.11929 2.5 2.5 2.5h43.5v35.9645l-11.6421-11.6422c-.9763-.9763-2.5592-.9763-3.5356 0-.9763.9763-.9763 2.5593 0 3.5356l15.9099 15.9099c.9763.9763 2.5593.9763 3.5356 0l15.9099-15.9099c.9763-.9763.9763-2.5593 0-3.5356s-2.5592-.9763-3.5356 0l-11.6421 11.6422v-37.9645c0-.08439-.0042-.16778-.0123-.25002.0081-.08222.0123-.16561.0123-.24998 0-1.38071-1.1193-2.5-2.5-2.5z"
                      fillRule="evenodd"
                    />
                  </g>
                </svg>
              </div>

              <div className="flex items-end">
                <div className="w-3/6"></div>
                <div className="relative w-2/5 -ml-8 bg-white border-4 border-orange-700 hover:border-orange-300 p-8 pl-12 rounded-lg cursor-pointer transition duration-100">
                  <h3 className="title">Data & Transport</h3>
                  <p className="mt-2 text-sm">
                    When your API is <a href="#">GraphQL</a> you're ready for
                    any client, from the browser to native mobile apps and more.
                    Transform your data with <a href="#">Directives</a> and keep
                    your business logic organized and reusable within{' '}
                    <a href="#">Services</a>.
                  </p>
                  <div className="absolute top-1/2 left-0 transform -translate-y-1/2 -translate-x-1/2 -ml-[2px] flex items-center justify-center bg-white border-4 w-20 h-20 border-orange-700 rounded-full">
                    <span className="icon md-48 text-teal-800">
                      local_shipping
                    </span>
                  </div>
                </div>
                <svg
                  viewBox="0 0 68 50"
                  xmlns="http://www.w3.org/2000/svg"
                  className="w-16 -ml-1 -mb-4 fill-current text-orange-700"
                >
                  <clipPath id="a">
                    <path d="m0 0h68v50h-68z" />
                  </clipPath>
                  <g clipPath="url(#a)">
                    <path
                      clipRule="evenodd"
                      d="m3 .00000308c-1.38071.00000009-2.5 1.11928692-2.5 2.49999692 0 1.38072 1.11929 2.5 2.5 2.5h43.5v35.9645l-11.6421-11.6422c-.9763-.9763-2.5592-.9763-3.5356 0-.9763.9763-.9763 2.5593 0 3.5356l15.9099 15.9099c.9763.9763 2.5593.9763 3.5356 0l15.9099-15.9099c.9763-.9763.9763-2.5593 0-3.5356s-2.5592-.9763-3.5356 0l-11.6421 11.6422v-37.9645c0-.08439-.0042-.16778-.0123-.25002.0081-.08222.0123-.16561.0123-.24998 0-1.38071-1.1193-2.5-2.5-2.5z"
                      fillRule="evenodd"
                    />
                  </g>
                </svg>
              </div>

              <div className="flex items-end">
                <div className="w-4/6"></div>
                <div className="relative w-2/5 bg-white border-4 border-orange-800 hover:border-orange-300 p-8 pl-12 rounded-lg cursor-pointer transition duration-100">
                  <h3 className="title">Deploy</h3>
                  <p className="mt-2 text-sm">
                    Deploy your app to serverless hosts divke{' '}
                    <a href="#">Netlify</a> and <a href="#">Vercel</a>, build
                    for <a href="#">containers</a>, or deploy to{' '}
                    <a href="#">bare metal</a>.
                  </p>
                  <div className="absolute top-1/2 left-0 transform -translate-y-1/2 -translate-x-1/2 -ml-[2px] flex items-center justify-center bg-white border-4 w-20 h-20 border-orange-800 rounded-full">
                    <span className="icon md-48 text-teal-900">
                      cloud_upload
                    </span>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div className="mt-24 flex flex-col items-center ">
            <h2 className="text-center text-5xl font-black text-teal-800">
              Watch it in action
            </h2>
            <h3 className="text-center mt-4 text-xl text-stone-500">
              Watch a feature being designed, built and deployed in Redwood
            </h3>
            <div className="mt-12">
              <iframe
                width="1024"
                height="576"
                src="https://www.youtube.com/embed/tiF9SdM1i7M"
                title="YouTube video player"
                frameBorder="0"
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                allowFullScreen
              ></iframe>
            </div>
          </div>
        </section>

        <section className="border-16 border-teal-600 bg-gradient-to-r from-teal-700 to-teal-500 text-white py-24">
          <div className="flex flex-col items-center justify-center max-w-screen-lg mx-auto">
            <h2 className="text-6xl font-black text-right px-4">
              Ready to learn Redwood?
            </h2>
            <h3 className="text-center mt-4 text-xl text-teal-200">
              Start from{' '}
              <span
                className="
              bg-teal-500 rounded px-1 py-[2px] text-teal-100 font-mono"
              >
                yarn install
              </span>{' '}
              and end up with a deployed app,
              <br />
              taking a tour of all major Redwood features
            </h3>
          </div>
          <div className="max-w-screen-lg mx-auto mt-24 pb-4 flex justify-center">
            <button type="button" className="button-invert">
              Start the Tutorial
            </button>
          </div>
        </section>
      </div>
    </>
  )
}

export default HomePage
