---
description: Redwood is the full-stack web framework designed to help you grow from side project to startup
---

# Introduction

Redwood is the full-stack web framework designed to help you grow from side project to startup.
Redwood features an end-to-end development workflow that weaves together the best parts of [React](https://reactjs.org/), [GraphQL](https://graphql.org/), [Prisma](https://www.prisma.io/), [TypeScript](https://www.typescriptlang.org/), [Jest](https://jestjs.io/), and [Storybook](https://storybook.js.org/).
For full inspiration and vision, see Redwood's [README](https://github.com/redwoodjs/redwood/blob/main/README.md).

Development on Redwood happens in the [redwoodjs/redwood repo on GitHub](https://github.com/redwoodjs/redwood).
The docs are [there too](https://github.com/redwoodjs/redwood/tree/main/docs).
While Redwood's [leadership and maintainers](https://github.com/redwoodjs/redwood#core-team-leadership)
handle most of the high-priority items and the day-to-day, Redwood wouldn't be
where it is without [all its contributors](https://github.com/redwoodjs/redwood#all-contributors)!
Feel free to reach out to us on the [forums](https://community.redwoodjs.com) or on [Discord](https://discord.gg/redwoodjs), and follow us on [Twitter](https://twitter.com/redwoodjs) for updates.

## Getting the Most out of Redwood

To get the most out of Redwood, do two things:

- [Start the tutorial](tutorial/foreword.md)
- [Join the community](https://redwoodjs.com/community)

The tutorial is the best way to start your Redwood adventure.
It's readable, feature-ful, and fun.
You'll go all the way from `git clone` to Netlify deploy!
And by the end, you should feel comfortable enough to start that side project.

After you've read the tutorial and started your side project, come say hi and tell us all about it by joining the community.
Redwood wouldn't be where it is without the people who use and contribute to it.
We warmly welcome you!

## How these Docs are Organized

As you can probably tell from the sidebar, Redwood's docs are organized into three sections:

- [Tutorial](tutorial/foreword.md)
- [Reference](index)
- [How To](how-to/index)

The order isn't arbitrary.
This is more or less the learning journey we have in mind for you.

While we expect you to read the tutorial from top to bottom (maybe even more than once?), we of course don't expect you to read the Reference and How To sections that way.
The content in those sections is there on an as-needed basis.
You need to know about the Router? Check out the [Router](router.md) reference.
You need to upload files? Check out the [File Uploads](how-to/file-uploads.md) how to.

That said, there are some references you should consider reading at some point in your Redwood learning journey.
Especially if you want to become an advanced user.
For example, [Services](services.md) are fundamental to Redwood.
It's worth getting to know them inside and out.
And if you're not writing [tests](testing.md) and [stories](storybook.md), you're not using Redwood to its full potential.

> **We realize that the content doesn't always match the organization**
>
> For example, half the [Testing](testing.md) reference reads like a tutorial, and half the [Logger](logger.md) reference read like a how to.
> Till now, we've focused on coverage, making sure we had content on all of Redwood's feature somewhere at least.
> We'll shift our focus to organization and pay more attention to how we can curate the experience.
