import type { EditEmptyUserById, UpdateEmptyUserInput } from 'types/graphql'

import type { RWGqlError } from '@redwoodjs/forms'
import {
  Form,
  FormError,
  FieldError,
  Label,
  TextField,
  Submit,
} from '@redwoodjs/forms'

type FormEmptyUser = NonNullable<EditEmptyUserById['emptyUser']>

interface EmptyUserFormProps {
  emptyUser?: EditEmptyUserById['emptyUser']
  onSave: (data: UpdateEmptyUserInput, id?: FormEmptyUser['id']) => void
  error: RWGqlError
  loading: boolean
}

const EmptyUserForm = (props: EmptyUserFormProps) => {
  const onSubmit = (data: FormEmptyUser) => {
    props.onSave(data, props?.emptyUser?.id)
  }

  return (
    <div className="rw-form-wrapper">
      <Form<FormEmptyUser> onSubmit={onSubmit} error={props.error}>
        <FormError
          error={props.error}
          wrapperClassName="rw-form-error-wrapper"
          titleClassName="rw-form-error-title"
          listClassName="rw-form-error-list"
        />

        <Label
          name="email"
          className="rw-label"
          errorClassName="rw-label rw-label-error"
        >
          Email
        </Label>

        <TextField
          name="email"
          defaultValue={props.emptyUser?.email}
          className="rw-input"
          errorClassName="rw-input rw-input-error"
          validation={{ required: true }}
        />

        <FieldError name="email" className="rw-field-error" />

        <Label
          name="name"
          className="rw-label"
          errorClassName="rw-label rw-label-error"
        >
          Name
        </Label>

        <TextField
          name="name"
          defaultValue={props.emptyUser?.name}
          className="rw-input"
          errorClassName="rw-input rw-input-error"
        />

        <FieldError name="name" className="rw-field-error" />

        <div className="rw-button-group">
          <Submit disabled={props.loading} className="rw-button rw-button-blue">
            Save
          </Submit>
        </div>
      </Form>
    </div>
  )
}

export default EmptyUserForm
