# Security Policy

The Redwood repo is scanned frequently for code and dependency vulnerabilities. Notifications are received by the Redwood Core Team members, who assess risk, prioritize, and determine a remediation plan. Typically this process involves a package update or patch release and is resolved within 24 hours of notification.

## Supported Versions

| Version | Supported          |
| ------- | ------------------ |
| 0.x.x   | :white_check_mark: |

## Reporting a Vulnerability

If you discover a potential security issue, do let us know as soon as possible. We'll work toward a resolution as quickly as possible, so please provide us with a reasonable amount of time before disclosure to the public or a third-party.

There are two ways to contact us:

1. Email [security@redwoodjs.com](mailto:security@redwoodjs.com), or
2. Use GitHub's private [Vulnerability Reporting feature](https://github.com/redwoodjs/redwood/security/advisories) (to learn how this works, [click here](https://docs.github.com/en/code-security/security-advisories/repository-security-advisories/configuring-private-vulnerability-reporting-for-a-repository))

Thank you for helping improve Redwood security!

## Security is Everyone's Responsibility

We take security seriously. Which is why we offer a friendly reminder that "Redwood Framework Security" **!=** "Security of Applications built with Redwood"

It's our responsibility (Core Team members) to implement security best practices and make the framework as secure as possible. We will do as much as we can; however, we can only do so much. Ultimately, security rests in the hands of the application developers who use Redwood. If you haven't already, we recommend starting the security process for your application with [GitHub's Security Tools and Best Practices](https://docs.github.com/en/github/managing-security-vulnerabilities/managing-security-vulnerabilities-in-your-project).
