- fix(dbAuth): Fix WebAuthn when authModelAccessor is set to a custom value (#11605) by @antonmoiseev

Previously if you had setup dbAuth with WebAuthn support and had chosen to rename the `User` and `UserCredential` models to some other name, such as `Account` and `AccountCredential` then dbAuth would have failed with an error something like:

```
{
  "error": "this.dbCredentialAccessor.findFirst(...).user is not a function"
}
```

This change fixes the database access so that it correctly takes into account the configured `authModelAccessor`.

**Note**: You should ensure your WebAuthn table has a unique index applied on the configured `id` column. Something like what our setup command generates will work great:

```
model UserCredential {
  id         String @id // <-- Note the index!
  ...
}
```
