// We use this to construct the data:
// yarn add timezones.json
//
// import { compact, flatten, uniqBy } from 'lodash'
// import zones from 'timezones.json'
// const converted = zones.map((zone) => {
//   return zone.utc.map((code) => {
//     if (code.startsWith('Etc/GMT')) {
//       return
//     } else if (zone.text.includes('Daylight')) {
//       return
//     }
//     const offsetStr = zone.text.replace(/^(\([^\)]+\) ).+$/, '$1')
//     const name = `${offsetStr}${code.replace('_', ' ')}`
//     return {
//       code,
//       name,
//       offset: zone.offset,
//       shortcode: zone.abbr,
//     }
//   })
// })
// console.dir(JSON.stringify(uniqBy(compact(flatten(converted)), 'code')))

/**
 * A list of available timezones.
 *
 * Based on https://github.com/dmfilipenko/timezones.json
 */
export const timezones = [
  {
    code: 'Pacific/Midway',
    name: '(UTC-11:00) Pacific/Midway',
    offset: -11,
    shortcode: 'U',
  },
  {
    code: 'Pacific/Niue',
    name: '(UTC-11:00) Pacific/Niue',
    offset: -11,
    shortcode: 'U',
  },
  {
    code: 'Pacific/Pago_Pago',
    name: '(UTC-11:00) Pacific/Pago Pago',
    offset: -11,
    shortcode: 'U',
  },
  {
    code: 'Pacific/Honolulu',
    name: '(UTC-10:00) Pacific/Honolulu',
    offset: -10,
    shortcode: 'HST',
  },
  {
    code: 'Pacific/Johnston',
    name: '(UTC-10:00) Pacific/Johnston',
    offset: -10,
    shortcode: 'HST',
  },
  {
    code: 'Pacific/Rarotonga',
    name: '(UTC-10:00) Pacific/Rarotonga',
    offset: -10,
    shortcode: 'HST',
  },
  {
    code: 'Pacific/Tahiti',
    name: '(UTC-10:00) Pacific/Tahiti',
    offset: -10,
    shortcode: 'HST',
  },
  {
    code: 'America/Anchorage',
    name: '(UTC-09:00) America/Anchorage',
    offset: -8,
    shortcode: 'AKDT',
  },
  {
    code: 'America/Juneau',
    name: '(UTC-09:00) America/Juneau',
    offset: -8,
    shortcode: 'AKDT',
  },
  {
    code: 'America/Nome',
    name: '(UTC-09:00) America/Nome',
    offset: -8,
    shortcode: 'AKDT',
  },
  {
    code: 'America/Sitka',
    name: '(UTC-09:00) America/Sitka',
    offset: -8,
    shortcode: 'AKDT',
  },
  {
    code: 'America/Yakutat',
    name: '(UTC-09:00) America/Yakutat',
    offset: -8,
    shortcode: 'AKDT',
  },
  {
    code: 'America/Santa_Isabel',
    name: '(UTC-08:00) America/Santa Isabel',
    offset: -7,
    shortcode: 'PDT',
  },
  {
    code: 'America/Los_Angeles',
    name: '(UTC-08:00) America/Los Angeles',
    offset: -8,
    shortcode: 'PST',
  },
  {
    code: 'America/Tijuana',
    name: '(UTC-08:00) America/Tijuana',
    offset: -8,
    shortcode: 'PST',
  },
  {
    code: 'America/Vancouver',
    name: '(UTC-08:00) America/Vancouver',
    offset: -8,
    shortcode: 'PST',
  },
  {
    code: 'PST8PDT',
    name: '(UTC-08:00) PST8PDT',
    offset: -8,
    shortcode: 'PST',
  },
  {
    code: 'America/Creston',
    name: '(UTC-07:00) America/Creston',
    offset: -7,
    shortcode: 'UMST',
  },
  {
    code: 'America/Dawson',
    name: '(UTC-07:00) America/Dawson',
    offset: -7,
    shortcode: 'UMST',
  },
  {
    code: 'America/Dawson_Creek',
    name: '(UTC-07:00) America/Dawson Creek',
    offset: -7,
    shortcode: 'UMST',
  },
  {
    code: 'America/Hermosillo',
    name: '(UTC-07:00) America/Hermosillo',
    offset: -7,
    shortcode: 'UMST',
  },
  {
    code: 'America/Phoenix',
    name: '(UTC-07:00) America/Phoenix',
    offset: -7,
    shortcode: 'UMST',
  },
  {
    code: 'America/Whitehorse',
    name: '(UTC-07:00) America/Whitehorse',
    offset: -7,
    shortcode: 'UMST',
  },
  {
    code: 'America/Chihuahua',
    name: '(UTC-07:00) America/Chihuahua',
    offset: -6,
    shortcode: 'MDT',
  },
  {
    code: 'America/Mazatlan',
    name: '(UTC-07:00) America/Mazatlan',
    offset: -6,
    shortcode: 'MDT',
  },
  {
    code: 'America/Boise',
    name: '(UTC-07:00) America/Boise',
    offset: -6,
    shortcode: 'MDT',
  },
  {
    code: 'America/Cambridge_Bay',
    name: '(UTC-07:00) America/Cambridge Bay',
    offset: -6,
    shortcode: 'MDT',
  },
  {
    code: 'America/Denver',
    name: '(UTC-07:00) America/Denver',
    offset: -6,
    shortcode: 'MDT',
  },
  {
    code: 'America/Edmonton',
    name: '(UTC-07:00) America/Edmonton',
    offset: -6,
    shortcode: 'MDT',
  },
  {
    code: 'America/Inuvik',
    name: '(UTC-07:00) America/Inuvik',
    offset: -6,
    shortcode: 'MDT',
  },
  {
    code: 'America/Ojinaga',
    name: '(UTC-07:00) America/Ojinaga',
    offset: -6,
    shortcode: 'MDT',
  },
  {
    code: 'America/Yellowknife',
    name: '(UTC-07:00) America/Yellowknife',
    offset: -6,
    shortcode: 'MDT',
  },
  {
    code: 'MST7MDT',
    name: '(UTC-07:00) MST7MDT',
    offset: -6,
    shortcode: 'MDT',
  },
  {
    code: 'America/Belize',
    name: '(UTC-06:00) America/Belize',
    offset: -6,
    shortcode: 'CAST',
  },
  {
    code: 'America/Costa_Rica',
    name: '(UTC-06:00) America/Costa Rica',
    offset: -6,
    shortcode: 'CAST',
  },
  {
    code: 'America/El_Salvador',
    name: '(UTC-06:00) America/El Salvador',
    offset: -6,
    shortcode: 'CAST',
  },
  {
    code: 'America/Guatemala',
    name: '(UTC-06:00) America/Guatemala',
    offset: -6,
    shortcode: 'CAST',
  },
  {
    code: 'America/Managua',
    name: '(UTC-06:00) America/Managua',
    offset: -6,
    shortcode: 'CAST',
  },
  {
    code: 'America/Tegucigalpa',
    name: '(UTC-06:00) America/Tegucigalpa',
    offset: -6,
    shortcode: 'CAST',
  },
  {
    code: 'Pacific/Galapagos',
    name: '(UTC-06:00) Pacific/Galapagos',
    offset: -6,
    shortcode: 'CAST',
  },
  {
    code: 'America/Chicago',
    name: '(UTC-06:00) America/Chicago',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/Indiana/Knox',
    name: '(UTC-06:00) America/Indiana/Knox',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/Indiana/Tell_City',
    name: '(UTC-06:00) America/Indiana/Tell City',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/Matamoros',
    name: '(UTC-06:00) America/Matamoros',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/Menominee',
    name: '(UTC-06:00) America/Menominee',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/North_Dakota/Beulah',
    name: '(UTC-06:00) America/North Dakota/Beulah',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/North_Dakota/Center',
    name: '(UTC-06:00) America/North Dakota/Center',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/North_Dakota/New_Salem',
    name: '(UTC-06:00) America/North Dakota/New_Salem',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/Rainy_River',
    name: '(UTC-06:00) America/Rainy River',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/Rankin_Inlet',
    name: '(UTC-06:00) America/Rankin Inlet',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/Resolute',
    name: '(UTC-06:00) America/Resolute',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/Winnipeg',
    name: '(UTC-06:00) America/Winnipeg',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'CST6CDT',
    name: '(UTC-06:00) CST6CDT',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/Bahia_Banderas',
    name: '(UTC-06:00) America/Bahia Banderas',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/Cancun',
    name: '(UTC-06:00) America/Cancun',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/Merida',
    name: '(UTC-06:00) America/Merida',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/Mexico_City',
    name: '(UTC-06:00) America/Mexico City',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/Monterrey',
    name: '(UTC-06:00) America/Monterrey',
    offset: -5,
    shortcode: 'CDT',
  },
  {
    code: 'America/Regina',
    name: '(UTC-06:00) America/Regina',
    offset: -6,
    shortcode: 'CCST',
  },
  {
    code: 'America/Swift_Current',
    name: '(UTC-06:00) America/Swift Current',
    offset: -6,
    shortcode: 'CCST',
  },
  {
    code: 'America/Bogota',
    name: '(UTC-05:00) America/Bogota',
    offset: -5,
    shortcode: 'SPST',
  },
  {
    code: 'America/Cayman',
    name: '(UTC-05:00) America/Cayman',
    offset: -5,
    shortcode: 'SPST',
  },
  {
    code: 'America/Coral_Harbour',
    name: '(UTC-05:00) America/Coral Harbour',
    offset: -5,
    shortcode: 'SPST',
  },
  {
    code: 'America/Eirunepe',
    name: '(UTC-05:00) America/Eirunepe',
    offset: -5,
    shortcode: 'SPST',
  },
  {
    code: 'America/Guayaquil',
    name: '(UTC-05:00) America/Guayaquil',
    offset: -5,
    shortcode: 'SPST',
  },
  {
    code: 'America/Jamaica',
    name: '(UTC-05:00) America/Jamaica',
    offset: -5,
    shortcode: 'SPST',
  },
  {
    code: 'America/Lima',
    name: '(UTC-05:00) America/Lima',
    offset: -5,
    shortcode: 'SPST',
  },
  {
    code: 'America/Panama',
    name: '(UTC-05:00) America/Panama',
    offset: -5,
    shortcode: 'SPST',
  },
  {
    code: 'America/Rio_Branco',
    name: '(UTC-05:00) America/Rio Branco',
    offset: -5,
    shortcode: 'SPST',
  },
  {
    code: 'America/Detroit',
    name: '(UTC-05:00) America/Detroit',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/Havana',
    name: '(UTC-05:00) America/Havana',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/Indiana/Petersburg',
    name: '(UTC-05:00) America/Indiana/Petersburg',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/Indiana/Vincennes',
    name: '(UTC-05:00) America/Indiana/Vincennes',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/Indiana/Winamac',
    name: '(UTC-05:00) America/Indiana/Winamac',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/Iqaluit',
    name: '(UTC-05:00) America/Iqaluit',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/Kentucky/Monticello',
    name: '(UTC-05:00) America/Kentucky/Monticello',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/Louisville',
    name: '(UTC-05:00) America/Louisville',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/Montreal',
    name: '(UTC-05:00) America/Montreal',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/Nassau',
    name: '(UTC-05:00) America/Nassau',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/New_York',
    name: '(UTC-05:00) America/New York',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/Nipigon',
    name: '(UTC-05:00) America/Nipigon',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/Pangnirtung',
    name: '(UTC-05:00) America/Pangnirtung',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/Port-au-Prince',
    name: '(UTC-05:00) America/Port-au-Prince',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/Thunder_Bay',
    name: '(UTC-05:00) America/Thunder Bay',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/Toronto',
    name: '(UTC-05:00) America/Toronto',
    offset: -5,
    shortcode: 'EST',
  },
  {
    code: 'America/Indiana/Marengo',
    name: '(UTC-05:00) America/Indiana/Marengo',
    offset: -5,
    shortcode: 'UEDT',
  },
  {
    code: 'America/Indiana/Vevay',
    name: '(UTC-05:00) America/Indiana/Vevay',
    offset: -5,
    shortcode: 'UEDT',
  },
  {
    code: 'America/Indianapolis',
    name: '(UTC-05:00) America/Indianapolis',
    offset: -5,
    shortcode: 'UEDT',
  },
  {
    code: 'America/Caracas',
    name: '(UTC-04:30) America/Caracas',
    offset: -4.5,
    shortcode: 'VST',
  },
  {
    code: 'America/Asuncion',
    name: '(UTC-04:00) America/Asuncion',
    offset: -4,
    shortcode: 'PYT',
  },
  {
    code: 'America/Glace_Bay',
    name: '(UTC-04:00) America/Glace Bay',
    offset: -3,
    shortcode: 'ADT',
  },
  {
    code: 'America/Goose_Bay',
    name: '(UTC-04:00) America/Goose Bay',
    offset: -3,
    shortcode: 'ADT',
  },
  {
    code: 'America/Halifax',
    name: '(UTC-04:00) America/Halifax',
    offset: -3,
    shortcode: 'ADT',
  },
  {
    code: 'America/Moncton',
    name: '(UTC-04:00) America/Moncton',
    offset: -3,
    shortcode: 'ADT',
  },
  {
    code: 'America/Thule',
    name: '(UTC-04:00) America/Thule',
    offset: -3,
    shortcode: 'ADT',
  },
  {
    code: 'Atlantic/Bermuda',
    name: '(UTC-04:00) Atlantic/Bermuda',
    offset: -3,
    shortcode: 'ADT',
  },
  {
    code: 'America/Campo_Grande',
    name: '(UTC-04:00) America/Campo Grande',
    offset: -4,
    shortcode: 'CBST',
  },
  {
    code: 'America/Cuiaba',
    name: '(UTC-04:00) America/Cuiaba',
    offset: -4,
    shortcode: 'CBST',
  },
  {
    code: 'America/Anguilla',
    name: '(UTC-04:00) America/Anguilla',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Antigua',
    name: '(UTC-04:00) America/Antigua',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Aruba',
    name: '(UTC-04:00) America/Aruba',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Barbados',
    name: '(UTC-04:00) America/Barbados',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Blanc-Sablon',
    name: '(UTC-04:00) America/Blanc-Sablon',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Boa_Vista',
    name: '(UTC-04:00) America/Boa Vista',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Curacao',
    name: '(UTC-04:00) America/Curacao',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Dominica',
    name: '(UTC-04:00) America/Dominica',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Grand_Turk',
    name: '(UTC-04:00) America/Grand Turk',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Grenada',
    name: '(UTC-04:00) America/Grenada',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Guadeloupe',
    name: '(UTC-04:00) America/Guadeloupe',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Guyana',
    name: '(UTC-04:00) America/Guyana',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Kralendijk',
    name: '(UTC-04:00) America/Kralendijk',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/La_Paz',
    name: '(UTC-04:00) America/La Paz',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Lower_Princes',
    name: '(UTC-04:00) America/Lower Princes',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Manaus',
    name: '(UTC-04:00) America/Manaus',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Marigot',
    name: '(UTC-04:00) America/Marigot',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Martinique',
    name: '(UTC-04:00) America/Martinique',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Montserrat',
    name: '(UTC-04:00) America/Montserrat',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Port_of_Spain',
    name: '(UTC-04:00) America/Port of_Spain',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Porto_Velho',
    name: '(UTC-04:00) America/Porto Velho',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Puerto_Rico',
    name: '(UTC-04:00) America/Puerto Rico',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Santo_Domingo',
    name: '(UTC-04:00) America/Santo Domingo',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/St_Barthelemy',
    name: '(UTC-04:00) America/St Barthelemy',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/St_Kitts',
    name: '(UTC-04:00) America/St Kitts',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/St_Lucia',
    name: '(UTC-04:00) America/St Lucia',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/St_Thomas',
    name: '(UTC-04:00) America/St Thomas',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/St_Vincent',
    name: '(UTC-04:00) America/St Vincent',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Tortola',
    name: '(UTC-04:00) America/Tortola',
    offset: -4,
    shortcode: 'SWST',
  },
  {
    code: 'America/Santiago',
    name: '(UTC-04:00) America/Santiago',
    offset: -4,
    shortcode: 'PSST',
  },
  {
    code: 'Antarctica/Palmer',
    name: '(UTC-04:00) Antarctica/Palmer',
    offset: -4,
    shortcode: 'PSST',
  },
  {
    code: 'America/St_Johns',
    name: '(UTC-03:30) America/St Johns',
    offset: -2.5,
    shortcode: 'NDT',
  },
  {
    code: 'America/Sao_Paulo',
    name: '(UTC-03:00) America/Sao Paulo',
    offset: -3,
    shortcode: 'ESAST',
  },
  {
    code: 'America/Argentina/La_Rioja',
    name: '(UTC-03:00) America/Argentina/La Rioja',
    offset: -3,
    shortcode: 'AST',
  },
  {
    code: 'America/Argentina/Rio_Gallegos',
    name: '(UTC-03:00) America/Argentina/Rio Gallegos',
    offset: -3,
    shortcode: 'AST',
  },
  {
    code: 'America/Argentina/Salta',
    name: '(UTC-03:00) America/Argentina/Salta',
    offset: -3,
    shortcode: 'AST',
  },
  {
    code: 'America/Argentina/San_Juan',
    name: '(UTC-03:00) America/Argentina/San Juan',
    offset: -3,
    shortcode: 'AST',
  },
  {
    code: 'America/Argentina/San_Luis',
    name: '(UTC-03:00) America/Argentina/San Luis',
    offset: -3,
    shortcode: 'AST',
  },
  {
    code: 'America/Argentina/Tucuman',
    name: '(UTC-03:00) America/Argentina/Tucuman',
    offset: -3,
    shortcode: 'AST',
  },
  {
    code: 'America/Argentina/Ushuaia',
    name: '(UTC-03:00) America/Argentina/Ushuaia',
    offset: -3,
    shortcode: 'AST',
  },
  {
    code: 'America/Buenos_Aires',
    name: '(UTC-03:00) America/Buenos Aires',
    offset: -3,
    shortcode: 'AST',
  },
  {
    code: 'America/Catamarca',
    name: '(UTC-03:00) America/Catamarca',
    offset: -3,
    shortcode: 'AST',
  },
  {
    code: 'America/Cordoba',
    name: '(UTC-03:00) America/Cordoba',
    offset: -3,
    shortcode: 'AST',
  },
  {
    code: 'America/Jujuy',
    name: '(UTC-03:00) America/Jujuy',
    offset: -3,
    shortcode: 'AST',
  },
  {
    code: 'America/Mendoza',
    name: '(UTC-03:00) America/Mendoza',
    offset: -3,
    shortcode: 'AST',
  },
  {
    code: 'America/Araguaina',
    name: '(UTC-03:00) America/Araguaina',
    offset: -3,
    shortcode: 'SEST',
  },
  {
    code: 'America/Belem',
    name: '(UTC-03:00) America/Belem',
    offset: -3,
    shortcode: 'SEST',
  },
  {
    code: 'America/Cayenne',
    name: '(UTC-03:00) America/Cayenne',
    offset: -3,
    shortcode: 'SEST',
  },
  {
    code: 'America/Fortaleza',
    name: '(UTC-03:00) America/Fortaleza',
    offset: -3,
    shortcode: 'SEST',
  },
  {
    code: 'America/Maceio',
    name: '(UTC-03:00) America/Maceio',
    offset: -3,
    shortcode: 'SEST',
  },
  {
    code: 'America/Paramaribo',
    name: '(UTC-03:00) America/Paramaribo',
    offset: -3,
    shortcode: 'SEST',
  },
  {
    code: 'America/Recife',
    name: '(UTC-03:00) America/Recife',
    offset: -3,
    shortcode: 'SEST',
  },
  {
    code: 'America/Santarem',
    name: '(UTC-03:00) America/Santarem',
    offset: -3,
    shortcode: 'SEST',
  },
  {
    code: 'Antarctica/Rothera',
    name: '(UTC-03:00) Antarctica/Rothera',
    offset: -3,
    shortcode: 'SEST',
  },
  {
    code: 'Atlantic/Stanley',
    name: '(UTC-03:00) Atlantic/Stanley',
    offset: -3,
    shortcode: 'SEST',
  },
  {
    code: 'America/Godthab',
    name: '(UTC-03:00) America/Godthab',
    offset: -3,
    shortcode: 'GDT',
  },
  {
    code: 'America/Montevideo',
    name: '(UTC-03:00) America/Montevideo',
    offset: -3,
    shortcode: 'MST',
  },
  {
    code: 'America/Bahia',
    name: '(UTC-03:00) America/Bahia',
    offset: -3,
    shortcode: 'BST',
  },
  {
    code: 'America/Noronha',
    name: '(UTC-02:00) America/Noronha',
    offset: -2,
    shortcode: 'U',
  },
  {
    code: 'Atlantic/South_Georgia',
    name: '(UTC-02:00) Atlantic/South Georgia',
    offset: -2,
    shortcode: 'U',
  },
  {
    code: 'America/Scoresbysund',
    name: '(UTC-01:00) America/Scoresbysund',
    offset: 0,
    shortcode: 'ADT',
  },
  {
    code: 'Atlantic/Azores',
    name: '(UTC-01:00) Atlantic/Azores',
    offset: 0,
    shortcode: 'ADT',
  },
  {
    code: 'Atlantic/Cape_Verde',
    name: '(UTC-01:00) Atlantic/Cape Verde',
    offset: -1,
    shortcode: 'CVST',
  },
  {
    code: 'Africa/Casablanca',
    name: '(UTC) Africa/Casablanca',
    offset: 1,
    shortcode: 'MDT',
  },
  {
    code: 'Africa/El_Aaiun',
    name: '(UTC) Africa/El Aaiun',
    offset: 1,
    shortcode: 'MDT',
  },
  {
    code: 'America/Danmarkshavn',
    name: '(UTC) America/Danmarkshavn',
    offset: 0,
    shortcode: 'UTC',
  },
  {
    code: 'Europe/Isle_of_Man',
    name: '(UTC) Europe/Isle of_Man',
    offset: 0,
    shortcode: 'GMT',
  },
  {
    code: 'Europe/Guernsey',
    name: '(UTC) Europe/Guernsey',
    offset: 0,
    shortcode: 'GMT',
  },
  {
    code: 'Europe/Jersey',
    name: '(UTC) Europe/Jersey',
    offset: 0,
    shortcode: 'GMT',
  },
  {
    code: 'Europe/London',
    name: '(UTC) Europe/London',
    offset: 0,
    shortcode: 'GMT',
  },
  {
    code: 'Atlantic/Canary',
    name: '(UTC) Atlantic/Canary',
    offset: 1,
    shortcode: 'GDT',
  },
  {
    code: 'Atlantic/Faeroe',
    name: '(UTC) Atlantic/Faeroe',
    offset: 1,
    shortcode: 'GDT',
  },
  {
    code: 'Atlantic/Madeira',
    name: '(UTC) Atlantic/Madeira',
    offset: 1,
    shortcode: 'GDT',
  },
  {
    code: 'Europe/Dublin',
    name: '(UTC) Europe/Dublin',
    offset: 1,
    shortcode: 'GDT',
  },
  {
    code: 'Europe/Lisbon',
    name: '(UTC) Europe/Lisbon',
    offset: 1,
    shortcode: 'GDT',
  },
  {
    code: 'Africa/Abidjan',
    name: '(UTC) Africa/Abidjan',
    offset: 0,
    shortcode: 'GST',
  },
  {
    code: 'Africa/Accra',
    name: '(UTC) Africa/Accra',
    offset: 0,
    shortcode: 'GST',
  },
  {
    code: 'Africa/Bamako',
    name: '(UTC) Africa/Bamako',
    offset: 0,
    shortcode: 'GST',
  },
  {
    code: 'Africa/Banjul',
    name: '(UTC) Africa/Banjul',
    offset: 0,
    shortcode: 'GST',
  },
  {
    code: 'Africa/Bissau',
    name: '(UTC) Africa/Bissau',
    offset: 0,
    shortcode: 'GST',
  },
  {
    code: 'Africa/Conakry',
    name: '(UTC) Africa/Conakry',
    offset: 0,
    shortcode: 'GST',
  },
  {
    code: 'Africa/Dakar',
    name: '(UTC) Africa/Dakar',
    offset: 0,
    shortcode: 'GST',
  },
  {
    code: 'Africa/Freetown',
    name: '(UTC) Africa/Freetown',
    offset: 0,
    shortcode: 'GST',
  },
  {
    code: 'Africa/Lome',
    name: '(UTC) Africa/Lome',
    offset: 0,
    shortcode: 'GST',
  },
  {
    code: 'Africa/Monrovia',
    name: '(UTC) Africa/Monrovia',
    offset: 0,
    shortcode: 'GST',
  },
  {
    code: 'Africa/Nouakchott',
    name: '(UTC) Africa/Nouakchott',
    offset: 0,
    shortcode: 'GST',
  },
  {
    code: 'Africa/Ouagadougou',
    name: '(UTC) Africa/Ouagadougou',
    offset: 0,
    shortcode: 'GST',
  },
  {
    code: 'Africa/Sao_Tome',
    name: '(UTC) Africa/Sao Tome',
    offset: 0,
    shortcode: 'GST',
  },
  {
    code: 'Atlantic/Reykjavik',
    name: '(UTC) Atlantic/Reykjavik',
    offset: 0,
    shortcode: 'GST',
  },
  {
    code: 'Atlantic/St_Helena',
    name: '(UTC) Atlantic/St Helena',
    offset: 0,
    shortcode: 'GST',
  },
  {
    code: 'Arctic/Longyearbyen',
    name: '(UTC+01:00) Arctic/Longyearbyen',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Amsterdam',
    name: '(UTC+01:00) Europe/Amsterdam',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Andorra',
    name: '(UTC+01:00) Europe/Andorra',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Berlin',
    name: '(UTC+01:00) Europe/Berlin',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Busingen',
    name: '(UTC+01:00) Europe/Busingen',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Gibraltar',
    name: '(UTC+01:00) Europe/Gibraltar',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Luxembourg',
    name: '(UTC+01:00) Europe/Luxembourg',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Malta',
    name: '(UTC+01:00) Europe/Malta',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Monaco',
    name: '(UTC+01:00) Europe/Monaco',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Oslo',
    name: '(UTC+01:00) Europe/Oslo',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Rome',
    name: '(UTC+01:00) Europe/Rome',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/San_Marino',
    name: '(UTC+01:00) Europe/San Marino',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Stockholm',
    name: '(UTC+01:00) Europe/Stockholm',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Vaduz',
    name: '(UTC+01:00) Europe/Vaduz',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Vatican',
    name: '(UTC+01:00) Europe/Vatican',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Vienna',
    name: '(UTC+01:00) Europe/Vienna',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Zurich',
    name: '(UTC+01:00) Europe/Zurich',
    offset: 2,
    shortcode: 'WEDT',
  },
  {
    code: 'Europe/Belgrade',
    name: '(UTC+01:00) Europe/Belgrade',
    offset: 2,
    shortcode: 'CEDT',
  },
  {
    code: 'Europe/Bratislava',
    name: '(UTC+01:00) Europe/Bratislava',
    offset: 2,
    shortcode: 'CEDT',
  },
  {
    code: 'Europe/Budapest',
    name: '(UTC+01:00) Europe/Budapest',
    offset: 2,
    shortcode: 'CEDT',
  },
  {
    code: 'Europe/Ljubljana',
    name: '(UTC+01:00) Europe/Ljubljana',
    offset: 2,
    shortcode: 'CEDT',
  },
  {
    code: 'Europe/Podgorica',
    name: '(UTC+01:00) Europe/Podgorica',
    offset: 2,
    shortcode: 'CEDT',
  },
  {
    code: 'Europe/Prague',
    name: '(UTC+01:00) Europe/Prague',
    offset: 2,
    shortcode: 'CEDT',
  },
  {
    code: 'Europe/Tirane',
    name: '(UTC+01:00) Europe/Tirane',
    offset: 2,
    shortcode: 'CEDT',
  },
  {
    code: 'Africa/Ceuta',
    name: '(UTC+01:00) Africa/Ceuta',
    offset: 2,
    shortcode: 'RDT',
  },
  {
    code: 'Europe/Brussels',
    name: '(UTC+01:00) Europe/Brussels',
    offset: 2,
    shortcode: 'RDT',
  },
  {
    code: 'Europe/Copenhagen',
    name: '(UTC+01:00) Europe/Copenhagen',
    offset: 2,
    shortcode: 'RDT',
  },
  {
    code: 'Europe/Madrid',
    name: '(UTC+01:00) Europe/Madrid',
    offset: 2,
    shortcode: 'RDT',
  },
  {
    code: 'Europe/Paris',
    name: '(UTC+01:00) Europe/Paris',
    offset: 2,
    shortcode: 'RDT',
  },
  {
    code: 'Europe/Sarajevo',
    name: '(UTC+01:00) Europe/Sarajevo',
    offset: 2,
    shortcode: 'CEDT',
  },
  {
    code: 'Europe/Skopje',
    name: '(UTC+01:00) Europe/Skopje',
    offset: 2,
    shortcode: 'CEDT',
  },
  {
    code: 'Europe/Warsaw',
    name: '(UTC+01:00) Europe/Warsaw',
    offset: 2,
    shortcode: 'CEDT',
  },
  {
    code: 'Europe/Zagreb',
    name: '(UTC+01:00) Europe/Zagreb',
    offset: 2,
    shortcode: 'CEDT',
  },
  {
    code: 'Africa/Algiers',
    name: '(UTC+01:00) Africa/Algiers',
    offset: 1,
    shortcode: 'WCAST',
  },
  {
    code: 'Africa/Bangui',
    name: '(UTC+01:00) Africa/Bangui',
    offset: 1,
    shortcode: 'WCAST',
  },
  {
    code: 'Africa/Brazzaville',
    name: '(UTC+01:00) Africa/Brazzaville',
    offset: 1,
    shortcode: 'WCAST',
  },
  {
    code: 'Africa/Douala',
    name: '(UTC+01:00) Africa/Douala',
    offset: 1,
    shortcode: 'WCAST',
  },
  {
    code: 'Africa/Kinshasa',
    name: '(UTC+01:00) Africa/Kinshasa',
    offset: 1,
    shortcode: 'WCAST',
  },
  {
    code: 'Africa/Lagos',
    name: '(UTC+01:00) Africa/Lagos',
    offset: 1,
    shortcode: 'WCAST',
  },
  {
    code: 'Africa/Libreville',
    name: '(UTC+01:00) Africa/Libreville',
    offset: 1,
    shortcode: 'WCAST',
  },
  {
    code: 'Africa/Luanda',
    name: '(UTC+01:00) Africa/Luanda',
    offset: 1,
    shortcode: 'WCAST',
  },
  {
    code: 'Africa/Malabo',
    name: '(UTC+01:00) Africa/Malabo',
    offset: 1,
    shortcode: 'WCAST',
  },
  {
    code: 'Africa/Ndjamena',
    name: '(UTC+01:00) Africa/Ndjamena',
    offset: 1,
    shortcode: 'WCAST',
  },
  {
    code: 'Africa/Niamey',
    name: '(UTC+01:00) Africa/Niamey',
    offset: 1,
    shortcode: 'WCAST',
  },
  {
    code: 'Africa/Porto-Novo',
    name: '(UTC+01:00) Africa/Porto-Novo',
    offset: 1,
    shortcode: 'WCAST',
  },
  {
    code: 'Africa/Tunis',
    name: '(UTC+01:00) Africa/Tunis',
    offset: 1,
    shortcode: 'WCAST',
  },
  {
    code: 'Africa/Windhoek',
    name: '(UTC+01:00) Africa/Windhoek',
    offset: 1,
    shortcode: 'NST',
  },
  {
    code: 'Asia/Nicosia',
    name: '(UTC+02:00) Asia/Nicosia',
    offset: 3,
    shortcode: 'GDT',
  },
  {
    code: 'Europe/Athens',
    name: '(UTC+02:00) Europe/Athens',
    offset: 3,
    shortcode: 'GDT',
  },
  {
    code: 'Europe/Bucharest',
    name: '(UTC+02:00) Europe/Bucharest',
    offset: 3,
    shortcode: 'GDT',
  },
  {
    code: 'Europe/Chisinau',
    name: '(UTC+02:00) Europe/Chisinau',
    offset: 3,
    shortcode: 'GDT',
  },
  {
    code: 'Asia/Beirut',
    name: '(UTC+02:00) Asia/Beirut',
    offset: 3,
    shortcode: 'MEDT',
  },
  {
    code: 'Africa/Cairo',
    name: '(UTC+02:00) Africa/Cairo',
    offset: 2,
    shortcode: 'EST',
  },
  {
    code: 'Asia/Damascus',
    name: '(UTC+02:00) Asia/Damascus',
    offset: 3,
    shortcode: 'SDT',
  },
  {
    code: 'Europe/Helsinki',
    name: '(UTC+02:00) Europe/Helsinki',
    offset: 3,
    shortcode: 'EEDT',
  },
  {
    code: 'Europe/Kiev',
    name: '(UTC+02:00) Europe/Kiev',
    offset: 3,
    shortcode: 'EEDT',
  },
  {
    code: 'Europe/Mariehamn',
    name: '(UTC+02:00) Europe/Mariehamn',
    offset: 3,
    shortcode: 'EEDT',
  },
  {
    code: 'Europe/Nicosia',
    name: '(UTC+02:00) Europe/Nicosia',
    offset: 3,
    shortcode: 'EEDT',
  },
  {
    code: 'Europe/Riga',
    name: '(UTC+02:00) Europe/Riga',
    offset: 3,
    shortcode: 'EEDT',
  },
  {
    code: 'Europe/Sofia',
    name: '(UTC+02:00) Europe/Sofia',
    offset: 3,
    shortcode: 'EEDT',
  },
  {
    code: 'Europe/Tallinn',
    name: '(UTC+02:00) Europe/Tallinn',
    offset: 3,
    shortcode: 'EEDT',
  },
  {
    code: 'Europe/Uzhgorod',
    name: '(UTC+02:00) Europe/Uzhgorod',
    offset: 3,
    shortcode: 'EEDT',
  },
  {
    code: 'Europe/Vilnius',
    name: '(UTC+02:00) Europe/Vilnius',
    offset: 3,
    shortcode: 'EEDT',
  },
  {
    code: 'Europe/Zaporozhye',
    name: '(UTC+02:00) Europe/Zaporozhye',
    offset: 3,
    shortcode: 'EEDT',
  },
  {
    code: 'Africa/Blantyre',
    name: '(UTC+02:00) Africa/Blantyre',
    offset: 2,
    shortcode: 'SAST',
  },
  {
    code: 'Africa/Bujumbura',
    name: '(UTC+02:00) Africa/Bujumbura',
    offset: 2,
    shortcode: 'SAST',
  },
  {
    code: 'Africa/Gaborone',
    name: '(UTC+02:00) Africa/Gaborone',
    offset: 2,
    shortcode: 'SAST',
  },
  {
    code: 'Africa/Harare',
    name: '(UTC+02:00) Africa/Harare',
    offset: 2,
    shortcode: 'SAST',
  },
  {
    code: 'Africa/Johannesburg',
    name: '(UTC+02:00) Africa/Johannesburg',
    offset: 2,
    shortcode: 'SAST',
  },
  {
    code: 'Africa/Kigali',
    name: '(UTC+02:00) Africa/Kigali',
    offset: 2,
    shortcode: 'SAST',
  },
  {
    code: 'Africa/Lubumbashi',
    name: '(UTC+02:00) Africa/Lubumbashi',
    offset: 2,
    shortcode: 'SAST',
  },
  {
    code: 'Africa/Lusaka',
    name: '(UTC+02:00) Africa/Lusaka',
    offset: 2,
    shortcode: 'SAST',
  },
  {
    code: 'Africa/Maputo',
    name: '(UTC+02:00) Africa/Maputo',
    offset: 2,
    shortcode: 'SAST',
  },
  {
    code: 'Africa/Maseru',
    name: '(UTC+02:00) Africa/Maseru',
    offset: 2,
    shortcode: 'SAST',
  },
  {
    code: 'Africa/Mbabane',
    name: '(UTC+02:00) Africa/Mbabane',
    offset: 2,
    shortcode: 'SAST',
  },
  {
    code: 'Europe/Istanbul',
    name: '(UTC+03:00) Europe/Istanbul',
    offset: 3,
    shortcode: 'TDT',
  },
  {
    code: 'Asia/Jerusalem',
    name: '(UTC+02:00) Asia/Jerusalem',
    offset: 3,
    shortcode: 'JDT',
  },
  {
    code: 'Africa/Tripoli',
    name: '(UTC+02:00) Africa/Tripoli',
    offset: 2,
    shortcode: 'LST',
  },
  {
    code: 'Asia/Amman',
    name: '(UTC+03:00) Asia/Amman',
    offset: 3,
  },
  {
    code: 'Asia/Baghdad',
    name: '(UTC+03:00) Asia/Baghdad',
    offset: 3,
    shortcode: 'AST',
  },
  {
    code: 'Europe/Kaliningrad',
    name: '(UTC+02:00) Europe/Kaliningrad',
    offset: 3,
    shortcode: 'KST',
  },
  {
    code: 'Asia/Aden',
    name: '(UTC+03:00) Asia/Aden',
    offset: 3,
    shortcode: 'AST',
  },
  {
    code: 'Asia/Bahrain',
    name: '(UTC+03:00) Asia/Bahrain',
    offset: 3,
    shortcode: 'AST',
  },
  {
    code: 'Asia/Kuwait',
    name: '(UTC+03:00) Asia/Kuwait',
    offset: 3,
    shortcode: 'AST',
  },
  {
    code: 'Asia/Qatar',
    name: '(UTC+03:00) Asia/Qatar',
    offset: 3,
    shortcode: 'AST',
  },
  {
    code: 'Asia/Riyadh',
    name: '(UTC+03:00) Asia/Riyadh',
    offset: 3,
    shortcode: 'AST',
  },
  {
    code: 'Africa/Addis_Ababa',
    name: '(UTC+03:00) Africa/Addis Ababa',
    offset: 3,
    shortcode: 'EAST',
  },
  {
    code: 'Africa/Asmera',
    name: '(UTC+03:00) Africa/Asmera',
    offset: 3,
    shortcode: 'EAST',
  },
  {
    code: 'Africa/Dar_es_Salaam',
    name: '(UTC+03:00) Africa/Dar es_Salaam',
    offset: 3,
    shortcode: 'EAST',
  },
  {
    code: 'Africa/Djibouti',
    name: '(UTC+03:00) Africa/Djibouti',
    offset: 3,
    shortcode: 'EAST',
  },
  {
    code: 'Africa/Juba',
    name: '(UTC+03:00) Africa/Juba',
    offset: 3,
    shortcode: 'EAST',
  },
  {
    code: 'Africa/Kampala',
    name: '(UTC+03:00) Africa/Kampala',
    offset: 3,
    shortcode: 'EAST',
  },
  {
    code: 'Africa/Khartoum',
    name: '(UTC+03:00) Africa/Khartoum',
    offset: 3,
    shortcode: 'EAST',
  },
  {
    code: 'Africa/Mogadishu',
    name: '(UTC+03:00) Africa/Mogadishu',
    offset: 3,
    shortcode: 'EAST',
  },
  {
    code: 'Africa/Nairobi',
    name: '(UTC+03:00) Africa/Nairobi',
    offset: 3,
    shortcode: 'EAST',
  },
  {
    code: 'Antarctica/Syowa',
    name: '(UTC+03:00) Antarctica/Syowa',
    offset: 3,
    shortcode: 'EAST',
  },
  {
    code: 'Indian/Antananarivo',
    name: '(UTC+03:00) Indian/Antananarivo',
    offset: 3,
    shortcode: 'EAST',
  },
  {
    code: 'Indian/Comoro',
    name: '(UTC+03:00) Indian/Comoro',
    offset: 3,
    shortcode: 'EAST',
  },
  {
    code: 'Indian/Mayotte',
    name: '(UTC+03:00) Indian/Mayotte',
    offset: 3,
    shortcode: 'EAST',
  },
  {
    code: 'Europe/Kirov',
    name: '(UTC+03:00) Europe/Kirov',
    offset: 3,
    shortcode: 'MSK',
  },
  {
    code: 'Europe/Moscow',
    name: '(UTC+03:00) Europe/Moscow',
    offset: 3,
    shortcode: 'MSK',
  },
  {
    code: 'Europe/Simferopol',
    name: '(UTC+03:00) Europe/Simferopol',
    offset: 3,
    shortcode: 'MSK',
  },
  {
    code: 'Europe/Volgograd',
    name: '(UTC+03:00) Europe/Volgograd',
    offset: 3,
    shortcode: 'MSK',
  },
  {
    code: 'Europe/Minsk',
    name: '(UTC+03:00) Europe/Minsk',
    offset: 3,
    shortcode: 'MSK',
  },
  {
    code: 'Europe/Astrakhan',
    name: '(UTC+04:00) Europe/Astrakhan',
    offset: 4,
    shortcode: 'SAMT',
  },
  {
    code: 'Europe/Samara',
    name: '(UTC+04:00) Europe/Samara',
    offset: 4,
    shortcode: 'SAMT',
  },
  {
    code: 'Europe/Ulyanovsk',
    name: '(UTC+04:00) Europe/Ulyanovsk',
    offset: 4,
    shortcode: 'SAMT',
  },
  {
    code: 'Asia/Tehran',
    name: '(UTC+03:30) Asia/Tehran',
    offset: 4.5,
    shortcode: 'IDT',
  },
  {
    code: 'Asia/Dubai',
    name: '(UTC+04:00) Asia/Dubai',
    offset: 4,
    shortcode: 'AST',
  },
  {
    code: 'Asia/Muscat',
    name: '(UTC+04:00) Asia/Muscat',
    offset: 4,
    shortcode: 'AST',
  },
  {
    code: 'Asia/Baku',
    name: '(UTC+04:00) Asia/Baku',
    offset: 5,
    shortcode: 'ADT',
  },
  {
    code: 'Indian/Mahe',
    name: '(UTC+04:00) Indian/Mahe',
    offset: 4,
    shortcode: 'MST',
  },
  {
    code: 'Indian/Mauritius',
    name: '(UTC+04:00) Indian/Mauritius',
    offset: 4,
    shortcode: 'MST',
  },
  {
    code: 'Indian/Reunion',
    name: '(UTC+04:00) Indian/Reunion',
    offset: 4,
    shortcode: 'MST',
  },
  {
    code: 'Asia/Tbilisi',
    name: '(UTC+04:00) Asia/Tbilisi',
    offset: 4,
    shortcode: 'GET',
  },
  {
    code: 'Asia/Yerevan',
    name: '(UTC+04:00) Asia/Yerevan',
    offset: 4,
    shortcode: 'CST',
  },
  {
    code: 'Asia/Kabul',
    name: '(UTC+04:30) Asia/Kabul',
    offset: 4.5,
    shortcode: 'AST',
  },
  {
    code: 'Antarctica/Mawson',
    name: '(UTC+05:00) Antarctica/Mawson',
    offset: 5,
    shortcode: 'WAST',
  },
  {
    code: 'Asia/Aqtau',
    name: '(UTC+05:00) Asia/Aqtau',
    offset: 5,
    shortcode: 'WAST',
  },
  {
    code: 'Asia/Aqtobe',
    name: '(UTC+05:00) Asia/Aqtobe',
    offset: 5,
    shortcode: 'WAST',
  },
  {
    code: 'Asia/Ashgabat',
    name: '(UTC+05:00) Asia/Ashgabat',
    offset: 5,
    shortcode: 'WAST',
  },
  {
    code: 'Asia/Dushanbe',
    name: '(UTC+05:00) Asia/Dushanbe',
    offset: 5,
    shortcode: 'WAST',
  },
  {
    code: 'Asia/Oral',
    name: '(UTC+05:00) Asia/Oral',
    offset: 5,
    shortcode: 'WAST',
  },
  {
    code: 'Asia/Samarkand',
    name: '(UTC+05:00) Asia/Samarkand',
    offset: 5,
    shortcode: 'WAST',
  },
  {
    code: 'Asia/Tashkent',
    name: '(UTC+05:00) Asia/Tashkent',
    offset: 5,
    shortcode: 'WAST',
  },
  {
    code: 'Indian/Kerguelen',
    name: '(UTC+05:00) Indian/Kerguelen',
    offset: 5,
    shortcode: 'WAST',
  },
  {
    code: 'Indian/Maldives',
    name: '(UTC+05:00) Indian/Maldives',
    offset: 5,
    shortcode: 'WAST',
  },
  {
    code: 'Asia/Yekaterinburg',
    name: '(UTC+05:00) Asia/Yekaterinburg',
    offset: 5,
    shortcode: 'YEKT',
  },
  {
    code: 'Asia/Karachi',
    name: '(UTC+05:00) Asia/Karachi',
    offset: 5,
    shortcode: 'PKT',
  },
  {
    code: 'Asia/Kolkata',
    name: '(UTC+05:30) Asia/Kolkata',
    offset: 5.5,
    shortcode: 'IST',
  },
  {
    code: 'Asia/Calcutta',
    name: '(UTC+05:30) Asia/Calcutta',
    offset: 5.5,
    shortcode: 'IST',
  },
  {
    code: 'Asia/Colombo',
    name: '(UTC+05:30) Asia/Colombo',
    offset: 5.5,
    shortcode: 'SLST',
  },
  {
    code: 'Asia/Kathmandu',
    name: '(UTC+05:45) Asia/Kathmandu',
    offset: 5.75,
    shortcode: 'NST',
  },
  {
    code: 'Antarctica/Vostok',
    name: '(UTC+06:00) Antarctica/Vostok',
    offset: 6,
    shortcode: 'CAST',
  },
  {
    code: 'Asia/Almaty',
    name: '(UTC+06:00) Asia/Almaty',
    offset: 6,
    shortcode: 'CAST',
  },
  {
    code: 'Asia/Bishkek',
    name: '(UTC+06:00) Asia/Bishkek',
    offset: 6,
    shortcode: 'CAST',
  },
  {
    code: 'Asia/Qyzylorda',
    name: '(UTC+06:00) Asia/Qyzylorda',
    offset: 6,
    shortcode: 'CAST',
  },
  {
    code: 'Asia/Urumqi',
    name: '(UTC+06:00) Asia/Urumqi',
    offset: 6,
    shortcode: 'CAST',
  },
  {
    code: 'Indian/Chagos',
    name: '(UTC+06:00) Indian/Chagos',
    offset: 6,
    shortcode: 'CAST',
  },
  {
    code: 'Asia/Dhaka',
    name: '(UTC+06:00) Asia/Dhaka',
    offset: 6,
    shortcode: 'BST',
  },
  {
    code: 'Asia/Thimphu',
    name: '(UTC+06:00) Asia/Thimphu',
    offset: 6,
    shortcode: 'BST',
  },
  {
    code: 'Asia/Rangoon',
    name: '(UTC+06:30) Asia/Rangoon',
    offset: 6.5,
    shortcode: 'MST',
  },
  {
    code: 'Indian/Cocos',
    name: '(UTC+06:30) Indian/Cocos',
    offset: 6.5,
    shortcode: 'MST',
  },
  {
    code: 'Antarctica/Davis',
    name: '(UTC+07:00) Antarctica/Davis',
    offset: 7,
    shortcode: 'SAST',
  },
  {
    code: 'Asia/Bangkok',
    name: '(UTC+07:00) Asia/Bangkok',
    offset: 7,
    shortcode: 'SAST',
  },
  {
    code: 'Asia/Hovd',
    name: '(UTC+07:00) Asia/Hovd',
    offset: 7,
    shortcode: 'SAST',
  },
  {
    code: 'Asia/Jakarta',
    name: '(UTC+07:00) Asia/Jakarta',
    offset: 7,
    shortcode: 'SAST',
  },
  {
    code: 'Asia/Phnom_Penh',
    name: '(UTC+07:00) Asia/Phnom Penh',
    offset: 7,
    shortcode: 'SAST',
  },
  {
    code: 'Asia/Pontianak',
    name: '(UTC+07:00) Asia/Pontianak',
    offset: 7,
    shortcode: 'SAST',
  },
  {
    code: 'Asia/Saigon',
    name: '(UTC+07:00) Asia/Saigon',
    offset: 7,
    shortcode: 'SAST',
  },
  {
    code: 'Asia/Vientiane',
    name: '(UTC+07:00) Asia/Vientiane',
    offset: 7,
    shortcode: 'SAST',
  },
  {
    code: 'Indian/Christmas',
    name: '(UTC+07:00) Indian/Christmas',
    offset: 7,
    shortcode: 'SAST',
  },
  {
    code: 'Asia/Novokuznetsk',
    name: '(UTC+07:00) Asia/Novokuznetsk',
    offset: 7,
    shortcode: 'NCAST',
  },
  {
    code: 'Asia/Novosibirsk',
    name: '(UTC+07:00) Asia/Novosibirsk',
    offset: 7,
    shortcode: 'NCAST',
  },
  {
    code: 'Asia/Omsk',
    name: '(UTC+07:00) Asia/Omsk',
    offset: 7,
    shortcode: 'NCAST',
  },
  {
    code: 'Asia/Hong_Kong',
    name: '(UTC+08:00) Asia/Hong Kong',
    offset: 8,
    shortcode: 'CST',
  },
  {
    code: 'Asia/Macau',
    name: '(UTC+08:00) Asia/Macau',
    offset: 8,
    shortcode: 'CST',
  },
  {
    code: 'Asia/Shanghai',
    name: '(UTC+08:00) Asia/Shanghai',
    offset: 8,
    shortcode: 'CST',
  },
  {
    code: 'Asia/Krasnoyarsk',
    name: '(UTC+08:00) Asia/Krasnoyarsk',
    offset: 8,
    shortcode: 'NAST',
  },
  {
    code: 'Asia/Brunei',
    name: '(UTC+08:00) Asia/Brunei',
    offset: 8,
    shortcode: 'MPST',
  },
  {
    code: 'Asia/Kuala_Lumpur',
    name: '(UTC+08:00) Asia/Kuala Lumpur',
    offset: 8,
    shortcode: 'MPST',
  },
  {
    code: 'Asia/Kuching',
    name: '(UTC+08:00) Asia/Kuching',
    offset: 8,
    shortcode: 'MPST',
  },
  {
    code: 'Asia/Makassar',
    name: '(UTC+08:00) Asia/Makassar',
    offset: 8,
    shortcode: 'MPST',
  },
  {
    code: 'Asia/Manila',
    name: '(UTC+08:00) Asia/Manila',
    offset: 8,
    shortcode: 'MPST',
  },
  {
    code: 'Asia/Singapore',
    name: '(UTC+08:00) Asia/Singapore',
    offset: 8,
    shortcode: 'MPST',
  },
  {
    code: 'Antarctica/Casey',
    name: '(UTC+08:00) Antarctica/Casey',
    offset: 8,
    shortcode: 'WAST',
  },
  {
    code: 'Australia/Perth',
    name: '(UTC+08:00) Australia/Perth',
    offset: 8,
    shortcode: 'WAST',
  },
  {
    code: 'Asia/Taipei',
    name: '(UTC+08:00) Asia/Taipei',
    offset: 8,
    shortcode: 'TST',
  },
  {
    code: 'Asia/Choibalsan',
    name: '(UTC+08:00) Asia/Choibalsan',
    offset: 8,
    shortcode: 'UST',
  },
  {
    code: 'Asia/Ulaanbaatar',
    name: '(UTC+08:00) Asia/Ulaanbaatar',
    offset: 8,
    shortcode: 'UST',
  },
  {
    code: 'Asia/Irkutsk',
    name: '(UTC+08:00) Asia/Irkutsk',
    offset: 8,
    shortcode: 'NAEST',
  },
  {
    code: 'Asia/Dili',
    name: '(UTC+09:00) Asia/Dili',
    offset: 9,
  },
  {
    code: 'Asia/Jayapura',
    name: '(UTC+09:00) Asia/Jayapura',
    offset: 9,
  },
  {
    code: 'Asia/Tokyo',
    name: '(UTC+09:00) Asia/Tokyo',
    offset: 9,
    shortcode: 'JST',
  },
  {
    code: 'Pacific/Palau',
    name: '(UTC+09:00) Pacific/Palau',
    offset: 9,
  },
  {
    code: 'Asia/Pyongyang',
    name: '(UTC+09:00) Asia/Pyongyang',
    offset: 9,
    shortcode: 'KST',
  },
  {
    code: 'Asia/Seoul',
    name: '(UTC+09:00) Asia/Seoul',
    offset: 9,
    shortcode: 'KST',
  },
  {
    code: 'Australia/Adelaide',
    name: '(UTC+09:30) Australia/Adelaide',
    offset: 9.5,
    shortcode: 'CAST',
  },
  {
    code: 'Australia/Broken_Hill',
    name: '(UTC+09:30) Australia/Broken Hill',
    offset: 9.5,
    shortcode: 'CAST',
  },
  {
    code: 'Australia/Darwin',
    name: '(UTC+09:30) Australia/Darwin',
    offset: 9.5,
    shortcode: 'ACST',
  },
  {
    code: 'Australia/Brisbane',
    name: '(UTC+10:00) Australia/Brisbane',
    offset: 10,
    shortcode: 'EAST',
  },
  {
    code: 'Australia/Lindeman',
    name: '(UTC+10:00) Australia/Lindeman',
    offset: 10,
    shortcode: 'EAST',
  },
  {
    code: 'Australia/Melbourne',
    name: '(UTC+10:00) Australia/Melbourne',
    offset: 10,
    shortcode: 'AEST',
  },
  {
    code: 'Australia/Sydney',
    name: '(UTC+10:00) Australia/Sydney',
    offset: 10,
    shortcode: 'AEST',
  },
  {
    code: 'Antarctica/DumontDUrville',
    name: '(UTC+10:00) Antarctica/DumontDUrville',
    offset: 10,
    shortcode: 'WPST',
  },
  {
    code: 'Pacific/Guam',
    name: '(UTC+10:00) Pacific/Guam',
    offset: 10,
    shortcode: 'WPST',
  },
  {
    code: 'Pacific/Port_Moresby',
    name: '(UTC+10:00) Pacific/Port Moresby',
    offset: 10,
    shortcode: 'WPST',
  },
  {
    code: 'Pacific/Saipan',
    name: '(UTC+10:00) Pacific/Saipan',
    offset: 10,
    shortcode: 'WPST',
  },
  {
    code: 'Pacific/Truk',
    name: '(UTC+10:00) Pacific/Truk',
    offset: 10,
    shortcode: 'WPST',
  },
  {
    code: 'Australia/Currie',
    name: '(UTC+10:00) Australia/Currie',
    offset: 10,
    shortcode: 'TST',
  },
  {
    code: 'Australia/Hobart',
    name: '(UTC+10:00) Australia/Hobart',
    offset: 10,
    shortcode: 'TST',
  },
  {
    code: 'Asia/Chita',
    name: '(UTC+09:00) Asia/Chita',
    offset: 9,
    shortcode: 'YST',
  },
  {
    code: 'Asia/Khandyga',
    name: '(UTC+09:00) Asia/Khandyga',
    offset: 9,
    shortcode: 'YST',
  },
  {
    code: 'Asia/Yakutsk',
    name: '(UTC+09:00) Asia/Yakutsk',
    offset: 9,
    shortcode: 'YST',
  },
  {
    code: 'Antarctica/Macquarie',
    name: '(UTC+11:00) Antarctica/Macquarie',
    offset: 11,
    shortcode: 'CPST',
  },
  {
    code: 'Pacific/Efate',
    name: '(UTC+11:00) Pacific/Efate',
    offset: 11,
    shortcode: 'CPST',
  },
  {
    code: 'Pacific/Guadalcanal',
    name: '(UTC+11:00) Pacific/Guadalcanal',
    offset: 11,
    shortcode: 'CPST',
  },
  {
    code: 'Pacific/Kosrae',
    name: '(UTC+11:00) Pacific/Kosrae',
    offset: 11,
    shortcode: 'CPST',
  },
  {
    code: 'Pacific/Noumea',
    name: '(UTC+11:00) Pacific/Noumea',
    offset: 11,
    shortcode: 'CPST',
  },
  {
    code: 'Pacific/Ponape',
    name: '(UTC+11:00) Pacific/Ponape',
    offset: 11,
    shortcode: 'CPST',
  },
  {
    code: 'Asia/Sakhalin',
    name: '(UTC+11:00) Asia/Sakhalin',
    offset: 11,
    shortcode: 'VST',
  },
  {
    code: 'Asia/Ust-Nera',
    name: '(UTC+11:00) Asia/Ust-Nera',
    offset: 11,
    shortcode: 'VST',
  },
  {
    code: 'Asia/Vladivostok',
    name: '(UTC+11:00) Asia/Vladivostok',
    offset: 11,
    shortcode: 'VST',
  },
  {
    code: 'Antarctica/McMurdo',
    name: '(UTC+12:00) Antarctica/McMurdo',
    offset: 12,
    shortcode: 'NZST',
  },
  {
    code: 'Pacific/Auckland',
    name: '(UTC+12:00) Pacific/Auckland',
    offset: 12,
    shortcode: 'NZST',
  },
  {
    code: 'Pacific/Funafuti',
    name: '(UTC+12:00) Pacific/Funafuti',
    offset: 12,
    shortcode: 'U',
  },
  {
    code: 'Pacific/Kwajalein',
    name: '(UTC+12:00) Pacific/Kwajalein',
    offset: 12,
    shortcode: 'U',
  },
  {
    code: 'Pacific/Majuro',
    name: '(UTC+12:00) Pacific/Majuro',
    offset: 12,
    shortcode: 'U',
  },
  {
    code: 'Pacific/Nauru',
    name: '(UTC+12:00) Pacific/Nauru',
    offset: 12,
    shortcode: 'U',
  },
  {
    code: 'Pacific/Tarawa',
    name: '(UTC+12:00) Pacific/Tarawa',
    offset: 12,
    shortcode: 'U',
  },
  {
    code: 'Pacific/Wake',
    name: '(UTC+12:00) Pacific/Wake',
    offset: 12,
    shortcode: 'U',
  },
  {
    code: 'Pacific/Wallis',
    name: '(UTC+12:00) Pacific/Wallis',
    offset: 12,
    shortcode: 'U',
  },
  {
    code: 'Pacific/Fiji',
    name: '(UTC+12:00) Pacific/Fiji',
    offset: 12,
    shortcode: 'FST',
  },
  {
    code: 'Asia/Anadyr',
    name: '(UTC+12:00) Asia/Anadyr',
    offset: 12,
    shortcode: 'MST',
  },
  {
    code: 'Asia/Kamchatka',
    name: '(UTC+12:00) Asia/Kamchatka',
    offset: 12,
    shortcode: 'MST',
  },
  {
    code: 'Asia/Magadan',
    name: '(UTC+12:00) Asia/Magadan',
    offset: 12,
    shortcode: 'MST',
  },
  {
    code: 'Asia/Srednekolymsk',
    name: '(UTC+12:00) Asia/Srednekolymsk',
    offset: 12,
    shortcode: 'MST',
  },
  {
    code: 'Pacific/Enderbury',
    name: '(UTC+13:00) Pacific/Enderbury',
    offset: 13,
    shortcode: 'TST',
  },
  {
    code: 'Pacific/Fakaofo',
    name: '(UTC+13:00) Pacific/Fakaofo',
    offset: 13,
    shortcode: 'TST',
  },
  {
    code: 'Pacific/Tongatapu',
    name: '(UTC+13:00) Pacific/Tongatapu',
    offset: 13,
    shortcode: 'TST',
  },
  {
    code: 'Pacific/Apia',
    name: '(UTC+13:00) Pacific/Apia',
    offset: 13,
    shortcode: 'SST',
  },
]

export const shortcodes = Object.fromEntries(
  timezones.map((tz) => [tz.shortcode, tz.code]),
)
