module.exports = {
  collectCoverageFrom: [
    '**/*.{js,jsx,ts,tsx}',
    '!**/*.d.ts',
    '!**/node_modules/**',
  ],
  moduleNameMapper: {
    /* Handle CSS imports (with CSS modules)
    https://jestjs.io/docs/webpack#mocking-css-modules */
    '^.+\\.module\\.(css|sass|scss)$': 'identity-obj-proxy',

    // Handle CSS imports (without CSS modules)
    '^.+\\.(css|sass|scss)$': '<rootDir>/src/test/styleMock.js',

    /* Handle image imports
    https://jestjs.io/docs/webpack#handling-static-assets */
    '^.+\\.(jpg|jpeg|png|gif|webp|svg)$': '<rootDir>/src/test/fileMock.js',

    /* Aliases */
    '^@/components/(.*)$': '<rootDir>/src/components/$1',
    '^@/contexts/(.*)$': '<rootDir>/src/contexts/$1',
    '^@/hooks/(.*)$': '<rootDir>/src/hooks/$1',
    '^@/images/(.*)$': '<rootDir>/src/images/$1',
    '^@/lib/(.*)$': '<rootDir>/src/lib/$1',
    '^@/locales/(.*)$': '<rootDir>/locales/$1',
    '^@/pages/(.*)$': '<rootDir>/src/components/pages/$1',
    '^@/root/(.*)$': '<rootDir>/src/$1',
    '^@/services/(.*)$': '<rootDir>/src/services/$1',
    '^@/test/(.*)$': '<rootDir>/src/test/$1',
  },
  setupFilesAfterEnv: ['<rootDir>/src/test/jest.setup.js'],
  testPathIgnorePatterns: ['<rootDir>/node_modules/', '<rootDir>/.next/'],
  testEnvironment: 'jsdom',
  transform: {
    /* Use babel-jest to transpile tests with the next/babel preset
    https://jestjs.io/docs/configuration#transform-objectstring-pathtotransformer--pathtotransformer-object */
    '^.+\\.(js|jsx|ts|tsx)$': ['babel-jest', { presets: ['next/babel'] }],
  },
  transformIgnorePatterns: ['^.+\\.module\\.(css|sass|scss)$', 'node_modules'],
  testPathIgnorePatterns: ['_helpers.tsx'],
}
