---
title: 설치하기
---

<Intro>

React는 처음부터 점진적으로 적용할 수 있도록 설계되었으며 필요한 만큼 React를 사용할 수 있습니다. React를 맛보기로 접해보려거나 간단한 HTML 페이지에 약간의 상호작용을 추가하거나 복잡한 React 기반의 앱을 시작하고자 하는 경우, 이 섹션을 참고하세요.

</Intro>

<YouWillLearn isChapter={true}>

* [새로운 React 프로젝트를 시작하는 방법](/learn/start-a-new-react-project)
* [기존 프로젝트에 React를 추가하는 방법](/learn/add-react-to-an-existing-project)
* [에디터를 설정하는 방법](/learn/editor-setup)
* [React 개발자 도구를 설치하는 방법](/learn/react-developer-tools)

</YouWillLearn>

## React 시도하기 {/*try-react*/}

단순히 React를 사용해 보고 싶다면, 아무것도 설치할 필요 없습니다. 이 샌드박스를 통해 사용해 보세요!

<Sandpack>

```js
function Greeting({ name }) {
  return <h1>Hello, {name}</h1>;
}

export default function App() {
  return <Greeting name="world" />
}
```

</Sandpack>

직접 편집하거나 오른쪽 상단의 "Fork" 버튼을 눌러 새 탭에서 열 수 있습니다.

React 문서의 대부분 페이지에는 이와 같은 샌드박스가 있습니다. React 문서 외에도 [CodeSandbox](https://codesandbox.io/s/new), [StackBlitz](https://stackblitz.com/fork/react), [CodePen.](https://codepen.io/pen?template=QWYVwWN) 등의 온라인 샌드박스에서 React를 지원합니다.

### 로컬 환경에서 React 시도하기 {/*try-react-locally*/}

컴퓨터의 로컬 환경에서 React를 사용해 보고 싶다면, 이 [HTML 페이지를 다운로드](https://gist.githubusercontent.com/gaearon/0275b1e1518599bbeafcde4722e79ed1/raw/db72dcbf3384ee1708c4a07d3be79860db04bff0/example.html)하고 에디터와 브라우저에서 열어보세요!

## 새로운 React 프로젝트 시작하기 {/*start-a-new-react-project*/}

React로 완전히 앱이나 웹사이트를 구축하고 싶다면, [새로운 React 프로젝트를 시작](/learn/start-a-new-react-project)하세요.

## 기존 프로젝트에 React 추가하기 {/*add-react-to-an-existing-project*/}

기존 앱이나 웹사이트에서 React를 적용하고 싶다면, [기존 프로젝트에 React를 추가](/learn/add-react-to-an-existing-project)하세요.

## 다음 단계 {/*next-steps*/}

React 개념 중 가장 중요한 개념들을 살펴보기 위해 [빠른 시작 가이드](/learn)로 이동하세요.

