---
title: React 영상들
---

<Intro>

React와 React 에코시스템에 대한 토론을 위한 영상들입니다.

</Intro>

## React Conf 2021 {/*react-conf-2021*/}

### React 18 기조연설 {/*react-18-keynote*/}

기조연설에서 React 18을 시작으로 React의 미래에 대한 비전을 공유했습니다.

[Andrew Clark](https://twitter.com/acdlite), [Juan Tejada](https://twitter.com/_jstejada), [Lauren Tan](https://twitter.com/potetotes), 그리고 [Rick Hanlon](https://twitter.com/rickhanlonii)의 전체 기조연설 보기.

<YouTubeIframe src="https://www.youtube.com/embed/FZ0cG47msEk" title="YouTube video player" />

### 애플리케이션 개발자를 위한 React 18 {/*react-18-for-application-developers*/}

React 18로 업그레이드하는 데모는 여기에서 [Shruti Kapoor](https://twitter.com/shrutikapoor08)의 강연을 참조하세요:

<YouTubeIframe src="https://www.youtube.com/embed/ytudH8je5ko" title="YouTube video player" />

### Suspense가 있는 스트리밍 서버 렌더링 {/*streaming-server-rendering-with-suspense*/}

React 18에는 Suspense를 사용한 서버 측 렌더링 성능 개선 사항도 포함되어 있습니다.

스트리밍 서버 렌더링을 사용하면 서버의 React 컴포넌트에서 HTML을 생성하고 해당 HTML을 사용자에게 스트리밍할 수 있습니다. React 18에서는 'Suspense'를 사용하여 앱을 더 작은 독립 단위로 분해하여 나머지 앱을 차단하지 않고 서로 독립적으로 스트리밍할 수 있습니다. 이는 사용자가 콘텐츠를 더 빨리 보고 훨씬 빠르게 상호작용을 시작할 수 있다는 것을 의미합니다.

더 자세히 알아보려면 [Shaundai Person](https://twitter.com/shaundai)의 강연을 참조하세요:

<YouTubeIframe src="https://www.youtube.com/embed/pj5N-Khihgc" title="YouTube video player" />

### 첫 번째 React 워킹 그룹 {/*the-first-react-working-group*/}

React 18에서는 전문가, 개발자, 라이브러리 관리자, 교육자들로 구성된 패널과 협력하기 위해 첫 번째 워킹 그룹을 만들었습니다. 우리는 함께 점진적인 채택 전략을 세우고 `useId`, `useSyncExternalStore`, `useInsertionEffect`와 같은 새로운 API를 개선하기 위해 노력했습니다.

이 작업에 대한 개요는 [Aakansha' Doshi](https://twitter.com/aakansha1216)의 강연을 참조하세요:

<YouTubeIframe src="https://www.youtube.com/embed/qn7gRClrC9U" title="YouTube video player" />

### React 개발자 도구 {/*react-developer-tooling*/}

이번 릴리즈의 새로운 기능을 지원하기 위해 새로 구성된 React 개발자 도구 팀과 개발자가 React 앱을 디버깅하는 데 도움이 되는 새로운 타임라인 프로파일러도 발표했습니다.

새로운 개발자 도구 기능에 대한 자세한 내용과 데모는 [Brian Vaughn](https://twitter.com/brian_d_vaughn)의 강연을 참조하세요:

<YouTubeIframe src="https://www.youtube.com/embed/oxDfrke8rZg" title="YouTube video player" />

### memo 없는 React {/*react-without-memo*/}

미래를 내다보며, [Xuan Huang(黄玄)](https://twitter.com/Huxpro)이 자동 메모화 컴파일러에 대한 React Labs 연구의 업데이트를 공유했습니다. 이 강연에서 자세한 정보와 컴파일러 프로토타입 데모를 확인하세요:

<YouTubeIframe src="https://www.youtube.com/embed/lGEMwh32soc" title="YouTube video player" />

### React 문서 기조연설 {/*react-docs-keynote*/}

[Rachel Nabors](https://twitter.com/rachelnabors)가 React의 새로운 문서에 대한 투자에 대한 기조연설로 React로 학습하고 디자인하는 방법에 대한 강연을 시작했습니다([현재 react.dev로 제공됨](/blog/2023/03/16/introducing-react-dev)):

<YouTubeIframe src="https://www.youtube.com/embed/mneDaMYOKP8" title="YouTube video player" />

### 그리고... {/*and-more*/}

**React로 학습하고 디자인하는 방법에 대한 강연:**

* Debbie O'Brien: [새로운 React 문서에서 배운 것들](https://youtu.be/-7odLW_hG7s).
* Sarah Rainsberger: [브라우저에서 학습하기](https://youtu.be/5X-WEQflCL0).
* Linton Ye: [React로 디자인함에서의 ROI](https://youtu.be/7cPWmID5XAk).
* Delba de Oliveira: [React를 이용한 인터랙티브 놀이터](https://youtu.be/zL8cz2W0z34).

**Relay, React Native, PyTorch 팀의 강연:**

* Robert Balicki: [Relay 다시 소개](https://youtu.be/lhVGdErZuN4).
* Eric Rozell과 Steven Moyes: [React Native 데스크톱](https://youtu.be/9L4FFrvwJwY).
* Roman Rädle: [React Native를 위한 온디바이스 머신러닝](https://youtu.be/NLj73vrc2I8)

**접근성, 툴링 및 서버 컴포넌트에 대한 커뮤니티 강연:**

* Daishi Kato: [외부 스토어 라이브러리를 위한 React 18](https://youtu.be/oPfSC5bQPR8).
* Diego Haz: [React 18에서 접근 가능한 컴포넌트 구축하기](https://youtu.be/dcm8fjBfro8).
* Tafu Nakazaki: [React로 접근 가능한 일본어 폼 컴포넌트](https://youtu.be/S4a0QlsH0pU).
* Lyle Troxell: [아티스트를 위한 UI 도구](https://youtu.be/b3l4WxipFsE).
* Helen Lin: [Hydrogen + React 18](https://youtu.be/HS6vIYkSNks).

## 더 예전 영상들 {/*older-videos*/}

### React Conf 2019 {/*react-conf-2019*/}

React Conf 2019의 영상 플레이리스트.
<YouTubeIframe title="React Conf 2019" src="https://www.youtube-nocookie.com/embed/playlist?list=PLPxbbTqCLbGHPxZpw4xj_Wwg8-fdNxJRh" />

### React Conf 2018 {/*react-conf-2018*/}

React Conf 2018의 영상 플레이리스트.
<YouTubeIframe title="React Conf 2018" src="https://www.youtube-nocookie.com/embed/playlist?list=PLPxbbTqCLbGE5AihOSExAa4wUM-P42EIJ" />

### React.js Conf 2017 {/*reactjs-conf-2017*/}

React.js Conf 2017의 영상 플레이리스트.
<YouTubeIframe title="React.js Conf 2017" src="https://www.youtube-nocookie.com/embed/playlist?list=PLb0IAmt7-GS3fZ46IGFirdqKTIxlws7e0" />

### React.js Conf 2016 {/*reactjs-conf-2016*/}

React.js Conf 2016의 영상 플레이리스트.
<YouTubeIframe title="React.js Conf 2016" src="https://www.youtube-nocookie.com/embed/playlist?list=PLb0IAmt7-GS0M8Q95RIc2lOM6nc77q1IY" />

### React.js Conf 2015 {/*reactjs-conf-2015*/}

React.js Conf 2015의 영상 플레이리스트.
<YouTubeIframe title="React.js Conf 2015" src="https://www.youtube-nocookie.com/embed/playlist?list=PLb0IAmt7-GS1cbw4qonlQztYV1TAW0sCr" />

### Best Practices 다시 생각해 보기 {/*rethinking-best-practices*/}

JSConf EU 2013에서 Pete Hunt의 강연: 템플릿 개념을 버리고 JavaScript를 사용하여 view를 구축하는 방법, 데이터가 변경될 때 전체 애플리케이션을 "re-rendering"하는 방법, DOM 및 이벤트를 경량으로 구현하는 방법 등 세 가지 주제를 다루고 있습니다. - (2013 - 0h30m).
<YouTubeIframe title="Pete Hunt: React: Rethinking Best Practices - JSConf EU 2013" src="https://www.youtube-nocookie.com/embed/x7cQ3mrcKaY" />

### React 소개하기 {/*introduction-to-react*/}

Facebook Seattle에서 Tom Occhino와 Jordan Walke의 React 소개 - (2013 - 1h20m).
<YouTubeIframe title="Tom Occhino and Jordan Walke introduce React at Facebook Seattle" src="https://www.youtube-nocookie.com/embed/XxVg_s8xAms" />
