> **⚠️ WARNING:** This repository is no longer maintained. We recommend migrating to [new repo](https://github.com/wootsbot/X-boilerplate) for the latest updates and support.

[![react-next-boilerplate](./docs/images/nv-rnb.png)](https://www.reactnextboilerplate.com/)

<div align="center">
  We spend time using good community practices to make your project scalable.
</div>

<br />

<div align="center">
  <!-- BUILD STATUS -->
  <a href="https://travis-ci.com/react-next-boilerplate/react-next-boilerplate/builds">
    <img src="https://img.shields.io/github/v/tag/react-next-boilerplate/react-next-boilerplate?color=000000&label=version&logo=version&style=flat-square" alt="Build Status" />
  </a>

  <!-- TEST COVERAGE -->
  <a href='https://coveralls.io/github/react-next-boilerplate/react-next-boilerplate?branch=master'>
    <img src='https://img.shields.io/coveralls/github/react-next-boilerplate/react-next-boilerplate/master?style=flat-square' alt='Coverage Status' />
  </a>

  <!-- QUALITY -->
  <a href="https://app.codacy.com/manual/react-next-boilerplate/react-next-boilerplate/dashboard?bid=14562912">
    <img src="https://img.shields.io/codacy/grade/ee2b85244d434adaa5aa04470fcdde48?style=flat-square" alt="Quality" />
  </a>

  <!-- ISSUES -->
  <a href="https://github.com/react-next-boilerplate/react-next-boilerplate/issues">
    <img src="https://img.shields.io/github/issues/react-next-boilerplate/react-next-boilerplate?style=flat-square" alt="issues" />
  </a>

  <!-- MIT -->
  <a href="https://github.com/react-next-boilerplate/react-next-boilerplate/blob/master/LICENSE">
    <img src="https://img.shields.io/github/license/react-next-boilerplate/react-next-boilerplate?style=flat-square" alt="MIT" />
  </a>

  <!-- CONTRIBUTORS -->
  <a href="https://github.com/react-next-boilerplate/react-next-boilerplate/graphs/contributors">
    <img src="https://img.shields.io/github/contributors/react-next-boilerplate/react-next-boilerplate?style=flat-square" alt="Contributors" />
  </a>

</div>

<div align="center">

  <!-- DISCORD -->
  <a href="https://discord.gg/ANbWXGs">
    <img src="https://img.shields.io/discord/680982918541082638?color=%237289DA&logo=discord&style=flat-square" alt="Discord" />
  </a>

  <!-- TWITTER -->
  <a href="https://twitter.com/RNBoilerplate">
    <img src="https://img.shields.io/twitter/url?label=%40RNBoilerplate&logo=twitter&style=flat-square&url=https%3A%2F%2Ftwitter.com%2FRNBoilerplate" alt="Twitter" />
  </a>

  <!-- RUNME -->
  <a href="https://runme.dev/api/runme?repository=https%3A%2F%2Fgithub.com%2Freact-next-boilerplate%2Freact-next-boilerplate.git&fileToOpen=README.md">
    <img src="https://badgen.net/badge/Run%20this%20/README/5B3ADF?icon=https://runme.dev/img/logo.svg" alt="Checkout project locally" />
  </a>

</div>

<div align="center">
  <sub>:rocket: A basis for reducing the configuration of your projects with <strong>Next.js</Strong>, best development practices and popular libraries in the developer community.</sub>
</div>

## Features

- [x] **redux-saga**: A library that aims to make application side effects (i.e. asynchronous things like data fetching and impure things like accessing the browser cache) easier to manage, more efficient to execute, easy to test, and better at handling failures.
- [x] **redux-saga-routines**: A smart action creator for Redux. Useful for any kind of async actions like fetching data. Also fully compatible with Redux Saga and Redux Form.
- [x] **next-i18next**: A plugin for [Next.js](https://nextjs.org/) projects that allows you to get translations up and running quickly and easily, while fully supporting SSR, multiple namespaces with code splitting, etc.
- [x] **i18next**: An internationalization-framework written in and for JavaScript. But it's much more than that.
- [x] **redux**: A predictable state container for JavaScript apps.
- [x] **reselect**: Simple selector library for Redux (and others) inspired by getters in [NuclearJS](https://optimizely.github.io/nuclear-js/), subscriptions in re-frame and this proposal from speedskater.
- [x] **Immer**: (German for: always) is a tiny package that allows you to work with immutable state in a more convenient way. It is based on the copy-on-write mechanism
- [x] **@testing-library/react**: Simple and complete React DOM testing utilities that encourage good testing practices.
- [x] **SEO**: The advantages of this approach is to be able to create Rich User experiences in a uniform way, without compromising Search Engine Optimisation (SEO) factors that are key to good ranking on Google and other search engines.
- [x] **Typefaces**: Self-hosting is significantly faster. Loading a typeface from Google Fonts or other hosted font service adds an extra (blocking) network request.
- [x] **Emotion**: A library designed for writing css styles with JavaScript. It provides powerful and predictable style composition in addition to a great developer experience with features such as source maps, labels, and testing utilities.

# Getting Started

Welcome to the light documentation of React Next Boilerplate!

## System Requirements

- [Node.js](https://nodejs.org/en/) 10 or later
- MacOS, Windows (including WSL), and Linux are supported

## Setup

Either click [this link](https://runme.dev/api/runme?repository=https%3A%2F%2Fgithub.com%2Freact-next-boilerplate%2Freact-next-boilerplate.git&fileToOpen=README.md) or manually clone this repo and move to the appropiate directory via:

```bash
git clone --depth=1 https://github.com/react-next-boilerplate/react-next-boilerplate.git <YOUR_PROJECT_NAME>`
cd <YOUR_PROJECT_NAME>
```

Then, install dependencies and run the dev server:

```bash
yarn
yarn dev
```

To see the example app at `http://localhost:3000`, run:

```bash
open http://localhost:3000
```

These scripts refer to the different stages of developing an application:

- `dev` - Runs `next` which starts Next.js in development mode
- `build` - Runs `next` build which builds the application for production usage
- `start` - Runs `next` start which starts a Next.js production server

Now you're ready to rumble! :traffic_light:

## Documentation

- [Commands](./docs/general/commands.md): Getting the most out of this boilerplate

## [Demo](https://react-next-boilerplate.vercel.app)

## Code of Conduct

React Next Boilerplate is dedicated to building a welcoming, diverse, safe community. We expect everyone participating in the React Next Boilerplate community to abide by our [Code of Conduct](./CODE_OF_CONDUCT.md). Please read it. Please follow it. In the React Next Boilerplate community, we work hard to build each other up and create amazing things together.

## Contributing

Thank you for your interest in contributing; we are delighted you want to help out. We have a [contributing guide](./CONTRIBUTING.md) to help you get started.

## License

This project is licensed under the MIT license, Copyright (c) 2019 Jorge Luis Calleja Alvarado. For more information see [project license](./LICENSE).

## Authors

- Jorge Luis Calleja Alvarado ([@wootsbot](https://twitter.com/wootsbot)) – [React Next Boilerplate](https://www.reactnextboilerplate.com/)
