# Thanks for being interested in contributing! We're so glad you want to help!

Below you'll find guides on the `react-next-boilerplate` community, and how to get started with contributing:

We really like React and some things that we think is excellent is its community, so I would like to use some [Gatsby Contributor Covenant Code of Conduct](https://www.gatsbyjs.org/contributing/code-of-conduct/).

## How to contribute

Feel free to contribute whatever you want by creating issues to improve the source code, contributing ideas to create a better community.

## Not sure how to start contributing?

If you are worried or don’t know where to start. You can reach out with questions to [Jorge L. C. A. (@wootsbot)](https://twitter.com/wootsbot) or [ @RNBoilerplate](https://twitter.com/RNBoilerplate) on Twitter, and anyone from the react-next-boilerplate team on [spectrum](https://spectrum.chat/react-next-boilerplate).

## Opening PRs in react-next-boilerplate

To test reaction-native-polyline-address changes and project files locally,
you can fork the repository and install parts to run it on your local machine

- Follow some of the [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0-beta.4/).
- Fork and clone the react-next-boilerplate [repo](https://github.com/react-next-boilerplate/react-next-boilerplate).
- Install yarn to pull in dependencies and build the project.
- Create a branch in Git to isolate your changes:

  ```shell
  git checkout -b some-change
  ```

- Once you have changes in Git that you want to push, add them and create a commit.
- Committing code will run the automated linter using Prettier. To run the linter manually, run an npm script in the project’s base directory:
- Push your changes to your fork, assuming it is set up as origin.
- Create an extraction request to the repository of [react-next-boilerplate](https://github.com/react-next-boilerplate/react-next-boilerplate).
- The development branch is `canary` (this is the branch pull requests should be made against). On a release, the relevant parts of the changes in the `canary` branch are rebased into `master`.
- Please assign the issues you are closing if this is the case, it would be good to place the correct lips.
