- 代码层面
  - 进一步体现 Rust 的优点，更接近真实开发社区的规范
  - 重新设计结构，完善设计模式
  - 增强可读性，添加可以完善了解系统代码的注释
  - 完善代码规范和风格，更贴近现代软件工程的准则
  - 完善 Windows / macOS / Linux 的环境支持和配置
- 功能层面
  - 进一步完善教学版 rCore 的功能（如进程、线程进一步区分），使得教学版有更具完整更加贴近课程
- 文档层面
  - 完善文档到非常细节的程度
  - 添加一些扩展信息
  - 进一步贴合课程所学
  - 微调文档的结构
  - 添加一些比如 qemu + gdb 从汇编层面的实践认知上的理解，添加例子进一步让同学理解操作系统如何工作
- 实验设计层面
  - 目标是让同学有对操作系统从前到后的完整理解，少一些类似数据结构的题目
  - 让工作量多一些系统层面原理的认识，减少一部分简单算法的 dirty work
  - 测试的方法会完善，强度会进一步加大，尽可能实现全自动化测试而且避免一些在代码中 cheet 的可能性
  - 设计上尽量可以检验同学们阅读代码的成果，可以设计些贯穿流程的问题或者代码填空，而不是基于可以运行的系统上来增量开发
  - 更加具体的内容和难度上需要参考老师的建议，可以把实验设计得更多更难，也可以不增加代码量而涵盖更多知识点
  - 测评尽量从每个章节的版本出发，而不是基于一个大的完整版
- 其他
  - 和做 uCore 的 RISC-V 支持的同学沟通并统一意见
