# 大实验方案设计文档：rCore Tutorial 重构

涂轶翔	2017011422  
赵成钢	2017011362



### 相关工作参考

- [**rCore_tutorial**](https://github.com/rcore-os/rCore_tutorial) 和 [**rCore**](https://github.com/rcore-os/rCore) 
  - 代码的主要参考，会在其基础上重构代码结构，而保留大部分的具体实现
- [**uCore 实验指导书**](https://learningos.github.io/ucore_os_webdocs/) 
  - 实验设计主要参照，视进度尝试移植更多挑战实验
- [Writing an OS in Rust](https://os.phil-opp.com/) 



### 设计方案

#### 1. 在多个方面改善 rCore 教学代码、文档和实验内容

##### 实验设计

- 改善自动化测试  
  *目前部分测试需要手动终止运行并人工观察输出* 

  - 测试指令直接返回成绩，节省助教检查的时间
  - 使用更强（例如随机化）的测例

- 探索更丰富的实验方法，不增加工作量而更考察知识

  - 例如，要求学生设计函数，使得某种调度算法的效率提升 / 降低
  - 例如，要求学生修改一些汇编，使得用户程序越界访问

- 尝试结合随堂作业、涵盖更多知识点

- - 部分作业比较适合作为额外挑战放在实验中

##### 代码

- 优化设计模式  
  *目前代码中存在许多软件工程角度的缺陷* 
  - 贯彻封装思想，将各个模块之间最大化地解耦合
  - 更多利用 rust 的特有功能，例如 Clone Drop 等 trait
- 提升代码可读性  
  *目前代码注释较少且不够起到解释作用* 
  - 添加规范格式的注释
  - 使用更加清晰的变量命名
  - 通过提取函数等形式让程序工作流程更加易读
- 规范代码
  - 让代码格式更加符合 rust 的 best practice，消除 Warning
- 完善对 Windows / macOS / Linux 的环境支持

##### 文档

- 细化对代码的讲解
  - 为函数添加规范的功能注释，可以自动生成 doc
  - 重要的代码添加注释
- 文档中深入阐释涉及的原理  
  *这部分现有文档仍有不足* 

##### 功能

- 实现一些目前框架缺少的功能
  - 资源的释放
  - 进程 vs 线程等

#### 2. 与 uCore 小组进行协作

- 尽可能在实验内容上达成统一
- 文档在代码讲解上差异会很大，而原理讲解上尽量做到一致

#### 3. 可能的额外项目

- 移植 uCore 中的扩展练习 和/或 将随堂作业相关内容作为挑战作业
- 物理硬件上运行 及 多核支持



### 实验计划

#### 分工

- 对于每个实验，一人负责代码与测试，另一人负责注释与文档
- 所有实验开发过程中会有轮换

#### 时间计划

- 7 ~ 10 周完成 8 个基础 lab（每周 2 个）
- 最晚 11 周时完成度达到足以供教学使用的进度
- 后续开发更多 lab 内容 和/或 拓展框架