## 什么是中断

中断是我们在操作系统上首先实现的功能，因为它是操作系统所有功能的基础。假如没有中断，操作系统在唤起一个用户程序之后，就只能等到用户程序执行完成之后才能继续执行，那操作系统完全无法进行资源调度。

### 一个比喻

操作系统就像家长，他将孩子（用户程序）送到学校（开始运行）之后便不再管。
- 但是如果孩子闯了祸，老师（硬件）就找到家长，这便是**异常**
- 孩子的作业可能需要家长来签字（系统调用），他就会主动找家长，这便是**陷阱**
- 放学时间（时钟中断）到，那么不管孩子想不想回家，家长都会把他接走，这便是**硬件中断**

### 中断的种类

#### 异常（Exception）
执行指令时产生的，通常无法预料的错误。例如：访问无效内存地址、执行非法指令（除以零）等。

有的异常可以恢复，例如缺页异常；有的异常会导致用户程序被终止，例如非法访问。

#### 陷阱（Trap）
陷阱是一系列强行导致中断的指令，例如：**系统调用（Syscall）**等。

#### 硬件中断（Hardware Interrupt）
前两种都是指令导致的异常，而硬件中断是由 CPU 之外的硬件产生的异步中断，例如：时钟中断、外设发来数据等。