# Contributing to Translations for FreeGPT WebUI  🌐
  
This README.md file was created to guide contributors on how to contribute translations to the FreeGPT WebUI project. The translations are located in the `translations` folder and are generated by `babel-flask`.  
  
## Modifying an existing translation  
  
To modify an existing translation, follow the steps below:  
  
1. Inside the `translations` folder, you will find all existing translations in the project.  
  
2. Translate the strings in the `.po` file found within the folder of the language translation you want to modify. <br>  
The identifiers of the strings to be translated are in the format `msgid "string"` and should be translated in the `msgstr ""` field. For example:  

```
msgid "New Conversation"
msgstr "Nova Conversa"
```
  
3. Add your name and GitHub profile to the "Contributors" section at the beginning of the `.po` file. If there are already contributors, add your name to the list. For example:  

```
# Portuguese (Brazil) translations for FreeGPT WebUI.
# Copyright (C) 2023 FreeGPT WebUI.
# This file is distributed under the same license as the FreeGPT WebUI
# project.
# Contributors:
# Ramon - github.com/ramonvc/
# Your Name - github.com/yourprofile/
# ...
```
  
4. Create a pull request with the changes so we can review and incorporate them into the project.  
  
## Adding a new language  
  
To add a new language, follow the steps below:  
  
1. Install `babel-flask` (if not already installed) using the command `pip install Flask-Babel`.  
  
2. Inside the project folder use the following code to generate the folder with the translation template, replacing LANGUAGE_CODE with the language code. Example: en_US  

```
pybabel init -i ./translations/messages.pot -d translations -l LANGUAGE_CODE
```
  
3. Translate the strings in the created `.po` file. The identifiers of the strings to be translated are in the format `msgid "string"` and should be translated in the `msgstr ""` field. For example:  

```
msgid "New Conversation"
msgstr "Nova Conversa"
```
  
4. Add your name and GitHub profile to the "Contributors" section at the beginning of the `.po` file. For example:  

```
# Portuguese (Brazil) translations for FreeGPT WebUI.
# Copyright (C) 2023 FreeGPT WebUI.
# This file is distributed under the same license as the FreeGPT WebUI
# project.
# Contributors:
# Ramon - github.com/ramonvc/
# ...
```
  
5. Create a pull request with the changes so we can review and incorporate them into the project.  

  
