/*
 * Decompiled with CFR 0.152.
 */
package net.iamvegan.multipartrequest;

import net.iamvegan.multipartrequest.ProgressListener;

class ProgressNotifier {
    private ProgressListener m_progressListener;
    private long m_contentLength;
    private int m_itemCount = 0;
    private long m_bytesReadLastTime = 0L;
    private long m_itemsLastTime = 0L;
    private static final long NOTIFY_BUFFER_SIZE = 4096L;

    ProgressNotifier(ProgressListener listener, long contentLength) {
        this.m_progressListener = listener;
        this.m_contentLength = contentLength;
    }

    void notifyProgress(long pBytesRead) {
        if (this.m_itemsLastTime < (long)this.m_itemCount || pBytesRead - this.m_bytesReadLastTime >= 4096L || pBytesRead > this.m_bytesReadLastTime && pBytesRead >= this.m_contentLength) {
            this.m_progressListener.update(pBytesRead, this.m_contentLength, this.m_itemCount);
            this.m_bytesReadLastTime = pBytesRead;
            this.m_itemsLastTime = this.m_itemCount;
        }
    }

    void newItem() {
        ++this.m_itemCount;
    }
}

