/*
 * Decompiled with CFR 0.152.
 */
package net.iamvegan.multipartrequest;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.iamvegan.multipartrequest.EmptyInputStream;

public class MultipartFile {
    private String m_fieldname;
    private String m_rawFileName;
    private String m_fileName;
    private File m_tmpFile;
    private byte[] m_fileContents;
    private long m_fileSize;
    private String m_contentType;

    protected MultipartFile(String fieldName, String fileName, String contentType, long fileSize, File tmpFile) {
        this.m_fieldname = fieldName;
        this.m_rawFileName = fileName;
        this.m_fileName = this.getBasename(this.m_rawFileName);
        this.m_contentType = contentType;
        this.m_tmpFile = tmpFile;
        this.m_fileSize = fileSize;
    }

    protected MultipartFile(String fieldName, String fileName, String contentType, long fileSize, byte[] fileContents) {
        this.m_fieldname = fieldName;
        this.m_rawFileName = fileName;
        this.m_fileName = this.getBasename(this.m_rawFileName);
        this.m_contentType = contentType;
        this.m_fileContents = fileContents;
        this.m_fileSize = fileSize;
    }

    public String getFieldName() {
        return this.m_fieldname;
    }

    public String getPathName() {
        return this.m_rawFileName;
    }

    public String getName() {
        return this.m_fileName;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public long getSize() {
        return this.m_fileSize;
    }

    public InputStream getInputStream() throws IOException {
        if (this.m_tmpFile != null) {
            return new FileInputStream(this.m_tmpFile);
        }
        if (this.m_fileContents != null) {
            return new ByteArrayInputStream(this.m_fileContents);
        }
        return new EmptyInputStream();
    }

    public String toString() {
        return "fieldName=" + this.getFieldName() + "; pathName=" + this.getPathName() + "; name=" + this.getName() + "; contentType=" + this.getContentType() + "; size=" + this.getSize();
    }

    private String getBasename(String strFilename) {
        if (strFilename == null) {
            return strFilename;
        }
        int intIndex = strFilename.lastIndexOf("/");
        if (intIndex == -1 || strFilename.lastIndexOf("\\") > intIndex) {
            intIndex = strFilename.lastIndexOf("\\");
        }
        if (intIndex != -1) {
            return strFilename.substring(intIndex + 1);
        }
        return strFilename;
    }
}

