/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.CipherKeyGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.DESKeyGenerator;
import org.bouncycastle.crypto.generators.DESedeKeyGenerator;

public class JCEKeyGenerator
extends KeyGeneratorSpi {
    protected String algName;
    protected int keySize;
    protected int defaultKeySize;
    protected CipherKeyGenerator engine;
    protected boolean uninitialised = true;

    protected JCEKeyGenerator(String string, int n, CipherKeyGenerator cipherKeyGenerator) {
        this.algName = string;
        this.keySize = this.defaultKeySize = n;
        this.engine = cipherKeyGenerator;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Not Implemented");
    }

    protected void engineInit(SecureRandom secureRandom) {
        this.uninitialised = false;
        this.engine.init(new KeyGenerationParameters(secureRandom, this.defaultKeySize));
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        this.uninitialised = false;
        this.engine.init(new KeyGenerationParameters(secureRandom, n));
    }

    protected SecretKey engineGenerateKey() {
        if (this.uninitialised) {
            this.engine.init(new KeyGenerationParameters(new SecureRandom(), this.defaultKeySize));
        }
        return new SecretKeySpec(this.engine.generateKey(), this.algName);
    }

    public static class IDEA
    extends JCEKeyGenerator {
        public IDEA() {
            super("IDEA", 128, new CipherKeyGenerator());
        }
    }

    public static class CAST6
    extends JCEKeyGenerator {
        public CAST6() {
            super("CAST6", 256, new CipherKeyGenerator());
        }
    }

    public static class CAST5
    extends JCEKeyGenerator {
        public CAST5() {
            super("CAST5", 128, new CipherKeyGenerator());
        }
    }

    public static class Serpent
    extends JCEKeyGenerator {
        public Serpent() {
            super("Serpent", 192, new CipherKeyGenerator());
        }
    }

    public static class Rijndael
    extends JCEKeyGenerator {
        public Rijndael() {
            super("Rijndael", 192, new CipherKeyGenerator());
        }
    }

    public static class AES
    extends JCEKeyGenerator {
        public AES() {
            super("AES", 192, new CipherKeyGenerator());
        }
    }

    public static class RC6
    extends JCEKeyGenerator {
        public RC6() {
            super("RC6", 256, new CipherKeyGenerator());
        }
    }

    public static class RC564
    extends JCEKeyGenerator {
        public RC564() {
            super("RC5-64", 256, new CipherKeyGenerator());
        }
    }

    public static class RC5
    extends JCEKeyGenerator {
        public RC5() {
            super("RC5", 128, new CipherKeyGenerator());
        }
    }

    public static class RC4
    extends JCEKeyGenerator {
        public RC4() {
            super("RC4", 128, new CipherKeyGenerator());
        }
    }

    public static class RC2
    extends JCEKeyGenerator {
        public RC2() {
            super("RC2", 128, new CipherKeyGenerator());
        }
    }

    public static class Twofish
    extends JCEKeyGenerator {
        public Twofish() {
            super("Twofish", 256, new CipherKeyGenerator());
        }
    }

    public static class Blowfish
    extends JCEKeyGenerator {
        public Blowfish() {
            super("Blowfish", 448, new CipherKeyGenerator());
        }
    }

    public static class Skipjack
    extends JCEKeyGenerator {
        public Skipjack() {
            super("SKIPJACK", 80, new CipherKeyGenerator());
        }
    }

    public static class DESede
    extends JCEKeyGenerator {
        private boolean keySizeSet = false;

        public DESede() {
            super("DESede", 192, new DESedeKeyGenerator());
        }

        protected void engineInit(int n, SecureRandom secureRandom) {
            super.engineInit(n, secureRandom);
            this.keySizeSet = true;
        }

        protected SecretKey engineGenerateKey() {
            if (this.uninitialised) {
                this.engine.init(new KeyGenerationParameters(new SecureRandom(), this.defaultKeySize));
            }
            if (!this.keySizeSet) {
                byte[] byArray = this.engine.generateKey();
                System.arraycopy(byArray, 0, byArray, 16, 8);
                return new SecretKeySpec(byArray, this.algName);
            }
            return new SecretKeySpec(this.engine.generateKey(), this.algName);
        }
    }

    public static class DES
    extends JCEKeyGenerator {
        public DES() {
            super("DES", 64, new DESKeyGenerator());
        }
    }
}

