export const Arrows = () => {
  return (
    <svg
      width={25}
      height={25}
      viewBox="0 0 25 25"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M16.5 3.298l4 4-4 4M20.5 7.298h-16M8.5 21.298l-4-4 4-4M4.5 17.298h16"
        stroke="#EE0768"
        strokeWidth={2}
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  );
};

export const Select = () => {
  return (
    <svg
      width={67}
      height={68}
      viewBox="0 0 67 68"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath="url(#clip0_628_2436)">
        <path
          d="M61.926 21.3v9.475a1.014 1.014 0 11-2.03 0V21.3a1.014 1.014 0 112.03 0zM5.373 14.498c-.946.913.517 2.38 1.434 1.434.917-.947-.51-2.351-1.434-1.434zm.716 10.528a1.018 1.018 0 000 2.033 1.017 1.017 0 000-2.033zm-.716 11.128c-.946.91.524 2.38 1.434 1.433.91-.946-.51-2.35-1.434-1.433zM67.002 6.749v38.577a6.097 6.097 0 01-6.09 6.09H56.85v15.231a1.015 1.015 0 01-1.014 1.015H39.734a1.017 1.017 0 01-1.018-1.015v-4.59c-3.317-1.337-7.01-5.932-10.73-6.998a19.768 19.768 0 00-6.16.497 1.014 1.014 0 01-1.066-.465 6.77 6.77 0 01-.494-3.674H6.092a6.098 6.098 0 01-6.09-6.09V6.748a6.097 6.097 0 016.09-6.09h54.82a6.097 6.097 0 016.09 6.09zM10.153 2.688H6.092a4.068 4.068 0 00-4.061 4.061v38.577a4.068 4.068 0 004.061 4.062h4.061v-46.7zm44.668 59.56H40.748v3.385h14.073v-3.385zm0-21.558a2.351 2.351 0 00-2.331-2.215c-.719-.087-1.337.65-2.036.325a1.02 1.02 0 01-.572-.708 2.338 2.338 0 00-2.276-1.844c-.953-.14-1.503.894-2.374.904a1.01 1.01 0 01-.728-.407 2.388 2.388 0 00-3.73 0 1.015 1.015 0 01-1.827-.608V24.48c-.026-1.95-3.97-1.918-3.997 0v23.516a1.018 1.018 0 01-1.3.975c-2.868-1.092-12.91-1.124-11.32 4.423a17.394 17.394 0 016.276-.267c3.902.976 7.847 5.973 11.118 7.089H54.81l.01-19.526zM64.973 6.749a4.068 4.068 0 00-4.062-4.061h-4.06V34.15a1.015 1.015 0 01-2.03 0V2.688H12.186v46.7h8.896c1.75-2.943 8.682-3.577 11.836-2.68V24.48c.085-4.61 7.97-4.624 8.054 0v9.612a4.484 4.484 0 014.462.702 4.394 4.394 0 016.038 1.773 4.368 4.368 0 015.378 4.123v8.698h4.061a4.064 4.064 0 004.062-4.062V6.75zm-23.35 4.738H25.365a6.439 6.439 0 00-6.413 6.431v16.259a6.435 6.435 0 006.429 6.412h4.494a1.015 1.015 0 000-2.03H25.38a4.406 4.406 0 01-4.4-4.408V17.892a4.406 4.406 0 014.4-4.373h16.258a4.406 4.406 0 014.4 4.4v13.305a1.018 1.018 0 002.032 0V17.918a6.44 6.44 0 00-6.448-6.431z"
          fill="#197BDD"
        />
      </g>
      <defs>
        <clipPath id="clip0_628_2436">
          <path
            fill="#fff"
            transform="translate(0 .659)"
            d="M0 0H67V67.0033H0z"
          />
        </clipPath>
      </defs>
    </svg>
  );
};

export const Paste = () => {
  return (
    <svg
      width={84}
      height={85}
      viewBox="0 0 84 85"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M29.416 63.974H19.182a5.957 5.957 0 01-5.95-5.95V19.599a5.957 5.957 0 015.95-5.951H49.95a5.958 5.958 0 015.951 5.95v3.584a1.312 1.312 0 11-2.625 0v-3.583a3.33 3.33 0 00-3.326-3.326H19.182a3.33 3.33 0 00-3.325 3.326v38.425a3.33 3.33 0 003.325 3.325h10.235a1.312 1.312 0 010 2.625z"
        fill="#EBB240"
      />
      <path
        d="M49.435 71.352h-15.38c-3.282 0-5.951-2.633-5.951-5.869V27.734c0-3.235 2.67-5.868 5.95-5.868h30.764c3.281 0 5.95 2.633 5.95 5.868v23.133a1.312 1.312 0 11-2.625 0V27.734a3.282 3.282 0 00-3.325-3.243H34.054a3.283 3.283 0 00-3.325 3.243v37.75a3.281 3.281 0 003.325 3.243h15.381a1.313 1.313 0 010 2.625z"
        fill="#EBB240"
      />
      <path
        d="M55.082 34.975H37.406a1.313 1.313 0 010-2.625h17.676a1.313 1.313 0 010 2.625zM55.082 43.035H37.406a1.312 1.312 0 010-2.625h17.676a1.313 1.313 0 010 2.625zM50.909 51.095H37.406a1.313 1.313 0 010-2.625H50.91a1.313 1.313 0 010 2.625zM61.477 71.352a1.312 1.312 0 01-1.312-1.313V56.306a1.312 1.312 0 112.625 0v13.733a1.312 1.312 0 01-1.313 1.313z"
        fill="#EBB240"
      />
      <path
        d="M67.886 64.484H55.069a1.313 1.313 0 010-2.625h12.817a1.313 1.313 0 010 2.625z"
        fill="#EBB240"
      />
    </svg>
  );
};

export const Download = () => {
  return (
    <svg
      width={80}
      height={81}
      viewBox="0 0 80 81"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M26.667 57.166L40 70.5l13.333-13.334M40 40.5v30"
        stroke="#3B2DFF"
        strokeWidth={2}
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M69.6 60.8A16.667 16.667 0 0060 30.5h-4.2A26.666 26.666 0 1010 54.8"
        stroke="#3B2DFF"
        strokeWidth={2}
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  );
};

interface SVGProps {
  className?: string;
}

export const Speaker = ({ className }: SVGProps) => {
  return (
    <svg
      width={16}
      height={17}
      viewBox="0 0 16 17"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      className={className}
    >
      <path
        d="M7.174 4.037l-3.176 2.54H1.457v3.812h2.54l3.177 2.541V4.037zM10.058 6.235a3.176 3.176 0 010 4.49M12.3 3.992a6.352 6.352 0 010 8.983"
        stroke="#EE0768"
        strokeWidth={0.846994}
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  );
};

export const Mic = ({ className }: SVGProps) => {
  return (
    <svg
      width={16}
      height={17}
      viewBox="0 0 16 17"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      className={className}
    >
      <path
        d="M8.204 2.131A1.906 1.906 0 006.3 4.037v4.447a1.906 1.906 0 003.811 0V4.037A1.906 1.906 0 008.204 2.13z"
        stroke="#EE0768"
        strokeWidth={0.846994}
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M12.651 7.213v1.27a4.447 4.447 0 11-8.893 0v-1.27M8.204 12.93v1.906"
        stroke="#EE0768"
        strokeWidth={0.846994}
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  );
};

export const Copy = ({ className }: SVGProps) => {
  return (
    <svg
      width={16}
      height={16}
      viewBox="0 0 16 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      className={className}
    >
      <path
        d="M10.623 1.901H6.29c-.25 0-.502.126-.69.314-.189.189-.314.44-.314.691v8.04c0 .25.125.502.314.69.188.189.44.315.69.315h6.156c.251 0 .502-.126.69-.315.19-.188.315-.44.315-.69V4.728L10.623 1.9z"
        stroke="#EE0768"
        strokeWidth={0.837455}
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M2.772 5.418v8.04c0 .251.126.502.314.69.189.19.44.315.691.315h6.155M10.31 1.901v3.14h3.14"
        stroke="#EE0768"
        strokeWidth={0.837455}
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  );
};

export const MicPlay = ({ className }: SVGProps) => {
  return (
    <svg
      width="24"
      height="25.5"
      viewBox="0 0 16 17"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      className={className}
    >
      <path
        d="M8.204 2.131A1.906 1.906 0 006.3 4.037v4.447a1.906 1.906 0 003.811 0V4.037A1.906 1.906 0 008.204 2.13z"
        stroke="#EE0768"
        strokeWidth="0.846994"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M12.651 7.213v1.27a4.447 4.447 0 11-8.893 0v-1.27M8.204 12.93v1.906"
        stroke="#EE0768"
        strokeWidth="0.846994"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <polygon points="12,1 12,7 16,4" fill="#EE0768" />
    </svg>
  );
};

export const MicPause = ({ className }: SVGProps) => {
  return (
    <svg
      width="20"
      height="21.25"
      viewBox="0 0 16 17"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      className={className}
    >
      <path
        d="M8.204 2.131A1.906 1.906 0 006.3 4.037v4.447a1.906 1.906 0 003.811 0V4.037A1.906 1.906 0 008.204 2.13z"
        stroke="#EE0768"
        strokeWidth="0.846994"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M12.651 7.213v1.27a4.447 4.447 0 11-8.893 0v-1.27M8.204 12.93v1.906"
        stroke="#EE0768"
        strokeWidth="0.846994"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <rect x="12" y="0" width="2" height="6" fill="#EE0768" />
      <rect x="15" y="0" width="2" height="6" fill="#EE0768" />
    </svg>
  );
};

export const MicStop = ({ className }: SVGProps) => {
  return (
    <svg
      width="20"
      height="21.25"
      viewBox="0 0 16 17"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      className={className}
    >
      <path
        d="M8.204 2.131A1.906 1.906 0 006.3 4.037v4.447a1.906 1.906 0 003.811 0V4.037A1.906 1.906 0 008.204 2.13z"
        stroke="#EE0768"
        strokeWidth="0.846994"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M12.651 7.213v1.27a4.447 4.447 0 11-8.893 0v-1.27M8.204 12.93v1.906"
        stroke="#EE0768"
        strokeWidth="0.846994"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <rect x="0" y="0" width="4" height="4" fill="#EE0768" />
    </svg>
  );
};
export const MicReset = ({ className }: SVGProps) => {
  return (
    <svg
      width="24"
      height="25.5"
      viewBox="0 0 16 17"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      className={className}
    >
      <path
        d="M8.204 2.131A1.906 1.906 0 006.3 4.037v4.447a1.906 1.906 0 003.811 0V4.037A1.906 1.906 0 008.204 2.13z"
        stroke="#EE0768"
        strokeWidth="0.846994"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M12.651 7.213v1.27a4.447 4.447 0 11-8.893 0v-1.27M8.204 12.93v1.906"
        stroke="#EE0768"
        strokeWidth="0.846994"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M8 1v4m0 -4l-1 1m1 -1l1 1M15 8h-4m4 0l-1 -1m1 1l-1 1"
        stroke="#EE0768"
        strokeWidth="0.846994"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M13.5 8a5.5 5.5 0 1 1-11 0"
        stroke="#EE0768"
        strokeWidth="0.846994"
        fill="none"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  );
};

// new to prbably check
export const UploadIcon = () => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="91"
      height="92"
      viewBox="0 0 91 92"
      fill="none"
    >
      <path
        d="M45.4998 89.9971C70.3522 89.9971 90.4991 69.8505 90.4991 44.9985C90.4991 20.1465 70.3522 0 45.4998 0C20.6474 0 0.500488 20.1465 0.500488 44.9985C0.500488 69.8505 20.6474 89.9971 45.4998 89.9971Z"
        fill="url(#paint0_linear_2048_33385)"
      />
      <g filter="url(#filter0_d_2048_33385)">
        <mask
          id="mask0_2048_33385"
          style={{ maskType: "alpha" }}
          maskUnits="userSpaceOnUse"
          x="0"
          y="0"
          width="91"
          height="90"
        >
          <path
            d="M45.4998 90C70.3522 90 90.4991 69.8535 90.4991 45.0015C90.4991 20.1495 70.3522 0.00292969 45.4998 0.00292969C20.6474 0.00292969 0.500488 20.1495 0.500488 45.0015C0.500488 69.8535 20.6474 90 45.4998 90Z"
            fill="url(#paint1_linear_2048_33385)"
          />
        </mask>
        <g mask="url(#mask0_2048_33385)">
          <path
            d="M71.3028 25.8018H19.7036C18.0467 25.8018 16.7036 27.1449 16.7036 28.8017V91.7996C16.7036 93.4564 18.0467 94.7995 19.7036 94.7995H71.3028C72.9596 94.7995 74.3027 93.4564 74.3027 91.7996V28.8017C74.3027 27.1449 72.9596 25.8018 71.3028 25.8018Z"
            fill="white"
          />
        </g>
      </g>
      <path
        d="M40.0994 31.7988H24.4997C23.5056 31.7988 22.6997 32.6047 22.6997 33.5988C22.6997 34.5928 23.5056 35.3987 24.4997 35.3987H40.0994C41.0935 35.3987 41.8994 34.5928 41.8994 33.5988C41.8994 32.6047 41.0935 31.7988 40.0994 31.7988Z"
        fill="#CED0D3"
      />
      <path
        d="M40.0994 56.998H24.4997C23.5056 56.998 22.6997 57.8039 22.6997 58.798C22.6997 59.7921 23.5056 60.5979 24.4997 60.5979H40.0994C41.0935 60.5979 41.8994 59.7921 41.8994 58.798C41.8994 57.8039 41.0935 56.998 40.0994 56.998Z"
        fill="#CED0D3"
      />
      <path
        d="M65.3045 40.8013H25.7051C24.3797 40.8013 23.3052 41.8758 23.3052 43.2012V49.201C23.3052 50.5264 24.3797 51.6009 25.7051 51.6009H65.3045C66.63 51.6009 67.7045 50.5264 67.7045 49.201V43.2012C67.7045 41.8758 66.63 40.8013 65.3045 40.8013Z"
        stroke="#CED0D3"
        strokeWidth="1.27462"
      />
      <path
        d="M65.299 65.3975H25.6997C24.0428 65.3975 22.6997 66.7406 22.6997 68.3974V73.1972C22.6997 74.854 24.0428 76.1971 25.6997 76.1971H65.299C66.9559 76.1971 68.299 74.854 68.299 73.1972V68.3974C68.299 66.7406 66.9559 65.3975 65.299 65.3975Z"
        fill="#CED0D3"
      />
      <path
        d="M32.295 19.1988C33.6204 19.1988 34.6949 18.1243 34.6949 16.7988C34.6949 15.4734 33.6204 14.3989 32.295 14.3989C30.9695 14.3989 29.895 15.4734 29.895 16.7988C29.895 18.1243 30.9695 19.1988 32.295 19.1988Z"
        fill="white"
      />
      <path
        d="M45.4981 19.1988C46.8236 19.1988 47.8981 18.1243 47.8981 16.7988C47.8981 15.4734 46.8236 14.3989 45.4981 14.3989C44.1726 14.3989 43.0981 15.4734 43.0981 16.7988C43.0981 18.1243 44.1726 19.1988 45.4981 19.1988Z"
        fill="#CED0D3"
      />
      <path
        d="M58.6934 19.1988C60.0189 19.1988 61.0934 18.1243 61.0934 16.7988C61.0934 15.4734 60.0189 14.3989 58.6934 14.3989C57.368 14.3989 56.2935 15.4734 56.2935 16.7988C56.2935 18.1243 57.368 19.1988 58.6934 19.1988Z"
        fill="white"
      />
      <path
        d="M52.0942 52.7996C53.751 52.7996 55.0941 51.4565 55.0941 49.7997C55.0941 48.1429 53.751 46.7998 52.0942 46.7998C50.4374 46.7998 49.0942 48.1429 49.0942 49.7997C49.0942 51.4565 50.4374 52.7996 52.0942 52.7996Z"
        fill="#CED0D3"
      />
      <path
        d="M54.4396 62.622C53.9596 62.622 53.5114 62.622 53.1034 62.5962C52.6008 62.5622 52.1174 62.3902 51.7062 62.0992C51.2951 61.8082 50.9722 61.4095 50.773 60.9468L48.2417 55.9442C48.056 55.728 47.9633 55.4472 47.9837 55.163C48.0042 54.8788 48.1362 54.6142 48.3509 54.4269C48.5268 54.2855 48.7462 54.2094 48.9718 54.2115C49.138 54.2163 49.3011 54.2571 49.4499 54.331C49.5988 54.405 49.7298 54.5104 49.834 54.6398L50.9836 56.2088L51.001 56.2292V50.2684C51.001 49.9727 51.1185 49.689 51.3276 49.4799C51.5367 49.2708 51.8204 49.1533 52.1161 49.1533C52.4118 49.1533 52.6955 49.2708 52.9046 49.4799C53.1137 49.689 53.2312 49.9727 53.2312 50.2684V54.1683C53.2182 54.0248 53.2353 53.8801 53.2813 53.7436C53.3274 53.607 53.4014 53.4816 53.4986 53.3752C53.5958 53.2689 53.7141 53.1839 53.8459 53.1258C53.9778 53.0677 54.1203 53.0376 54.2644 53.0376C54.4085 53.0376 54.551 53.0677 54.6828 53.1258C54.8147 53.1839 54.933 53.2689 55.0302 53.3752C55.1274 53.4816 55.2013 53.607 55.2474 53.7436C55.2934 53.8801 55.3105 54.0248 55.2975 54.1683V54.9812C55.2846 54.8377 55.3017 54.6931 55.3477 54.5566C55.3938 54.42 55.4677 54.2946 55.5649 54.1882C55.6621 54.0818 55.7804 53.9969 55.9123 53.9388C56.0441 53.8806 56.1866 53.8506 56.3307 53.8506C56.4748 53.8506 56.6173 53.8806 56.7492 53.9388C56.881 53.9969 56.9993 54.0818 57.0965 54.1882C57.1937 54.2946 57.2677 54.42 57.3137 54.5566C57.3598 54.6931 57.3769 54.8377 57.3639 54.9812V55.6076C57.351 55.4641 57.368 55.3195 57.4141 55.1829C57.4601 55.0464 57.5341 54.9209 57.6313 54.8146C57.7285 54.7082 57.8468 54.6233 57.9786 54.5651C58.1105 54.507 58.253 54.477 58.3971 54.477C58.5412 54.477 58.6837 54.507 58.8155 54.5651C58.9474 54.6233 59.0657 54.7082 59.1629 54.8146C59.2601 54.9209 59.3341 55.0464 59.3801 55.1829C59.4261 55.3195 59.4432 55.4641 59.4303 55.6076V59.4097C59.4099 60.579 58.8813 62.5506 57.0219 62.5506C56.8869 62.5566 55.7433 62.6226 54.442 62.6226L54.4396 62.622Z"
        fill="#CED0D3"
        stroke="white"
        strokeWidth="0.637308"
      />
      <defs>
        <filter
          id="filter0_d_2048_33385"
          x="12.8798"
          y="20.066"
          width="65.2468"
          height="71.8459"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="-1.91193" />
          <feGaussianBlur stdDeviation="1.91193" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.788235 0 0 0 0 0.803922 0 0 0 0 0.85098 0 0 0 0.349 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_2048_33385"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect1_dropShadow_2048_33385"
            result="shape"
          />
        </filter>
        <linearGradient
          id="paint0_linear_2048_33385"
          x1="45.4998"
          y1="0"
          x2="45.4998"
          y2="89.9971"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#EDEDED" />
          <stop offset="1" stopColor="#EAEAEA" />
        </linearGradient>
        <linearGradient
          id="paint1_linear_2048_33385"
          x1="45.4998"
          y1="0.00292969"
          x2="45.4998"
          y2="98.7926"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#EBF3FF" />
          <stop offset="1" stopColor="#CED4E1" />
        </linearGradient>
      </defs>
    </svg>
  );
};

export const UploadIconActive = () => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="91"
      height="93"
      viewBox="0 0 91 93"
      fill="none"
    >
      <path
        d="M45.5 90C70.3528 90 90.5 69.8528 90.5 45C90.5 20.1472 70.3528 0 45.5 0C20.6472 0 0.5 20.1472 0.5 45C0.5 69.8528 20.6472 90 45.5 90Z"
        fill="url(#paint0_linear_2048_33409)"
      />
      <g filter="url(#filter0_d_2048_33409)">
        <mask
          id="mask0_2048_33409"
          style={{ maskType: "alpha" }}
          maskUnits="userSpaceOnUse"
          x="0"
          y="0"
          width="91"
          height="90"
        >
          <path
            d="M45.5 90C70.3528 90 90.5 69.8528 90.5 45C90.5 20.1472 70.3528 0 45.5 0C20.6472 0 0.5 20.1472 0.5 45C0.5 69.8528 20.6472 90 45.5 90Z"
            fill="url(#paint1_linear_2048_33409)"
          />
        </mask>
        <g mask="url(#mask0_2048_33409)">
          <path
            d="M71.3031 25.8003H19.7031C18.0463 25.8003 16.7031 27.1434 16.7031 28.8003V91.8003C16.7031 93.4572 18.0463 94.8003 19.7031 94.8003H71.3031C72.96 94.8003 74.3031 93.4572 74.3031 91.8003V28.8003C74.3031 27.1434 72.96 25.8003 71.3031 25.8003Z"
            fill="white"
          />
        </g>
      </g>
      <path
        d="M40.0953 31.8003H24.4953C23.5012 31.8003 22.6953 32.6062 22.6953 33.6003C22.6953 34.5944 23.5012 35.4003 24.4953 35.4003H40.0953C41.0894 35.4003 41.8953 34.5944 41.8953 33.6003C41.8953 32.6062 41.0894 31.8003 40.0953 31.8003Z"
        fill="#FEF3F2"
      />
      <path
        d="M40.0953 56.9995H24.4953C23.5012 56.9995 22.6953 57.8054 22.6953 58.7995C22.6953 59.7936 23.5012 60.5995 24.4953 60.5995H40.0953C41.0894 60.5995 41.8953 59.7936 41.8953 58.7995C41.8953 57.8054 41.0894 56.9995 40.0953 56.9995Z"
        fill="#FEF3F2"
      />
      <path
        d="M65.3008 40.8013H25.7008C24.3753 40.8013 23.3008 41.8758 23.3008 43.2013V49.2013C23.3008 50.5268 24.3753 51.6013 25.7008 51.6013H65.3008C66.6263 51.6013 67.7008 50.5268 67.7008 49.2013V43.2013C67.7008 41.8758 66.6263 40.8013 65.3008 40.8013Z"
        stroke="#F6463D"
        strokeWidth="1.58251"
        strokeLinecap="square"
      />
      <path
        d="M65.2953 65.3984H25.6953C24.0385 65.3984 22.6953 66.7416 22.6953 68.3984V73.1984C22.6953 74.8553 24.0385 76.1984 25.6953 76.1984H65.2953C66.9522 76.1984 68.2953 74.8553 68.2953 73.1984V68.3984C68.2953 66.7416 66.9522 65.3984 65.2953 65.3984Z"
        fill="#FEF3F2"
      />
      <path
        d="M32.3023 19.1989C33.6278 19.1989 34.7023 18.1244 34.7023 16.7989C34.7023 15.4734 33.6278 14.3989 32.3023 14.3989C30.9769 14.3989 29.9023 15.4734 29.9023 16.7989C29.9023 18.1244 30.9769 19.1989 32.3023 19.1989Z"
        fill="white"
      />
      <path
        d="M45.5016 19.1989C46.827 19.1989 47.9016 18.1244 47.9016 16.7989C47.9016 15.4734 46.827 14.3989 45.5016 14.3989C44.1761 14.3989 43.1016 15.4734 43.1016 16.7989C43.1016 18.1244 44.1761 19.1989 45.5016 19.1989Z"
        fill="#F6463D"
      />
      <path
        d="M58.7047 19.1989C60.0302 19.1989 61.1047 18.1244 61.1047 16.7989C61.1047 15.4734 60.0302 14.3989 58.7047 14.3989C57.3792 14.3989 56.3047 15.4734 56.3047 16.7989C56.3047 18.1244 57.3792 19.1989 58.7047 19.1989Z"
        fill="white"
      />
      <path
        d="M52.0938 52.8018C53.7506 52.8018 55.0938 51.4586 55.0938 49.8018C55.0938 48.1449 53.7506 46.8018 52.0938 46.8018C50.4369 46.8018 49.0938 48.1449 49.0938 49.8018C49.0938 51.4586 50.4369 52.8018 52.0938 52.8018Z"
        fill="#FBDFDF"
      />
      <path
        d="M54.4392 62.6263C53.9592 62.6263 53.511 62.6263 53.103 62.6005C52.6004 62.5665 52.117 62.3946 51.7058 62.1036C51.2947 61.8126 50.9717 61.4138 50.7726 60.9511L48.2412 55.9483C48.0555 55.7322 47.9628 55.4514 47.9833 55.1671C48.0037 54.8829 48.1357 54.6183 48.3504 54.4309C48.5263 54.2895 48.7457 54.2134 48.9714 54.2155C49.1375 54.2204 49.3006 54.2612 49.4495 54.3351C49.5983 54.4091 49.7294 54.5144 49.8336 54.6439L50.9832 56.2129L51.0006 56.2333V50.2723C51.0006 49.9766 51.1181 49.693 51.3272 49.4838C51.5363 49.2747 51.8199 49.1572 52.1157 49.1572C52.4114 49.1572 52.695 49.2747 52.9042 49.4838C53.1133 49.693 53.2308 49.9766 53.2308 50.2723V54.1723C53.2178 54.0288 53.2349 53.8842 53.2809 53.7476C53.327 53.6111 53.401 53.4856 53.4982 53.3793C53.5954 53.2729 53.7137 53.1879 53.8455 53.1298C53.9774 53.0717 54.1199 53.0417 54.264 53.0417C54.4081 53.0417 54.5506 53.0717 54.6824 53.1298C54.8143 53.1879 54.9326 53.2729 55.0298 53.3793C55.127 53.4856 55.201 53.6111 55.247 53.7476C55.293 53.8842 55.3101 54.0288 55.2972 54.1723V54.9853C55.2842 54.8418 55.3013 54.6972 55.3473 54.5606C55.3934 54.4241 55.4674 54.2986 55.5646 54.1923C55.6618 54.0859 55.7801 54.0009 55.9119 53.9428C56.0438 53.8847 56.1863 53.8547 56.3304 53.8547C56.4745 53.8547 56.617 53.8847 56.7488 53.9428C56.8807 54.0009 56.999 54.0859 57.0962 54.1923C57.1934 54.2986 57.2674 54.4241 57.3134 54.5606C57.3594 54.6972 57.3765 54.8418 57.3636 54.9853V55.6117C57.3506 55.4682 57.3677 55.3236 57.4137 55.187C57.4598 55.0505 57.5338 54.925 57.631 54.8187C57.7282 54.7123 57.8465 54.6273 57.9783 54.5692C58.1102 54.5111 58.2527 54.4811 58.3968 54.4811C58.5409 54.4811 58.6834 54.5111 58.8152 54.5692C58.9471 54.6273 59.0654 54.7123 59.1626 54.8187C59.2598 54.925 59.3338 55.0505 59.3798 55.187C59.4258 55.3236 59.4429 55.4682 59.43 55.6117V59.4139C59.4096 60.5833 58.881 62.5549 57.0216 62.5549C56.8866 62.5609 55.743 62.6269 54.4416 62.6269L54.4392 62.6263Z"
        fill="#F6463D"
        stroke="white"
        strokeWidth="0.791255"
        strokeLinecap="square"
      />
      <defs>
        <filter
          id="filter0_d_2048_33409"
          x="11.9556"
          y="18.679"
          width="67.0952"
          height="73.6948"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="-2.37377" />
          <feGaussianBlur stdDeviation="2.37377" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.788235 0 0 0 0 0.803922 0 0 0 0 0.85098 0 0 0 0.349 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_2048_33409"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect1_dropShadow_2048_33409"
            result="shape"
          />
        </filter>
        <linearGradient
          id="paint0_linear_2048_33409"
          x1="45.5"
          y1="0"
          x2="45.5"
          y2="90"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FFE8E8" />
          <stop offset="1" stopColor="#FFF1F1" />
        </linearGradient>
        <linearGradient
          id="paint1_linear_2048_33409"
          x1="45.5"
          y1="0"
          x2="45.5"
          y2="90"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#E3ECFA" />
          <stop offset="1" stopColor="#DAE7FF" />
        </linearGradient>
      </defs>
    </svg>
  );
};

export const Document = ({ fileExtension }: { fileExtension: string }) => {
  return (
    <div className="relative">
      <div className="absolute top-2.5 bg-[#BF1F16] w-[95%] text-center text-white text-[8px]">
        {fileExtension}
      </div>
      <svg
        xmlns="http://www.w3.org/2000/svg"
        width="32"
        height="29"
        viewBox="0 0 39 46"
        fill="none"
      >
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M1.8335 0.600098C1.28121 0.600098 0.833496 1.04781 0.833496 1.6001V44.4001C0.833496 44.9524 1.28121 45.4001 1.83349 45.4001H37.1668C37.7191 45.4001 38.1668 44.9524 38.1668 44.4001V8.06676L30.7002 0.600098H1.8335Z"
          fill="#E4E7EC"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M30.7002 0.600098V8.06676H38.1669L30.7002 0.600098Z"
          fill="#98A2B3"
        />
      </svg>
    </div>
  );
};

export const Alert = () => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="16"
      height="16"
      viewBox="0 0 16 16"
      fill="none"
    >
      <path
        d="M8.00004 14.6668C11.6819 14.6668 14.6667 11.6821 14.6667 8.00016C14.6667 4.31826 11.6819 1.3335 8.00004 1.3335C4.31814 1.3335 1.33337 4.31826 1.33337 8.00016C1.33337 11.6821 4.31814 14.6668 8.00004 14.6668Z"
        fill="#DE5E5E"
      />
      <path
        d="M8 5.3335V8.00016"
        stroke="white"
        strokeWidth="2"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M8 10.6665H8.00667"
        stroke="white"
        strokeWidth="2"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  );
};
export const AlertIcon = (props: any) => {
  return (
    <svg
      {...props}
      xmlns="http://www.w3.org/2000/svg"
      width="50"
      height="50"
      viewBox="0 0 50 50"
      fill="none"
    >
      <path
        d="M24.9993 16.667V25.0003M24.9993 33.3337H25.0202M45.8327 25.0003C45.8327 36.5063 36.5053 45.8337 24.9993 45.8337C13.4934 45.8337 4.16602 36.5063 4.16602 25.0003C4.16602 13.4944 13.4934 4.16699 24.9993 4.16699C36.5053 4.16699 45.8327 13.4944 45.8327 25.0003Z"
        stroke="#BF1F16"
        strokeWidth="4.16667"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  );
};


export const TrashCanIcon = () => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24"
      height="25"
      viewBox="0 0 24 25"
      fill="none"
    >
      <path
        d="M7 21.6201C6.45 21.6201 5.979 21.4241 5.587 21.0321C5.195 20.6401 4.99933 20.1695 5 19.6201V6.62012H4V4.62012H9V3.62012H15V4.62012H20V6.62012H19V19.6201C19 20.1701 18.804 20.6411 18.412 21.0331C18.02 21.4251 17.5493 21.6208 17 21.6201H7ZM17 6.62012H7V19.6201H17V6.62012ZM9 17.6201H11V8.62012H9V17.6201ZM13 17.6201H15V8.62012H13V17.6201Z"
        fill="#DC2626"
      />
    </svg>
  );
};

export const LoadingIndicator = (props: any) => {
  return (
    <svg
      {...props}
      className="m-auto h-7 w-7 animate-spin"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <circle
        className="opacity-25"
        cx="12"
        cy="12"
        r="10"
        stroke="currentColor"
        strokeWidth="4"
      ></circle>
      <path
        className="opacity-75"
        fill="currentColor"
        d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"
      ></path>
    </svg>
  );
};

export const ThreeFeathers = (props: any) => {
  return (
    <svg
      {...props}
      xmlns="http://www.w3.org/2000/svg"
      width="62"
      height="64"
      viewBox="0 0 62 64"
      fill="none"
    >
      <path
        d="M46.2726 25.2209L56.1787 38.8605C59.2916 43.9177 57.183 42.6729 55.4521 41.0397C49.6388 35.5546 37.821 24.321 36.6756 16.3681C35.2407 6.4055 41.7298 19.4264 46.2726 25.2209Z"
        fill="#EE0768"
      />
      <path
        d="M23.0593 41.2603L39.2874 45.8227C44.865 47.8615 42.4387 48.1918 40.0681 47.9832C32.1064 47.2826 15.8695 45.7931 10.0409 40.2625C2.73933 33.3343 15.9027 39.5293 23.0593 41.2603Z"
        fill="#EE0768"
      />
      <path
        d="M27.4951 29.4889L42.2356 38.7034C56.1199 47.3925 48.5516 44.2288 45.2821 42.7321C34.3017 37.7056 11.9395 27.3685 6.46469 16.5652C-0.393558 3.03183 14.2998 21.3744 27.4951 29.4889Z"
        fill="#EE0768"
      />
    </svg>
  );
};

export const ArrowDark = (props: any) => {
  return (
    <svg
      {...props}
      xmlns="http://www.w3.org/2000/svg"
      width="29"
      height="22"
      viewBox="0 0 29 22"
      fill="none"
    >
      <path
        d="M0.183105 10.7668L28.0001 10.7668M28.0001 10.7668C24.4113 10.6706 17.2336 8.38278 17.2336 0.000354097M28.0001 10.7668C24.4113 10.7347 17.2336 12.8432 17.2336 21.5332"
        stroke="black"
        strokeWidth="3.37175"
      />
    </svg>
  );
};
