# Security Policy

## Supported Versions

We maintain and provide security updates for the following versions of our project. 
Versions not listed here are considered deprecated and will not receive security updates.

| Version | Supported          |
| ------- | ------------------ |
| 1.0.x   | :white_check_mark: |

## Reporting a Vulnerability

If you discover a security vulnerability in this project, we encourage you to report it as soon as possible to help us maintain the safety and security of our users.

### How to Report

- **Email**: Please report any vulnerabilities by sending an email to [abdrahmanoladimeji02@gmail.com](mailto:abdrahmanoladimeji02@gmail.com). Include the following details:
  - A detailed description of the vulnerability.
  - Steps to reproduce the vulnerability.
  - Any potential impacts or exploitability assessments.
  - Your contact information for follow-up.

### What to Expect

- **Acknowledgment**: You will receive an acknowledgment of your report within 48 hours.
- **Initial Assessment**: Our security team will conduct an initial assessment of the vulnerability within 5 business days. During this period, we might reach out for additional information.
- **Mitigation**: If the vulnerability is confirmed, we will work on a fix and notify you when a patch is available.
- **Public Disclosure**: We aim to publicly disclose the vulnerability after a fix has been released, typically within 30 days of the initial report. We will credit the reporter unless they wish to remain anonymous.

### How We Handle Vulnerabilities

- **Severity Assessment**: We prioritize the remediation of vulnerabilities based on their severity, impact, and exploitability.
- **Patching**: We will create patches for supported versions listed above. We do not provide security patches for versions that are no longer supported.
- **Communication**: Once the vulnerability is fixed, we will notify affected users and publish a security advisory that includes details about the vulnerability and the steps taken to address it.

### Thank You

We appreciate the community’s efforts in reporting vulnerabilities and helping us ensure the security of our project. Thank you for your responsible disclosure and collaboration.
