# LanguageAI

![License](https://img.shields.io/github/license/rahmlad-aramide/LanguageAI)
![Issues](https://img.shields.io/github/issues/rahmlad-aramide/LanguageAI)
![Stars](https://img.shields.io/github/stars/rahmlad-aramide/LanguageAI)
![Forks](https://img.shields.io/github/forks/rahmlad-aramide/LanguageAI)

![LanguageAI Thumbnail](https://languageai.vercel.app/og.png)

## Description
LanguageAI is a comprehensive language translation platform that supports over 130 languages. It allows seamless translation of text and documents in various formats, breaking down language barriers and fostering global communication.

## Features
- Translate text in 130+ languages
- Support for multiple document formats
- Easy-to-use interface
- Locale-based translations

## Table of Contents
- [Installation](#installation)
- [Usage](#usage)
- [Contributing](#contributing)
- [License](#license)
- [Acknowledgements](#acknowledgements)

## Installation

### Prerequisites
- Node.js >= 18.17
- npm or yarn
- Next.js 14.1.0

### Steps
1. Clone the repository:
   ```bash
   git clone https://github.com/rahmlad-aramide/LanguageAI.git
   ```
2. Navigate to the project directory:
   ```bash
   cd LanguageAI
   ```
3. Install dependencies:
   ```bash
   npm install
   # or
   yarn install
   ```

## Usage

### Development
To start the development server, run:
```bash
npm run dev
# or
yarn dev
```
This will start the project on `http://localhost:5015`.

### Format
Before pushing, format the codebase, run:
```bash
npm run format
# or
yarn format
```

### Build
To build the project for production, run:
```bash
npm run build
# or
yarn build
```

### Deployment
Deployment is handled via Vercel.

## Contributing
We welcome contributions! Please see the [CONTRIBUTING.md](CONTRIBUTING.md) for more details.

## License
This project is licensed under the MIT License. See the [LICENSE](LICENSE) file for more details.

## Acknowledgements
- Thanks to all contributors and supporters of the project.
- Special mentions to Microsoft and Microsoft Azure translation service that made this project possible.
