/*!

=========================================================
* Argon Dashboard React - v1.0.0
=========================================================

* Product Page: https://www.creative-tim.com/product/argon-dashboard-react
* Copyright 2019 Creative Tim (https://www.creative-tim.com)
* Licensed under MIT (https://github.com/creativetimofficial/argon-dashboard-react/blob/master/LICENSE.md)

* Coded by Creative Tim

=========================================================

* The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

*/
import React from "react";

// reactstrap components
import {
  Card,
  CardHeader,
  CardFooter,
  Pagination,
  PaginationItem,
  PaginationLink,
  Table,
  Container,
  Row,
} from "reactstrap";
// core components
import Header from "components/Headers/Header.jsx";
import Axios from "axios";

class Tables extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      list: []
    }

  }

  async search() {
    let token = window.localStorage.getItem('token');
    let baseUrl = "http://34.238.41.114:8081/api/users/search?fullname="

    await Axios.get(baseUrl + this.state.search, {
      headers : {
        Authorization : 'Bearer ' + token
      }
    }).then(response => {
      console.log(response)
    })

  }

  async componentDidMount() {
    let token = window.localStorage.getItem('token');

    await Axios.get('http://34.238.41.114:8081/api/users/all?page=0&limit=10', {
      headers: {
        Authorization : 'Bearer ' + token
      }
    }).then(response => {
      if(!response) {
        alert('Server Sedang Bermasalah')
      }
      this.setState({list : response.data.data})
    });
  }

  check() {
    alert(JSON.stringify(this.state))
  }

  render() {
    return (
      <>
        <Header />
        {/* Page content */}
        <Container className="mt--8" fluid>
          {/* Table */}
          <Row>
            <div className="col">
              <Card className="shadow">
                <CardHeader className="border-0">
                  <h3 className="mb-0">Daftar User</h3>
                </CardHeader>
                <Table className="align-items-center table-flush" responsive>
                  <thead className="thead-light">
                    <tr>
                      <th scope="col">Fullname</th>
                      <th scope="col">Email</th>
                      <th scope="col">Phone</th>
                      <th scope="col">Gender</th>
                      <th scope="col">Class</th>
                    </tr>
                  </thead>
                  <tbody>
                  {this.state.list.map((item,key) => {
                    return (
                      <>
                        <tr>
                          <td className="text-sm"><a href={"/admin/detail/" + item.id}>{item.fullname}</a></td>
                          <td>{item.email}</td>
                          <td>{item.phone}</td>
                          <td>{item.gender}</td>
                          <td>{item.gym_class.title}</td>     
                        </tr>
                      </>
                      );
                    })}    
                  </tbody>
                </Table>
                <CardFooter className="py-4">
                  <nav aria-label="...">
                    <Pagination
                      className="pagination justify-content-end mb-0"
                      listClassName="justify-content-end mb-0"
                    >
                      <PaginationItem className="disabled">
                        <PaginationLink
                          href="#pablo"
                          onClick={e => e.preventDefault()}
                          tabIndex="-1"
                        >
                          <i className="fas fa-angle-left" />
                          <span className="sr-only">Previous</span>
                        </PaginationLink>
                      </PaginationItem>
                      <PaginationItem className="active">
                        <PaginationLink
                          href="#pablo"
                          onClick={e => e.preventDefault()}
                        >
                          1
                        </PaginationLink>
                      </PaginationItem>
                      <PaginationItem>
                        <PaginationLink
                          href="#pablo"
                          onClick={e => e.preventDefault()}
                        >
                          2 <span className="sr-only">(current)</span>
                        </PaginationLink>
                      </PaginationItem>
                      <PaginationItem>
                        <PaginationLink
                          href="#pablo"
                          onClick={e => e.preventDefault()}
                        >
                          3
                        </PaginationLink>
                      </PaginationItem>
                      <PaginationItem>
                        <PaginationLink
                          href="#pablo"
                          onClick={e => e.preventDefault()}
                        >
                          <i className="fas fa-angle-right" />
                          <span className="sr-only">Next</span>
                        </PaginationLink>
                      </PaginationItem>
                    </Pagination>
                  </nav>
                </CardFooter>
              </Card>
            </div>
          </Row>
          {/* Dark table */}
        </Container>
      </>
    );
  }
}

export default Tables;
