class: CommandLineTool
cwlVersion: v1.0
$namespaces:
  gx: "http://galaxyproject.org/cwl#"
  edam: 'http://edamontology.org/'
  s: 'http://schema.org/'
baseCommand:
  - TransDecoder.LongOrfs
inputs:
  - format: 'edam:format_3475'
    id: geneToTranscriptMap
    type: File?
    inputBinding:
      position: 0
      prefix: '--gene_trans_map'
    label: gene-to-transcript mapping
    doc: >-
      gene-to-transcript identifier mapping file (tab-delimited,
      gene_id<tab>trans_id<return>)
  - id: geneticCode
    type: TransDecoder-v5-genetic_codes.yaml#genetic_codes?
    inputBinding:
      position: 0
      prefix: '-G'
    label: genetic code
    doc: >-
      genetic code (default: universal; see PerlDoc; options: Euplotes,
      Tetrahymena, Candida, Acetabularia)
  - id: minimumProteinLength
    type: int?
    inputBinding:
      position: 0
      prefix: '-m'
    label: minimum protein length
    doc: 'minimum protein length (default: 100)'
  - id: strandSpecific
    type: boolean?
    inputBinding:
      position: 0
      prefix: '-S'
    label: strand-specific
    doc: strand-specific (only analyzes top strand)
  - format: 'edam:format_1929'
    id: transcriptsFile
    type: File
    inputBinding:
      position: 0
      prefix: '-t'
    label: transcripts.fasta
    doc: FASTA formatted sequence file containing your transcripts.
outputs:
  - id: workingDir
    type: Directory
    outputBinding:
      glob: $(inputs.transcriptsFile.basename).transdecoder_dir
doc: >-
  TransDecoder identifies candidate coding regions within transcript sequences,
  such as those generated by de novo RNA-Seq transcript assembly using Trinity,
  or constructed based on RNA-Seq alignments to the genome using Tophat and
  Cufflinks.

  TransDecoder identifies likely coding sequences based on the following
  criteria:
        + a minimum length open reading frame (ORF) is found in a transcript sequence
        + a log-likelihood score similar to what is computed by the GeneID software is > 0.
        + the above coding score is greatest when the ORF is scored in the 1st reading frame
        as compared to scores in the other 2 forward reading frames.
        + if a candidate ORF is found fully encapsulated by the coordinates of another candidate ORF,
        the longer one is reported. However, a single transcript can report multiple ORFs
        (allowing for operons, chimeras, etc).
        + a PSSM is built/trained/used to refine the start codon prediction.
        + optional the putative peptide has a match to a Pfam domain above the noise cutoff score.

  Please visit https://github.com/TransDecoder/TransDecoder/wiki for full
  documentation.


  Releases can be downloaded from
  https://github.com/TransDecoder/TransDecoder/releases
label: >-
  TransDecoder.LongOrfs: Perl script, which extracts the long open reading
  frames
requirements:
  - class: SchemaDefRequirement
    types:
      - $import: TransDecoder-v5-genetic_codes.yaml
  - class: ResourceRequirement
    coresMin: 2
    ramMin: 50
  - class: InlineJavascriptRequirement
hints:
  - class: DockerRequirement
    dockerPull: 'greatfireball/ime_transdecoder:5.0.2'
  - class: gx:interface
    gx:inputs:
      - gx:name: geneToTranscriptMap
        gx:type: data
        gx:format: 'txt'
        gx:optional: True
      - gx:name: geneticCode
        gx:type: text 
        gx:optional: True
      - gx:name: minimumProteinLength
        gx:type: integer
        gx:optional: True
      - gx:name: strandSpecific
        gx:type: boolean
        gx:optional: True
      - gx:name: transcriptsFile
        gx:type: data
        gx:format: 'txt'
$schemas:
  - 'http://edamontology.org/EDAM_1.20.owl'
  - 'https://schema.org/version/latest/schema.rdf'
s:license: "https://www.apache.org/licenses/LICENSE-2.0"
s:copyrightHolder: "EMBL - European Bioinformatics Institute, 2018"
s:author: "Arnaud Meng, Maxim Scheremetjew"
