'use client';

import { useAllFormFields, useDocumentInfo, useLocale, useTranslation } from '@payloadcms/ui';
import type { FormField, UIField } from 'payload';
import React, { useEffect, useState } from 'react';

import type { GenerateURL } from '../types';

// eslint-disable-next-line @typescript-eslint/no-redundant-type-constituents
type PreviewProps = {
  hasGenerateURLFn: boolean;
} & UIField;

export const Preview: React.FC<PreviewProps> = ({ hasGenerateURLFn }) => {
  const { t } = useTranslation();

  const locale = useLocale();

  const [fields] = useAllFormFields();

  const docInfo = useDocumentInfo();

  const {
    'meta.description': { value: metaDescription } = {} as FormField,
    'meta.title': { value: metaTitle } = {} as FormField,
  } = fields;

  const [href, setHref] = useState<string>();

  useEffect(() => {
    const getHref = async () => {
      const genURLResponse = await fetch('/api/plugin-seo/generate-url', {
        body: JSON.stringify({
          ...docInfo,
          doc: { ...fields },
          locale: typeof locale === 'object' ? locale?.code : locale,
        } satisfies Parameters<GenerateURL>[0]),
        credentials: 'include',
        headers: {
          'Content-Type': 'application/json',
        },
        method: 'POST',
      });

      const { result: newHref } = await genURLResponse.json();

      setHref(newHref);
    };

    if (hasGenerateURLFn && !href) {
      void getHref();
    }
  }, [fields, href, locale, docInfo, hasGenerateURLFn]);

  type TArg = Parameters<typeof t>[0];

  return (
    <div>
      <div>{t('plugin-seo:preview' as TArg)}</div>
      <div
        style={{
          color: '#9A9A9A',
          marginBottom: '5px',
        }}
      >
        {t('plugin-seo:previewDescription' as TArg)}
      </div>
      <div
        style={{
          background: 'var(--theme-elevation-50)',
          borderRadius: '5px',
          boxShadow: '0px 0px 10px rgba(0, 0, 0, 0.1)',
          maxWidth: '600px',
          padding: '20px',
          pointerEvents: 'none',
          width: '100%',
        }}
      >
        <div>
          <a
            href={href}
            style={{
              textDecoration: 'none',
            }}
          >
            {href || 'https://...'}
          </a>
        </div>
        <h4
          style={{
            margin: 0,
          }}
        >
          <a
            href='/'
            style={{
              textDecoration: 'none',
            }}
          >
            {metaTitle as string}
          </a>
        </h4>
        <p
          style={{
            margin: 0,
          }}
        >
          {metaDescription as string}
        </p>
      </div>
    </div>
  );
};
