export const translations = {
  en: {
    $schema: './translation-schema.json',
    'plugin-seo': {
      almostThere: 'Almost there',
      autoGenerate: 'Auto-generate',
      bestPractices: 'best practices',
      characterCount: '{{current}}/{{minLength}}-{{maxLength}} chars, ',
      charactersLeftOver: '{{characters}} left over',
      charactersToGo: '{{characters}} to go',
      charactersTooMany: '{{characters}} too many',
      checksPassing: '{{current}}/{{max}} checks are passing',
      generateAi: 'AI-generate',
      good: 'Good',
      imageAutoGenerationTip: 'Auto-generation will retrieve the selected hero image.',
      lengthTipDescription:
        'This should be between {{minLength}} and {{maxLength}} characters. For help in writing quality meta descriptions, see ',
      lengthTipTitle:
        'This should be between {{minLength}} and {{maxLength}} characters. For help in writing quality meta titles, see ',
      noImage: 'No image',
      preview: 'Preview',
      previewDescription: 'Exact result listings may vary based on content and search relevancy.',
      tooLong: 'Too long',
      tooShort: 'Too short',
    },
  },
  es: {
    $schema: './translation-schema.json',
    'plugin-seo': {
      almostThere: 'Ya casi está',
      autoGenerate: 'Autogénerar',
      bestPractices: 'mejores prácticas',
      characterCount: '{{current}}/{{minLength}}-{{maxLength}} letras, ',
      charactersLeftOver: '{{characters}} letras sobrantes',
      charactersToGo: '{{characters}} letras sobrantes',
      charactersTooMany: '{{characters}} letras demasiados',
      checksPassing: '{{current}}/{{max}} las comprobaciones están pasando',
      generateAi: 'AI-generate',
      good: 'Bien',
      imageAutoGenerationTip: 'La autogeneración recuperará la imagen de héroe seleccionada.',
      lengthTipDescription:
        'Esto debe estar entre {{minLength}} y {{maxLength}} caracteres. Para obtener ayuda sobre cómo escribir meta descripciones de calidad, consulte ',
      lengthTipTitle:
        'Debe tener entre {{minLength}} y {{maxLength}} caracteres. Para obtener ayuda sobre cómo escribir metatítulos de calidad, consulte ',
      noImage: 'Sin imagen',
      preview: 'Vista previa',
      previewDescription:
        'Las listas de resultados pueden variar segun la relevancia de buesqueda y el contenido.',
      tooLong: 'Demasiado largo',
      tooShort: 'Demasiado corto',
    },
  },
  fa: {
    $schema: './translation-schema.json',
    'plugin-seo': {
      almostThere: 'چیزیی باقی نمونده',
      autoGenerate: 'تولید خودکار',
      bestPractices: 'آموزش بیشتر',
      characterCount: '{{current}}/{{minLength}}-{{maxLength}} کلمه، ',
      charactersLeftOver: '{{characters}} باقی مانده',
      charactersToGo: '{{characters}} باقی مانده',
      charactersTooMany: '{{characters}} بیش از حد',
      checksPassing: '{{current}}/{{max}} بررسی‌ها با موفقیت انجام شده است',
      generateAi: 'AI-generate',
      good: 'خوب',
      imageAutoGenerationTip:
        'این قابلیت، تصویر فعلی بارگذاری شده در مجموعه محتوای شما را بازیابی می‌کند',
      lengthTipDescription:
        'این باید بین {{minLength}} و {{maxLength}} کلمه باشد. برای کمک در نوشتن توضیحات متا با کیفیت، مراجعه کنید به ',
      lengthTipTitle:
        'این باید بین {{minLength}} و {{maxLength}} کلمه باشد. برای کمک در نوشتن عناوین متا با کیفیت، مراجعه کنید به ',
      noImage: 'بدون تصویر',
      preview: 'پیش‌نمایش',
      previewDescription:
        'فهرست نتایج ممکن است بر اساس محتوا و متناسب با کلمه کلیدی جستجو شده باشند',
      tooLong: 'خیلی طولانی',
      tooShort: 'خیلی کوتاه',
    },
  },
  fr: {
    $schema: './translation-schema.json',
    'plugin-seo': {
      almostThere: 'On y est presque',
      autoGenerate: 'Auto-générer',
      bestPractices: 'bonnes pratiques',
      characterCount: '{{current}}/{{minLength}}-{{maxLength}} caractères, ',
      charactersLeftOver: '{{characters}} restants',
      charactersToGo: '{{characters}} à ajouter',
      charactersTooMany: '{{characters}} en trop',
      checksPassing: '{{current}}/{{max}} vérifications réussies',
      generateAi: 'AI-generate',
      good: 'Bien',
      imageAutoGenerationTip: "L'auto-génération récupérera l'image principale sélectionnée.",
      lengthTipDescription:
        "Ceci devrait contenir entre {{minLength}} et {{maxLength}} caractères. Pour obtenir de l'aide pour rédiger des descriptions meta de qualité, consultez les ",
      lengthTipTitle:
        "Ceci devrait contenir entre {{minLength}} et {{maxLength}} caractères. Pour obtenir de l'aide pour rédiger des titres meta de qualité, consultez les ",
      noImage: "Pas d'image",
      preview: 'Aperçu',
      previewDescription:
        'Les résultats exacts peuvent varier en fonction du contenu et de la pertinence de la recherche.',
      tooLong: 'Trop long',
      tooShort: 'Trop court',
    },
  },
  nb: {
    $schema: './translation-schema.json',
    'plugin-seo': {
      almostThere: 'Nesten der',
      autoGenerate: 'Auto-generer',
      bestPractices: 'beste praksis',
      characterCount: '{{current}}/{{minLength}}-{{maxLength}} tegn, ',
      charactersLeftOver: '{{characters}} til overs',
      charactersToGo: '{{characters}} igjen',
      charactersTooMany: '{{characters}} for mange',
      checksPassing: '{{current}}/{{max}} sjekker bestått',
      generateAi: 'AI-generate',
      good: 'Bra',
      imageAutoGenerationTip: 'Auto-generering vil hente det valgte hero-bildet.',
      lengthTipDescription:
        'Dette bør være mellom {{minLength}} og {{maxLength}} tegn. For hjelp til å skrive beskrivelser av god kvalitet, se ',
      lengthTipTitle:
        'Dette bør være mellom {{minLength}} og {{maxLength}} tegn. For hjelp til å skrive metatitler av god kvalitet, se ',
      noImage: 'Bilde mangler',
      preview: 'Forhåndsvisning',
      previewDescription:
        'Eksakte resultatoppføringer kan variere basert på innhold og søke relevans.',
      tooLong: 'For lang',
      tooShort: 'For kort',
    },
  },
  pl: {
    $schema: './translation-schema.json',
    'plugin-seo': {
      almostThere: 'Prawie gotowe',
      autoGenerate: 'Wygeneruj automatycznie',
      bestPractices: 'najlepsze praktyki',
      characterCount: '{{current}}/{{minLength}}-{{maxLength}} znaków, ',
      charactersLeftOver: 'zostało {{characters}} znaków',
      charactersToGo: 'pozostało {{characters}} znaków',
      charactersTooMany: '{{characters}} znaków za dużo',
      checksPassing: '{{current}}/{{max}} testów zakończonych pomyślnie',
      generateAi: 'AI-generate',
      good: 'Dobrze',
      imageAutoGenerationTip: 'Automatyczne generowanie pobierze wybrany główny obraz.',
      lengthTipDescription:
        'Długość powinna wynosić od {{minLength}} do {{maxLength}} znaków. Po porady dotyczące pisania wysokiej jakości meta opisów zobacz ',
      lengthTipTitle:
        'Długość powinna wynosić od {{minLength}} do {{maxLength}} znaków. Po porady dotyczące pisania wysokiej jakości meta tytułów zobacz ',
      noImage: 'Brak obrazu',
      preview: 'Podgląd',
      previewDescription:
        'Dokładne wyniki listowania mogą się różnić w zależności od treści i zgodności z kryteriami wyszukiwania.',
      tooLong: 'Zbyt długie',
      tooShort: 'Zbyt krótkie',
    },
  },
  uk: {
    $schema: './translation-schema.json',
    'plugin-seo': {
      almostThere: 'Ще трошки',
      autoGenerate: 'Згенерувати',
      bestPractices: 'найкращі практики',
      characterCount: '{{current}}/{{minLength}}-{{maxLength}} символів, ',
      charactersLeftOver: 'залишилось {{characters}} символів',
      charactersToGo: ' на {{characters}} символів коротше',
      charactersTooMany: 'на {{characters}} символів довше',
      checksPassing: '{{current}}/{{max}} перевірок пройдено',
      generateAi: 'AI-генерація',
      good: 'Чудово',
      imageAutoGenerationTip: 'Автоматична генерація використає зображення з головного блоку',
      lengthTipDescription:
        'Має бути від {{minLength}} до {{maxLength}} символів. Щоб дізнатися, як писати якісні метаописи — перегляньте ',
      lengthTipTitle:
        'Має бути від {{minLength}} до {{maxLength}} символів. Щоб дізнатися, як писати якісні метазаголовки — перегляньте ',
      noImage: 'Немає зображення',
      preview: 'Попередній перегляд',
      previewDescription:
        'Реальне відображення може відрізнятися в залежності від вмісту та релевантності пошуку.',
      tooLong: 'Задовгий',
      tooShort: 'Закороткий',
    },
  },
};
