/** MIT License
 *
 * Copyright (c) 2020 Qv Junping
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* kernel/include/inwox/errno.h
 * 错误码定义
 */

#ifndef INWOX_ERRNO_H_
#define INWOX_ERRNO_H_

#define E2BIG           1
#define EACCES          2
#define EADDRINUSE      3
#define EADDRNOTAVAIL   4
#define EAFNOSUPPORT    5
#define EAGAIN          6
#define EALREADY        7
#define EBADF           8
#define EBADMSG         9
#define EBUSY           10
#define ECANCELED       11
#define ECHILD          12
#define ECONNABORTED    13
#define ECONNREFUSED    14
#define ECONNRESET      15
#define EDEADLK         16
#define EDESTADDRREQ    17
#define EDOM            18
#define EDQUOT          19
#define EEXIST          20
#define EFAULT          21
#define EFBIG           22
#define EHOSTUNREACH    23
#define EIDRM           24
#define EILSEQ          25
#define EINPROGRESS     26
#define EINTR           27
#define EINVAL          28
#define EIO             29
#define EISCONN         30
#define EISDIR          31
#define ELOOP           32
#define EMFILE          33
#define EMLINK          34
#define EMSGSIZE        35
#define EMULTIHOP       36
#define ENAMETOOLONG    37
#define ENETDOWN        38
#define ENETRESET       39
#define ENETUNREACH     40
#define ENFILE          41
#define ENOBUFS         42
#define ENODEV          43
#define ENOENT          44
#define ENOEXEC         45
#define ENOLCK          46
#define ENOLINK         47
#define ENOMEM          48
#define ENOMSG          49
#define ENOPROTOOPT     50
#define ENOSPC          51
#define ENOSYS          52
#define ENOTCONN        53
#define ENOTDIR         54
#define ENOTEMPTY       55
#define ENOTRECOVERABLE 56
#define ENOTSOCK        57
#define ENOTSUP         58
#define ENOTTY          59
#define ENXIO           60
#define EOPNOTSUPP      61
#define EOVERFLOW       62
#define EOWNERDEAD      63
#define EPERM           64
#define EPIPE           65
#define EPROTO          66
#define EPROTONOSUPPORT 67
#define EPROTOTYPE      68
#define ERANGE          69
#define EROFS           70
#define ESPIPE          71
#define ESRCH           72
#define ESTALE          73
#define ETIMEDOUT       74
#define ETXTBSY         75
#define EWOULDBLOCK     76
#define EXDEV           77

#endif /* INWOX_ERRNO_H_ */
