#[derive(serde::Serialize, serde::Deserialize, utoipa::ToSchema)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IngestRequestV2 {
    #[prost(message, repeated, tag = "1")]
    pub subrequests: ::prost::alloc::vec::Vec<IngestSubrequest>,
    #[prost(enumeration = "super::CommitTypeV2", tag = "2")]
    pub commit_type: i32,
}
#[derive(serde::Serialize, serde::Deserialize, utoipa::ToSchema)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IngestSubrequest {
    /// The subrequest ID is used to identify the various subrequests and responses
    /// (ingest, persist, replicate) at play during the ingest and replication
    /// process.
    #[prost(uint32, tag = "1")]
    pub subrequest_id: u32,
    #[prost(string, tag = "2")]
    pub index_id: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub source_id: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "4")]
    pub doc_batch: ::core::option::Option<super::DocBatchV2>,
}
#[derive(serde::Serialize, serde::Deserialize, utoipa::ToSchema)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IngestResponseV2 {
    #[prost(message, repeated, tag = "1")]
    pub successes: ::prost::alloc::vec::Vec<IngestSuccess>,
    #[prost(message, repeated, tag = "2")]
    pub failures: ::prost::alloc::vec::Vec<IngestFailure>,
}
#[derive(serde::Serialize, serde::Deserialize, utoipa::ToSchema)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IngestSuccess {
    #[prost(uint32, tag = "1")]
    pub subrequest_id: u32,
    #[prost(message, optional, tag = "2")]
    pub index_uid: ::core::option::Option<crate::types::IndexUid>,
    #[prost(string, tag = "3")]
    pub source_id: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "4")]
    pub shard_id: ::core::option::Option<crate::types::ShardId>,
    /// Replication position inclusive.
    #[prost(message, optional, tag = "5")]
    pub replication_position_inclusive: ::core::option::Option<crate::types::Position>,
    #[prost(uint32, tag = "6")]
    pub num_ingested_docs: u32,
    #[prost(message, repeated, tag = "7")]
    pub parse_failures: ::prost::alloc::vec::Vec<super::ParseFailure>,
}
#[derive(serde::Serialize, serde::Deserialize, utoipa::ToSchema)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IngestFailure {
    #[prost(uint32, tag = "1")]
    pub subrequest_id: u32,
    #[prost(string, tag = "2")]
    pub index_id: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub source_id: ::prost::alloc::string::String,
    #[prost(enumeration = "IngestFailureReason", tag = "5")]
    pub reason: i32,
}
#[derive(serde::Serialize, serde::Deserialize, utoipa::ToSchema)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum IngestFailureReason {
    Unspecified = 0,
    IndexNotFound = 1,
    SourceNotFound = 2,
    Internal = 3,
    NoShardsAvailable = 4,
    ShardRateLimited = 5,
    WalFull = 6,
    Timeout = 7,
    RouterLoadShedding = 8,
    LoadShedding = 9,
    CircuitBreaker = 10,
}
impl IngestFailureReason {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            IngestFailureReason::Unspecified => "INGEST_FAILURE_REASON_UNSPECIFIED",
            IngestFailureReason::IndexNotFound => "INGEST_FAILURE_REASON_INDEX_NOT_FOUND",
            IngestFailureReason::SourceNotFound => {
                "INGEST_FAILURE_REASON_SOURCE_NOT_FOUND"
            }
            IngestFailureReason::Internal => "INGEST_FAILURE_REASON_INTERNAL",
            IngestFailureReason::NoShardsAvailable => {
                "INGEST_FAILURE_REASON_NO_SHARDS_AVAILABLE"
            }
            IngestFailureReason::ShardRateLimited => {
                "INGEST_FAILURE_REASON_SHARD_RATE_LIMITED"
            }
            IngestFailureReason::WalFull => "INGEST_FAILURE_REASON_WAL_FULL",
            IngestFailureReason::Timeout => "INGEST_FAILURE_REASON_TIMEOUT",
            IngestFailureReason::RouterLoadShedding => {
                "INGEST_FAILURE_REASON_ROUTER_LOAD_SHEDDING"
            }
            IngestFailureReason::LoadShedding => "INGEST_FAILURE_REASON_LOAD_SHEDDING",
            IngestFailureReason::CircuitBreaker => {
                "INGEST_FAILURE_REASON_CIRCUIT_BREAKER"
            }
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "INGEST_FAILURE_REASON_UNSPECIFIED" => Some(Self::Unspecified),
            "INGEST_FAILURE_REASON_INDEX_NOT_FOUND" => Some(Self::IndexNotFound),
            "INGEST_FAILURE_REASON_SOURCE_NOT_FOUND" => Some(Self::SourceNotFound),
            "INGEST_FAILURE_REASON_INTERNAL" => Some(Self::Internal),
            "INGEST_FAILURE_REASON_NO_SHARDS_AVAILABLE" => Some(Self::NoShardsAvailable),
            "INGEST_FAILURE_REASON_SHARD_RATE_LIMITED" => Some(Self::ShardRateLimited),
            "INGEST_FAILURE_REASON_WAL_FULL" => Some(Self::WalFull),
            "INGEST_FAILURE_REASON_TIMEOUT" => Some(Self::Timeout),
            "INGEST_FAILURE_REASON_ROUTER_LOAD_SHEDDING" => {
                Some(Self::RouterLoadShedding)
            }
            "INGEST_FAILURE_REASON_LOAD_SHEDDING" => Some(Self::LoadShedding),
            "INGEST_FAILURE_REASON_CIRCUIT_BREAKER" => Some(Self::CircuitBreaker),
            _ => None,
        }
    }
}
/// BEGIN quickwit-codegen
#[allow(unused_imports)]
use std::str::FromStr;
use tower::{Layer, Service, ServiceExt};
use quickwit_common::tower::RpcName;
impl RpcName for IngestRequestV2 {
    fn rpc_name() -> &'static str {
        "ingest"
    }
}
#[cfg_attr(any(test, feature = "testsuite"), mockall::automock)]
#[async_trait::async_trait]
pub trait IngestRouterService: std::fmt::Debug + Send + Sync + 'static {
    /// Ingests batches of documents for one or multiple indexes.
    /// TODO: Describe error cases and how to handle them.
    async fn ingest(
        &self,
        request: IngestRequestV2,
    ) -> crate::ingest::IngestV2Result<IngestResponseV2>;
}
#[derive(Debug, Clone)]
pub struct IngestRouterServiceClient {
    inner: InnerIngestRouterServiceClient,
}
#[derive(Debug, Clone)]
struct InnerIngestRouterServiceClient(std::sync::Arc<dyn IngestRouterService>);
impl IngestRouterServiceClient {
    pub fn new<T>(instance: T) -> Self
    where
        T: IngestRouterService,
    {
        #[cfg(any(test, feature = "testsuite"))]
        assert!(
            std::any::TypeId::of:: < T > () != std::any::TypeId::of:: <
            MockIngestRouterService > (),
            "`MockIngestRouterService` must be wrapped in a `MockIngestRouterServiceWrapper`: use `IngestRouterServiceClient::from_mock(mock)` to instantiate the client"
        );
        Self {
            inner: InnerIngestRouterServiceClient(std::sync::Arc::new(instance)),
        }
    }
    pub fn as_grpc_service(
        &self,
        max_message_size: bytesize::ByteSize,
    ) -> ingest_router_service_grpc_server::IngestRouterServiceGrpcServer<
        IngestRouterServiceGrpcServerAdapter,
    > {
        let adapter = IngestRouterServiceGrpcServerAdapter::new(self.clone());
        ingest_router_service_grpc_server::IngestRouterServiceGrpcServer::new(adapter)
            .max_decoding_message_size(max_message_size.0 as usize)
            .max_encoding_message_size(max_message_size.0 as usize)
    }
    pub fn from_channel(
        addr: std::net::SocketAddr,
        channel: tonic::transport::Channel,
        max_message_size: bytesize::ByteSize,
    ) -> Self {
        let (_, connection_keys_watcher) = tokio::sync::watch::channel(
            std::collections::HashSet::from_iter([addr]),
        );
        let client = ingest_router_service_grpc_client::IngestRouterServiceGrpcClient::new(
                channel,
            )
            .max_decoding_message_size(max_message_size.0 as usize)
            .max_encoding_message_size(max_message_size.0 as usize);
        let adapter = IngestRouterServiceGrpcClientAdapter::new(
            client,
            connection_keys_watcher,
        );
        Self::new(adapter)
    }
    pub fn from_balance_channel(
        balance_channel: quickwit_common::tower::BalanceChannel<std::net::SocketAddr>,
        max_message_size: bytesize::ByteSize,
    ) -> IngestRouterServiceClient {
        let connection_keys_watcher = balance_channel.connection_keys_watcher();
        let client = ingest_router_service_grpc_client::IngestRouterServiceGrpcClient::new(
                balance_channel,
            )
            .max_decoding_message_size(max_message_size.0 as usize)
            .max_encoding_message_size(max_message_size.0 as usize);
        let adapter = IngestRouterServiceGrpcClientAdapter::new(
            client,
            connection_keys_watcher,
        );
        Self::new(adapter)
    }
    pub fn from_mailbox<A>(mailbox: quickwit_actors::Mailbox<A>) -> Self
    where
        A: quickwit_actors::Actor + std::fmt::Debug + Send + 'static,
        IngestRouterServiceMailbox<A>: IngestRouterService,
    {
        IngestRouterServiceClient::new(IngestRouterServiceMailbox::new(mailbox))
    }
    pub fn tower() -> IngestRouterServiceTowerLayerStack {
        IngestRouterServiceTowerLayerStack::default()
    }
    #[cfg(any(test, feature = "testsuite"))]
    pub fn from_mock(mock: MockIngestRouterService) -> Self {
        let mock_wrapper = mock_ingest_router_service::MockIngestRouterServiceWrapper {
            inner: tokio::sync::Mutex::new(mock),
        };
        Self::new(mock_wrapper)
    }
    #[cfg(any(test, feature = "testsuite"))]
    pub fn mocked() -> Self {
        Self::from_mock(MockIngestRouterService::new())
    }
}
#[async_trait::async_trait]
impl IngestRouterService for IngestRouterServiceClient {
    async fn ingest(
        &self,
        request: IngestRequestV2,
    ) -> crate::ingest::IngestV2Result<IngestResponseV2> {
        self.inner.0.ingest(request).await
    }
}
#[cfg(any(test, feature = "testsuite"))]
pub mod mock_ingest_router_service {
    use super::*;
    #[derive(Debug)]
    pub struct MockIngestRouterServiceWrapper {
        pub(super) inner: tokio::sync::Mutex<MockIngestRouterService>,
    }
    #[async_trait::async_trait]
    impl IngestRouterService for MockIngestRouterServiceWrapper {
        async fn ingest(
            &self,
            request: super::IngestRequestV2,
        ) -> crate::ingest::IngestV2Result<super::IngestResponseV2> {
            self.inner.lock().await.ingest(request).await
        }
    }
}
pub type BoxFuture<T, E> = std::pin::Pin<
    Box<dyn std::future::Future<Output = Result<T, E>> + Send + 'static>,
>;
impl tower::Service<IngestRequestV2> for InnerIngestRouterServiceClient {
    type Response = IngestResponseV2;
    type Error = crate::ingest::IngestV2Error;
    type Future = BoxFuture<Self::Response, Self::Error>;
    fn poll_ready(
        &mut self,
        _cx: &mut std::task::Context<'_>,
    ) -> std::task::Poll<Result<(), Self::Error>> {
        std::task::Poll::Ready(Ok(()))
    }
    fn call(&mut self, request: IngestRequestV2) -> Self::Future {
        let svc = self.clone();
        let fut = async move { svc.0.ingest(request).await };
        Box::pin(fut)
    }
}
/// A tower service stack is a set of tower services.
#[derive(Debug)]
struct IngestRouterServiceTowerServiceStack {
    #[allow(dead_code)]
    inner: InnerIngestRouterServiceClient,
    ingest_svc: quickwit_common::tower::BoxService<
        IngestRequestV2,
        IngestResponseV2,
        crate::ingest::IngestV2Error,
    >,
}
#[async_trait::async_trait]
impl IngestRouterService for IngestRouterServiceTowerServiceStack {
    async fn ingest(
        &self,
        request: IngestRequestV2,
    ) -> crate::ingest::IngestV2Result<IngestResponseV2> {
        self.ingest_svc.clone().ready().await?.call(request).await
    }
}
type IngestLayer = quickwit_common::tower::BoxLayer<
    quickwit_common::tower::BoxService<
        IngestRequestV2,
        IngestResponseV2,
        crate::ingest::IngestV2Error,
    >,
    IngestRequestV2,
    IngestResponseV2,
    crate::ingest::IngestV2Error,
>;
#[derive(Debug, Default)]
pub struct IngestRouterServiceTowerLayerStack {
    ingest_layers: Vec<IngestLayer>,
}
impl IngestRouterServiceTowerLayerStack {
    pub fn stack_layer<L>(mut self, layer: L) -> Self
    where
        L: tower::Layer<
                quickwit_common::tower::BoxService<
                    IngestRequestV2,
                    IngestResponseV2,
                    crate::ingest::IngestV2Error,
                >,
            > + Clone + Send + Sync + 'static,
        <L as tower::Layer<
            quickwit_common::tower::BoxService<
                IngestRequestV2,
                IngestResponseV2,
                crate::ingest::IngestV2Error,
            >,
        >>::Service: tower::Service<
                IngestRequestV2,
                Response = IngestResponseV2,
                Error = crate::ingest::IngestV2Error,
            > + Clone + Send + Sync + 'static,
        <<L as tower::Layer<
            quickwit_common::tower::BoxService<
                IngestRequestV2,
                IngestResponseV2,
                crate::ingest::IngestV2Error,
            >,
        >>::Service as tower::Service<IngestRequestV2>>::Future: Send + 'static,
    {
        self.ingest_layers.push(quickwit_common::tower::BoxLayer::new(layer.clone()));
        self
    }
    pub fn stack_ingest_layer<L>(mut self, layer: L) -> Self
    where
        L: tower::Layer<
                quickwit_common::tower::BoxService<
                    IngestRequestV2,
                    IngestResponseV2,
                    crate::ingest::IngestV2Error,
                >,
            > + Send + Sync + 'static,
        L::Service: tower::Service<
                IngestRequestV2,
                Response = IngestResponseV2,
                Error = crate::ingest::IngestV2Error,
            > + Clone + Send + Sync + 'static,
        <L::Service as tower::Service<IngestRequestV2>>::Future: Send + 'static,
    {
        self.ingest_layers.push(quickwit_common::tower::BoxLayer::new(layer));
        self
    }
    pub fn build<T>(self, instance: T) -> IngestRouterServiceClient
    where
        T: IngestRouterService,
    {
        let inner_client = InnerIngestRouterServiceClient(std::sync::Arc::new(instance));
        self.build_from_inner_client(inner_client)
    }
    pub fn build_from_channel(
        self,
        addr: std::net::SocketAddr,
        channel: tonic::transport::Channel,
        max_message_size: bytesize::ByteSize,
    ) -> IngestRouterServiceClient {
        let client = IngestRouterServiceClient::from_channel(
            addr,
            channel,
            max_message_size,
        );
        let inner_client = client.inner;
        self.build_from_inner_client(inner_client)
    }
    pub fn build_from_balance_channel(
        self,
        balance_channel: quickwit_common::tower::BalanceChannel<std::net::SocketAddr>,
        max_message_size: bytesize::ByteSize,
    ) -> IngestRouterServiceClient {
        let client = IngestRouterServiceClient::from_balance_channel(
            balance_channel,
            max_message_size,
        );
        let inner_client = client.inner;
        self.build_from_inner_client(inner_client)
    }
    pub fn build_from_mailbox<A>(
        self,
        mailbox: quickwit_actors::Mailbox<A>,
    ) -> IngestRouterServiceClient
    where
        A: quickwit_actors::Actor + std::fmt::Debug + Send + 'static,
        IngestRouterServiceMailbox<A>: IngestRouterService,
    {
        let inner_client = InnerIngestRouterServiceClient(
            std::sync::Arc::new(IngestRouterServiceMailbox::new(mailbox)),
        );
        self.build_from_inner_client(inner_client)
    }
    #[cfg(any(test, feature = "testsuite"))]
    pub fn build_from_mock(
        self,
        mock: MockIngestRouterService,
    ) -> IngestRouterServiceClient {
        let client = IngestRouterServiceClient::from_mock(mock);
        let inner_client = client.inner;
        self.build_from_inner_client(inner_client)
    }
    fn build_from_inner_client(
        self,
        inner_client: InnerIngestRouterServiceClient,
    ) -> IngestRouterServiceClient {
        let ingest_svc = self
            .ingest_layers
            .into_iter()
            .rev()
            .fold(
                quickwit_common::tower::BoxService::new(inner_client.clone()),
                |svc, layer| layer.layer(svc),
            );
        let tower_svc_stack = IngestRouterServiceTowerServiceStack {
            inner: inner_client,
            ingest_svc,
        };
        IngestRouterServiceClient::new(tower_svc_stack)
    }
}
#[derive(Debug, Clone)]
struct MailboxAdapter<A: quickwit_actors::Actor, E> {
    inner: quickwit_actors::Mailbox<A>,
    phantom: std::marker::PhantomData<E>,
}
impl<A, E> std::ops::Deref for MailboxAdapter<A, E>
where
    A: quickwit_actors::Actor,
{
    type Target = quickwit_actors::Mailbox<A>;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
#[derive(Debug)]
pub struct IngestRouterServiceMailbox<A: quickwit_actors::Actor> {
    inner: MailboxAdapter<A, crate::ingest::IngestV2Error>,
}
impl<A: quickwit_actors::Actor> IngestRouterServiceMailbox<A> {
    pub fn new(instance: quickwit_actors::Mailbox<A>) -> Self {
        let inner = MailboxAdapter {
            inner: instance,
            phantom: std::marker::PhantomData,
        };
        Self { inner }
    }
}
impl<A: quickwit_actors::Actor> Clone for IngestRouterServiceMailbox<A> {
    fn clone(&self) -> Self {
        let inner = MailboxAdapter {
            inner: self.inner.clone(),
            phantom: std::marker::PhantomData,
        };
        Self { inner }
    }
}
impl<A, M, T, E> tower::Service<M> for IngestRouterServiceMailbox<A>
where
    A: quickwit_actors::Actor
        + quickwit_actors::DeferableReplyHandler<M, Reply = Result<T, E>> + Send
        + 'static,
    M: std::fmt::Debug + Send + 'static,
    T: Send + 'static,
    E: std::fmt::Debug + Send + 'static,
    crate::ingest::IngestV2Error: From<quickwit_actors::AskError<E>>,
{
    type Response = T;
    type Error = crate::ingest::IngestV2Error;
    type Future = BoxFuture<Self::Response, Self::Error>;
    fn poll_ready(
        &mut self,
        _cx: &mut std::task::Context<'_>,
    ) -> std::task::Poll<Result<(), Self::Error>> {
        //! This does not work with balance middlewares such as `tower::balance::pool::Pool` because
        //! this always returns `Poll::Ready`. The fix is to acquire a permit from the
        //! mailbox in `poll_ready` and consume it in `call`.
        std::task::Poll::Ready(Ok(()))
    }
    fn call(&mut self, message: M) -> Self::Future {
        let mailbox = self.inner.clone();
        let fut = async move {
            mailbox.ask_for_res(message).await.map_err(|error| error.into())
        };
        Box::pin(fut)
    }
}
#[async_trait::async_trait]
impl<A> IngestRouterService for IngestRouterServiceMailbox<A>
where
    A: quickwit_actors::Actor + std::fmt::Debug,
    IngestRouterServiceMailbox<
        A,
    >: tower::Service<
        IngestRequestV2,
        Response = IngestResponseV2,
        Error = crate::ingest::IngestV2Error,
        Future = BoxFuture<IngestResponseV2, crate::ingest::IngestV2Error>,
    >,
{
    async fn ingest(
        &self,
        request: IngestRequestV2,
    ) -> crate::ingest::IngestV2Result<IngestResponseV2> {
        self.clone().call(request).await
    }
}
#[derive(Debug, Clone)]
pub struct IngestRouterServiceGrpcClientAdapter<T> {
    inner: T,
    #[allow(dead_code)]
    connection_addrs_rx: tokio::sync::watch::Receiver<
        std::collections::HashSet<std::net::SocketAddr>,
    >,
}
impl<T> IngestRouterServiceGrpcClientAdapter<T> {
    pub fn new(
        instance: T,
        connection_addrs_rx: tokio::sync::watch::Receiver<
            std::collections::HashSet<std::net::SocketAddr>,
        >,
    ) -> Self {
        Self {
            inner: instance,
            connection_addrs_rx,
        }
    }
}
#[async_trait::async_trait]
impl<T> IngestRouterService
for IngestRouterServiceGrpcClientAdapter<
    ingest_router_service_grpc_client::IngestRouterServiceGrpcClient<T>,
>
where
    T: tonic::client::GrpcService<tonic::body::BoxBody> + std::fmt::Debug + Clone + Send
        + Sync + 'static,
    T::ResponseBody: tonic::codegen::Body<Data = tonic::codegen::Bytes> + Send + 'static,
    <T::ResponseBody as tonic::codegen::Body>::Error: Into<tonic::codegen::StdError>
        + Send,
    T::Future: Send,
{
    async fn ingest(
        &self,
        request: IngestRequestV2,
    ) -> crate::ingest::IngestV2Result<IngestResponseV2> {
        self.inner
            .clone()
            .ingest(request)
            .await
            .map(|response| response.into_inner())
            .map_err(|status| crate::error::grpc_status_to_service_error(
                status,
                IngestRequestV2::rpc_name(),
            ))
    }
}
#[derive(Debug)]
pub struct IngestRouterServiceGrpcServerAdapter {
    inner: InnerIngestRouterServiceClient,
}
impl IngestRouterServiceGrpcServerAdapter {
    pub fn new<T>(instance: T) -> Self
    where
        T: IngestRouterService,
    {
        Self {
            inner: InnerIngestRouterServiceClient(std::sync::Arc::new(instance)),
        }
    }
}
#[async_trait::async_trait]
impl ingest_router_service_grpc_server::IngestRouterServiceGrpc
for IngestRouterServiceGrpcServerAdapter {
    async fn ingest(
        &self,
        request: tonic::Request<IngestRequestV2>,
    ) -> Result<tonic::Response<IngestResponseV2>, tonic::Status> {
        self.inner
            .0
            .ingest(request.into_inner())
            .await
            .map(tonic::Response::new)
            .map_err(crate::error::grpc_error_to_grpc_status)
    }
}
/// Generated client implementations.
pub mod ingest_router_service_grpc_client {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    use tonic::codegen::http::Uri;
    #[derive(Debug, Clone)]
    pub struct IngestRouterServiceGrpcClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl IngestRouterServiceGrpcClient<tonic::transport::Channel> {
        /// Attempt to create a new client by connecting to a given endpoint.
        pub async fn connect<D>(dst: D) -> Result<Self, tonic::transport::Error>
        where
            D: TryInto<tonic::transport::Endpoint>,
            D::Error: Into<StdError>,
        {
            let conn = tonic::transport::Endpoint::new(dst)?.connect().await?;
            Ok(Self::new(conn))
        }
    }
    impl<T> IngestRouterServiceGrpcClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::BoxBody>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> IngestRouterServiceGrpcClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::BoxBody>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
            >>::Error: Into<StdError> + Send + Sync,
        {
            IngestRouterServiceGrpcClient::new(
                InterceptedService::new(inner, interceptor),
            )
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        /// Ingests batches of documents for one or multiple indexes.
        /// TODO: Describe error cases and how to handle them.
        pub async fn ingest(
            &mut self,
            request: impl tonic::IntoRequest<super::IngestRequestV2>,
        ) -> std::result::Result<
            tonic::Response<super::IngestResponseV2>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/quickwit.ingest.router.IngestRouterService/Ingest",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "quickwit.ingest.router.IngestRouterService",
                        "Ingest",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
    }
}
/// Generated server implementations.
pub mod ingest_router_service_grpc_server {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    /// Generated trait containing gRPC methods that should be implemented for use with IngestRouterServiceGrpcServer.
    #[async_trait]
    pub trait IngestRouterServiceGrpc: Send + Sync + 'static {
        /// Ingests batches of documents for one or multiple indexes.
        /// TODO: Describe error cases and how to handle them.
        async fn ingest(
            &self,
            request: tonic::Request<super::IngestRequestV2>,
        ) -> std::result::Result<
            tonic::Response<super::IngestResponseV2>,
            tonic::Status,
        >;
    }
    #[derive(Debug)]
    pub struct IngestRouterServiceGrpcServer<T: IngestRouterServiceGrpc> {
        inner: _Inner<T>,
        accept_compression_encodings: EnabledCompressionEncodings,
        send_compression_encodings: EnabledCompressionEncodings,
        max_decoding_message_size: Option<usize>,
        max_encoding_message_size: Option<usize>,
    }
    struct _Inner<T>(Arc<T>);
    impl<T: IngestRouterServiceGrpc> IngestRouterServiceGrpcServer<T> {
        pub fn new(inner: T) -> Self {
            Self::from_arc(Arc::new(inner))
        }
        pub fn from_arc(inner: Arc<T>) -> Self {
            let inner = _Inner(inner);
            Self {
                inner,
                accept_compression_encodings: Default::default(),
                send_compression_encodings: Default::default(),
                max_decoding_message_size: None,
                max_encoding_message_size: None,
            }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> InterceptedService<Self, F>
        where
            F: tonic::service::Interceptor,
        {
            InterceptedService::new(Self::new(inner), interceptor)
        }
        /// Enable decompressing requests with the given encoding.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.accept_compression_encodings.enable(encoding);
            self
        }
        /// Compress responses with the given encoding, if the client supports it.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.send_compression_encodings.enable(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.max_decoding_message_size = Some(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.max_encoding_message_size = Some(limit);
            self
        }
    }
    impl<T, B> tonic::codegen::Service<http::Request<B>>
    for IngestRouterServiceGrpcServer<T>
    where
        T: IngestRouterServiceGrpc,
        B: Body + Send + 'static,
        B::Error: Into<StdError> + Send + 'static,
    {
        type Response = http::Response<tonic::body::BoxBody>;
        type Error = std::convert::Infallible;
        type Future = BoxFuture<Self::Response, Self::Error>;
        fn poll_ready(
            &mut self,
            _cx: &mut Context<'_>,
        ) -> Poll<std::result::Result<(), Self::Error>> {
            Poll::Ready(Ok(()))
        }
        fn call(&mut self, req: http::Request<B>) -> Self::Future {
            let inner = self.inner.clone();
            match req.uri().path() {
                "/quickwit.ingest.router.IngestRouterService/Ingest" => {
                    #[allow(non_camel_case_types)]
                    struct IngestSvc<T: IngestRouterServiceGrpc>(pub Arc<T>);
                    impl<
                        T: IngestRouterServiceGrpc,
                    > tonic::server::UnaryService<super::IngestRequestV2>
                    for IngestSvc<T> {
                        type Response = super::IngestResponseV2;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::IngestRequestV2>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move { (*inner).ingest(request).await };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = IngestSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                _ => {
                    Box::pin(async move {
                        Ok(
                            http::Response::builder()
                                .status(200)
                                .header("grpc-status", "12")
                                .header("content-type", "application/grpc")
                                .body(empty_body())
                                .unwrap(),
                        )
                    })
                }
            }
        }
    }
    impl<T: IngestRouterServiceGrpc> Clone for IngestRouterServiceGrpcServer<T> {
        fn clone(&self) -> Self {
            let inner = self.inner.clone();
            Self {
                inner,
                accept_compression_encodings: self.accept_compression_encodings,
                send_compression_encodings: self.send_compression_encodings,
                max_decoding_message_size: self.max_decoding_message_size,
                max_encoding_message_size: self.max_encoding_message_size,
            }
        }
    }
    impl<T: IngestRouterServiceGrpc> Clone for _Inner<T> {
        fn clone(&self) -> Self {
            Self(Arc::clone(&self.0))
        }
    }
    impl<T: std::fmt::Debug> std::fmt::Debug for _Inner<T> {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
            write!(f, "{:?}", self.0)
        }
    }
    impl<T: IngestRouterServiceGrpc> tonic::server::NamedService
    for IngestRouterServiceGrpcServer<T> {
        const NAME: &'static str = "quickwit.ingest.router.IngestRouterService";
    }
}
