---
title: Quickwit documentation
slug: /
sidebar_position: 1
---

import CallToAction from '@theme/CallToAction';

Quickwit is the first engine to execute complex search and analytics queries directly on cloud storage with sub-second latency. Powered by Rust and its decoupled compute and storage architecture, it is designed to be resource-efficient, easy to operate, and scale to petabytes of data.

Quickwit is a great fit for log management, distributed tracing, and generally immutable data such as conversational data (emails, texts, messaging platforms) and event-based analytics.

<CallToAction
heading='Get started with Quickwit'
description='Get up and running in minutes and start harnessing the power of Quickwit today!'
buttontext='GET STARTED'
to='/docs/main-branch/get-started/quickstart'>
</CallToAction>

## Use cases

- [Log management](../log-management/overview.md)
- [Distributed Tracing](../distributed-tracing/overview.md)

## Key concepts

- [Architecture](architecture.md)
- [Indexing](concepts/indexing.md)
- [Querying](concepts/querying.md)

## Reference

- [Configuration](../configuration/index.md)
- [REST API](../reference/rest-api.md)
- [CLI](../reference/cli.md)
